/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import oracle.i18n.lcsd.Profile;
import oracle.i18n.text.OraBoot;
import oracle.i18n.util.LocaleMapper;

public class LCSDResultSet {
    Object[][] resultArray = null;
    OraBoot ob = null;
    Profile profile = null;
    int process_flag = 0;
    private static int PROCESS_STRING = 2;
    private static String ISO_UTF16 = "UTF-16";
    private static String ORA_UTF16 = "AL16UTF16";

    LCSDResultSet(Profile profile, String string, String string2, int n) {
        this.profile = profile;
        this.resultArray = this.profile.getResult(string, string2);
        this.ob = OraBoot.getInstance();
        this.process_flag = n;
    }

    public String getISOLanguage() {
        String string = (String)this.resultArray[0][0];
        String string2 = string.substring(0, string.indexOf(95));
        if (string2.equalsIgnoreCase("zt")) {
            return "zh_TW";
        }
        return string2;
    }

    public String getISOLanguage(int n) {
        String string = (String)this.resultArray[n - 1][0];
        String string2 = string.substring(0, string.indexOf(95));
        if (string2.equalsIgnoreCase("zt")) {
            return "zh_TW";
        }
        return string2;
    }

    public String getORALanguage() {
        String string = (String)this.resultArray[0][0];
        String string2 = string.substring(0, string.indexOf(95));
        if (string2.equalsIgnoreCase("zt")) {
            return "TRADITIONAL CHINESE";
        }
        if (string2.equalsIgnoreCase("eu")) {
            return string2;
        }
        return LocaleMapper.getOraLangFromJavaLang((String)string2);
    }

    public String getORALanguage(int n) {
        String string = (String)this.resultArray[n - 1][0];
        String string2 = string.substring(0, string.indexOf(95));
        if (string2.equalsIgnoreCase("zt")) {
            return "TRADITIONAL CHINESE";
        }
        if (string2.equalsIgnoreCase("eu")) {
            return string2;
        }
        return LocaleMapper.getOraLangFromJavaLang((String)string2);
    }

    public String getIANACharacterSet() {
        String string;
        if (this.process_flag == PROCESS_STRING) {
            return ISO_UTF16;
        }
        String string2 = (String)this.resultArray[0][0];
        String string3 = string2.substring(string2.indexOf(95) + 1);
        int n = this.profile.promote_demote(Integer.parseInt(this.ob.getCharSetId(string3)));
        if (!(n != 2000 || !this.profile.isAL16UTF16() || (string = string2.substring(0, string2.indexOf(95))).equals("ja") || string.equals("ko") || string.equals("zh") || string.equals("zt"))) {
            n = 2002;
        }
        string = this.ob.getCharSetName(Integer.toString(n));
        return LocaleMapper.getJavaCharacterSet((int)1, (String)string);
    }

    public String getIANACharacterSet(int n) {
        String string;
        if (this.process_flag == PROCESS_STRING && n == 1) {
            return ISO_UTF16;
        }
        String string2 = (String)this.resultArray[n - 1][0];
        String string3 = string2.substring(string2.indexOf(95) + 1);
        int n2 = this.profile.promote_demote(Integer.parseInt(this.ob.getCharSetId(string3)));
        if (!(n2 != 2000 || !this.profile.isAL16UTF16() || (string = string2.substring(0, string2.indexOf(95))).equals("ja") || string.equals("ko") || string.equals("zh") || string.equals("zt"))) {
            n2 = 2002;
        }
        string = this.ob.getCharSetName(Integer.toString(n2));
        return LocaleMapper.getJavaCharacterSet((int)1, (String)string);
    }

    public String getORACharacterSet() {
        String string;
        if (this.process_flag == PROCESS_STRING) {
            return ORA_UTF16;
        }
        String string2 = (String)this.resultArray[0][0];
        String string3 = string2.substring(string2.indexOf(95) + 1);
        int n = this.profile.promote_demote(Integer.parseInt(this.ob.getCharSetId(string3)));
        if (!(n != 2000 || !this.profile.isAL16UTF16() || (string = string2.substring(0, string2.indexOf(95))).equals("ja") || string.equals("ko") || string.equals("zh") || string.equals("zt"))) {
            n = 2002;
        }
        string = this.ob.getCharSetName(Integer.toString(n));
        return string;
    }

    public String getORACharacterSet(int n) {
        String string;
        if (this.process_flag == PROCESS_STRING && n == 1) {
            return ORA_UTF16;
        }
        String string2 = (String)this.resultArray[n - 1][0];
        String string3 = string2.substring(string2.indexOf(95) + 1);
        int n2 = Integer.parseInt(this.ob.getCharSetId(string3));
        int n3 = this.profile.promote_demote(n2);
        if (!(n3 != 2000 || !this.profile.isAL16UTF16() || (string = string2.substring(0, string2.indexOf(95))).equals("ja") || string.equals("ko") || string.equals("zh") || string.equals("zt"))) {
            n3 = 2002;
        }
        string = this.ob.getCharSetName(Integer.toString(n3));
        return string;
    }

    public int getHiHitPairs() {
        float f;
        float f2 = ((Float)this.resultArray[0][1]).floatValue();
        if ((double)((f2 - (f = ((Float)this.resultArray[1][1]).floatValue())) / f2) < 0.05) {
            float f3 = ((Float)this.resultArray[2][1]).floatValue();
            if ((double)((f2 - f3) / f2) < 0.05) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public int getSize() {
        int n = 0;
        int n2 = this.resultArray.length;
        n = 0;
        while (n < n2) {
            if (((Float)this.resultArray[n][1]).floatValue() == 0.0f) break;
            ++n;
        }
        return n;
    }

    public float getRatio() {
        return ((Float)this.resultArray[0][1]).floatValue();
    }

    public float getRatio(int n) {
        return ((Float)this.resultArray[n - 1][1]).floatValue();
    }
}

