package samples.webcenter.services.wiki.remote;

public class WikiServiceProxy implements samples.webcenter.services.wiki.remote.WikiService {
  private String _endpoint = null;
  private samples.webcenter.services.wiki.remote.WikiService wikiService = null;
  
  public WikiServiceProxy() {
    _initWikiServiceProxy();
  }
  
  public WikiServiceProxy(String endpoint) {
    _endpoint = endpoint;
    _initWikiServiceProxy();
  }
  
  private void _initWikiServiceProxy() {
    try {
      wikiService = (new samples.webcenter.services.wiki.remote.WikiServiceServiceLocator()).getWikiRemoteService();
      if (wikiService != null) {
        if (_endpoint != null)
          ((javax.xml.rpc.Stub)wikiService)._setProperty("javax.xml.rpc.service.endpoint.address", _endpoint);
        else
          _endpoint = (String)((javax.xml.rpc.Stub)wikiService)._getProperty("javax.xml.rpc.service.endpoint.address");
      }
      
    }
    catch (javax.xml.rpc.ServiceException serviceException) {}
  }
  
  public String getEndpoint() {
    return _endpoint;
  }
  
  public void setEndpoint(String endpoint) {
    _endpoint = endpoint;
    if (wikiService != null)
      ((javax.xml.rpc.Stub)wikiService)._setProperty("javax.xml.rpc.service.endpoint.address", _endpoint);
    
  }
  
  public samples.webcenter.services.wiki.remote.WikiService getWikiService() {
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService;
  }
  
  public samples.webcenter.services.wiki.SearchResult[] search(java.lang.String searchText, samples.webcenter.services.wiki.SearchType type, int maxResults, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.search(searchText, type, maxResults, key);
  }
  
  public java.lang.String login(java.lang.String username, java.lang.String passcode) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.login(username, passcode);
  }
  
  public void logout(java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.logout(key);
  }
  
  public samples.webcenter.services.wiki.PageInfo getPageInfo(java.lang.String domainName, java.lang.String pageName, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getPageInfo(domainName, pageName, key);
  }
  
  public void createPage(java.lang.String domainName, java.lang.String pageName, samples.webcenter.services.wiki.PageEditMode mode, samples.webcenter.services.wiki.PageType type, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.createPage(domainName, pageName, mode, type, key);
  }
  
  public boolean enablePersonalBlog(java.lang.String description, boolean enable, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.enablePersonalBlog(description, enable, key);
  }
  
  public void deleteDomain(java.lang.String domainName, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.deleteDomain(domainName, key);
  }
  
  public void deletePage(java.lang.String domainName, java.lang.String pageName, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.deletePage(domainName, pageName, key);
  }
  
  public samples.webcenter.services.wiki.DomainInfo getDomainInfo(java.lang.String domainName, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getDomainInfo(domainName, key);
  }
  
  public samples.webcenter.services.wiki.DomainInfo[] getAllDomainInfo(int maxResults, int offset, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getAllDomainInfo(maxResults, offset, key);
  }
  
  public void createDomain(java.lang.String domainName, java.lang.String description, java.lang.String startPage, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.createDomain(domainName, description, startPage, key);
  }
  
  public void editDomainInfo(java.lang.String domainName, java.lang.String description, java.lang.String startPage, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.editDomainInfo(domainName, description, startPage, key);
  }
  
  public samples.webcenter.services.wiki.PageInfo[] getAllPageInfo(java.lang.String domainName, int maxResults, int offset, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getAllPageInfo(domainName, maxResults, offset, key);
  }
  
  public java.lang.String getPlainPage(java.lang.String domainName, java.lang.String pageName, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getPlainPage(domainName, pageName, key);
  }
  
  public java.lang.String getRenderedPage(java.lang.String domainName, java.lang.String pageName, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getRenderedPage(domainName, pageName, key);
  }
  
  public void savePage(java.lang.String domainName, java.lang.String pageName, java.lang.String content, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.savePage(domainName, pageName, content, key);
  }
  
  public void createBlogEntry(java.lang.String blogName, java.lang.String title, java.lang.String content, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.createBlogEntry(blogName, title, content, key);
  }
  
  public void editBlogEntry(java.lang.String blogEntryID, java.lang.String title, java.lang.String content, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.editBlogEntry(blogEntryID, title, content, key);
  }
  
  public void deleteBlogEntry(java.lang.String blogEntryID, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.deleteBlogEntry(blogEntryID, key);
  }
  
  public java.lang.String getBlogEntry(java.lang.String blogEntryID, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getBlogEntry(blogEntryID, key);
  }
  
  public java.lang.String[] getAllBlogEntries(java.lang.String blogName, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getAllBlogEntries(blogName, key);
  }
  
  public void createBlogEntryComment(java.lang.String blogEntryID, java.lang.String text, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    wikiService.createBlogEntryComment(blogEntryID, text, key);
  }
  
  public java.lang.String[] getAllBlogEntryComments(java.lang.String blogEntryID, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getAllBlogEntryComments(blogEntryID, key);
  }
  
  public java.lang.String[] getListofBlogs(samples.webcenter.services.wiki.BlogType type, java.lang.String keyword, int maxResults, int offset, java.lang.String key) throws java.rmi.RemoteException{
    if (wikiService == null)
      _initWikiServiceProxy();
    return wikiService.getListofBlogs(type, keyword, maxResults, offset, key);
  }
  
  
}