<jsp:root 
    version="2.0" 
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:portlet="http://java.sun.com/portlet"
    xmlns:c="http://java.sun.com/jsp/jstl/core"
    xmlns:fmt="http://java.sun.com/jsp/jstl/fmt"
>
	<jsp:directive.page session="false"/>
	<jsp:directive.page isELIgnored="false"/>
	<fmt:setLocale value=""/>
	<fmt:setBundle basename="samples.webcenter.portlets.wiki.WikiPortlet"/>		
	<portlet:defineObjects/>
	<fmt:message key='wiki.done.label' var="wiki_done_label"/>
	<fmt:message key='wiki.done.desc' var="wiki_done_desc"/>
	<jsp:include page="views/init.jspx"/>
	<portlet:actionURL var="actionURL" portletMode="edit"/>
	<c:set var="wiki_templates"><fmt:message key='wiki.templates'/></c:set>
	<div class="wiki-edit">
		<h3><fmt:message key='wiki.pref.desc'/></h3>
		<h4 id="${uid}_message"></h4>
		<form method="POST" action="${actionURL}">
			<div>
				<label for="wiki_url"><fmt:message key='wiki.url.label'/>:</label>
				<input id="wiki_url" name="wiki_url" type="text" value="${wiki_url}"/>
			</div>
			<div>
				<label for="wiki_scope"><fmt:message key='wiki.scope.label'/>:</label>
				<select id="wiki_scope" name="wiki_scope">
					<c:forEach items="${all_domain_info}" var="info">
						<c:choose>
							<c:when test="${wiki_scope == info.domain}">
								<option value="${info.domain}" selected="true">${info.domain}</option>
								<c:set var="wiki_selection" value="true"/>								
							</c:when>
							<c:otherwise>
								<option value="${info.domain}">${info.domain}</option>
							</c:otherwise>
						</c:choose>
					</c:forEach>
					<c:if test="${wiki_selection != 'true'}">
						<option value="" selected="true"></option>
					</c:if>
				</select>				
			</div>
			<div>
				<label for="wiki_page"><fmt:message key='wiki.page.label'/>:</label>
				<input id="wiki_page" name="wiki_page" type="text" value="${wiki_page}"/>
			</div>
			<div>
				<label for="wiki_max_pages"><fmt:message key='wiki.max.pages.label'/>:</label>
				<input id="wiki_max_pages" name="wiki_max_pages" type="text" value="${wiki_max_pages}"/>
			</div>
			<div>
				<label for="wiki_template"><fmt:message key='wiki.template.label'/>:</label>
				<select id="wiki_template" name="wiki_template">
					<c:forTokens items="${wiki_templates}" delims="," var="template">
						<c:choose>
							<c:when test="${wiki_template == template}">
								<option value="${template}" selected="true">${template}</option>
							</c:when>
							<c:otherwise>
								<option value="${template}">${template}</option>
							</c:otherwise>
						</c:choose>
					</c:forTokens>
				</select>
			</div>
			<div>
				<input id="wiki_submit" name="wiki_submit" type="submit" value="${wiki_done_label}"/>
			</div>
		</form>
	</div>
</jsp:root>