<jsp:root 
    version="2.0" 
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:portlet="http://java.sun.com/portlet"
    xmlns:c="http://java.sun.com/jsp/jstl/core"
    xmlns:fmt="http://java.sun.com/jsp/jstl/fmt"
>
	<jsp:directive.page session="false"/>
	<jsp:directive.page isELIgnored="false"/>
	<fmt:setLocale value=""/>
	<fmt:setBundle basename="samples.webcenter.portlets.blog.BlogPortlet"/>		
	<portlet:defineObjects/>
	<fmt:message key='blog.done.label' var="blog_done_label"/>
	<fmt:message key='blog.done.desc' var="blog_done_desc"/>
	<jsp:include page="views/init.jspx"/>	
	<portlet:actionURL var="actionURL" portletMode="edit"/>
	<c:set var="blog_templates"><fmt:message key='blog.templates'/></c:set>
	<div class="blog-edit">
		<h3><fmt:message key='blog.pref.desc'/></h3>
		<h4 id="${uid}_message"></h4>
		<form method="POST" action="${actionURL}">
			<div>
				<label for="blog_url"><fmt:message key='blog.url.label'/>:</label>
				<input id="blog_url" name="blog_url" type="text" value="${blog_url}"/>
			</div>
			<div>
				<label for="blog_type"><fmt:message key='blog.type.label'/>:</label>
				<select id="blog_type" name="blog_type">
					<c:choose>
						<c:when test="${blog_type == 'domain'}">
							<option value="user"><fmt:message key='blog.type.personal.label'/></option>
							<option value="domain" selected="true"><fmt:message key='blog.type.community.label'/></option>
						</c:when>
						<c:otherwise>
							<option value="user" selected="true"><fmt:message key='blog.type.personal.label'/></option>
							<option value="domain"><fmt:message key='blog.type.community.label'/></option>
						</c:otherwise>
					</c:choose>
				</select>
			</div>
			<div>
				<label for="blog_scope"><fmt:message key='blog.scope.personal.label'/>:</label>
				<select id="blog_scope" name="blog_scope">
					<c:forEach items="${blog_names}" var="name">
						<c:choose>
							<c:when test="${pageContext.request.userPrincipal.name == name && blog_type == 'user'}">
								<c:set var="blog_personal" value="true" scope="request"/>
								<c:choose>
									<c:when test="${blog_scope == name}">
										<option value="${name}" selected="true">${name} (Your personal blog)</option>
										<c:set var="blog_selection" value="true" scope="request"/>
									</c:when>
									<c:otherwise>
										<option value="${name}">${name} (Your personal blog)</option>
									</c:otherwise>
								</c:choose>
							</c:when>
							<c:when test="${blog_scope == name}">
								<option value="${name}" selected="true">${name}</option>									
								<c:set var="blog_selection" value="true" scope="request"/>
							</c:when>
							<c:otherwise>
								<option value="${name}">${name}</option>
							</c:otherwise>
						</c:choose>
					</c:forEach>
					<c:if test="${blog_personal != 'true' && pageContext.request.userPrincipal != null}">
						<option value="${pageContext.request.userPrincipal.name}">${pageContext.request.userPrincipal.name} (Your personal blog)</option>
					</c:if>
					<c:if test="${blog_selection != 'true'}">
						<option value="" selected="true"></option>
					</c:if>
				</select>
			</div>
			<div>
				<label for="blog_show"><fmt:message key='blog.show.label'/>:</label>
				<select id="blog_show" name="blog_show">
					<c:choose>
						<c:when test="${blog_show == 'single'}">
							<option value="all"><fmt:message key='blog.show.all.label'/></option>
							<option value="single" selected="true"><fmt:message key='blog.show.single.label'/></option>
						</c:when>
						<c:otherwise>
							<option value="all" selected="true"><fmt:message key='blog.show.all.label'/></option>
							<option value="single"><fmt:message key='blog.show.single.label'/></option>
						</c:otherwise>
					</c:choose>
				</select>
			</div>
			<div>
				<label for="blog_entry_id"><fmt:message key='blog.entry.id.label'/>:</label>
				<input id="blog_entry_id" name="blog_entry_id" type="text" value="${blog_entry_id}"/>
			</div>
			<div>
				<label for="blog_max_entries"><fmt:message key='blog.max.entries.label'/>:</label>
				<input id="blog_max_entries" name="blog_max_entries" type="text" value="${blog_max_entries}"/>
			</div>
			<div>
				<label for="blog_template"><fmt:message key='blog.template.label'/>:</label>
				<select id="blog_template" name="blog_template">
					<c:forTokens items="${blog_templates}" delims="," var="template">
						<c:choose>
							<c:when test="${blog_template == template}">
								<option value="${template}" selected="true">${template}</option>
							</c:when>
							<c:otherwise>
								<option value="${template}">${template}</option>
							</c:otherwise>
						</c:choose>
					</c:forTokens>
				</select>
			</div>
			<div>
				<input id="blog_submit" name="blog_submit" type="submit" value="${blog_done_label}"/>
			</div>
		</form>
	</div>
</jsp:root>