
function wikiPortlet_alert(uid, text) {
	var msg = document.getElementById(uid + "_message");
	if (msg) {
		msg.innerHTML = text;
	}
}

function wikiPortlet_confirm(uid, text) {
	return confirm(text);
}

function wikiPortlet_select(uid, t) {
	t.className = "wiki-link-selected";
	var o = document.getElementById(uid + "_link_${selectedIndex}");
	if (o) {
		o.className = "wiki-link";
	}
}

function wikiPortlet_navClick(uid, e) {
	e = e ? e : window.event;
	var target = e.target || e.srcElement;
	var ie = navigator.userAgent.toLowerCase().indexOf("msie") >= 0 ? true : false;
	var box = {
		left: target.offsetLeft + target.offsetWidth - 5,
		top: target.offsetTop + (target.offsetHeight / 2) - 12,
		right: target.offsetLeft + target.offsetWidth,
		bottom: target.offsetTop + (target.offsetHeight / 2) + 12
	};
	var point = {
		x: ie ? e.offsetX + target.offsetLeft: e.clientX,
		y: ie ? e.offsetY + target.offsetTop : e.clientY 
	}
	if (point.x >= box.left && point.x <= box.right) {
		if (point.y >= box.top && point.y <= box.bottom) {
			var navDiv = document.getElementById(uid + "_wiki_nav"); 				
			var mainDiv = document.getElementById(uid + "_wiki_main"); 				
			if (navDiv.className.indexOf("wiki-nav wiki-nav-collapsed") >= 0) {
				navDiv.className = "wiki-nav";
				navDiv.firstChild.style.visibility = "visible";
			} else {
				navDiv.className = "wiki-nav wiki-nav-collapsed";					
				navDiv.firstChild.style.visibility = "hidden";
			}
			if (mainDiv.className.indexOf("wiki-main wiki-main-expanded") >= 0) {
				mainDiv.className = "wiki-main";
			} else {
				mainDiv.className = "wiki-main wiki-main-expanded";					
			}
		}
	}
}

function wikiPortlet_doSearch(uid) {
	var form = document.getElementById(uid + "_wiki_search_form");
	form.submit();
}

function wikiPortlet_nospaces(t) {
	if (t.value.match(/\s/g)) {
		t.value = t.value.replace(/\s/g, '');
	}
}

function wikiPortlet_checkWikiName(name){
	// Return true as this can be too picky...
	return true;
	
	
	// Check for unchanged name
	if (name == '${page_info.name}') {
		return true;
	} else if (name.match(/[A-Z][a-z0-9]*[0-9A-Z]/)) {
		var wikiName = name.match(/[A-Z][a-z0-9]*[0-9A-Z]/).toString();
		if (wikiName.length > 2) {
			return true;
		}
	}
	
	return false;
}

function wikiPortlet_doCreate(uid) {
	setTimeout("wikiPortlet_doOpenEditor('" + uid + "', 'create', '', '')", 500);
}

function wikiPortlet_doEdit(uid) {
	var content = document.getElementById(uid + "_content");
	var nameDiv = document.getElementById(uid + "_name");
	wikiPortlet_doOpenEditor(uid, "update", nameDiv.innerHTML, content.innerHTML);
}

function wikiPortlet_doDelete(uid, msg) {
	if (confirm(msg)) {
		var actionInput = document.getElementById(uid + "_page_action");
		actionInput.value = "delete";
		var form = document.getElementById(uid + "_page_content_form");
		form.submit();			
	}
}

function wikiPortlet_doOpenEditor(uid, action, name, text) {
	var editor = document.getElementById(uid + "_editor");
	var editorButtons = document.getElementById(uid + "_editor_buttons");
	var actionInput = document.getElementById(uid + "_page_action");
	var content = document.getElementById(uid + "_content");
	var info = document.getElementById(uid + "_info");
	var controls = document.getElementById(uid + "_controls");
	var nameDiv = document.getElementById(uid + "_name");
	var nameEdit = document.getElementById(uid + "_name_edit");
	var nameEditor = document.getElementById(uid + "_name_editor");

	actionInput.value = action;
	editor.innerHTML = "";
	
	var textarea = document.createElement("textarea");
	textarea.id = uid + "_textarea";
	textarea.value = text.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	editor.appendChild(textarea);		
       
	content.style.display = "";
	var e = content;
	var y = 0;
	while (e) {
		y += e.offsetTop;
		e = e.offsetParent;
	}
	var h = (document.documentElement.clientHeight - y) - 100;
	h = h < 200 ? 200 : h;
	
	if (typeof FCKeditor != "undefined") {
		var oFCKeditor = new FCKeditor(uid + "_textarea");
		//oFCKeditor.BasePath = window.location.protocol + "//" + window.location.host + "/" + window.location.pathname.split("/")[1] + "/fckeditor/";
		oFCKeditor.BasePath = wikiblogPortlet_fckeditorPath;
		oFCKeditor.ToolbarSet= 'Basic';
		oFCKeditor.Height = h < 200 ? 200 : h;			
		oFCKeditor.ReplaceTextarea();
	} else {
		textarea.style.height = h + "px";
	}

	if (action == "create") {
		nameEditor.value = name;
		nameDiv.style.display = "none";
		nameEdit.style.display = "";
	}
	content.style.display = "none";
	info.style.display = "none";
	controls.style.display = "none";
	editor.style.display = "";
	editorButtons.style.display = "";
}

function wikiPortlet_doShowContent(uid, name, html) {
	var content = document.getElementById(uid + "_content");
	var info = document.getElementById(uid + "_info");
	var controls = document.getElementById(uid + "_controls");
	var editor = document.getElementById(uid + "_editor");
	var editorButtons = document.getElementById(uid + "_editor_buttons");
	var nameDiv = document.getElementById(uid + "_name");
	var nameEdit = document.getElementById(uid + "_name_edit");
	var nameEditor = document.getElementById(uid + "_name_editor")
	
	if (html) {
		content.innerHTML = html;
	}
	
	if (name) {
		nameDiv.innerHTML = name;
		nameEditor.value = name;
	}
	
	nameDiv.style.display = "";
	nameEdit.style.display = "none";
	content.style.display = "";
	info.style.display = "";
	controls.style.display = "";
	editor.style.display = "none";
	editorButtons.style.display = "none";
}

function wikiPortlet_doSave(uid) {

	var nameEditor = document.getElementById(uid + "_name_editor")
	var name = nameEditor.value;
	
	if (wikiPortlet_checkWikiName(name)) {
		 var nameDiv = document.getElementById(uid + "_name");
		 var nameEdit = document.getElementById(uid + "_name_edit");
		 var nameField = document.getElementById(uid + "_page_name_field");
		 nameField.value = name;
		 
		var html = null;
		
		if (typeof FCKeditor != "undefined") {
			var oFCKeditor = FCKeditorAPI.GetInstance(uid + "_textarea");
			if (oFCKeditor) {
				html = oFCKeditor.GetHTML();
			}
		} else {
			var textarea = document.getElementById(uid + "_textarea");
			if (textarea) {
				html = textarea.value;
			}
		}
		
		if (!html) {
			alert("Content could not be saved.");
			wikiPortlet_doCancel(uid);
			return;
		}
		
		var contentField = document.getElementById(uid + "_page_content_field");
		contentField.value = html;
		
		var form = document.getElementById(uid + "_page_content_form");
		form.submit();
	} else {
		alert(name + " is not a valid WikiName");
	}
}

function wikiPortlet_doCancel(uid) {
	wikiPortlet_doShowContent(uid);
}
