
function blogPortlet_alert(uid, text) {
	var msg = document.getElementById(uid + "_message");
	if (msg) {
		msg.innerHTML = text;
	}
}

function blogPortlet_confirm(uid, text) {
	return confirm(text);
}

function blogPortlet_expandShrink(uid, blogEntryId) {
	var id = uid + "_" + blogEntryId;
	var link = document.getElementById(id + "_link");
	var c = link.className;
	c = (c == "blog-entry-toggle blog-entry-toggle-closed") ? "blog-entry-toggle blog-entry-toggle-open" : "blog-entry-toggle blog-entry-toggle-closed";
	link.className = c;
	var content = document.getElementById(id + "_content");
	c = content.className;
	c = (c == "blog-entry-content blog-entry-content-collapsed") ? "blog-entry-content blog-entry-content-expanded" : "blog-entry-content blog-entry-content-collapsed";
	content.className = c;
}

function blogPortlet_doCreate(uid) {
	setTimeout("blogPortlet_doOpenEditor('" + uid + "', 'create', '', '')", 500);
}

function blogPortlet_doEdit(uid) {
	var content = document.getElementById(uid + "_content");
	var titleDiv = document.getElementById(uid + "_title");
	blogPortlet_doOpenEditor(uid, "update", titleDiv.innerHTML, content.innerHTML);
}

function blogPortlet_doDelete(uid, msg) {
	if (confirm(msg)) {
		var actionInput = document.getElementById(uid + "_blog_action");
		actionInput.value = "delete";
		var form = document.getElementById(uid + "_blog_content_form");
		form.submit();			
	}
}

function blogPortlet_doOpenEditor(uid, action, title, text) {
	var editor = document.getElementById(uid + "_editor");
	var editorButtons = document.getElementById(uid + "_editor_buttons");
	var actionInput = document.getElementById(uid + "_blog_action");
	var content = document.getElementById(uid + "_content");
	var info = document.getElementById(uid + "_info");
	//var controls = document.getElementById(uid + "_controls");
	var comments = document.getElementById(uid + "_comments");
	var titleDiv = document.getElementById(uid + "_title");
	var titleEdit = document.getElementById(uid + "_title_edit");
	var titleEditor = document.getElementById(uid + "_title_editor");

	actionInput.value = action;
	editor.innerHTML = "";

	var textarea = document.createElement("textarea");
	textarea.id = uid + "_textarea";
	//textarea.className = "blog-editor-non-rte";
	textarea.value = text.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	editor.appendChild(textarea);		

	content.style.display = "";
	var e = content;
	var y = 0;
	while (e) {
		y += e.offsetTop;
		e = e.offsetParent;
	}
	var h = (document.documentElement.clientHeight - y) - 100;
	h = h < 200 ? 200 : h;
	
	if (typeof FCKeditor != "undefined") {
		var oFCKeditor = new FCKeditor(uid + "_textarea");
		//oFCKeditor.BasePath = window.location.protocol + "//" + window.location.host + "/" + window.location.pathname.split("/")[1] + "/fckeditor/";
		oFCKeditor.BasePath = wikiblogPortlet_fckeditorPath;
		oFCKeditor.ToolbarSet= 'Basic';
		oFCKeditor.Height = h < 200 ? 200 : h;			
		oFCKeditor.ReplaceTextarea();
	} else {
		textarea.style.height = h + "px";
	}
	
	titleEditor.value = title;
	titleDiv.style.display = "none";
	titleEdit.style.display = "";
	content.style.display = "none";
	info.style.display = "none";
	comments.style.display = "none";
	//controls.style.display = "none";
	editor.style.display = "";
	editorButtons.style.display = "";
}

function blogPortlet_doShowContent(uid, title, html) {
	var content = document.getElementById(uid + "_content");
	var info = document.getElementById(uid + "_info");
	//var controls = document.getElementById(uid + "_controls");
	var comments = document.getElementById(uid + "_comments");
	var editor = document.getElementById(uid + "_editor");
	var editorButtons = document.getElementById(uid + "_editor_buttons");
	var titleDiv = document.getElementById(uid + "_title");
	var titleEdit = document.getElementById(uid + "_title_edit");
	var titleEditor = document.getElementById(uid + "_title_editor");

	if (html) {
		content.innerHTML = html;
	}
	
	if (title) {
		titleDiv.innerHTML = title;
	}
	
	titleDiv.style.display = "";
	titleEdit.style.display = "none";
	content.style.display = "";
	info.style.display = "";
	comments.style.display = "";
	//controls.style.display = "";
	editor.style.display = "none";
	editorButtons.style.display = "none";
}

function blogPortlet_doSave(uid) {

	var html = null;
	
	if (typeof FCKeditor != "undefined") {
		var oFCKeditor = FCKeditorAPI.GetInstance(uid + "_textarea");
		if (oFCKeditor) {
			html = oFCKeditor.GetHTML();
		}
	} else {
		var textarea = document.getElementById(uid + "_textarea");
		if (textarea) {
			html = textarea.value;
		}
	}
	
	if (!html) {
		alert("Content could not be saved.");
		blogPortlet_doCancel(uid);
		return;
	}
	
	var contentField = document.getElementById(uid + "_blog_content_field");
	contentField.value = html;

	var titleDiv = document.getElementById(uid + "_title");
	var titleEdit = document.getElementById(uid + "_title_edit");
	var titleEditor = document.getElementById(uid + "_title_editor");

	var titleField = document.getElementById(uid + "_blog_title_field");
	titleField.value = titleEditor.value;
	
	var form = document.getElementById(uid + "_blog_content_form");
	form.submit();
}

function blogPortlet_doSaveComment(uid, auth) {
	var textfield = document.getElementById(uid + "_blog_comment_text");
	if (textfield.value == null || textfield.value.length <= 0) {
		alert("Please enter a comment.");
		return;
	} else if (!auth) {
		var username = document.getElementById(uid + "_blog_comment_username");
		var email = document.getElementById(uid + "_blog_comment_email");
		if (username.value == null || username.value.length <= 0) {
			alert("Please enter your name.");
			return;
		} else if (email.value == null || email.value.length <= 0) {
			alert("Please enter your email address.");
			return;
		}
	}
	
	var form = document.getElementById(uid + "_blog_comment_form");
	form.submit();
}

function blogPortlet_doCancel(uid) {
	blogPortlet_doShowContent(uid);
}
