----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


SET LINESIZE 100
SET PAGESIZE 1000

COLUMN subject    FORMAT A30 WORD
COLUMN predicate  FORMAT A30 WORD
COLUMN object     FORMAT A30 WORD

BREAK ON subject DUP ON predicate DUP SKIP 1

PROMPT
PROMPT ***********************************************************
PROMPT ** Exercise 9: Demonstrate the importance of properly    **
PROMPT **             defining the semantics.                   **
PROMPT ***********************************************************
PROMPT

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUESTION: Can the "hasParent" property be re-used to assert
PROMPT **           the ancestry of Sherman (Bobby Smith's dog)?
PROMPT **
PROMPT ** ANSWER:   Absolutely it can, so create the triples to annotate
PROMPT **           Sherman and his parents.
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Dog>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Dog>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Dog"^^<http://www.w3.org/2001/XMLSchema#string>'));

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Sherman>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Dog>'))

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Sherman>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Sherman the Dog"^^<http://www.w3.org/2001/XMLSchema#string>'));

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Molly>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Dog>'))

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Molly>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Molly the Dog"^^<http://www.w3.org/2001/XMLSchema#string>'));

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Max>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Dog>'))

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Max>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Max the Dog"^^<http://www.w3.org/2001/XMLSchema#string>'));

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Sherman>',
     '<http://www.example.org/familytree#hasParent>',
     '<http://www.example.org/familytree#Max>'))

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Sherman>',
     '<http://www.example.org/familytree#hasParent>',
     '<http://www.example.org/familytree#Molly>'))

RUN

COMMIT;


PROMPT EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************
PROMPT ** QUERY 9-1: Given the new data, what do we know about
PROMPT **            Sherman the Dog?
PROMPT

SELECT sl subject, p$_SUFFIX predicate, ol object
FROM   TABLE(SEM_MATCH('
          {
            ?s ?p ?o .
            ?s rdfs:label ?sl .
            ?o rdfs:label ?ol .
            FILTER( ?s = :Sherman )
          }',
          SEM_MODELS('familytree'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************
PROMPT ** QUERY 9-2: What do we know about Sherman if we include
PROMPT **            the inferencing set?
PROMPT

SELECT sl subject, p$_SUFFIX predicate, ol object
FROM   TABLE(SEM_MATCH('
          {
            ?s ?p ?o .
            ?s rdfs:label ?sl .
            ?o rdfs:label ?ol .
            FILTER( ?s = :Sherman )
          }',
          SEM_MODELS('familytree'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUESTION: Why is Sherman the Dog now classified as a "Human
PROMPT **           Being" (i.e. Person class)?
PROMPT **
PROMPT ** ANSWER:   Because of the semantics of the "isRelatedTo"
PROMPT **           property, which is the parent property of "hasChild".
PROMPT **
PROMPT **           Although this sounds appropriate, the actual semantics
PROMPT **           of "hasChild" specifies that the property's domain
PROMPT **           and range are members of the Person class.
PROMPT **
PROMPT **           Unlike relational which is based on a "closed world"
PROMPT **           assumption, the Semantic Web operates on the
PROMPT **           "open world" assumption which uses the metadata to
PROMPT **           classify the data rather than restrict the data.
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT **********************************************************************
PROMPT ** QUERY 9-3: What are the semantics of the "isRelatedTo"
PROMPT **            and "hasChild" properties?
PROMPT

CLEAR BREAKS

BREAK ON subject DUP SKIP 1

SELECT s$_SUFFIX subject, p$_SUFFIX predicate, NVL(o$_SUFFIX,o) object
FROM   TABLE(SEM_MATCH('
          {
            ?s ?p ?o .
            FILTER( (?s = :isRelatedTo || ?o = :isRelatedto
                  || ?s = :hasChild    || ?o = :hasChild )
                 && (?o != owl:Thing)  )
          }',
          SEM_MODELS('familytree'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,3,2

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

