----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


SET LINESIZE 100
SET PAGESIZE 1000

COLUMN class      FORMAT A40 WORD
COLUMN label      FORMAT A30 WORD
COLUMN domain     FORMAT A30 WORD
COLUMN property   FORMAT A30 WORD
COLUMN range      FORMAT A30 WORD

COLUMN subject    FORMAT A30 WORD
COLUMN predicate  FORMAT A30 WORD
COLUMN object     FORMAT A30 WORD
COLUMN person     FORMAT A30 WORD
COLUMN gender     FORMAT A10 WORD

COLUMN parent     FORMAT A30 WORD

COLUMN ancestor   FORMAT A30 WORD

COLUMN relative   FORMAT A30 WORD

PROMPT
PROMPT **********************************************************************
PROMPT ** Exercise 8: Demonstrate the semantics of the Symmetric,
PROMPT **             Inverse-Of, and Transitive properties in OWL.
PROMPT **********************************************************************
PROMPT
PROMPT *****
PROMPT ***** Cleaning Up FAMILYTREE Environment ...
PROMPT *****
PROMPT

EXEC SEM_APIS.DROP_ENTAILMENT('familytree_rix');

EXEC SEM_APIS.DROP_SEM_MODEL('familytree');

DROP TABLE familytree_tpl;

PROMPT *****
PROMPT ***** Setting Up FAMILYTREE Environment ...
PROMPT *****

PROMPT
PROMPT ***** Creating the FAMILYTREE_TPL triples table ...
PROMPT

CREATE TABLE familytree_tpl (triple SDO_RDF_TRIPLE_S) COMPRESS;

PROMPT
PROMPT ***** Creating the FAMILYTREE semantic model ...
PROMPT 

EXEC SEM_APIS.CREATE_SEM_MODEL('familytree','familytree_tpl','triple');

PROMPT
PROMPT ***** Inserting FAMILYTREE graph data ...
PROMPT

SET FEED OFF

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CamrynLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Ontology>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CamrynLund>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Camryn Lund"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CamrynLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ScottGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ScottGreene>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Scott Greene"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ScottGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ChelseaSmith>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#JoeyStone>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ChelseaSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#CaydenStone>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ChelseaSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Chelsea Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ChelseaSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ChelseaSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#FreemanRoy>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#FreemanRoy>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Freeman Roy"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#FreemanRoy>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AmySmith>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#NateLund>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AmySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#CamrynLund>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AmySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ColeLund>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AmySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#NickLund>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AmySmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Amy Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AmySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AmySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#DavidGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#TylerGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#AshleyGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#DillonGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Lisa Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ScottGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LisaSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#OnaGentry>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#TomAdams>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#OnaGentry>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#LillyAdams>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#OnaGentry>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#OnaGentry>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Ona Gentry"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#OnaGentry>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SamSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SamSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ChelseaSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SamSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#KyleSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SamSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#TaylorSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SamSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Sam Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SamSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#FreemanRoy>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#MarkFerguson>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#SteveFerguson>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#LindaFerguson>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#VirginiaFerguson>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Shirley Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ShirleySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Person>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Human being"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Person>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.w3.org/2002/07/owl#Thing>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Person>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#VirginiaFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#VirginiaFerguson>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Virginia Ferguson"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#VirginiaFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#KyleSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#KyleSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Kyle Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#KyleSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Female>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Female"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Female>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.w3.org/2002/07/owl#Thing>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Female>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#JimmySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#JeffSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#WandaSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#TerrySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#LisaSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#SamSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Bobby Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BobbySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#MickeySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NickLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NickLund>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Nick Lund"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NickLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ColeLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ColeLund>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Cole Lund"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#ColeLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#PattiSims>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#SamSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#PattiSims>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Patti Sims"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#PattiSims>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#PattiSims>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#TaylorSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#PattiSims>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#KyleSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#PattiSims>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ChelseaSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#PattiSims>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#RobAdams>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Rob Adams"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#RobAdams>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MarkFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MarkFerguson>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Mark Ferguson"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MarkFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CarcieSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CarcieSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#BobbySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CarcieSmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ShirleySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CarcieSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Carcie Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CarcieSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AshleyGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AshleyGreene>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Ashley Greene"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#AshleyGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TaylorSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TaylorSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Taylor Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TaylorSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JoeyStone>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JoeyStone>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#CaydenStone>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JoeyStone>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Joey Stone"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JoeyStone>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JeffSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JeffSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Jeff Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JeffSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree>',
     '<http://www.w3.org/2002/07/owl#versionInfo>',
     '"Created with TopBraid Composer"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NateLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NateLund>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#CamrynLund>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NateLund>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ColeLund>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NateLund>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#NickLund>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NateLund>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Nate Lund"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#NateLund>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#WandaSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Wanda Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#WandaSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#WandaSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DillonGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DillonGreene>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Dillon Greene"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DillonGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"has child"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CaydenStone>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CaydenStone>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Cayden Stone"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#CaydenStone>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DavidGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DavidGreene>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#TylerGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DavidGreene>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#AshleyGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DavidGreene>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#DillonGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DavidGreene>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"David Greene"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DavidGreene>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ScottGreene>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#DavidGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JuliaPolson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JuliaPolson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JuliaPolson>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#MickeySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JuliaPolson>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#AmySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JuliaPolson>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#BrianSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JuliaPolson>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Julia Polson"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"is married to"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#GeneArmstrong>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Gene Armstrong"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#GeneArmstrong>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#GeneArmstrongII>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Gene Armstrong II"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#GeneArmstrongII>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Male>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Male>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.w3.org/2002/07/owl#Thing>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#Male>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TylerGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TylerGreene>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Tyler Greene"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TylerGreene>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JimmySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JimmySmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Jimmy Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#JimmySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#WandaSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#JeffSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#LisaSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#TerrySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#BobbySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Lilly Adams"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#JimmySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#SamSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LillyAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#MickeySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#RobertaFolsom>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#GeneArmstrongII>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#RobertaFolsom>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#GeneArmstrong>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#RobertaFolsom>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Roberta Folsom"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#RobertaFolsom>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LindaFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LindaFerguson>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Linda Ferguson"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LindaFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LauraWest>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Laura West"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LauraWest>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#BobbySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LauraWest>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#ShirleySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LauraWest>',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.example.org/familytree#CarcieSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LauraWest>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Female>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#LauraWest>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TomAdams>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TomAdams>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#LillyAdams>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TomAdams>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Tom Adams"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TomAdams>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MickeySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MickeySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#BrianSmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MickeySmith>',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.example.org/familytree#AmySmith>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MickeySmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Mickey Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#MickeySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BrianSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BrianSmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Brian Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#BrianSmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SteveFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SteveFerguson>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Steve Ferguson"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#SteveFerguson>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TerrySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Male>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TerrySmith>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Terry Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#TerrySmith>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example.org/familytree#Person>'));

COMMIT;

SET FEED ON

PROMPT
PROMPT ***** Compiling statistics on semantic data (this may take a few moments) ...
PROMPT

EXEC SEM_PERF.GATHER_STATS;

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **************************************************************
PROMPT ** QUERY 8-1: What classes exist in the FAMILYTREE ontology?
PROMPT

SELECT class, label
FROM   TABLE(SEM_MATCH('
          {
            ?class rdf:type owl:Class .
            OPTIONAL { ?class rdfs:label ?label } .
          }',
          SEM_MODELS('familytree'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 8-2: What properties exist in the FAMILYTREE ontology?
PROMPT

SELECT domain$_SUFFIX domain, property$_SUFFIX property,
       range$_SUFFIX range
FROM   TABLE(SEM_MATCH('
          {
            ?property rdf:type owl:ObjectProperty .
            ?property rdfs:domain ?domain .
            ?property rdfs:range ?range .
          }',
          SEM_MODELS('familytree'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 8-3: What do we know about Bobby Smith?
PROMPT

BREAK ON subject DUP ON predicate DUP SKIP 1

SELECT s$_SUFFIX subject, p$_SUFFIX predicate, NVL(o$_SUFFIX,o) object
FROM   TABLE(SEM_MATCH('
          {
            ?s ?p ?o .
            FILTER( ?s = :BobbySmith || ?o = :BobbySmith )
          }',
          SEM_MODELS('familytree'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

CLEAR BREAKs

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************************
PROMPT **                      OWL Symmetric Property
PROMPT **
PROMPT ** QUERY 8-4: What are the semantics of the "isMarriedTo" property?
PROMPT

SELECT s$_SUFFIX subject, p$_SUFFIX predicate, NVL(o$_SUFFIX,o) object
FROM   TABLE(SEM_MATCH('
          {
            ?s ?p ?o .
            FILTER( ?s = :isMarriedTo && ?p != rdfs:label )
          }',
          SEM_MODELS('familytree'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 8-5: Who is married and what is their gender?
PROMPT

SELECT person$_SUFFIX person, gender$_SUFFIX gender
FROM   TABLE(SEM_MATCH('
          {
            ?person :isMarriedTo ?o .
            ?person rdf:type ?gender .
            FILTER(?gender = :Male || ?gender = :Female)
          }',
          SEM_MODELS('familytree'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 2,1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUESTION: Why are only females married?
PROMPT **
PROMPT ** ANSWER:   RDF is a directed graph and all of the "isMarriedTo"
PROMPT **           triples in the model have females as the subject and
PROMPT **           males as the object of the RDF triple.
PROMPT **
PROMPT **           The Symmetric property in OWL states that any 
PROMPT **           assertion using a symmetric property is bi-directional
PROMPT **           (i.e. the RDF statement is true reading left to right
PROMPT **           as well as right to left).
PROMPT **
PROMPT **           Redefine the "isMarriedTo" property to be symmetric,
PROMPT **           run inferencing, and re-execute the query to include
PROMPT **           the inferencing set.
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to make the property Symmetric ... "
PROMPT

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#isMarriedTo>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#SymmetricProperty>'))

RUN

COMMIT;

PROMPT EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 8-6: Who is married and what is their gender?
PROMPT

SELECT person$_SUFFIX person, gender$_SUFFIX gender
FROM   TABLE(SEM_MATCH('
          {
            ?person :isMarriedTo ?o .
            ?person rdf:type ?gender .
            FILTER(?gender = :Male || ?gender = :Female)
          }',
          SEM_MODELS('familytree'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 2,1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/


PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************************
PROMPT **                      OWL Inverse-Of Property
PROMPT **
PROMPT ** QUERY 8-7: Who are the parents of Bobby Smith?
PROMPT

SELECT parent
FROM   TABLE(SEM_MATCH('
          {
            ?s :hasChild  :BobbySmith .
            ?s rdfs:label ?parent .
          }',
          SEM_MODELS('familytree'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUESTION: Should the "hasChild" property really be used to
PROMPT **           identify a parent?
PROMPT **
PROMPT ** ANSWER:   The use of a "hasParent" property would be more
PROMPT **           meaningful and intuitive. Semanticaly, it would be
PROMPT **           the inverse of the "hasChild" property.
PROMPT **
PROMPT **           The InverseOf property in OWL provides the ability to
PROMPT **           define a property that is the inverse (i.e. "opposite")
PROMPT **           of another poperty.
PROMPT ** 
PROMPT **           Create a new "hasParent" property that is the
PROMPT **           OWL:inverseOf the "hasChild" property, review the new
PROMPT **           property's inferred semantics, and use it to query
PROMPT **           for Bobby Smith's parents.
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.w3.org/2002/07/owl#inverseOf>',
     '<http://www.example.org/familytree#hasParent>'))

RUN

COMMIT;

PROMPT EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************************
PROMPT ** QUERY 8-8: What are the inferred semantics of the
PROMPT **  "hasParent" property?
PROMPT

SELECT s$_SUFFIX subject, p$_SUFFIX predicate, NVL(o$_SUFFIX,o) object
FROM   TABLE(SEM_MATCH('
          {
            ?s ?p ?o .
            FILTER( (?s = :hasParent || ?o = :hasParent)
                 && (?o != owl:Thing)  )
          }',
          SEM_MODELS('familytree'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,3,2

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 8-9: Who are the parents of Bobby Smith?
PROMPT

SELECT parent
FROM   TABLE(SEM_MATCH('
          {
            :BobbySmith :hasParent ?p .
            ?p rdfs:label ?parent .
          }',
          SEM_MODELS('familytree'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST 

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************************
PROMPT **                       OWL Transitive Property
PROMPT **
PROMPT ** QUESTION: Is it possible to identify the ancestors of Cole Lund?
PROMPT **
PROMPT ** ANSWER:   Not easily with the semantics defined in the current
PROMPT **           ontology. It is possible to iteratively query all
PROMPT **           instances of the "hasParent" property, but how many
PROMPT **           iterations must be traversed to return ALL ancestors?
PROMPT **
PROMPT **           The semantics of the Transitive property in OWL states
PROMPT **           that if X hasProperty Y, and Y hasProperty Z, then
PROMPT **           X hasProperty Z. Therefore, the creation of a
PROMPT **           transitive property that relies on triples that use
PROMPT **           the "hasParent" property would satisfy this request.
PROMPT **
PROMPT **           Create a new transitive "hasAncestor" property that is
PROMPT **           the parent to "hasChild",  run inferencing, and query
PROMPT **           for Cole Lund's ancestors.
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasParent>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example.org/familytree#hasAncestor>'))

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasAncestor>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#TransitiveProperty>'))

RUN

COMMIT;

PROMPT EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);


PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 8-10: Who are the ancestors of Cole Lund?
PROMPT

SELECT ancestor
FROM   TABLE(SEM_MATCH('
          {
            :ColeLund :hasAncestor ?a .
            ?a rdfs:label ?ancestor .
          }',
          SEM_MODELS('familytree'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST 

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************************
PROMPT **                   Using the Properties Together
PROMPT **
PROMPT ** QUESTION: Is it possible to know all of the relatives of
PROMPT **           Bobby Smith?
PROMPT **
PROMPT ** ANSWER:   Yes, by using the semantics of the Transitive and Symmetric
PROMPT **           Symmetric properties in conjunction with each other.
PROMPT **
PROMPT **           Many of the properties in OWL are not mutually excluseive
PROMPT **           of each other. Therefore, a property can be defined as
PROMPT **           both Symmetric and Transitive.
PROMPT **
PROMPT **           Create a new "isRelatedTo" property that is defined as
PROMPT **           Transitive and Symmetric and make it a parent property
PROMPT **           of "hasChild". Run inferencing and query for all the
PROMPT **           people related to Bobby Smith.
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#hasChild>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example.org/familytree#isRelatedTo>'))

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#isRelatedTo>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#TransitiveProperty>'))

RUN

INSERT INTO familytree_tpl VALUES (SDO_RDF_TRIPLE_S('familytree',
     '<http://www.example.org/familytree#isRelatedTo>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#SymmetricProperty>'))

RUN

COMMIT;

PROMPT EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

EXEC SEM_APIS.CREATE_ENTAILMENT('FAMILYTREE_RIX',SEM_MODELS('familytree'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);


PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 8-11: Who are all of Bobby Smith's relatives?
PROMPT

SELECT relative
FROM   TABLE(SEM_MATCH('
          {
            :BobbySmith :isRelatedTo ?r .
            ?r rdfs:label ?relative .
          }',
          SEM_MODELS('familytree'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.example.org/familytree#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/



