----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


SET LINESIZE 130
SET PAGESIZE 100

COLUMN type    FORMAT a10
COLUMN company FORMAT A10
COLUMN object  FORMAT A30

COLUMN local_term      FORMAT a47
COLUMN mapping_method  FORMAT a15
COLUMN standard_term   FORMAT a56

COLUMN firstname     FORMAT a10
COLUMN lastname      FORMAT a15
COLUMN manager_of    FORMAT a20
COLUMN organization  FORMAT a30

PROMPT
PROMPT ***********************************************************
PROMPT ** Exercise 7: Demonstrate the ability to semantics to   **
PROMPT **             synchronize disparate vocabularies from   **
PROMPT **             two separate data sources.                **
PROMPT ***********************************************************
PROMPT
PROMPT *****
PROMPT ***** Cleaning Up ACME and ICORP Environments ...
PROMPT *****
PROMPT

EXEC SEM_APIS.DROP_ENTAILMENT('integrator_rix');

EXEC SEM_APIS.DROP_SEM_MODEL('acme');
EXEC SEM_APIS.DROP_SEM_MODEL('icorp');
EXEC SEM_APIS.DROP_SEM_MODEL('integrator');

DROP TABLE acme_tpl;
DROP TABLE icorp_tpl;
DROP TABLE integrator_tpl;

PROMPT *****
PROMPT ***** Setting Up ACME and ICORP Environment ...
PROMPT *****

PROMPT
PROMPT ***** Creating the ACME_TPL and ICORP_TPL triples tables ...
PROMPT

CREATE TABLE acme_tpl (triple SDO_RDF_TRIPLE_S) COMPRESS;
CREATE TABLE icorp_tpl (triple SDO_RDF_TRIPLE_S) COMPRESS;

PROMPT
PROMPT ***** Creating the ACME and ICORP semantic models ...
PROMPT

EXEC SEM_APIS.CREATE_SEM_MODEL('acme','acme_tpl','triple');
EXEC SEM_APIS.CREATE_SEM_MODEL('icorp','icorp_tpl','triple');

PROMPT
PROMPT ***** Inserting ACME graph data ...
PROMPT

SET FEED OFF

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Ontology>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/>',
     '<http://www.w3.org/2002/07/owl#imports>',
     '<http://www.topbraidcomposer.org/owl/2006/09/sparql.owl>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/EMP>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Employee table"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/EMP>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/EMP>',
     '<http://www.topbraidcomposer.org/owl/2006/09/sparql.owl#query>',
     '"SELECT ?fn ?ln ?email ?org ?mgrFn ?mgrLn\r\nWHERE {\r\n  ?emp rdf:type :EMP .\r\n  ?emp :LName ?ln .\r\n  ?emp :FName ?fn .\r\n  ?emp :email_addr ?email .\r\n  ?emp :Org ?o .\r\n  ?o rdf:type :DEPT .\r\n  ?o :DName ?org .\r\n  ?o :Mgr ?oemp .\r\n  ?oemp :LName ?mgrLn .\r\n  ?oemp :FName ?mgrFn .\r\n}\r\nORDER BY ?org ?ln ?fn"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Sex>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Sex>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Sex>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E002>',
     '<http://www.example-acme.org/FName>',
     '"Fred"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E002>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D300>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E002>',
     '<http://www.example-acme.org/LName>',
     '"Keller"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E002>',
     '<http://www.example-acme.org/email_addr>',
     '"fk@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E002>',
     '<http://www.example-acme.org/Sex>',
     '"M"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E002>',
     '<http://www.example-acme.org/empno>',
     '"2"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E002>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E008>',
     '<http://www.example-acme.org/email_addr>',
     '"lo@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E008>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D200>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E008>',
     '<http://www.example-acme.org/Sex>',
     '"F"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E008>',
     '<http://www.example-acme.org/FName>',
     '"Lily"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E008>',
     '<http://www.example-acme.org/empno>',
     '"8"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E008>',
     '<http://www.example-acme.org/LName>',
     '"Olsen"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E008>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Org>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Organization (i.e. Department)"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Org>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Org>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.example-acme.org/DEPT>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Org>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/DName>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/DName>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Department name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/DName>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/DEPT>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/DName>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E001>',
     '<http://www.example-acme.org/FName>',
     '"Martha"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E001>',
     '<http://www.example-acme.org/LName>',
     '"Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E001>',
     '<http://www.example-acme.org/email_addr>',
     '"ms@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E001>',
     '<http://www.example-acme.org/Sex>',
     '"F"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E001>',
     '<http://www.example-acme.org/empno>',
     '"001"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E001>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D200>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E001>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E007>',
     '<http://www.example-acme.org/FName>',
     '"Sam"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E007>',
     '<http://www.example-acme.org/LName>',
     '"Snodgrass"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E007>',
     '<http://www.example-acme.org/Sex>',
     '"M"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E007>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D200>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E007>',
     '<http://www.example-acme.org/empno>',
     '"7"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E007>',
     '<http://www.example-acme.org/email_addr>',
     '"ss@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E007>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E010>',
     '<http://www.example-acme.org/email_addr>',
     '"sh@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E010>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D100>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E010>',
     '<http://www.example-acme.org/LName>',
     '"Henderson"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E010>',
     '<http://www.example-acme.org/Sex>',
     '"F"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E010>',
     '<http://www.example-acme.org/FName>',
     '"Sarah"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E010>',
     '<http://www.example-acme.org/empno>',
     '"10"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E010>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/email_addr>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/email_addr>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.w3.org/2002/07/owl#Thing>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/email_addr>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"email address"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/email_addr>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D300>',
     '<http://www.example-acme.org/email_addr>',
     '"hr@acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D300>',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.example-acme.org/E009>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D300>',
     '<http://www.example-acme.org/DName>',
     '"Human Resources"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D300>',
     '<http://www.example-acme.org/Deptno>',
     '"300"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D300>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/DEPT>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E006>',
     '<http://www.example-acme.org/email_addr>',
     '"rr@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E006>',
     '<http://www.example-acme.org/empno>',
     '"6"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E006>',
     '<http://www.example-acme.org/LName>',
     '"Rogers"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E006>',
     '<http://www.example-acme.org/Sex>',
     '"M"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E006>',
     '<http://www.example-acme.org/FName>',
     '"Rick"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E006>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D300>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E006>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D200>',
     '<http://www.example-acme.org/Deptno>',
     '"200"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D200>',
     '<http://www.example-acme.org/DName>',
     '"Marketing"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D200>',
     '<http://www.example-acme.org/email_addr>',
     '"marketing@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D200>',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.example-acme.org/E001>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D200>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/DEPT>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E005>',
     '<http://www.example-acme.org/email_addr>',
     '"bh@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E005>',
     '<http://www.example-acme.org/empno>',
     '"5"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E005>',
     '<http://www.example-acme.org/FName>',
     '"Bob"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E005>',
     '<http://www.example-acme.org/Sex>',
     '"M"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E005>',
     '<http://www.example-acme.org/LName>',
     '"Hope"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E005>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D100>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E005>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Deptno>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Deptno>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Department number"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Deptno>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/DEPT>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Deptno>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/emp>',
     '<http://www.w3.org/2002/07/owl#versionInfo>',
     '"Created with TopBraid Composer"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/LName>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/LName>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Employee last name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/LName>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/LName>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D100>',
     '<http://www.example-acme.org/Deptno>',
     '"100"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D100>',
     '<http://www.example-acme.org/DName>',
     '"Accounting"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D100>',
     '<http://www.example-acme.org/email_addr>',
     '"accounting@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D100>',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.example-acme.org/E003>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/D100>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/DEPT>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/FName>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Employee first name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/FName>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/FName>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/FName>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/DEPT>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Department table"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/DEPT>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Manager"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/DEPT>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E004>',
     '<http://www.example-acme.org/LName>',
     '"Presley"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E004>',
     '<http://www.example-acme.org/email_addr>',
     '"jp@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E004>',
     '<http://www.example-acme.org/Sex>',
     '"M"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E004>',
     '<http://www.example-acme.org/FName>',
     '"Jim"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E004>',
     '<http://www.example-acme.org/empno>',
     '"4"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E004>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D100>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E004>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/empno>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Employee Number"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/empno>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/empno>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/empno>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E003>',
     '<http://www.example-acme.org/FName>',
     '"Bill"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E003>',
     '<http://www.example-acme.org/email_addr>',
     '"bs@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E003>',
     '<http://www.example-acme.org/empno>',
     '"3"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E003>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D100>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E003>',
     '<http://www.example-acme.org/LName>',
     '"Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E003>',
     '<http://www.example-acme.org/Sex>',
     '"M"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E003>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E009>',
     '<http://www.example-acme.org/LName>',
     '"Douglas"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E009>',
     '<http://www.example-acme.org/Sex>',
     '"M"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E009>',
     '<http://www.example-acme.org/empno>',
     '"9"^^<http://www.w3.org/2001/XMLSchema#integer>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E009>',
     '<http://www.example-acme.org/Org>',
     '<http://www.example-acme.org/D300>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E009>',
     '<http://www.example-acme.org/FName>',
     '"Harry"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E009>',
     '<http://www.example-acme.org/email_addr>',
     '"hd@example-acme.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO acme_tpl VALUES (SDO_RDF_TRIPLE_S('acme',
     '<http://www.example-acme.org/E009>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-acme.org/EMP>'));

COMMIT;

PROMPT
PROMPT ***** Inserting ICORP graph data ...
PROMPT

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Ontology>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/>',
     '<http://www.w3.org/2002/07/owl#imports>',
     '<http://www.topbraidcomposer.org/owl/2006/09/sparql.owl>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Last_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Last name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Last_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Last_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Last_Name>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Org_Unit"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/WORKFORCE>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Workforce table"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/WORKFORCE>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/WORKFORCE>',
     '<http://www.topbraidcomposer.org/owl/2006/09/sparql.owl#query>',
     '"SELECT ?fn ?ln ?email ?org ?mgrFn ?mgrLn\r\nWHERE {\r\n  ?emp rdf:type :WORKFORCE .\r\n  ?emp :Last_Name ?ln .\r\n  ?emp :First_Name ?fn .\r\n  ?emp :Workforce_Email ?email .\r\n  ?emp :Org_Unit ?o .\r\n  ?o rdf:type :ORGANIZATION .\r\n  ?o :Organization_Name ?org .\r\n  ?o :Manager ?oemp .\r\n  ?oemp :Last_Name ?mgrLn .\r\n  ?oemp :First_Name ?mgrFn .\r\n}\r\nORDER BY ?org ?ln ?fn"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/ORGANIZATION>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Organization table"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/ORGANIZATION>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"0238"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W0238"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org101>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Orst"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.example-icorp.org/First_Name>',
     '"Steve"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"steveo@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0238>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/First_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"First name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/First_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/First_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/First_Name>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Unit>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Unit>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Unit>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Organization Unit"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Unit>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"2001"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"ben@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org101>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Adams"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.example-icorp.org/First_Name>',
     '"Ben"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W2001"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W2001>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Organization_Name>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"8900"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"hank@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org101>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Black"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.example-icorp.org/First_Name>',
     '"Hank"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W8900"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W8900>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#float>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Monthly_Budget"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"0128"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"homer@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org2134>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Simpson"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.example-icorp.org/First_Name>',
     '"Homer"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W0128"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0128>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_Email>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_Email>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_Email>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Workforce email address"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_Email>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"7288"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"linda@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org2134>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Blair"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.example-icorp.org/Gender>',
     '"Female"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.example-icorp.org/First_Name>',
     '"Linda"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W7288"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7288>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"7892"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"paul@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org107>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Jones"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.example-icorp.org/First_Name>',
     '"Paul"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W7892"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W7892>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org2134>',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.example-icorp.org/W0926>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org2134>',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '"25000"^^<http://www.w3.org/2001/XMLSchema#float>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org2134>',
     '<http://www.example-icorp.org/Organization_Name>',
     '"Shipping"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org2134>',
     '<http://www.example-icorp.org/Organization_Unit>',
     '"2134"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org2134>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Org2134"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org2134>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"1627"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"sam@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org200>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Strong"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.example-icorp.org/First_Name>',
     '"Sam"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W1627"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1627>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"marsha@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"009"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org200>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Jentzen"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.example-icorp.org/Gender>',
     '"Female"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.example-icorp.org/First_Name>',
     '"Marsha"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W0009"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0009>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"1001"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"pam@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org107>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Snyder"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.example-icorp.org/Gender>',
     '"Female"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.example-icorp.org/First_Name>',
     '"Pam"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W1001"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W1001>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"6577"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"steves@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org200>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Smith"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.example-icorp.org/First_Name>',
     '"Steve"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W6577"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W6577>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"0926"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"adam@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org2134>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Wayne"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.example-icorp.org/Gender>',
     '"Male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.example-icorp.org/First_Name>',
     '"Adam"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W0926"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0926>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Gender>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Gender>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Gender>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Gender"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Gender>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_ID>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_ID>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Employee ID"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_ID>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Workforce_ID>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org101>',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '"1000"^^<http://www.w3.org/2001/XMLSchema#float>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org101>',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.example-icorp.org/W0238>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org101>',
     '<http://www.example-icorp.org/Organization_Unit>',
     '"101"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org101>',
     '<http://www.example-icorp.org/Organization_Name>',
     '"Personnel"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org101>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Org101"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org101>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org107>',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.example-icorp.org/W1001>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org107>',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '"10000"^^<http://www.w3.org/2001/XMLSchema#float>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org107>',
     '<http://www.example-icorp.org/Organization_Unit>',
     '"107"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org107>',
     '<http://www.example-icorp.org/Organization_Name>',
     '"Administration"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org107>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Org107"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org107>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org200>',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.example-icorp.org/W6577>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org200>',
     '<http://www.example-icorp.org/Monthly_Budget>',
     '"20000"^^<http://www.w3.org/2001/XMLSchema#float>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org200>',
     '<http://www.example-icorp.org/Organization_Name>',
     '"Sales and Marketing"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org200>',
     '<http://www.example-icorp.org/Organization_Unit>',
     '"200"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org200>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Org200"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Org200>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.example-icorp.org/ORGANIZATION>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Manager"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.example-icorp.org/First_Name>',
     '"Jean"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.example-icorp.org/Gender>',
     '"Female"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.example-icorp.org/Last_Name>',
     '"Simmons"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.example-icorp.org/Org200>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.example-icorp.org/Workforce_Email>',
     '"jean@example-icorp.org"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.example-icorp.org/Workforce_ID>',
     '"0987"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"W0987"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/W0987>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.example-icorp.org/WORKFORCE>'));

INSERT INTO icorp_tpl VALUES (SDO_RDF_TRIPLE_S('icorp',
     '<http://www.example-icorp.org/hr>',
     '<http://www.w3.org/2002/07/owl#versionInfo>',
     '"Created with TopBraid Composer"^^<http://www.w3.org/2001/XMLSchema#string>'));

COMMIT;

SET FEED ON

PROMPT
PROMPT ***** Compiling statistics on semantic data ...
PROMPT

EXEC SEM_PERF.GATHER_STATS;

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************
PROMPT ** QUERY 7-1: What are the vocabularies used in the ACME
PROMPT **            and ICORP data sources?
PROMPT

BREAK ON type SKIP 1 NODUP

SELECT 'CLASS' Type, 'ACME' company, class$_SUFFIX object
FROM   TABLE(SEM_MATCH('
          {
            ?class rdf:type owl:Class .
          }',
          SEM_MODELS('acme'),
          null,
          SEM_ALIASES(SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
UNION
SELECT 'PROPERTY' Type, 'ACME' company, prop$_SUFFIX object
FROM   TABLE(SEM_MATCH('
          {
            { ?prop rdf:type owl:DatatypeProperty . }
            UNION
            { ?prop rdf:type owl:ObjectProperty . }
          }',
          SEM_MODELS('acme'),
          null,
          SEM_ALIASES(SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
UNION
SELECT 'CLASS' Type, 'ICORP' company, class$_SUFFIX object
FROM   TABLE(SEM_MATCH('
          {
            ?class rdf:type owl:Class .
          }',
          SEM_MODELS('icorp'),
          null,
          SEM_ALIASES(SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
UNION
SELECT 'PROPERTY' Type, 'ICORP' company, prop$_SUFFIX object
FROM   TABLE(SEM_MATCH('
          {
            { ?prop rdf:type owl:DatatypeProperty . }
            UNION
            { ?prop rdf:type owl:ObjectProperty . }
          }',
          SEM_MODELS('icorp'),
          null,
          SEM_ALIASES(SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 7-2: Who are the employees of ACME?
PROMPT

COLUMN FName       FORMAT a10
COLUMN LName       FORMAT a10
COLUMN email_addr  FORMAT a25
COLUMN DName       FORMAT a20
column MGR_FName   FORMAT a10
COLUMN MGR_LName   FORMAT a10

SELECT fn FName, ln LName, email email_addr, org DName,
       mgrFn MGR_FName, mgrLn MGR_LName
FROM   TABLE(SEM_MATCH('
          {
            ?emp rdf:type :EMP .
            ?emp :LName ?ln .
            ?emp :FName ?fn .
            ?emp :email_addr ?email .
            ?emp :Org ?o .
            ?o rdf:type :DEPT .
            ?o :DName ?org .
            ?o :Mgr ?oemp .
            ?oemp :LName ?mgrLn .
            ?oemp :FName ?mgrFn .
          }',
          SEM_MODELS('acme'),
          null,
          SEM_ALIASES(SEM_ALIAS('','http://www.example-acme.org/')),
          null))
ORDER BY org,ln, fn

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 7-3: Using ACME's vocabulary, who are the employees
PROMPT **            of ICORP?
PROMPT

COLUMN FName       FORMAT a10
COLUMN LName       FORMAT a10
COLUMN email_addr  FORMAT a25
COLUMN DName       FORMAT a20
column MGR_FName   FORMAT a10
COLUMN MGR_LName   FORMAT a10

SELECT fn FName, ln LName, email email_addr, org DName,
       mgrFn MGR_FName, mgrLn MGR_LName
FROM   TABLE(SEM_MATCH('
          {
            ?emp rdf:type :EMP .
            ?emp :LName ?ln .
            ?emp :FName ?fn .
            ?emp :email_addr ?email .
            ?emp :Org ?o .
            ?o rdf:type :DEPT .
            ?o :DName ?org .
            ?o :Mgr ?oemp .
            ?oemp :LName ?mgrLn .
            ?oemp :FName ?mgrFn .
          }',
          SEM_MODELS('icorp'),
          null,
          SEM_ALIASES(SEM_ALIAS('','http://www.example-icorp.org/')),
          null))
ORDER BY org,ln, fn

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUESTION: Why did the query not return any results?
PROMPT **
PROMPT ** ANSWER:   Because the companies do not use the same vocabulary!
PROMPT **
PROMPT **           To query ICORP data, the ICORP vocabulary must
PROMPT **           be used.
PROMPT ******************************************************************
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 7-4: Who are the employees of ICORP?
PROMPT

COLUMN First_Name         FORMAT a10
COLUMN Last_Name          FORMAT a10
COLUMN Workforce_Email    FORMAT a25
COLUMN Organization_Name  FORMAT a20
column MGR_First_Name     FORMAT a15
COLUMN MGR_Last_Name      FORMAT a15

SELECT fn First_Name, ln Last_Name, email Workforce_Email,
       org Organization_Name, mgrFn MGR_First_Name,
       mgrLn MGR_Last_Name
FROM   TABLE(SEM_MATCH('
          {
            ?emp rdf:type :WORKFORCE .
            ?emp :Last_Name ?ln .
            ?emp :First_Name ?fn .
            ?emp :Workforce_Email ?email .
            ?emp :Org_Unit ?o .
            ?o rdf:type :ORGANIZATION .
            ?o :Organization_Name ?org .
            ?o :Manager ?oemp .
            ?oemp :Last_Name ?mgrLn .
            ?oemp :First_Name ?mgrFn .
          }',
          SEM_MODELS('icorp'),
          null,
          SEM_ALIASES(SEM_ALIAS('','http://www.example-icorp.org/')),
          null))
ORDER BY org,ln, fn

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
PROMPT
PROMPT ********************************************************************
PROMPT ** QUESTION: Is there a simple way to query both data sets using
PROMPT **           a standard vocabulary?
PROMPT **
PROMPT ** ANSWER:   Yes, by creating a new ontology containing the
PROMPT **           desired vocabulary and then mapping the terms used
PROMPT **           by the 2 corporations to it.
PROMPT **
PROMPT **           Create a new ontology called INTEGRATOR and map the
PROMPT **           terms of the 2 data sets to it
PROMPT ******************************************************************
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT *****
PROMPT ***** Setting Up INTEGRATOR Environment ...
PROMPT *****

PROMPT
PROMPT ***** Creating the IINTEGRATOR_TPL triples table and semantic model ...
PROMPT

CREATE TABLE integrator_tpl (triple SDO_RDF_TRIPLE_S) COMPRESS;

EXEC SEM_APIS.CREATE_SEM_MODEL('integrator','integrator_tpl','triple');

PROMPT
PROMPT ***** Loading INTEGRATOR ontology ...
PROMPT

SET FEED OFF

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Ontology>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/>',
     '<http://www.w3.org/2002/07/owl#imports>',
     '<http://www.topbraidcomposer.org/owl/2006/09/sparql.owl>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/Last_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasLastName>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/isAssignedToDepartment>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"is assigned to department"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/isAssignedToDepartment>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/EMP>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.example-integrator.org/Employee>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/Org_Unit>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/isAssignedToDepartment>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/WORKFORCE>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.example-integrator.org/Employee>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/Org>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/isAssignedToDepartment>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/ORGANIZATION>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.example-integrator.org/Department>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/DName>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasDepartmentName>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/First_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasFirstName>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/Employee>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.w3.org/2002/07/owl#Thing>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/Employee>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Employee"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/Employee>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/Organization_Name>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasDepartmentName>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/email_addr>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasEmail>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasEmail>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"has email"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasEmail>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/Workforce_Email>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasEmail>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasFirstName>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"has first name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasFirstName>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/isManagedBy>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"is managed by"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/isManagedBy>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/LName>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasLastName>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/FName>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/hasFirstName>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/DEPT>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.example-integrator.org/Department>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-acme.org/Mgr>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/isManagedBy>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/Department>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.w3.org/2002/07/owl#Thing>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/Department>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"Department"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/Department>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-icorp.org/Manager>',
     '<http://www.w3.org/2000/01/rdf-schema#subPropertyOf>',
     '<http://www.example-integrator.org/isManagedBy>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasLastName>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"has last name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasLastName>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasDepartmentName>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"has department name"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/hasDepartmentName>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/isManagerOf>',
     '<http://www.w3.org/2000/01/rdf-schema#label>',
     '"is manager of"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/isManagerOf>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Property>'));

INSERT INTO integrator_tpl VALUES (SDO_RDF_TRIPLE_S('integrator',
     '<http://www.example-integrator.org/isManagerOf>',
     '<http://www.w3.org/2002/07/owl#inverseOf>',
     '<http://www.example-integrator.org/isManagedBy>'));

COMMIT;

SET FEED ON

PROMPT
PROMPT ***** Creating entailment using the ACME, ICORP, and INTEGRATOR models (this may take a few moments) ...
PROMPT

EXEC SEM_APIS.CREATE_ENTAILMENT('integrator_rix',SEM_MODELS('acme','icorp','integrator'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE);

PROMPT
PROMPT ***** Compiling statistics on semantic data ...
PROMPT

EXEC SEM_PERF.GATHER_STATS;

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 7-5: What is the standard vocabulary in the INTEGRATOR
PROMPT **            ontology and how is it mapped to the vocabulary
PROMPT **            used in the ACME and ICORP data sources?
PROMPT

BREAK ON mapped_to DUP SKIP 1

SELECT s local_term, p$_SUFFIX mapping_method, o standard_term
FROM   TABLE(SEM_MATCH('
          {
             ?s ?p ?o .
             FILTER( ?p = rdfs:subClassOf || ?p = rdfs:subPropertyOf )
          }',
          SEM_MODELS('integrator'),
          null,
          SEM_ALIASES(SEM_ALIAS('','http://www.example-integrator.org/')),
          null))
ORDER BY 3,2

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************
PROMPT ** QUERY 7-6: Using the standard vocabulary, who are the
PROMPT **            employees in both companies?
PROMPT

COLUMN FirstName       FORMAT a10
COLUMN LastName        FORMAT a10
COLUMN Organization    FORMAT a30
COLUMN DepartmentName  FORMAT a20
column mgr_FirstName   FORMAT a13
COLUMN mgr_LastName    FORMAT a12

SELECT FirstName, LastName, dept$_PREFIX organization,
       DepartmentName, mgr_FirstName, mgr_LastName
FROM   TABLE(SEM_MATCH('
          {
            ?emp rdf:type :Employee .
            ?emp :hasFirstName ?FirstName .
            ?emp :hasLastName ?LastName .
            ?emp :isAssignedToDepartment ?dept .
            ?dept rdf:type :Department .
            ?dept :hasDepartmentName ?DepartmentName .
            ?dept :isManagedBy ?mgr .
            ?mgr :hasFirstName ?mgr_FirstName .
            ?mgr :hasLastName  ?mgr_LastName .
          }',
          SEM_MODELS('acme','icorp','integrator'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS('','http://www.example-integrator.org/')),
          null))
ORDER BY dept$_PREFIX, DepartmentName,
         LastName, FirstName

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************
PROMPT ** QUERY 7-7: Who are all the managers in each company?
PROMPT

SELECT firstname, lastname, dept$_PREFIX organization, DepartmentName
FROM   TABLE(SEM_MATCH('
          {
            ?emp rdf:type :Employee .
            ?emp :hasFirstName ?firstname .
            ?emp :hasLastName ?lastname .
            ?emp :isManagerOf ?dept .
            ?dept rdf:type :Department .
            ?dept :hasDepartmentName ?DepartmentName .
          }',
          SEM_MODELS('acme','icorp','integrator'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS('','http://www.example-integrator.org/')),
          null))
ORDER BY organization, DepartmentName

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT **********************************************************
PROMPT ** QUERY 7-8: Does either company have anyone with the
PROMPT **            first name of "Sam" working for them?
PROMPT

SELECT firstname, lastname, dept$_PREFIX organization, DepartmentName
FROM   TABLE(SEM_MATCH('
          {
            ?emp :hasFirstName ?firstname .
            ?emp :hasLastName ?lastname .
            ?emp :isAssignedToDepartment ?dept .
            ?dept rdf:type :Department .
            ?dept :hasDepartmentName ?DepartmentName .
            FILTER( ?firstname = "Sam" )
          }',
          SEM_MODELS('acme','icorp','integrator'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS('','http://www.example-integrator.org/')),
          null))
ORDER BY lastname

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/
