----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


SET LINESIZE 100
SET PAGESIZE 1000

COLUMN subject   FORMAT A30 WORD
COLUMN predicate FORMAT A30 WORD
COLUMN object    FORMAT A30 WORD


PROMPT
PROMPT ********************************************************************
PROMPT ** Exercise 6: Demonstrate the use of inferencing to integrate    **
PROMPT **             data using the semantics of the inverse-functional **
PROMPT **             and sameAs properties in OWL.                      **
PROMPT ********************************************************************

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 6-1: What information exists in the model for a
PROMPT **            Contact named "JohnathanLeeAdams"?
PROMPT

SELECT s$_SUFFIX subject, p$_SUFFIX predicate,
       NVL(o$_SUFFIX,o) Object
FROM   TABLE(SEM_MATCH('
          {
             ?s ?p ?o .
             FILTER( ?s = :JohnathanLeeAdams )
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 6-2: What information exists in the model for a
PROMPT **            Contact named "JohnAdams"?
PROMPT

SELECT s$_SUFFIX subject, p$_SUFFIX predicate,
       NVL(o$_SUFFIX,o) Object
FROM   TABLE(SEM_MATCH('
          {
             ?s ?p ?o .
             FILTER( ?s = :JohnAdams )
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 6-3: What are the semantics regarding the "hasEMail"
PROMPT **            property that both contacts share?
PROMPT

SELECT s$_SUFFIX subject, p$_SUFFIX predicate,
       NVL(o$_SUFFIX,o) Object
FROM   TABLE(SEM_MATCH('
          {
             ?s ?p ?o .
             FILTER( ?s = :hasEMail || ?o = :hasEMail )
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *****************************************************************
PROMPT ** QUERY 6-4: What information exists in the model for a
PROMPT **            Contact named "JohnathanLeeAdams" if we include
PROMPT **            the inferencing set (created in exercise 4)?
PROMPT

SELECT s$_SUFFIX subject, p$_SUFFIX predicate,
       NVL(o$_SUFFIX,o) Object
FROM   TABLE(SEM_MATCH('
          {
             ?s ?p ?o .
             FILTER( ?s = :JohnathanLeeAdams )
          }',
          SEM_MODELS('geotravel'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 2,3

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

