----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


PROMPT
PROMPT ***********************************************************************
PROMPT ** Exercise 5:  Demonstrate the ability of semantic inferencing for  **
PROMPT **               knowledge discovery.                                **
PROMPT ***********************************************************************
PROMPT

PROMPT
PROMPT 
PROMPT *************************************************
PROMPT ** Cleaning Up GEOTRAVEL_BEACHCITY Environment
PROMPT 
PROMPT

EXEC SEM_APIS.DROP_ENTAILMENT('geo_beachcity_rix');
EXEC SEM_APIS.DROP_SEM_MODEL('geotravel_beachcity');
DROP TABLE geotravel_beachcity_tpl;

PROMPT
PROMPT 
PROMPT *************************************************
PROMPT ** Setting Up GEOTRAVEL_BEACHCITY Environment
PROMPT 

CREATE TABLE geotravel_beachcity_tpl (triple SDO_RDF_TRIPLE_S) COMPRESS

LIST

/

PROMPT
PROMPT 
PROMPT EXEC SEM_APIS.CREATE_SEM_MODEL('geotravel_beachcity','geotravel_beachcity_tpl','triple');;
PROMPT

EXEC SEM_APIS.CREATE_SEM_MODEL('geotravel_beachcity','geotravel_beachcity_tpl','triple');

PROMPT
PROMPT 
PROMPT *****************************************************************
PROMPT ** Inserting GEOTRAVEL_BEACHCITY triples ...
PROMPT 
PROMPT

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BeachCity>',
'<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
'<http://www.w3.org/2002/07/owl#Thing>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BeachCity>',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
'<http://www.w3.org/2002/07/owl#Class>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BeachCity>',
'<http://www.w3.org/2000/01/rdf-schema#label>',
'"Beach city"^^<http://www.w3.org/2001/XMLSchema#string>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BeachCity>',
'<http://www.w3.org/2000/01/rdf-schema#comment>',
'"A city that has at least one part that is a Beach."^^<http://www.w3.org/2001/XMLSchema#string>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BeachCity>',
'<http://www.w3.org/2002/07/owl#equivalentClass>',
'_:BNSEQNE7371'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE7371',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
'<http://www.w3.org/2002/07/owl#Class>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE7371',
'<http://www.w3.org/2002/07/owl#intersectionOf>',
'_:BNSEQNE7370'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE7370',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#first>',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#City>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE7370',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#rest>',
'_:BNSEQNE736e'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE736e',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#rest>',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#nil>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE736e',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#first>',
'_:BNSEQNE736f'))

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE736f',
'<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
'<http://www.w3.org/2002/07/owl#Restriction>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE736f',
'<http://www.w3.org/2002/07/owl#someValuesFrom>',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Beach>'));

RUN

INSERT INTO geotravel_beachcity_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel_beachcity',
'_:BNSEQNE736f',
'<http://www.w3.org/2002/07/owl#onProperty>',
'<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>'));

RUN

COMMIT;

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 5-1: Are there any Beach Cities?
PROMPT

SELECT dest$_SUFFIX destination
FROM   TABLE(SEM_MATCH('
          {
            ?dest rdf:type :BeachCity .
          }',
          SEM_MODELS('geotravel','geotravel_beachcity'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUESTION: Why did the query not return any results?
PROMPT **
PROMPT ** ANSWER:   Because there are no explicit instances of the 
PROMPT **           "BeachCity" class.
PROMPT **
PROMPT **           However, the semantics for identifying Beach Cities
PROMPT **           has now been specified in the GEOTRAVEL_BEACHCITY
PROMPT **           model.
PROMPT **
PROMPT **           Execute inferencing against both models and include
PROMPT **           the inference set (i.e. inferred triples) in the
PROMPT **           re-execution of the original query.
PROMPT ******************************************************************
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT ***** Creating the entailment (i.e inferencing set) ...
PROMPT

PROMPT
PROMPT EXEC SEM_APIS.CREATE_ENTAILMENT('geo_beachcity_rix',SEM_MODELS('geotravel','geotravel_beachcity'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE,'INTERSECT,SVFH, INTERSECTSCOH, THINGH, THINGSAM, SAM');;
PROMPT

EXEC SEM_APIS.CREATE_ENTAILMENT('geo_beachcity_rix',SEM_MODELS('geotravel','geotravel_beachcity'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE,'INTERSECT,SVFH, INTERSECTSCOH, THINGH, THINGSAM, SAM');

PROMPT
PROMPT ***** Compiling statistics on semantic data ...
PROMPT
PROMPT EXEC SEM_PERF.GATHER_STATS;;
PROMPT

EXEC SEM_PERF.GATHER_STATS;

ACCEPT var PROMPT "Press <ENTER> to continue ... "

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 5-2: Now are there any Beach Cities?
PROMPT

SELECT dest$_SUFFIX destination
FROM   TABLE(SEM_MATCH('
          {
            ?dest rdf:type :BeachCity .
          }',
          SEM_MODELS('geotravel','geotravel_beachcity'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

