----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


SET LINESIZE 100
SET PAGESIZE 40

COLUMN destination FORMAT A30 WORD

PROMPT
PROMPT *********************************************************************
PROMPT ** Exercise 4: Demonstrate the use of inferencing to annotate data **
PROMPT **             within a class hierarchy.                           **
PROMPT *********************************************************************

PROMPT
PROMPT
PROMPT ***************************************************************
PROMPT ** QUERY 4-1: What destinations exist within the graph?
PROMPT

SELECT dest$_SUFFIX destination
FROM   TABLE(SEM_MATCH('
          {
            ?dest rdf:type :Destination .
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUESTION: Why did the query not return any results?
PROMPT **
PROMPT ** ANSWER:   Because there are no explicit instances of the 
PROMPT **           "Destination" class. In order to retrieve all of the
PROMPT **           destinations, the query must explicitly specify each
PROMPT **           class in the Destination class hierarchy.
PROMPT ******************************************************************
PROMPT

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUERY 4-2: What destinations exist within the graph if they
PROMPT **            are specified EXPLICITLY in the graph pattern?
PROMPT

SELECT dest$_SUFFIX destination
FROM   TABLE(SEM_MATCH('
          {
            { ?dest rdf:type :Beach }
            UNION
            { ?dest rdf:type :RuralArea }
            UNION
            { ?dest rdf:type :NationalPark }
            UNION
            { ?dest rdf:type :City }
            UNION
            { ?dest rdf:type :Capital }
            UNION
            { ?dest rdf:type :Town }
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT ********************************************************************
PROMPT ** QUESTION: Is there a way to list the destinations without
PROMPT **           having to explicity specify each type of destination?
PROMPT **
PROMPT ** ANSWER:   Yes, by using inferencing to instantiate the semantics
PROMPT **           of the class hierachy, 
PROMPT **
PROMPT **           Execute inferencing against the model (i.e. build an
PROMPT **           entailment) and include it in the re-execution of
PROMPT **           the original query.
PROMPT ********************************************************************
PROMPT

PROMPT SEM_APIS.CREATE_ENTAILMENT('geotravel_rix',SEM_MODELS('geotravel'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE,'SAM');;

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

PROMPT ** Creating the entailment (this may take a few moments) ...

EXEC SEM_APIS.DROP_ENTAILMENT('geotravel_rix');

EXEC SEM_APIS.CREATE_ENTAILMENT('geotravel_rix',SEM_MODELS('geotravel'),SEM_RULEBASES('owlprime'),SEM_APIS.REACH_CLOSURE,'SAM');

ACCEPT var PROMPT "Press <ENTER> to continue ... "

PROMPT
PROMPT
PROMPT ***************************************************************
PROMPT ** QUERY 4-3: What destinations exist within the graph?
PROMPT

SELECT dest$_SUFFIX destination
FROM   TABLE(SEM_MATCH('
          {
            ?dest rdf:type :Destination .
          }',
          SEM_MODELS('geotravel'),
          SEM_RULEBASES('owlprime'),
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

ACCEPT var PROMPT "Press <ENTER> to continue ... "

PROMPT
PROMPT
PROMPT ***************************************************************
PROMPT ** QUERY 4-4: What classes does Sydney belong to with and
PROMPT **            without inferencing?
PROMPT


PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

COLUMN class_wo_inf   FORMAT a35 HEADING "Sydney Classes WITHOUT Inferencing"
COLUMN class_with_Inf FORMAT a35 HEADING "Sydney Classes WITH Inferencing"

SELECT a.class_wo_inf, b.class_with_inf
FROM   ( SELECT distinct class$_SUFFIX class_wo_inf
         FROM   TABLE(SEM_MATCH('
                    {
                      <http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney> rdf:type ?class .
                    }',
                    SEM_MODELS('geotravel'),
                    null,
                    SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                                SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
                    null))
         WHERE class$_SUFFIX IS NOT NULL) a,
       ( SELECT DISTINCT class$_SUFFIX class_with_inf
         FROM   TABLE(SEM_MATCH('
                    {
                      <http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney> rdf:type ?class .
                    }',
                    SEM_MODELS('geotravel'),
                    SEM_RULEBASES('owlprime'),
                    SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                                SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
                    null))
         WHERE class$_SUFFIX IS NOT NULL) b
/

