----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


SET LINESIZE 100
SET PAGESIZE 40

COLUMN capital		FORMAT A30 WORD
COLUMN accommodation	FORMAT A30 WORD

PROMPT
PROMPT ************************************************************************
PROMPT ** Exercise 3: Demonstrate the use of the OPTIONAL clause in semantic **
PROMPT **             queries.  Also demonstrates Oracle's annotation        **
PROMPT **             attributes (i.e. SUFFIX, PREFIX, etc).                 **
PROMPT ************************************************************************

PROMPT
PROMPT
PROMPT *******************************************************************
PROMPT ** QUERY 3-1: What are all the capitals and their accommodations?
PROMPT

SELECT cap$_SUFFIX capital, acc$_SUFFIX accommodation
FROM   TABLE(SEM_MATCH('
          {
            ?cap rdf:type :Capital .
            ?cap :hasAccommodation ?acc .
          }',
          SEM_MODELS('geotravel'),
          null, 
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT ******************************************************************
PROMPT ** QUERY 3-2: What are all the capitals and their accommodations
PROMPT **            (if they have any)?
PROMPT

SELECT cap$_SUFFIX capital, acc$_SUFFIX accommodation
FROM   TABLE(SEM_MATCH('
          {
            ?cap rdf:type :Capital .
            OPTIONAL{?cap :hasAccommodation ?acc .}
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/
