----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------


SET LINESIZE 100
SET PAGESIZE 1000

COLUMN subject   FORMAT A100 WORD
COLUMN predicate FORMAT A100 WORD
COLUMN object    FORMAT A100 WORD

PROMPT
PROMPT ***********************************************************************
PROMPT ** Exercise 2: Demonstrate the ability to specify selective criteria **
PROMPT **             within a semantic query, including the use of FILTER. **
PROMPT ***********************************************************************

PROMPT
PROMPT
PROMPT *********************************************************
PROMPT ** QUERY 2-1: Are there any Luxury Hotels?
PROMPT

SELECT subject
FROM   TABLE(SEM_MATCH('
          {
            ?subject rdf:type :LuxuryHotel .
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *************************************************************************
PROMPT ** QUERY 2-2: What information exists for the "All Seasons Sunshine
PROMPT **            Tower" hotel?
PROMPT

SELECT subject,
       predicate,
       object
FROM   TABLE(SEM_MATCH('
          {
            ?subject ?predicate ?object .
            FILTER(?subject = :AllSeasonsSunshineTower || ?object = :AllSeasonsSunshineTower)
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1,2

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/
