----------------------------------------------------------------------------
--                                                                        --
-- +++ THE CONTENTS OF THIS SCRIPT ARE FOR EDUCATIONAL PURPOSES ONLY. +++ --
--                                                                        --
-- THEY PROVIDE NO VALUE OTHER THAN TO DEMONSTRATE THE CAPABILITIES OF    --
-- RDF, SEMANTICS, AND THE SEMANTIC WEB USING AN ORACLE DATABASE THAT HAS --
-- THE SEMANTIC TECHNOLOGIES OPTION (AND ALL ITS DEPENDENCIES) INSTALLED. --
--                                                                        --
-- FOR MORE INFORMATION, REFERENCE "THE SEMANTIC TECHNOLOGIES DEVELOPER'S --
-- GUIDE" DOCUMENTATION PROVIDED BY ORACLE CORPORATION.                   --
--                                                                        --
----------------------------------------------------------------------------

SET LINESIZE 100
SET PAGESIZE 1000

COLUMN subject   FORMAT A100 WORD
COLUMN predicate FORMAT A100 WORD
COLUMN object    FORMAT A100 WORD


PROMPT
PROMPT ***********************************************************
PROMPT ** Exercise 1:  Create, load, and explore the GEOTRAVEL  **
PROMPT **              semantic model.                          **
PROMPT ***********************************************************
PROMPT
PROMPT *****
PROMPT ***** Cleaning Up GEOTRAVEL Environment ...
PROMPT *****
PROMPT

EXEC SEM_APIS.DROP_ENTAILMENT('geotravel_rix');
EXEC SEM_APIS.DROP_ENTAILMENT('geotravel_beachcity_rix');

EXEC SEM_APIS.DROP_SEM_MODEL('geotravel');

DROP TABLE geotravel_tpl;

PROMPT *****
PROMPT ***** Setting Up GEOTRAVEL Environment ...
PROMPT *****

PROMPT
PROMPT ***** Creating the GEOTRAVEL_TPL triples table ...
PROMPT

CREATE TABLE geotravel_tpl (triple SDO_RDF_TRIPLE_S) COMPRESS

LIST

RUN

PROMPT
PROMPT ***** Creating the GEOTRAVEL semantic model ...
PROMPT 
PROMPT EXEC SEM_APIS.CREATE_SEM_MODEL('geotravel','geotravel_tpl','triple');;
PROMPT

EXEC SEM_APIS.CREATE_SEM_MODEL('geotravel','geotravel_tpl','triple');

PROMPT
PROMPT ***** Loading graph data (see sample insert for given triple below) ...
PROMPT

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl>',
     '<http://www.w3.org/2002/07/owl#imports>',
     '<http://www.topbraidcomposer.org/owl/2006/09/sparql.owl>'))

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute graph load statements ... "
PROMPT

/

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl>',
     '<http://www.w3.org/2002/07/owl#imports>',
     '<http://xmlns.com/foaf/0.1/>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl>',
     '<http://www.w3.org/2002/07/owl#imports>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Ontology>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnathanLeeAdams>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasZipCode>',
     '"47992"^^<http://www.w3.org/2001/XMLSchema#int>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnathanLeeAdams>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasEMail>',
     '"jla@acme.com"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnathanLeeAdams>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasCity>',
     '"Westpoint"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnathanLeeAdams>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasState>',
     '"IN"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnathanLeeAdams>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Canberra>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"-80.2241666666666667"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Canberra>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"13"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Canberra>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-35.30223743763137"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Canberra>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Capital>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0040',
     '<http://www.w3.org/2002/07/owl#hasValue>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#ThreeStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0040',
     '<http://www.w3.org/2002/07/owl#onProperty>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0040',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Restriction>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasZipCode>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#FunctionalProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasZipCode>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasZipCode>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#int>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasZipCode>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#OneStarRating>',
     '<http://www.w3.org/2002/07/owl#differentFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#TwoStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#OneStarRating>',
     '<http://www.w3.org/2002/07/owl#differentFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#ThreeStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#OneStarRating>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AccommodationRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0038',
     '<http://www.w3.org/2002/07/owl#someValuesFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0038',
     '<http://www.w3.org/2002/07/owl#onProperty>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0038',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Restriction>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Miami>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"-80.28"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Miami>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#SouthBeach>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Miami>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"25.787777777777778"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Miami>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AcqualinaResort>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Miami>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#City>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BondiBeach>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"151.20861053466797"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-33.868135032968624"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"12"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#FourSeasons>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sydney>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Capital>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Beach>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Beach>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AllSeasonsSunshineTower>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasStreet>',
     '"136-140 Sheridan St"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AllSeasonsSunshineTower>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"16"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AllSeasonsSunshineTower>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"145.77327489852905"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AllSeasonsSunshineTower>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-16.92276073199948"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AllSeasonsSunshineTower>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#LuxuryHotel>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#TwoStarRating>',
     '<http://www.w3.org/2002/07/owl#differentFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#OneStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#TwoStarRating>',
     '<http://www.w3.org/2002/07/owl#differentFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#ThreeStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#TwoStarRating>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AccommodationRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Museums>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Museums>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BedAndBreakfast>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hotel>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BedAndBreakfast>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Accommodation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BedAndBreakfast>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BedAndBreakfast>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#FourSeasons>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#LuxuryHotel>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Town>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#UrbanArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Town>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003e',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#rest>',
     '_:BNSEQN003d'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003e',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#first>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#OneStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AcqualinaResort>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#LuxuryHotel>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#NationalPark>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '_:BNSEQN0037'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#NationalPark>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '_:BNSEQN0038'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#NationalPark>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#NationalPark>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Cairns>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"145.7724380493164"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Cairns>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-16.92610684982019"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Cairns>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AllSeasonsSunshineTower>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Cairns>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"12"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Cairns>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#City>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BudgetHotelDestination>',
     '<http://www.w3.org/2000/01/rdf-schema#comment>',
     '"A destination with a hotel that is also a budget accommodation."^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BudgetHotelDestination>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Farmland>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Farmland>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0037',
     '<http://www.w3.org/2002/07/owl#someValuesFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hiking>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0037',
     '<http://www.w3.org/2002/07/owl#onProperty>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasActivity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0037',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Restriction>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#isOfferedAt>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#isOfferedAt>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#isOfferedAt>',
     '<http://www.w3.org/2002/07/owl#inverseOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasActivity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#isOfferedAt>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sunbathing>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sunbathing>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BedAndBreakfast>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '_:BNSEQN003a'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hotel>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Accommodation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Accommodation>',
     '<http://www.w3.org/2000/01/rdf-schema#comment>',
     '"A place to stay for tourists."^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Accommodation>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#WoodbineBeach>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Beach>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#UrbanArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003d',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#rest>',
     '_:BNSEQN003c'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003d',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#first>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#TwoStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Capital>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '_:BNSEQN003b'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Capital>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#City>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Capital>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Surfing>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Surfing>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BondiBeach>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"14"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BondiBeach>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"151.2729835510254"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BondiBeach>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-33.89050998115991"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BondiBeach>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Beach>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasEMail>',
     '"jla@acme.com"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasEMail>',
     '"john_adams@zmail.com"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://xmlns.com/foaf/0.1/gender>',
     '"male"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://xmlns.com/foaf/0.1/geekcode>',
     '"Fantasy Football geek"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://xmlns.com/foaf/0.1/firstName>',
     '"John"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://xmlns.com/foaf/0.1/family_name>',
     '"Adams"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://xmlns.com/foaf/0.1/birthday>',
     '"1967-11-27"^^<http://www.w3.org/2001/XMLSchema#date>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://xmlns.com/foaf/0.1/nick>',
     '"Johnnie"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#JohnAdams>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Safari>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Safari>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Safari>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Yoga>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Yoga>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Warrumbungles>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"11"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Warrumbungles>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"149.32205200195312"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Warrumbungles>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-31.17168484747176"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Warrumbungles>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#NationalPark>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BlueMountains>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"8"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BlueMountains>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"150.3753662109375"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BlueMountains>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-33.88865750124074"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BlueMountains>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#NationalPark>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#City>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '_:BNSEQN0039'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#City>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#UrbanArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#City>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#SouthBeach>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Beach>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Accommodation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasEMail>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#InverseFunctionalProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasEMail>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasEMail>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasEMail>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003c',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#rest>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#nil>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003c',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#first>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#ThreeStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#LuxuryHotel>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '_:BNSEQN0040'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#LuxuryHotel>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hotel>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#LuxuryHotel>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sightseeing>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Relaxation>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AccommodationRating>',
     '<http://www.w3.org/2000/01/rdf-schema#comment>',
     '"Consists of exactly three individuals."^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AccommodationRating>',
     '<http://www.w3.org/2002/07/owl#equivalentClass>',
     '_:BNSEQN003f'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AccommodationRating>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasContact>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasContact>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasContact>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#CapeYork>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"4"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#CapeYork>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"142.91015625"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#CapeYork>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-15.368949896534692"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#CapeYork>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#UrbanArea>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#UrbanArea>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#UrbanArea>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003b',
     '<http://www.w3.org/2002/07/owl#someValuesFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Museums>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003b',
     '<http://www.w3.org/2002/07/owl#onProperty>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasActivity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003b',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Restriction>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>',
     '<http://www.topbraidcomposer.org/owl/2006/09/sparql.owl#query>',
     '"SELECT \t?dest\nWHERE { ?dest rdf:type :Destination .\n    \t\t\t?dest :hasAccommodation ?hotel .\n    \t\t\t?hotel :hasRating :ThreeStarRating  }"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl>',
     '<http://www.w3.org/2002/07/owl#versionInfo>',
     '"1.0 by Holger Knublauch (holger@topquadrant.com)"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl>',
     '<http://www.w3.org/2000/01/rdf-schema#comment>',
     '"An example ontology to illustrate reasoning and the TBC Geography support."^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#TransitiveProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasActivity>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Activity>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasActivity>',
     '<http://www.w3.org/2002/07/owl#inverseOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#isOfferedAt>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasActivity>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Destination>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasActivity>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasRating>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AccommodationRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasRating>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Accommodation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasRating>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#ObjectProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasCity>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#FunctionalProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasCity>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasCity>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasCity>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasState>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#FunctionalProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasState>',
     '<http://www.w3.org/2000/01/rdf-schema#domain>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Contact>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasState>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasState>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hiking>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Sports>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hiking>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BunjeeJumping>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Adventure>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BunjeeJumping>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Coonabarabran>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"149.2793083190918"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Coonabarabran>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"14"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Coonabarabran>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-31.27715709457754"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Coonabarabran>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Town>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003a',
     '<http://www.w3.org/2002/07/owl#onProperty>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003a',
     '<http://www.w3.org/2002/07/owl#hasValue>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#OneStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003a',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Restriction>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#ThreeStarRating>',
     '<http://www.w3.org/2002/07/owl#differentFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#TwoStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#ThreeStarRating>',
     '<http://www.w3.org/2002/07/owl#differentFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#OneStarRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#ThreeStarRating>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#AccommodationRating>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Woomera>',
     '<http://www.topbraidcomposer.org/owl/2006/07/tbcgeo.owl#zoom>',
     '"12"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Woomera>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"136.8244171142578"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Woomera>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"-31.203404950917384"'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Woomera>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#RuralArea>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0039',
     '<http://www.w3.org/2002/07/owl#someValuesFrom>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#LuxuryHotel>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0039',
     '<http://www.w3.org/2002/07/owl#onProperty>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasAccommodation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN0039',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Restriction>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasStreet>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#DatatypeProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasStreet>',
     '<http://www.w3.org/2000/01/rdf-schema#range>',
     '<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasStreet>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#FunctionalProperty>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Toronto>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#hasPart>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#WoodbineBeach>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Toronto>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#lat>',
     '"43.65"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Toronto>',
     '<http://www.w3.org/2003/01/geo/wgs84_pos#long>',
     '"-79.383333333333333"^^<http://www.w3.org/2001/XMLSchema#string>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Toronto>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Capital>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hotel>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#BedAndBreakfast>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hotel>',
     '<http://www.w3.org/2002/07/owl#disjointWith>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Campground>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hotel>',
     '<http://www.w3.org/2000/01/rdf-schema#subClassOf>',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Accommodation>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#Hotel>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003f',
     '<http://www.w3.org/2002/07/owl#oneOf>',
     '_:BNSEQN003e'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '_:BNSEQN003f',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Class>'));

INSERT INTO geotravel_tpl VALUES (SDO_RDF_TRIPLE_S('geotravel',
     '<http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl>',
     '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>',
     '<http://www.w3.org/2002/07/owl#Ontology>'));


COMMIT;

PROMPT
PROMPT ***** Compiling statistics on semantic data (this may take a few moments) ...
PROMPT
PROMPT EXEC SEM_PERF.GATHER_STATS;;
PROMPT

EXEC SEM_PERF.GATHER_STATS;
                                            
PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *******************************************************************
PROMPT ** QUERY 1-1: What does the graph data look like when querying it
PROMPT **            relationally using Oracle's SDO_RDF_TRIPLE_S
PROMPT **            functions? 
PROMPT

SELECT a.triple.GET_SUBJECT()         subject,
       a.triple.GET_PROPERTY()        predicate,
       TO_CHAR(a.triple.GET_OBJECT()) object
FROM   geotravel_tpl a
ORDER BY 1 DESC

LIST


PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/
                                        
PROMPT
ACCEPT var PROMPT "Press <ENTER> to continue ... "
PROMPT

PROMPT
PROMPT
PROMPT *******************************************************************
PROMPT ** QUERY 1-2: What does the graph data look like when querying it
PROMPT **            semantically using SEM_MATCH? 
PROMPT

SELECT subject,
       predicate,
       object
FROM   TABLE(SEM_MATCH('
          {
            ?subject ?predicate ?object .
          }',
          SEM_MODELS('geotravel'),
          null,
          SEM_ALIASES(SEM_ALIAS(null,'http://www.topbraidcomposer.org/owl/2006/07/geotravel.owl#'),
                      SEM_ALIAS('owl','http://www.w3.org/2002/07/owl#')),
          null))
ORDER BY 1 DESC

LIST

PROMPT
ACCEPT var PROMPT "Press <ENTER> to execute ... "
PROMPT

/

