#!/bin/sh
# Compilation script for interMedia Java classes Quick Start
# You need to edit the the connection string on the last line
# to work with your database
# Ensure that the ORACLE_HOME environment variable works
if [ -z "$ORACLE_HOME" ]; then
   echo ERROR: ORACLE_HOME environment variable not set
   echo ERROR: e.g. setenv ORACLE_HOME /scratch/alamb/OH101
   exit 1
fi

# define which versions of java we will use
JAVAC=$ORACLE_HOME/jdk/bin/javac
JAVA=$ORACLE_HOME/jdk/bin/java

# Setup the classpath to point at the appropriate libraries

#  the locatiuon of the oracle jdbc driver library
JDBCLIB=$ORACLE_HOME/jdbc/lib/ojdbc14.jar

#  the location of the ordim.jar client side ordim libary
ORDIMLIB=$ORACLE_HOME/ord/jlib/ordim.jar

#  the location of the sqlj supporting runtime library
SQLJLIB=$ORACLE_HOME/sqlj/lib/runtime12.jar

# The classpath to compile and run with
CLASSPATH=$JDBCLIB:$ORDIMLIB:$SQLJLIB:.
echo CLASSPATH=$CLASSPATH

# -----------------------------------
# Compile the java source
$JAVAC -classpath $CLASSPATH InterMediaQuickStart.java

# Usage: java InterMediaQuickStart <connection url> <username> <password>
$JAVA -classpath $CLASSPATH InterMediaQuickStart jdbc:oracle:thin:@138.2.233.47:27239:AAL10 scott tiger
# -----------------------------------



# The lines below compile and run the example code using the
# getCustomDatum syntax.

# -----------------------------------
# Have to switch back to old jdbc drivers to work with jdk 1.3 that ships with Oracle 9i
JDBCLIB=$ORACLE_HOME/jdbc/lib/classes12.jar
CLASSPATH=$JDBCLIB:$ORDIMLIB:$SQLJLIB:.
echo CLASSPATH=$CLASSPATH

# Compile the java source
$JAVAC -classpath $CLASSPATH InterMediaQuickStartCustom.java

# Usage: java InterMediaQuickStart <connection url> <username> <password>
$JAVA -classpath $CLASSPATH InterMediaQuickStartCustom jdbc:oracle:thin:@138.2.233.47:27239:AAL10 scott tiger
# -----------------------------------
