@ECHO OFF
REM Compilation script for interMedia Java classes Quick Start
REM You need to edit the the connection string on the last line
REM to work with your database

REM Ensure that the ORACLE_HOME environment variable works
if {%ORACLE_HOME%}=={} (
   echo ERROR: ORACLE_HOME environment variable not set
   echo ERROR: e.g. c:\^> set ORACLE_HOME=C:\oracle\product\10.1.0\db_1
   goto :EOF
)

REM define which versions of java we will use
set JAVAC=%ORACLE_HOME%\jdk\bin\javac
set JAVA=%ORACLE_HOME%\jdk\bin\java

REM Setup the classpath to point at the appropriate libraries

REM  the locatiuon of the oracle jdbc driver library
set JDBCLIB=%ORACLE_HOME%\jdbc\lib\ojdbc14.jar

REM  the location of the ordim.jar client side ordim libary
set ORDIMLIB=%ORACLE_HOME%\ord\jlib\ordim.jar

REM  the location of the sqlj supporting runtime library
set SQLJLIB=%ORACLE_HOME%\sqlj\lib\runtime12.jar

REM The classpath to compile and run with
echo on
set CLASSPATH=%JDBCLIB%;%ORDIMLIB%;%SQLJLIB%;.

ECHO ON
REM -----------------------------------
REM Compile the java source
%JAVAC% InterMediaQuickStart.java

REM Usage: java InterMediaQuickStart <connection url> <username> <password>
%JAVA% InterMediaQuickStart jdbc:oracle:oci:@AAL10 scott tiger
REM -----------------------------------



REM The lines below compile and run the example code using the
REM getCustomDatum syntax.

REM -----------------------------------
REM Have to switch back to old jdbc drivers to work with jdk 1.3 that ships with Oracle 9i
set JDBCLIB=%ORACLE_HOME%\jdbc\lib\classes12.jar
set CLASSPATH=%JDBCLIB%;%ORDIMLIB%;%SQLJLIB%;

REM Compile the java source
%JAVAC% InterMediaQuickStartCustom.java

REM Usage: java InterMediaQuickStart <connection url> <username> <password>
%JAVA% InterMediaQuickStartCustom jdbc:oracle:thin:@localhost:27239:AAL10 scott tiger

REM -----------------------------------
