-- Create the base schema objects for SRDemo
-- $Id: createSchemaObjects.sql,v 1.5 2005/12/22 22:46:41 duncan Exp $


CREATE TABLE SERVICE_REQUESTS (
    SVR_ID NUMBER(8,0) NOT NULL,
    STATUS VARCHAR2(20) NOT NULL,
    REQUEST_DATE TIMESTAMP(6) NOT NULL,
    PROBLEM_DESCRIPTION VARCHAR2(4000) NOT NULL,
    PROD_ID NUMBER(8,0) NOT NULL,
    CREATED_BY NUMBER(8,0) NOT NULL,
    ASSIGNED_TO NUMBER(8,0),
    ASSIGNED_DATE TIMESTAMP(6)
    )
    NOLOGGING 
    INITRANS 1
    MAXTRANS 255
    STORAGE (
        INITIAL 64K
        MINEXTENTS 1
        MAXEXTENTS 2147483645);

CREATE TABLE PRODUCTS (
    PROD_ID NUMBER(8,0) NOT NULL,
    NAME VARCHAR2(50) NOT NULL,
    IMAGE VARCHAR2(4000),
    DESCRIPTION VARCHAR2(4000) NOT NULL
    )
    NOLOGGING 
    INITRANS 1
    MAXTRANS 255
    STORAGE (
        INITIAL 64K
        MINEXTENTS 1
        MAXEXTENTS 2147483645);

CREATE TABLE EXPERTISE_AREAS (
    PROD_ID NUMBER(8,0) NOT NULL,
    USER_ID NUMBER(8,0) NOT NULL,
    EXPERTISE_LEVEL VARCHAR2(30) NOT NULL,
    NOTES VARCHAR2(4000)
    )
    NOLOGGING 
    INITRANS 1
    MAXTRANS 255
    STORAGE (
        INITIAL 64K
        MINEXTENTS 1
        MAXEXTENTS 2147483645);

CREATE TABLE SERVICE_HISTORIES (
    SVR_ID NUMBER(8,0) NOT NULL,
    LINE_NO NUMBER(4,0) NOT NULL,
    SVH_DATE TIMESTAMP(6) NOT NULL,
    NOTES VARCHAR2(4000) NOT NULL,
    SVH_TYPE VARCHAR2(10) NOT NULL,
    CREATED_BY NUMBER(8,0) NOT NULL
    )
    NOLOGGING 
    INITRANS 1
    MAXTRANS 255
    STORAGE (
        INITIAL 64K
        MINEXTENTS 1
        MAXEXTENTS 2147483645);

CREATE TABLE USERS (
    USER_ID NUMBER(8,0) NOT NULL,
    USER_ROLE VARCHAR2(10) NOT NULL,
    EMAIL VARCHAR2(50) NOT NULL,
    FIRST_NAME VARCHAR2(30) NOT NULL,
    LAST_NAME VARCHAR2(30) NOT NULL,
    STREET_ADDRESS VARCHAR2(40) NOT NULL,
    CITY VARCHAR2(30) NOT NULL,
    STATE_PROVINCE VARCHAR2(25),
    POSTAL_CODE VARCHAR2(12),
    COUNTRY_ID CHAR(2)
    )
    NOLOGGING 
    INITRANS 1
    MAXTRANS 255
    STORAGE (
        INITIAL 64K
        MINEXTENTS 1
        MAXEXTENTS 2147483645);

ALTER TABLE SERVICE_REQUESTS ADD CONSTRAINT SVR_PK PRIMARY KEY (SVR_ID) ENABLE;

ALTER TABLE PRODUCTS ADD CONSTRAINT PRD_PK PRIMARY KEY (PROD_ID) ENABLE;

ALTER TABLE EXPERTISE_AREAS ADD CONSTRAINT EXA_PK PRIMARY KEY (PROD_ID,USER_ID) ENABLE;

ALTER TABLE SERVICE_HISTORIES ADD CONSTRAINT SVH_PK PRIMARY KEY (SVR_ID,LINE_NO) ENABLE;

ALTER TABLE USERS ADD CONSTRAINT USR_PK PRIMARY KEY (USER_ID) ENABLE;

ALTER TABLE USERS ADD CONSTRAINT USR_UK UNIQUE (EMAIL) ENABLE;

ALTER TABLE SERVICE_REQUESTS ADD CONSTRAINT SVR_PRD_FK FOREIGN KEY(PROD_ID) REFERENCES PRODUCTS (PROD_ID) ENABLE;

ALTER TABLE SERVICE_REQUESTS ADD CONSTRAINT SVR_CREATED_BY_USR_FK FOREIGN KEY (CREATED_BY) REFERENCES USERS (USER_ID) ENABLE;

ALTER TABLE SERVICE_REQUESTS ADD CONSTRAINT SVR_ASSIGNED_TO_USR_FK FOREIGN KEY (ASSIGNED_TO) REFERENCES USERS (USER_ID) ENABLE;

ALTER TABLE EXPERTISE_AREAS ADD CONSTRAINT EXA_PRD_FK FOREIGN KEY (PROD_ID) REFERENCES PRODUCTS (PROD_ID) ENABLE;

ALTER TABLE EXPERTISE_AREAS ADD CONSTRAINT EXA_USR_FK FOREIGN KEY (USER_ID) REFERENCES USERS (USER_ID) ENABLE;

ALTER TABLE SERVICE_HISTORIES ADD CONSTRAINT SVH_USR_FK FOREIGN KEY (CREATED_BY) REFERENCES USERS (USER_ID) ENABLE;

ALTER TABLE SERVICE_HISTORIES ADD CONSTRAINT SVH_SVR_FK FOREIGN KEY (SVR_ID) REFERENCES SERVICE_REQUESTS (SVR_ID) ENABLE;

ALTER TABLE EXPERTISE_AREAS ADD CONSTRAINT EXPERTISE_LEVEL_CHK CHECK (EXPERTISE_LEVEL IN ('Expert','Qualified','Apprentice')) ENABLE;

ALTER TABLE SERVICE_HISTORIES ADD CONSTRAINT HISTORY_TYPE_CHK CHECK (SVH_TYPE IN ('Customer','Technician','Hidden')) ENABLE;

ALTER TABLE SERVICE_REQUESTS ADD CONSTRAINT SR_STATUS_CHK CHECK (STATUS IN ('Open','Pending','Closed')) ENABLE;

ALTER TABLE USERS ADD CONSTRAINT USER_ROLE_CHK CHECK (USER_ROLE IN ('manager','technician','user')) ENABLE;

COMMENT ON COLUMN SERVICE_REQUESTS.PROBLEM_DESCRIPTION IS 'This is the initial description from the customer. It never changes.';

COMMENT ON COLUMN SERVICE_HISTORIES.SVR_ID IS 'This is the id of the person adding (updating) this note.';

COMMENT ON COLUMN SERVICE_HISTORIES.SVH_TYPE IS 'This will be either Customer, Technician or Hidden. If it''s Hidden, the customer won''t see this comment.';

CREATE INDEX SVR_PRD_FK_I ON SERVICE_REQUESTS (PROD_ID);

CREATE INDEX SVR_CREATED_BY_USR_FK_I ON SERVICE_REQUESTS (CREATED_BY);

CREATE INDEX SVR_ASSIGNED_TO_FK_I ON SERVICE_REQUESTS (ASSIGNED_TO);

CREATE INDEX EXA_PRD_FK_I ON EXPERTISE_AREAS (PROD_ID);

CREATE INDEX EXA_USR_FK_I ON EXPERTISE_AREAS (USER_ID);

CREATE INDEX SVH_SVR_FK_I ON SERVICE_HISTORIES (SVR_ID);

CREATE INDEX SVH_USR_FK_I ON SERVICE_HISTORIES (CREATED_BY);

CREATE SEQUENCE USERS_SEQ INCREMENT BY 1 START WITH 400 MAXVALUE 99999999 MINVALUE 1 CACHE 20 ;

CREATE SEQUENCE PRODUCTS_SEQ INCREMENT BY 1 START WITH 200 MAXVALUE 99999999 MINVALUE 1 CACHE 20 ;

CREATE SEQUENCE SERVICE_REQUESTS_SEQ INCREMENT BY 1 START WITH 200 MAXVALUE 99999999 MINVALUE 1 CACHE 20 ;
