#!/usr/bin/perl
#
# $Header: opsm/utl/rhpmovegi.pl /main/3 2015/12/03 22:24:17 ksviswan Exp $
#
# rhpmovegi.pl
#
# Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      rhpmovegi.pl - Implements the  actions needed for out of place GI home
#                    move to a new gold image for 12.1
#
#    DESCRIPTION
#
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ksviswan   12/03/15 - adapt for 12.2
#    ksviswan   06/05/15 - fix copyConfigurationData invoke
#    ksviswan   05/03/15 - Creation
#
use strict;
use English;
use File::Basename;
use File::Spec::Functions;
use Term::ANSIColor;
use POSIX qw(tmpnam);
use Cwd;
use Cwd 'abs_path';

BEGIN {
  # Add the directory of this file to the search path
  push @INC, dirname($PROGRAM_NAME);
  my $scriptdir = abs_path(dirname($PROGRAM_NAME));
  my $gridhome = `$scriptdir/../../srvm/admin/getcrshome`;
  my $incdir = "$gridhome/crs/install";
  push @INC, $incdir;
}

use crscpcfg;
use crsutils;

# globals
my $DEBUG;

#cmd line params
my $srchome = $ARGV[0];
my $dsthome = $ARGV[1];
my $is122 = $ARGV[2];

# MAIN SCRIPT BODY
#

# pull all parameters defined in crsconfig_params and s_crsconfig_defs (if
# it exists) as variables in Perl
my $paramfile = catfile($dsthome, "crs", "install", "crsconfig_params");

# pull all parameters defined in crsconfig_addparams
my $addfile = catfile($dsthome, "crs", "install", "crsconfig_addparams");

# pull all definitions in s_crsconfig_defs (if it exists) as variables in Perl
# this file might not exist for all platforms
my $osdfile = catfile($dsthome, "crs", "install", "s_crsconfig_defs");

if (!$DEBUG) { $DEBUG = $ENV{'ORA_INSTALL_DEBUG'}; }

### Set this host name (lower case and no domain name)
our $HOST = tolower_host();
our $SUPERUSER = check_SuperUser ();


# subsequent processing 
   crsutils->new(
                     SIHA                => FALSE,
                     paramfile           => $paramfile,
                     osdfile             => $osdfile,
                     addfile             => $addfile,
                     crscfg_trace        => TRUE,
                     DEBUG               => $DEBUG,
                     HAS_USER            => $SUPERUSER,
                     DESTCRSHOME         => $dsthome,
                     HOST                => $HOST
                );



copyConfigurationData (
                      SIHA                => FALSE,
                      paramfile           => $paramfile,
                      osdfile             => $osdfile,
                      addfile             => $addfile,
                      crscfg_trace        => TRUE,
                      DEBUG               => $DEBUG,
                      HAS_USER            => $SUPERUSER,
                      DESTCRSHOME         => $dsthome,
                      HOST                => $HOST
                      );

if ($is122 eq 'false')
{
  trace("Preparing the destination GI home for out-of-place patching ...");
  preunlockPatchDestHome($dsthome);
}

sub preunlockPatchDestHome
{
   my $unlock_home = $_[0];

   trace("prepare for unlock: $unlock_home");

   modifyparamfile("ORACLE_HOME", $unlock_home);
   modifyparamfile("CRFHOME", $unlock_home);
   modifyparamfile("JREDIR", "$unlock_home/jdk/jre/");
   modifyparamfile("JLIBDIR", "$unlock_home/jlib");

   # set new home instantiate prior to unlock
   $ENV{'ORACLE_HOME'} = $unlock_home;
   $CFG->ORA_CRS_HOME($unlock_home);

   # instantiate prior to unlock
   instantiate_scripts($unlock_home);
   my $cdataDir = catfile($unlock_home, 'cdata');
   my $olrPath = $cdataDir;
   $CFG->OLR_LOCATION(catfile($olrPath,  $CFG->HOST . '.olr'));
   add_localOlr_OlrConfig_OcrConfig();

   my @crsconfig_dirs = read_file(catfile($CFG->ORA_CRS_HOME,
                        'crs', 'utl', $CFG->HOST, 'crsconfig_dirs'));
   create_dirs(\@crsconfig_dirs);

   copy_wrapper_scripts();
   my @crsconfig_fileperms = read_file(catfile($CFG->ORA_CRS_HOME,
                             'crs', 'utl', $CFG->HOST, 'crsconfig_fileperms'));
   set_file_perms(\@crsconfig_fileperms);

}
