# $Id: cus_net_client.mk /unix/15 2016/06/01 00:07:27 bhmathur Exp $
#
# cus_net_client.mk - "make" file to reload network client executables
# 
# NOTE: ORACLE_HOME must be either:
#   . set in the user's environment
#   . passed in on the command line
#   . defined in a modified version of this makefile
#
# MODIFIED  (MM/DD/YY)
# bhmathur   05/30/16 - Bug 23484840: Set 600 on ldflagsO.
# skramas    05/05/16 - Permissions for backup
# pkale      08/18/10 - Replace -fPIC with KPIC_OPTION
# adadhich   08/06/10 - Bug 9803056: No need to build 32-bit nnfgt.o
# spamu      12/28/09 - add -fPIC
# shwagarw   09/02/08 - Bug # 5551406
# donlee     06/16/04 - mv RMF of ntcontab and nnfgt 
# donlee     05/20/04 - rm -f ntcontab.[os], nnfgt.[os] 
# donlee     03/02/04 - macroize TR 
# jboyce     11/21/03  - 
# jboyce     11/17/03  - mksoftlinks:
# donlee     03/08/02  - cannot use $<
# donlee     02/27/02  - mkldflags: echo already adds a NEWLINE
# donlee     02/27/02  - define/use macro covers for INSTALL_TARGS
# donlee     02/26/02  - use relevant LINKLINE macros
# smendiol   07/24/01  - obsolete trcasst
# donlee     02/08/01 -  rm unneeded macro defs
# donlee     02/08/01  - rm unnecessary def of ECHO
# mkrohan    10/12/00  - Switch from LINKEXSYSLIBS to LINKLDLIBS
# mkrohan    10/11/00  - Adding genagtsh
# mkrohan    05/20/00  - Bug #1304913
#

include $(ORACLE_HOME)/network/lib/env_network.mk 

LIBNET=$(LIBHOME)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)

CATLDFLAGS=$(CAT) $(NETWORKINSTALL)ldflags.* | $(TR) '\n' ' '
CFLAGS_SHIP+= $(KPIC_OPTION)

INSTALL_TARGS=clean $(INSTALL_NET_CLIENT_TARGS)

default: itrcroute  itnsping itrcfmt

tnsping: $(S0NSPING) $(NSPING)
	$(SILENT)$(ECHO) " - Linking $(TNSPING)"
	$(RMF) $@
	$(TNSPING_LINKLINE)

itnsping: tnsping
	-$(MV) -f $(BINHOME)tnsping $(BINHOME)tnsping0
	-$(MV) tnsping $(BINHOME)tnsping
	-$(CHMOD) 751 $(BINHOME)tnsping
	-$(CHMOD) 600 $(BINHOME)tnsping0

trcroute: $(S0NUR) $(LIBNULOCAL)
	$(SILENT)$(ECHO) " - Linking $(TRCROUTE)"
	$(RMF) $@
	$(TRCROUTE_LINKLINE)

itrcroute: trcroute
	-$(MV) -f $(BINHOME)trcroute $(BINHOME)trcroute0
	-$(MV) trcroute $(BINHOME)trcroute
	-$(CHMOD) 751 $(BINHOME)trcroute
	-$(CHMOD) 600 $(BINHOME)trcroute0

itrcfmt: 
	$(ECHO) "Do not relink 'trcfmt'"

# Target for relinking ntcontab.o

ntcontab.o:
	$(RMF) ntcontab.*
	(if [ "$(GENNT)" = "compile" ] ; then \
	  $(BINHOME)gennttab > ntcontab.c ;\
	  $(CC) $(CFLAGS_SHIP) -c ntcontab.c ;\
	  $(RMF) $(LIBHOME)ntcontab.o ;\
	  $(MV) ntcontab.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)
	(if [ "$(GENNT)" = "assemble" ] ; then \
	  $(BINHOME)gennttab > ntcontab.s ;\
	  $(AS) $(ASFLAGS_SHIP) ntcontab.o ntcontab.s ;\
	  $(RMF) $(LIBHOME)ntcontab.o ;\
	  $(MV) ntcontab.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)
	(if [ "$(GENNT)" = "oratmp" ] ; then \
	  $(BINHOME)gennttab > ntcontab.c ;\
	  /lib/idcpp ntcontab.c oratmp.c ;\
	  $(COMP) -i oratmp.c -o oratmp.s -f ntcontab.c ;\
	  $(AS) -o ntcontab.o oratmp.s ;\
	  $(RMF) oratmp.c oratmp.s ;\
	  $(RMF) $(LIBHOME)ntcontab.o ;\
	  $(MV) ntcontab.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)
	(if [ "$(GENNT)" = "binary" ] ; then \
	  $(BINHOME)gennttab > ntcontab.c ;\
	  TARGET_BINARY_INTERFACE=$(BINARY_INTERFACE) ;\
	  export TARGET_BINARY_INTERFACE ;\
	  $(CC) $(CFLAGS_SHIP) -c ntcontab.c ;\
	  -$(RMF) $(LIBHOME)ntcontab.o ;\
	  -$(MV) ntcontab.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)

nnfgt.o:
	$(RMF) nnfgt.*
	(if [ "$(GENNT)" = "compile" ] ; then \
	  $(BINHOME)gennfgt > nnfgt.c ;\
	  $(CC) $(CFLAGS_SHIP) -c nnfgt.c ;\
	  $(RMF) $(LIBHOME)nnfgt.o ;\
	  $(MV) nnfgt.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)
	(if [ "$(GENNT)" = "assemble" ] ; then \
	  $(BINHOME)gennfgt > nnfgt.s ;\
	  $(AS) $(ASFLAGS_SHIP) nnfgt.o nnfgt.s ;\
	  $(RMF) $(LIBHOME)nnfgt.o ;\
	  $(MV) nnfgt.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)
	(if [ "$(GENNT)" = "oratmp" ] ; then \
	  $(BINHOME)gennfgt > nnfgt.c ;\
	  /lib/idcpp nnfgt.c oratmp.c ;\
	  $(COMP) -i oratmp.c -o oratmp.s -f nnfgt.c ;\
	  $(AS) -o nnfgt.o oratmp.s ;\
	  $(RMF) oratmp.c oratmp.s ;\
	  $(RMF) $(LIBHOME)nnfgt.o ;\
	  $(MV) nnfgt.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)
	(if [ "$(GENNT)" = "binary" ] ; then \
	  $(BINHOME)gennfgt > nnfgt.c ;\
	  TARGET_BINARY_INTERFACE=$(BINARY_INTERFACE) ;\
	  export TARGET_BINARY_INTERFACE ;\
	  $(CC) $(CFLAGS_SHIP) -c nnfgt.c ;\
	  -$(RMF) $(LIBHOME)nnfgt.o ;\
	  -$(MV) nnfgt.o $(LIBHOME) ;\
          $(AR) rv $(LIBNET) $(LIBHOME)$@ ; fi)

preinstall:
	-$(CHMOD) 755 $(BINHOME)
 
install: preinstall $(INSTALL_TARGS)
 
clean:

client_sharedlib:
	$(GENCLNTSH)
	$(GENAGTSH) $(LIBAGTSH) 1.0

# $(CATLDFLAGS) strips away all the newlines; $(ECHO) adds one
mkldflags: empty_ldflags
	-$(SILENT) $(CATLDFLAGS) >> $(LIBHOME)ldflags 
	-$(SILENT) $(ECHO) >> $(LIBHOME)ldflags

empty_ldflags:
	-$(SILENT) $(RMF) $(LIBHOME)ldflagsO
	-$(SILENT) $(TOUCH) $(LIBHOME)ldflags
	-$(SILENT) $(MV) $(LIBHOME)ldflags $(LIBHOME)ldflagsO
	-$(SILENT) $(CHMOD) 600 $(LIBHOME)ldflagsO
	-$(SILENT) $(TOUCH) $(LIBHOME)ldflags

mk_softlinks:
	$(LNS) $(OHLIBNETWORK) $(LOC_LIBNETWORKSH)
	$(LNS) $(LIBNETWORKSH) $(OHLIBNETWORKSH)
	$(LNS) $(OHLIBNL) $(LOC_LIBNLSH)
	$(LNS) $(LIBNLSH) $(OHLIBNLSH)
	$(LNS) $(OHLIBLDAP) $(LOC_LIBLDAPSH)
	$(LNS) $(LIBLDAPSH) $(OHLIBLDAPSH)
	$(LNS) $(OHLIBRPC) $(LOC_LIBRPCSH)
	$(LNS) $(LIBRPCSH) $(OHLIBRPCSH)
