# Entering network.mk

# Entering SRCHOME/buildtools/mkfile/prefix.mk

# Entering SRCHOME/buildtools/mkfile/defs.mk

SHELL=/bin/sh

AS_EXT=s
CC_EXT=cpp
LIB_EXT=a
OBJ_EXT=o
PLB_EXT=plb
SO_EXT=so
LOCK_EXT=lk
SQL_EXT=sql
SYM_EXT=sym
JAVA_EXT=java
CLASS_EXT=class
JAR_EXT=jar
ZIP_EXT=zip
DEF_EXT=def
BITCODE_EXT=bc

LIB_PREFIX=lib
LDLIBFLAG=-l
LDPATHFLAG=-L
PATHSEP= :
DEPLIB_EXT=$(LIB_EXT)
DEPSO_EXT=$(SO_EXT)

AR=ar
AS=as
AWK=awk
CAT=cat
CC=cc
CCC=CC
CD=cd
CHMOD=chmod
CP=cp
CPP=cpp
CPP_WITH_COMMENTS=cpp -C -std=c9x
CODECOV_TOOL_CCB=stattool.STABLE
CODECOV_TOOL_HTML=stattool.STABLE --ed-commands
DATE=date
ECHO=echo
ECHON=echo -n
EXEC=exec
FIND=find
FOLLOW=-follow
NOLEAF=-noleaf
GREP=grep
KILL=kill
SLEEP=sleep
LD=ld
LMAKE=make
LN=ln
LNS=ln -s
MKDIR=mkdir
MKDIRP=mkdir -p
MV=mv
MVF=mv -f
NM=nm
PERL=perl
RM=rm
RMF=rm -f
CPF=cp -f
RMRF=rm -rf
SED=sed
SORT=sort
TOUCH=touch
TR=tr
XARGS=xargs
LS=ls
ED=ed - -s

ANT=ant

NULL_DEVICE=/dev/null

BINDIR=bin
LIBDIR=lib
JSRCDIR=jsrc
JLIBDIR=jlib
BINHOME=$(ORACLE_HOME)/$(BINDIR)/
LIBHOME=$(ORACLE_HOME)/$(LIBDIR)/

PRODHOME=$(ORACLE_HOME)/$(PRODUCT)/
PRODJORACLE_HOME=$(PRODHOME)$(JSRCDIR)/
PRODLIBHOME=$(PRODHOME)$(LIBDIR)/
PRODSOHOME=$(PRODLIBHOME)
PRODADMIN=$(PRODHOME)admin/
PRODDEFHOME=$(PRODADMIN)

ECHODO=$(BINHOME)echodo
GENSYSLIB=$(BINHOME)gensyslib
GENCLNTSH=$(BINHOME)genclntsh
GENCLNTST=$(BINHOME)genclntst
GENOCCISH=$(BINHOME)genoccish
GENAGTSH=$(BINHOME)genagtsh
GENNAFLG=$(BINHOME)gennaflg
GENAUTAB=$(BINHOME)genautab
MKMANIFEST=$(ORACLE_HOME)/buildtools/bin/mkjmanifest
GENORASDKBASE=$(BINHOME)genorasdksh -base
GENORASDKSH=$(BINHOME)genorasdksh

ARCHIVE=$(ECHODO) $(ARCREATE) $(LIB) $?
ARCHIVE2=$(ECHODO) $(ARCREATE) $(LIB2) $?
ARCHIVE_PIC=$(ECHODO) $(ARCREATE) $(PIC_LIB) $?
ARCHIVE2_PIC=$(ECHODO) $(ARCREATE) $(PIC_LIB2) $?
ARCHIVE_NOPIC=$(ECHODO) $(ARCREATE) $(NOPIC_LIB) $?
ARCHIVE2_NOPIC=$(ECHODO) $(ARCREATE) $(NOPIC_LIB2) $?
ARCHIVE_OBJ=$(AR) r $@ $*.$(OBJ_EXT)
ARCREATE=$(AR) cr$(ARLOCAL)
ARDELETE=$(AR) d$(ARLOCAL)
AREXTRACT=$(AR) x 
ARPRINT=$(AR) t
ARREPLACE=$(AR) r 
DOAR=$(ARCREATE) $@ $? 

JARCHIVE_OBJ=$(JAR) cv0f $@ $(JPKG_FILES) $(EXTRA_CLASS_FILES)
JARCREATE=$(JAR) cv0f
JARDELETE=$(ECHO) "no such thing"
JAREXTRACT=$(JAR) xf
JARPRINT=$(JAR) tvf
JARREPLACE=$(JAR) uf

CCARCREATE=$(CCC) -xar -o 

MAKE=$(LMAKE)
QUIET=>/dev/null 2>&1
QUIETE=2>/dev/null
SILENT=@

CTSCLEAN=clean
CTSCOMPTYPE=comp_ar1 _UNLOCK='$$(_unlock)' _LOCK='$$(_lock)' _RM='$$(_rm)' 
CTSDEPLIST=DEPLIST=/dev/null
CTSMAKEFLAGS=$(SILENT:@=--no-print-directory -s) $(CTSCLEAN) $(CTSCOMPTYPE) $(CTSDEPLIST)

CFLAGS=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGS) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
CFLAGSCC=$(GFLAG) $(OPTIMIZE) $(CDEBUG) $(CCFLAGSCC) $(PFLAGS)\
	$(SHARED_CFLAG) $(USRFLAGS)
LPFLAGS+= $(BANNERDEFINES)
PFLAGS=$(INCLUDE) $(SPFLAGS) $(LPFLAGS) $(PLSQLNCGFLAGS)

LD_SHARED_FLAG=$(SHARED_CFLAG)

LDCCOM=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(CC) $(GFLAG) $(CCFLAGS) $(EXOSFLAGS) $(LDFLAGS)
LDCCOMCC=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(CCC) $(GFLAG) $(CCFLAGSCC) $(EXOSFLAGS) $(LDFLAGS)
PURECMDS=$(PURELINK) $(PURIFY) $(PURECOV) $(QUANTIFY)
LINK=$(LDCCOM)
LINKCC=$(LDCCOMCC)
LDFLAGS=-o $@ $(LDPATHFLAG)$(PRODLIBHOME) $(LDPATHFLAG)$(LIBHOME)
LDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(EXSYSLIBS) $(MATHLIB) $(USRLIBS)
MATHLIB=-lm
LINKLDLIBS=$(LDLIBS)
COBLDLIBS=$(LDLIBS)

SYSLIBLIST=$(LIBHOME)sysliblist
SYSLIBS=`$(CAT) $(SYSLIBLIST)`

NAETTOBJS=$(NAUTAB) $(NAETAB) $(NAEDHS)
TTLIBD=$(NETLIBD) $(LIBRDBMS_CLT) $(LIBMM) $(CORELIBD) $(LIBEPC) $(LIBCLNTSH)
ORACLETTLIBS1=$(NTZEOBJ) $(NETLIBS) $(NZLIBS) $(LLIBZTKG) $(LLIBRDBMS_CLT) $(LLIBMM) $(CORELIBS)\
       $(NETLIBS) $(LLIBRDBMS_CLT) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) \
       $(LLIBRDBMS_CLT) $(CORELIBS)
ORACLETTLIBS=$(ORACLETTLIBS1)
STATICTTLIBS=$(ORACLETTLIBS) $(LDLIBS)
TTLIBS=$(LLIBCLNTSH) $(STATICTTLIBS)
DEVTTLIBS=$(TTLIBS)
LINKTTLIBS=$(LLIBCLNTSH) $(ORACLETTLIBS) $(LINKLDLIBS)
LINKSHCORETTLIBS=$(LLIBCLNTSHCORE) $(ORACLETTLIBS) $(LINKLDLIBS)
COBTTLIBS=$(ORACLETTLIBS) $(COBLDLIBS)
SUIDLINKTTLIBS=$(LLIBCLNTSH) $(ORACLETTLIBS) $(SUIDLINKLDLIBS)

STATIC_ORACLETTLIBS=$(NTZEOBJ) $(NETLIBS) $(NZLIBS) $(LIBRDBMS_CLT) \
    $(LIBMM) $(CORELIBS) $(NETLIBS) $(LIBRDBMS_CLT) $(LIBPLS_CLT) \
    $(LIBEPC) $(CORELIBS) $(LIBRDBMS_CLT) $(CORELIBS)

SHARED_CLIENTLIBS=$(LLIBCLNTSH) $(LDFLAGSLIST)
STATIC_CLIENTLIBS=$(LLIBCLNTST) $(LDFLAGSLIST)
SHARED_LDCLIENTLIBS=$(SHARED_CLIENTLIBS) $(LDLIBS)
STATIC_LDCLIENTLIBS=$(STATIC_CLIENTLIBS) $(LDLIBS)

I_SYM=-I

LD_SHLIBS=$(SHLIBS)
DLOPENLIB_COMMAND=$(LD_SHLIB_COMMAND)
DLOPEN_SYM_COMMAND=$(SYM_COMMAND)
LD_SHLIB_COMMAND=$(SO_COMMAND)


OH_LINK_SHLIB_COMMAND=$(MAKE) -f $(MAKEFILE) ALWAYS=always \
$(LIBHOME)$(@:.ohso=.$(SO_EXT))
PROD_LINK_SHLIB_COMMAND=$(MAKE) -f $(MAKEFILE) ALWAYS=always \
$(PRODLIBHOME)$(@:.prodso=.$(SO_EXT))

LIBMAJORVSN=12

MAJORVSN=12
MINORVSN=2
MIDTIERVSN=0
PATCHMAJORVSN=1
PATCHMINORVSN=0
BANNERVERSION=$(MAJORVSN).$(MINORVSN).$(MIDTIERVSN).$(PATCHMAJORVSN).$(PATCHMINORVSN)

SPACE2NEWLINE=| $(TR) ' ' \\n

LINKSHLIB=$(BINHOME)linkshlib
LIBS_SUFFIX=LIBS
LINKSHLIB_CALL=$(LINKSHLIB) $@ $(MAKEFILE) $(SO_EXT)
CUS_NEW_SHLIB_COMMAND=$(LINKSHLIB_CALL) new_ld_shlib $(LIBS_SUFFIX) $(VARLIB)
CUS_NEW_DLOPENLIB_COMMAND=$(LINKSHLIB_CALL) new_dlopenlib $(LIBS_SUFFIX) $(VARLIB)
CUS_SHLIB_COMMAND=$(LINKSHLIB_CALL) ld_shlib $(LIBS_SUFFIX) $(VARLIB)
CUS_DLOPENLIB_COMMAND=$(LINKSHLIB_CALL) dlopenlib $(LIBS_SUFFIX) $(VARLIB)
CUS_VARLIB_COMMAND=$(LINKSHLIB_CALL) var $(PRODHOME)admin
CUS_BOOTSTRAPLIB_COMMAND=$(LINKSHLIB_CALL) bootstrap $(LIBS_SUFFIX)

# Exiting SRCHOME/buildtools/mkfile/defs.mk
# Entering SRCHOME/buildtools/mkfile/platform.mk

FAMILY=unix
PLATFORM=i86pc

MOTIFHOME=
OPENWINHOME=
GUILIBHOME= 

DIRSEP=/
PSEP=:

CLUSTERDIR=/opt/SUNWcluster

ORACLUSTERDIR=/opt/ORCLcluster/lib/

SO_EXT=so

GMAKE=make -r
LMAKE=/usr/ccs/bin/make
FIND=/usr/bin/find # gnu find!
PS=ps -feda


JARCHIVE=@`if echo ${JLIB} | egrep '\.jar' > /dev/null 2>&1;then $(JARCREATE) $(JLIB) $? ; else echo ""; fi`

GROUP=/etc/group

LINK=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(LD) $(LDFLAGS) -dy $(COMPSOBJS)
LINKCC=$(ADE_DEL_FILE_CMD) $(PURECMDS) $(CCC) $(LDFLAGS) -m64  -norunpath -mt -dy $(COMPOBJSCC)

LDFLAGS64=-o $@ $(LDPATHFLAG)$(ORACLE_HOME)/$(PRODUCT)/lib64/ \
        $(LDPATHFLAG)$(ORACLE_HOME)/lib64/

LDFLAGS32=-o $@ $(LDPATHFLAG)$(ORACLE_HOME)/$(PRODUCT)/lib32/ \
        $(LDPATHFLAG)$(ORACLE_HOME)/lib32/

LLIBSTDCPP=-lCrun -lCstd

LLIBTHREAD=

MOTIFLIBS= -lXm -lXt -lX11 -lgen -lm -lXext -lX11 -lm
XLIBS=
EXOSFLAGS=

EXOSFLAGS=-L$(CLUSTERDIR)/lib -R$(CLUSTERDIR)/lib \
          -L$(ORACLUSTERDIR) -R$(ORACLUSTERDIR)

OIC_LIB_ORIGIN=-R'$$ORIGIN'
OIC_EXE_ORIGIN=-R'$$ORIGIN'/../lib/64

CCVER=prod
COMPOBJ32=$(ORACLE_HOME)/$(LIBDIR)/$(CCVER)/lib
COMPOBJ64=$(ORACLE_HOME)/$(LIBDIR)/$(CCVER)/lib/amd64

COMPSOBJS32=$(COMPOBJ32)/crti.o $(COMPOBJ32)/crt1x.o
COMPEOBJS32=$(COMPOBJ32)/crtn.o

COMPSOBJS32INS=$(ORACLE_HOME)/lib32/$(CCVER)/lib/crti.o $(ORACLE_HOME)/lib32/$(CCVER)/lib/crt1x.o
COMPEOBJS32INS=$(ORACLE_HOME)/lib32/$(CCVER)/lib/crtn.o

COMPSOBJS64=$(COMPOBJ64)/crti.o $(COMPOBJ64)/crt1x.o
COMPEOBJS64=$(COMPOBJ64)/crtn.o

SHAREDLIBPATH = -R$(ORACLE_HOME)/$(LIBDIR)
EXSYSLIBS= $(THREADLIBS)

LLPPATH=$(LD_LIBRARYPATH):
LINKEXSYSLIBS32= -R $(CLUSTERDIR)/lib $(SHAREDLIBPATH) -R $(ORACLUSTERDIR) \
	$(LDPATHFLAG)$(CLUSTERDIR)/lib $(LDPATHFLAG)$(ORACLUSTERDIR) $(LDPATHFLAG)/usr/ccs/lib/ \
	$(LDPATHFLAG)/usr/lib/ \
	-Qy
LINKEXSYSLIBS64= -R $(CLUSTERDIR)/lib $(SHAREDLIBPATH) -R $(ORACLUSTERDIR) \
	$(LDPATHFLAG)$(CLUSTERDIR)/lib $(LDPATHFLAG)$(ORACLUSTERDIR) $(LDPATHFLAG)/usr/ccs/lib/amd64 \
	$(LDPATHFLAG)/usr/lib/amd64 \
	-Qy
LINKEXSYSLIBSCC= -R $(CLUSTERDIR)/lib $(SHAREDLIBPATH) -R $(ORACLUSTERDIR) \
	$(LDPATHFLAG)$(CLUSTERDIR)/lib $(LDPATHFLAG)$(ORACLUSTERDIR) $(LDPATHFLAG)/usr/ccs/lib/amd64 \
	$(LDPATHFLAG)/usr/lib/amd64

LINKLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(LINKEXSYSLIBS) $(MATHLIB) $(USRLIBS) $(COMPEOBJS)
LINKLDLIBSCC=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(LINKEXSYSLIBSCC) $(MATHLIB) $(USRLIBS)
SUIDLINKLDLIBS=$(LINKLDLIBS:$(SHAREDLIBPATH)=)
LINKEXSYSLIBS64= -R $(CLUSTERDIR)/lib $(SHAREDLIBPATH) -R $(ORACLUSTERDIR) \
	$(LDPATHFLAG)$(CLUSTERDIR)/lib $(LDPATHFLAG)$(ORACLUSTERDIR) $(LDPATHFLAG)/usr/ccs/lib/amd64 \
	$(LDPATHFLAG)/usr/lib/amd64 \
	-Qy


COBEXSYSLIBS= $(LLAIO) $(THREADLIBS) $(LLIBPOSIX4) $(LLIBKSTAT)
COBLDLIBS=$(EXPDLIBS) $(EXOSLIBS) $(SYSLIBS) $(COBEXSYSLIBS) $(MATHLIB) $(USRLIBS)


OPTIMIZEG=-g
OPTIMIZE1=-xO1
OPTIMIZE2=-xO2
OPTIMIZE3=-xO3
OPTIMIZE4=-xO4
OPTIMIZE=$(OPTIMIZE4) 

ROFLAGS=-c -xMerge
SPFLAGS= -DSVR4 -D_LARGEFILE64_SOURCE=1 -D_LARGEFILE_SOURCE=1 -DSLMXMX_ENABLE -DSLTS_ENABLE -D_REENTRANT -DSOLARISAMD64  -DSS_64BIT_SERVER  -DSOL_X86 -DSVR4 -Di386 -DSOLARISX86 -m64 -DCOMP_DIR="$(DIR)"

SPFLAGS64=-DSVR4 -DSLMXMX_ENABLE -DSLTS_ENABLE  -D_REENTRANT -DSS_64BIT_SERVER -DBIT64 -DMACHINE64 -DSOLARISAMD64   -DSOL_X86 -DSVR4 -Di386 -DSOLARISX86 -DCOMP_DIR="$(DIR)"


AR=/usr/ccs/bin/ar
AS=/usr/ccs/bin/as
LD=/usr/ccs/bin/ld 
NM=/usr/ccs/bin/nm
TR=/usr/bin/tr
CPP=$(CC) -E $(ANSI)
TOUCH=/bin/touch
CHMOD=/bin/chmod
CHGRP=/bin/chgrp
CHOWN=/bin/chown
ZIP=/usr/local/bin/zip
UNZIP_DIR_FLAG=-d

KPIC_OPTION=-Kpic
ASPFLAGS=-P $(PFLAGS)
NOKPIC_ASFLAGS=
ASFLAGS=$(NOKPIC_ASFLAGS) -Kpic
ASRO=$(AS) $(ASROFLAGS) $(MAKERO) $<
ASROFLAGS=$(ASFLAGS)

NOKPIC_ASFLAGS64= -m64
ASFLAGS64= $(NOKPIC_ASFLAGS64) -Kpic
ASPFLAGS64=-P $(PFLAGS) $(ASFLAGS64)

CXC=-Xc
CXA=-Xa
ANSI=$(CXC)



SHARED_LDFLAG=-G -L$(ORACLE_HOME)/$(LIBDIR) -R$(ORACLE_HOME)/$(LIBDIR) -o
SHARED_CFLAG=

SHARED_LDFLAG64=-G -z text -L$(ORACLE_HOME)/$(LIBDIR) -R$(ORACLE_HOME)/$(LIBDIR) -o

NOKPIC_CCFLAGS= -m64   -Xa $(PROFILE) -xstrconst -xF $(XS) $(MR) \
        -W2,-AKNR_S -W2,-Rglobal_hoist \
        -W2,-Rloop -errtags=yes $(CC_SUPPRESS) $(CFLAG_INLINE) -v -W2,-xsafe=unboundsym \
        -xbuiltin=%none

NOKPIC_CCFLAGS64= -m64   -Xa $(PROFILE) -xstrconst -dalign -xF $(XS) $(MR) \
        -xildoff -errtags=yes -v $(ILPATH) $(ONLINE_PATCHING_CCFLAGS) \
        -W2,-AKNR_S $(CFLAG_INLINE) -W2,-xsafe=unboundsym -xbuiltin=%none


NOKPIC_CCFLAGS=$(NOKPIC_CCFLAGS64)

SHLIBCCFLAGS=$(NOKPIC_CCFLAGS) $(KPIC_OPTION)

CCFLAGS= $(SHLIBCCFLAGS)   

FASTCCFLAGS= $(NOKPIC_CCFLAGS)
PCHCCFLAGS = $(SHLIBCCFLAGS) $(CFLAG_INLINE_OFF)

SHARED_LDFLAG=$(SHARED_LDFLAG64)
COMPOBJ=$(COMPOBJ64)
COMPSOBJS=$(COMPSOBJS64)
COMPEOBJS=$(COMPEOBJS64)
LINKEXSYSLIBS=$(LINKEXSYSLIBS64)
NOKPIC_ASFLAGS=$(NOKPIC_ASFLAGS64)

NOKPIC_CCFLAGSCC=$(PROFILE) $(XS)  -m64  $(LOCAL_CCFLAGSCC) $(ILPATH)

BASECCFLAGSCC= $(NOKPIC_CCFLAGSCC) $(KPIC_OPTION)
 
SHLIBCCFLAGSCC=$(BASECCFLAGSCC) 
FASTCCFLAGSCC=$(BASECCFLAGSCC)

CCFLAGSCC = $(SHLIBCCFLAGSCC)

SHLIB_LD=$(LD) -o $(_FULL_LIBNAME) -G -z text -i -L$(BOOTSTRAPLIB) -L$(LIBHOME) -L$(PRODLIBHOME) 
BOOTSTRAPLIB=/tmp/bootstraplib/
SHLIB_MAP=-M $(PRODDEFHOME)$(_LIBNAME).$(DEF_EXT)
SHLIB_NAME=-h $(_LIBNAME).$(SO_EXT)
SHLIB_OBJS=-z allextract $(_LIBDIR)$(_LIBNAME).$(LIB_EXT) -z defaultextract
SHLIB_OBJS_OLD=-z allextract $(_LIBDIR)$(_LIBNAME).$(LIB_EXT)
SHLIB_OTHER=$(_LIBNAME_LIBS) $(_VAR_LIBS)
SHLIB_BOOTSTRAP_OTHER=$(_LIBNAME_EXTRALIBS) $(_VAR_EXTRALIBS)
SHLIB_CLOSED=-z defs
SHLIB_RP=-R$(LIBHOME) -R$(PRODLIBHOME)

LD_SHLIB_COMMAND=$(LD) -o $(_FULL_LIBNAME) $(SHLIB_MAP) -G -ztext $(SHLIB_OBJS_OLD) $(SHLIB_OTHER_DEP)

DLOPENLIB_COMMAND=$(LD_SHLIB_COMMAND) -z defaultextract $(PROD_DLLIBS) $(_LIBNAME_LIBS)

NEW_LD_SHLIB_COMMAND=$(SHLIB_LD) $(SHLIB_MAP) $(SHLIB_NAME) $(SHLIB_OBJS) \
$(SHLIB_RP) $(SHLIB_OTHER) $(SHLIB_CLOSED)
NEW_DLOPENLIB_COMMAND=$(NEW_LD_SHLIB_COMMAND)
BOOTSTRAPLIB_COMMAND=$(NEW_LD_SHLIB_COMMAND) $(SHLIB_BOOTSTRAP_OTHER)
NEW_LD_SHLIB_DEP=$(PRODDEFHOME)%.$(DEF_EXT) $(PRODLIBHOME)%.$(LIB_EXT) 
NEW_DLOPENLIB_DEP=$(NEW_LD_SHLIB_DEP)
BOOTSTRAPLIB_DEP=$(NEW_LD_SHLIB_DEP)

IEEE_FLAGS=-DORA_IEEE_FLAG_DEFINED


# Exiting SRCHOME/buildtools/mkfile/platform.mk
# Entering SRCHOME/buildtools/mkfile/rules.mk
 
# Exiting SRCHOME/buildtools/mkfile/rules.mk
# Exiting SRCHOME/buildtools/mkfile/prefix.mk
# Entering SRCHOME/rdbms/exports.mk


RDBMS_VERSION=12
RDBMS_MINOR_VERSION=1

RDBMSLIB_VERSION=-DRDBMS_LIBRARY_VERSION=$(RDBMS_VERSION)

LIBCLNTSTNAME=clntst$(RDBMS_VERSION)
LIBCLNTST=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSTNAME).$(LIB_EXT)
LLIBCLNTST=$(LDLIBFLAG)$(LIBCLNTSTNAME) $(S_STATIC_IPPLIBS)

LIBSERVERNAME=server$(RDBMS_VERSION)
LIBSERVER=$(LIBHOME)$(LIB_PREFIX)$(LIBSERVERNAME).$(LIB_EXT)
LLIBSERVER=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSERVERNAME)$(LIB_SUFFIX)

LIBCLIENTNAME=client$(RDBMS_VERSION)
LIBCLIENT=$(LIBHOME)$(LIB_PREFIX)$(LIBCLIENTNAME).$(DEPLIB_EXT)
LLIBCLIENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLIENTNAME)$(ILIB_SUFFIX)

LIBGENERICNAME=generic$(RDBMS_VERSION)
LIBGENERIC=$(LIBHOME)$(LIB_PREFIX)$(LIBGENERICNAME).$(DEPLIB_EXT)
LLIBGENERIC=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGENERICNAME)$(ILIB_SUFFIX)

LIBSKGXPNAME=skgxp$(RDBMS_VERSION)
LIBSKGXP=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXPNAME).$(SKGXP_EXT)
LLIBSKGXP=$(LDLIBFLAG)$(LIBSKGXPNAME)

LIBSKJCXNAME=skjcx$(RDBMS_VERSION)
LIBSKJCX=$(LIBHOME)$(LIB_PREFIX)$(LIBSKJCXNAME).$(SKJCX_EXT)
LLIBSKJCX=$(LDLIBFLAG)$(LIBSKJCXNAME)

LIBSKGTRNAME=skgtr$(RDBMS_VERSION)
LIBSKGTR_MPMT=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGTRNAME).$(SKGTR_EXT)
LIBSKGTR_=
LIBSKGTR=$(LIBSKGTR_$(MPMT_SERVER))
LLIBSKGTR_MPMT=$(LDLIBFLAG)$(LIBSKGTRNAME)
LLIBSKGTR_=
LLIBSKGTR=$(LLIBSKGTR_$(MPMT_SERVER))

LIBDBMIGNAME=dbmig$(RDBMS_VERSION)
LIBDBMIG_DEPS=$(LLIBCLNTSH)

LIBORAMYSQLNAME=oramysql$(RDBMS_VERSION)
LIBORAMYSQL_DEPS=$(LLIBCLNTSH)

LIBASMCLNTNAME=asmclnt$(RDBMS_VERSION)
LIBASMCLNT=$(LIBHOME)$(LIB_PREFIX)$(LIBASMCLNTNAME).$(DEPLIB_EXT)
LLIBASMCLNT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBASMCLNTNAME)$(ILIB_SUFFIX)
LIBASMCLNT_DEPS=$(LLIBCLNTSH) $(LLIBHASGEN) $(LLIBSKGXN) $(LLIBCOMMON) $(LLIBOCR) $(LLIBGENERIC) $(LLIBSAGE) $(LLIBSKGXP) $(LLIBXML)

LIBASMCLNTSHNAME=asmclntsh$(RDBMS_VERSION)
LIBASMCLNTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBASMCLNTSHNAME).$(DEPSO_EXT)
LLIBASMCLNTSH=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBASMCLNTSHNAME)$(ILIB_SUFFIX)
LIBASMCLNTSH_DEPS=$(LLIBCLNTSH) $(LLIBHASGEN) $(LLIBSKGXN) $(LLIBCOMMON) $(LLIBOCR) $(LLIBGENERIC) $(LLIBSAGE) $(LLIBSKGXP) $(LLIBXML)

LIBPATCHGENSHNAME=patchgensh$(RDBMS_VERSION)
LIBPATCHGENSH=$(LIBHOME)$(LIB_PREFIX)$(LIBPATCHGENSHNAME).$(DEPSO_EXT)
LLIBPATCHGENSH=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPATCHGENSHNAME)$(ILIB_SUFFIX)
LIBPATCHGENSH_DEPS=$(LLIBCLNTSH) $(LLIBASMCLNTSH)

ENCRYPTLIBS = $(PL_ENCRYPTLIBS)

LIBSKGXNNAME=skgxn$(RDBMS_VERSION)
LIBSKGXN=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)
LLIBSKGXN=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSKGXNNAME)$(LIB_SUFFIX)
LIBSKGXNI=$(LIBHOME)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)

LIBOCCINAME=occi
LIBOCCI=$(LIBHOME)$(LIB_PREFIX)$(LIBOCCINAME)$(RDBMS_VERSION).$(LIB_EXT)
LLIBOCCI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCCINAME)$(RDBMS_VERSION)$(ILIB_SUFFIX)
LLIBOCCISTATIC=$(LDLIBFLAG)$(LIBOCCINAME)$(RDBMS_VERSION)

LIBCDFNAME=cdf
LIBCDF=$(LIBHOME)$(LIB_PREFIX)$(LIBCDFNAME)$(RDBMS_VERSION).$(LIB_EXT)
LLIBCDF=$(LDLIBFLAG)$(LIBCDFNAME)$(RDBMS_VERSION)

LIBWSECNAME=wsec
LIBWSEC=$(LIBHOME)$(LIB_PREFIX)wsec$(RDBMS_VERSION).$(LIB_EXT)
LLIBWSEC=$(LDLIBFLAG)$(LIB_PREFIX)$(LIBWSECNAME)$(RDBMS_VERSION)$(ILIB_SUFFIX)

LIBSKGXP_CLT=
LLIBSKGXP_CLT=

LIBCOMMONNAME=common$(RDBMS_VERSION)
LIBCOMMON=$(LIBHOME)$(LIB_PREFIX)$(LIBCOMMONNAME).$(DEPLIB_EXT)
LLIBCOMMON=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCOMMONNAME)$(ILIB_SUFFIX)

LIBEVANAME=eva$(RDBMS_VERSION)
LIBEVA=$(LIBHOME)$(LIB_PREFIX)$(LIBEVANAME).$(LIB_EXT)
LLIBEVA=$(LDLIBFLAG)$(LIBEVANAME)

LIBEVADMSCONAME=evadmsco$(RDBMS_VERSION)
LIBEVADMSCO=$(LIBHOME)$(LIB_PREFIX)$(LIBEVADMSCONAME).$(LIB_EXT)
LLIBEVADMSCO=$(LDLIBFLAG)$(LIBEVADMSCONAME)

LIBVSNNAME=vsn$(RDBMS_VERSION)
LIBVSN=$(LIBHOME)$(LIB_PREFIX)$(LIBVSNNAME).$(DEPLIB_EXT)
LLIBVSN=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBVSNNAME)$(ILIB_SUFFIX)

LIBAGENTNAME=agent$(RDBMS_VERSION)
LIBAGENT=$(LIBHOME)$(LIB_PREFIX)$(LIBAGENTNAME).$(LIB_EXT)
LLIBAGENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAGENTNAME)$(LIB_SUFFIX)

LIBHGOSHNAME=hgosh$(RDBMS_VERSION)
LIBHGOSH=$(LIBHOME)$(LIB_PREFIX)$(LIBHGOSHNAME).$(LIB_EXT)
LLIBHGOSH=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGOSHNAME)$(LIB_SUFFIX)

LIBHGMSQLNAME=hgmsql$(RDBMS_VERSION)
LIBHGMSQL=$(LIBHOME)$(LIB_PREFIX)$(LIBHGMSQLNAME).$(LIB_EXT)
LLIBHGMSQL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGMSQLNAME)$(LIB_SUFFIX)

LIBHGSYBSNAME=hgsybs$(RDBMS_VERSION)
LIBHGSYBS=$(LIBHOME)$(LIB_PREFIX)$(LIBHGSYBSNAME).$(LIB_EXT)
LLIBHGSYBS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGSYBSNAME)$(LIB_SUFFIX)

LIBHGIFMXNAME=hgifmx$(RDBMS_VERSION)
LIBHGIFMX=$(LIBHOME)$(LIB_PREFIX)$(LIBHGIFMXNAME).$(LIB_EXT)
LLIBHGIFMX=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGIFMXNAME)$(LIB_SUFFIX)

LIBHGTERANAME=hgtera$(RDBMS_VERSION)
LIBHGTERA=$(LIBHOME)$(LIB_PREFIX)$(LIBHGTERANAME).$(LIB_EXT)
LLIBHGTERA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGTERANAME)$(LIB_SUFFIX)

LIBHGDB2NAME=hgdb2$(RDBMS_VERSION)
LIBHGDB2=$(LIBHOME)$(LIB_PREFIX)$(LIBHGDB2NAME).$(LIB_EXT)
LLIBHGDB2=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGDB2NAME)$(LIB_SUFFIX)

LIBHGGCONNAME=hggcon$(RDBMS_VERSION)
LIBHGGCON=$(LIBHOME)$(LIB_PREFIX)$(LIBHGGCONNAME).$(LIB_EXT)
LLIBHGGCON=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGGCONNAME)$(LIB_SUFFIX)

LIBHGOTRACENAME=hgotrace$(RDBMS_VERSION)
LIBHGOTRACE=$(LIBHOME)$(LIB_PREFIX)$(LIBHGOTRACENAME).$(SO_EXT)
LLIBHGOTRACE=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHGOTRACENAME)$(LIB_SUFFIX)

LIBDBTOOLSNAME=dbtools$(RDBMS_VERSION)
LIBDBTOOLS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBTOOLSNAME).$(LIB_EXT)
LLIBDBTOOLS=$(LDLIBFLAG)$(LIBDBTOOLSNAME)

LIBNNETNAME=nnet$(RDBMS_VERSION)
LIBNNET=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNNETNAME).$(LIB_EXT)
LLIBNNET=$(LDLIBFLAG)$(LIBNNETNAME)

LIBNNETDNAME=nnetd$(RDBMS_VERSION)
LIBNNETD=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNNETDNAME).$(LIB_EXT)
LLIBNNETD=$(LDLIBFLAG)$(LIBNNETDNAME)

LIBNNET_CLT=$(LIBNNETD)
LLIBNNET_CLT=$(LLIBNNETD)

DLMHOME=$(ORACLE_HOME)/odlm/

LIBMMNAME=mm
LIBMM=$(LIBHOME)$(LIB_PREFIX)$(LIBMMNAME).$(LIB_EXT)
LLIBMM=$(LDLIBFLAG)$(LIBMMNAME)


LIBRDBMS_CLT=$(LIBCLIENT) $(LIBNNET_CLT) $(LIBSKGXP_CLT) $(LIBVSN) \
	$(LIBCOMMON) $(LIBGENERIC)
LLIBRDBMS_CLT=$(LLIBCLIENT) $(LLIBNNET_CLT) $(LLIBSKGXP_CLT) $(LLIBVSN) \
	$(LLIBCOMMON) $(LLIBGENERIC)

LIBRDBMS_SERVER=$(LIBCLIENT) $(LIBSKGXP_CLT) $(LIBVSN) \
	$(LIBCOMMON) $(LIBGENERIC)
LLIBRDBMS_SERVER=$(LLIBCLIENT) $(LLIBSKGXP_CLT) $(LLIBVSN) \
	$(LLIBCOMMON) $(LLIBGENERIC)

LIBCLNTSHNAME=clntsh
LIBCLNTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSHNAME).$(SO_EXT)
LIBCLNTSHCORENAME=clntshcore
LIBCLNTSHCORE=$(LIBHOME)$(LIB_PREFIX)$(LIBCLNTSHCORENAME).$(SO_EXT)
LLIBCLNTSHCORE=$(LDLIBFLAG)$(LIBCLNTSHCORENAME)
LLIBCLNTSH=$(LDLIBFLAG)$(LIBCLNTSHNAME) $(LLIBCLNTSHCORE)
LIBCLNTSH_NPT=
LLIBCLNTSH_NPT=

LIBAGTSHNAME=agtsh
LIBAGTSH=$(LIBHOME)$(LIB_PREFIX)$(LIBAGTSHNAME).$(SO_EXT)
LLIBAGTSH=$(LDLIBFLAG)$(LIBAGTSHNAME)

LIBKNLOPTNAME=knlopt
LIBKNLOPT=$(RDBMSLIB)$(LIB_PREFIX)$(LIBKNLOPTNAME).$(LIB_EXT)
LLIBKNLOPT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBKNLOPTNAME)$(LIB_SUFFIX)

LIBAVSTUBNAME=avstub$(RDBMS_VERSION)
LIBAVSTUB=$(LIBHOME)$(LIB_PREFIX)$(LIBAVSTUBNAME).$(LIB_EXT)
LLIBAVSTUB=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAVSTUBNAME)$(LIB_SUFFIX)

LIBAVSERVERNAME=avserver$(RDBMS_VERSION)
LIBAVSERVER=$(LIBHOME)$(LIB_PREFIX)$(LIBAVSERVERNAME).$(LIB_EXT)
LLIBAVSERVER=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAVSERVERNAME)$(LIB_SUFFIX)

LIBAVCLIENTNAME=avclient$(RDBMS_VERSION)
LIBAVCLIENT=$(LIBHOME)$(LIB_PREFIX)$(LIBAVCLIENTNAME).$(LIB_EXT)
LLIBAVCLIENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAVCLIENTNAME)$(LIB_SUFFIX)

AVLIBS = `if [ -f $(LIBAVSERVER) ] ; then echo "$(LLIBAVSERVER)" ; else echo "$(LLIBAVSTUB)"; fi` `if [ -f $(LIBAVCLIENT) ] ; then echo "$(LLIBAVCLIENT)" ; fi`

CONFIG = $(RDBMSLIB)config.$(OBJ_EXT)


LLIBORDSDO=$(LDLIBFLAG)$(LIBORDSDONAME)$(LIB_SUFFIX)
SDOLIBS = `if ${AR} tv $(LIBKNLOPT) | $(GREP) "kxmnsd.$(OBJ_EXT)" > /dev/null 2>&1 ; then echo " " ; else echo "${LLIBORDSDO} ${LLIBSERVER}"; fi`

RDBMSHOME=$(ORACLE_HOME)/rdbms/
RDBMSLIB=$(RDBMSHOME)$(LIBDIR)/
RDBMSADMIN=$(RDBMSHOME)admin/

ORAMAPLIB=$(RDBMSLIB)

LIBNIDNAME=nid
LIBNID=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNIDNAME).$(LIB_EXT)
LLIBNID=$(LDLIBFLAG)$(LIBNIDNAME)

THREAD_ORALIBS_MPMT=-lpthread
THREAD_ORALIBS_=
THREAD_ORALIBS=$(THREAD_ORALIBS_$(MPMT_SERVER))


ORACLE_KERNEL_LIBS=$(LLIBPERFSRV) $(NAETTOBJS) $(CONFIG)\
	$(SPOBJS) $(LLIBDMEXT) $(LLIBSERVER) $(LLIBODM) $(LLIBOFS) $(LLIBSAGE) \
	$(LLIBNNET) $(LLIBSKGXP) $(CORELIBS) $(LLIBRDBMS_SERVER) \
	$(LLIBKNLOPT) $(OLAPLINKOPTS) $(LLIBSKJCX) \
	$(LLIBSLAX) $(LLIBPLSQL) $(LLIBDMEXT) $(LLIBSERVER) $(LLIBRDBMS_SERVER) $(AVLIBS) \
	$(LLIBKNLOPT) $(LLIBSLAX) $(LLIBPLSQL) $(LLIBJAVAVMORJOX) \
	$(LLIBOCIJDBCST) $(LLIBWWG) $(NTZEOBJ) $(NETLIBS) $(NZLIBS_SERVER) \
	$(LLIBMM) $(CORELIBS) $(LLIBZTKG) \
	$(NETLIBS) $(NZLIBS_SERVER) $(LIBPLS_CLT) $(LLIBEPC) $(CORELIBS) \
	$(SDOLIBS) $(CARTLIBS) \
	$(CLSRLIBS_SERVER) $(CSSCLNTLIBS_SERVER) \
	$(LLIBGENERIC) \
	$(CORECOMPRESSLIBS) $(ENCRYPTLIBS)  \
	$(CORELIBS) $(LLIBSNLSRTL) $(LLIBUNLSRTL) $(LLIBXSD) $(CORELIBS) \
	$(LLIBASMCLNT) $(LLIBCOMMON) $(LLIBCORE) $(LLIBSKGTR) \
	$(PL_ORALIBS) $(LLIBONS) $(THREAD_ORALIBS)
LIBCLIENTSHNAME=clientsh$(RDBMS_VERSION)
LLIBCLIENTSH=$(LDLIBFLAG)$(LIBCLIENTSHNAME)$(LIB_SUFFIX)
LIBGENERICSHNAME=genericsh$(RDBMS_VERSION)
LLIBGENERICSH=$(LDLIBFLAG)$(LIBGENERICSHNAME)$(LIB_SUFFIX)
LIBCOMMONSHNAME=commonsh$(RDBMS_VERSION)
LLIBCOMMONSH=$(LDLIBFLAG)$(LIBCOMMONSHNAME)$(LIB_SUFFIX)
LIBMMSHNAME=mmsh
LLIBMMSH=$(LDLIBFLAG)$(LIBMMSHNAME)$(LIB_SUFFIX)
LIBVSNSHNAME=vsnsh$(RDBMS_VERSION)
LLIBVSNSH=$(LDLIBFLAG)$(LIBVSNSHNAME)$(LIB_SUFFIX)
LIBNNETSHNAME=nnetsh$(RDBMS_VERSION)
LLIBNNETSH=$(LDLIBFLAG)$(LIBNNETSHNAME)$(LIB_SUFFIX)

LIBORIONNAME=orion$(RDBMS_VERSION)
LIBORION=$(LIBHOME)$(LIB_PREFIX)$(LIBORIONNAME).$(LIB_EXT)
LLIBORION=$(LDLIBFLAG)$(LIBORIONNAME)

LIBASMLGNAME=asmlg$(RDBMS_VERSION)
LIBASMLG=$(RDBMSLIB)$(LIB_PREFIX)$(LIBASMLGNAME).$(SO_EXT)
LLIBASMLG=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBASMLGNAME)$(ILIB_SUFFIX)

LIBDSGANAME=dsga$(RDBMS_VERSION)
LIBDSGA=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDSGANAME).$(LIB_EXT)
LLIBDSGA=$(LDLIBFLAG)$(LIBDSGANAME)
LOC_LIBDSGA=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDSGANAME).$(LIB_EXT)

LIBDBGUISSNAME=dbguiss
LOC_LIBDBGUISS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBGUISSNAME).$(LIB_EXT)
LIBDBGUISS=$(RDBMSLIB)$(LIB_PREFIX)$(LIBDBGUISSNAME).$(SO_EXT)
LLIBDBGUISS=$(LDLIBFLAG)$(LIBDBGUISSNAME)

LIBNHPNAME=nhp$(RDBMS_VERSION)
LLIBNHP=$(LDLIBFLAG)$(LIBNHPNAME)
LOC_LIBNHP=$(RDBMSLIB)$(LIB_PREFIX)$(LIBNHPNAME).$(LIB_EXT)

ASMCLNT_LIBS=$(LLIBASMCLNT) $(LLIBCOMMON) $(LLIBSAGE) $(LLIBSKGXP) \
             $(LLIBGENERIC)
ASMCLNTSH_LIBS=$(LLIBASMCLNTSH) $(LLIBSAGE) $(LLIBSKGXP)
ASMCLNT_OCR_LIBS=$(ASMCLNT_LIBS)
ASMCLNT_CSS_LIBS=$(ASMCLNT_LIBS)


LINK_JOX_STATICALLY=yes

LIBDPSCNAME=dpsc$(RDBMS_VERSION)
LIBDPSC=$(LIBHOME)$(LIB_PREFIX)$(LIBDPSCNAME).$(LIB_EXT)
LLIBDPSC=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDPSCNAME)$(LIB_SUFFIX)

LIBDPSSNAME=dpss$(RDBMS_VERSION)
LIBDPSS=$(LIBHOME)$(LIB_PREFIX)$(LIBDPSSNAME).$(LIB_EXT)
LLIBDPSS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDPSSNAME)$(LIB_SUFFIX)

LIBDPSPNAME=dpsp$(RDBMS_VERSION)
LIBDPSP=$(LIBHOME)$(LIB_PREFIX)$(LIBDPSPNAME).$(LIB_EXT)
LLIBDPSP=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDPSPNAME)$(LIB_SUFFIX)

LIBDPSFNAME=dpsf$(RDBMS_VERSION)
LIBDPSF=$(LIBHOME)$(LIB_PREFIX)$(LIBDPSFNAME).$(LIB_EXT)
LLIBDPSF=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDPSFNAME)$(LIB_SUFFIX)
LIBDPSADAPINAME=dpsadapi$(RDBMS_VERSION)
LIBDPSADAPI=$(LIBHOME)$(LIB_PREFIX)$(LIBDPSADAPINAME).$(LIB_EXT)
LLIBDPSADAPI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDPSADAPINAME)$(LIB_SUFFIX)

LIBDPSADRDANAME=dpsadrda$(RDBMS_VERSION)
LIBDPSADRDA=$(LIBHOME)$(LIB_PREFIX)$(LIBDPSADRDANAME).$(LIB_EXT)
LLIBDPSADRDA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDPSADRDANAME)$(LIB_SUFFIX)
LIBDPSADDFDNAME=dpsaddfd$(RDBMS_VERSION)
LIBDPSADDFD=$(LIBHOME)$(LIB_PREFIX)$(LIBDPSADDFDNAME).$(LIB_EXT)
LLIBDPSADDFD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDPSADDFDNAME)$(LIB_SUFFIX)

LIBFTHREADNAME=fthread$(RDBMS_VERSION)
LIBFTHREAD=$(RDBMSLIB)$(LIB_PREFIX)$(LIBFTHREADNAME).$(LIB_EXT)
LLIBFTHREAD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBFTHREADNAME)$(LIB_SUFFIX)

# Entering SRCHOME/rdbms/export_banner.mk

# Exiting SRCHOME/rdbms/export_banner.mk
# Entering SRCHOME/rdbms/s_exports.mk


LIBPERFSRVNAME=perfsrv$(RDBMS_VERSION)
LIBPERFSRV=$(LIBHOME)$(LIB_PREFIX)$(LIBPERFSRVNAME).$(LIB_EXT)
LLIBPERFSRV=-z allextract $(LDLIBFLAG)$(LIBPERFSRVNAME)$(LIB_SUFFIX) -z defaultextract

SKGXP_EXT=$(SO_EXT)




SKGXN_EXT=$(SO_EXT)


SKGTR_EXT=$(SO_EXT)

SKGXN_VERSION=2
LIBSKGXNNAME=skgxn$(SKGXN_VERSION)
LIBSKGXN=$(ORACLUSTERDIR)$(LIB_PREFIX)$(LIBSKGXNNAME).$(SKGXN_EXT)


SKJCX_EXT=$(SO_EXT)



LLIBOCCI=$(LDLIBFLAG)$(LIBOCCINAME)
LIBOCCI=$(LIBHOME)$(LIB_PREFIX)$(LIBOCCINAME).$(SO_EXT).$(RDBMS_VERSION).$(RDBMS_MINOR_VERSION)


DSGALIBLIST=$(RDBMSLIB)dsgaliblist

# Exiting SRCHOME/rdbms/s_exports.mk
# Exiting SRCHOME/rdbms/exports.mk
# Entering SRCHOME/oracore/exports.mk

COREHOME    = $(ORACLE_HOME)/oracore/
ORACOREHOME = $(COREHOME)



CORE_LIB_NAME     = core
CORE_LIB_VER      = $(LIBMAJORVSN)
CORE_LIB          = $(CORE_LIB_NAME)$(CORE_LIB_VER)

LIBCORE_STATIC    = $(LIB_PREFIX)$(CORE_LIB).$(LIB_EXT)
LIBCORE_SHARED    = $(LIB_PREFIX)$(CORE_LIB).$(SO_EXT)
LIBCORE_SH        = $(LIB_PREFIX)$(CORE_LIB_NAME)sh$(CORE_LIB_VER).$(SO_EXT)
LIBCORE_SLH       = $(LIB_PREFIX)$(CORE_LIB).$(ILIB_EXT)

LIBCORE           = $(LIBHOME)$(LIBCORE_STATIC)
LLIBCORE          = $(LDLIBFLAG)$(CORE_LIB)
LLIBCORE_SH       = $(LDLIBFLAG)$(CORE_LIB_NAME)sh$(CORE_LIB_VER)

LIBCORE_ARC_LIB   = $(LIBCORE)
LIBCORE_SHARE_LIB = $(LIBHOME)$(LIBCORE_SHARED)

ORAZLIB              = oraz

LIBORAZLIB_STATIC    = $(LIB_PREFIX)$(ORAZLIB).$(LIB_EXT)
LIBORAZLIB_SHARED    = $(LIB_PREFIX)$(ORAZLIB).$(SO_EXT)

LIBORAZLIB           = $(LIBHOME)$(LIBORAZLIB_STATIC)
LLIBORAZLIB          = $(LDLIBFLAG)$(ORAZLIB)

LIBORAZLIB_ARC_LIB   = $(LIBORAZLIB)
LIBORAZLIB_SHARE_LIB = $(LIBHOME)$(LIBORAZLIB_SHARED)

LZOPROLIB           = lzopro

LIBLZOPRO_STATIC    = $(LIB_PREFIX)$(LZOPROLIB).$(LIB_EXT)
LIBLZOPRO_SHARED    = $(LIB_PREFIX)$(LZOPROLIB).$(SO_EXT)

LIBLZOPRO           = $(LIBHOME)$(LIBLZOPRO_STATIC)
LLIBLZOPRO          = $(LDLIBFLAG)$(LZOPROLIB)

LIBLZOPRO_ARC_LIB   = $(LIBLZOPRO)
LIBLZOPRO_SHARE_LIB = $(LIBHOME)$(LIBLZOPRO_SHARED)

ORABZ2LIB              = bz2

LIBORABZ2LIB_STATIC    = $(LIB_PREFIX)$(ORABZ2LIB).$(LIB_EXT)
LIBORABZ2LIB_SHARED    = $(LIB_PREFIX)$(ORABZ2LIB).$(SO_EXT)

LIBORABZ2LIB           = $(LIBHOME)$(LIBORABZ2LIB_STATIC)
LLIBORABZ2LIB          = $(LDLIBFLAG)$(ORABZ2LIB)

LIBORABZ2LIB_ARC_LIB   = $(LIBORABZ2LIB)
LIBORABZ2LIB_SHARE_LIB = $(LIBHOME)$(LIBORABZ2LIB_SHARED)

ORAZIPLIB              = zip

LIBORAZIPLIB_STATIC    = $(LIB_PREFIX)$(ORAZIPLIB).$(LIB_EXT)
LIBORAZIPLIB_SHARED    = $(LIB_PREFIX)$(ORAZIPLIB).$(SO_EXT)

LIBORAZIPLIB           = $(LIBHOME)$(LIBORAZIPLIB_STATIC)
LLIBORAZIPLIB          = $(LDLIBFLAG)$(ORAZIPLIB)

LIBORAZIPLIB_ARC_LIB   = $(LIBORAZIPLIB)
LIBORAZIPLIB_SHARE_LIB = $(LIBHOME)$(LIBORAZIPLIB_SHARED)

CORECOMPRESSLIBS = $(LLIBORAZIPLIB) $(LLIBORAZLIB) $(LLIBLZOPRO) \
$(LLIBORABZ2LIB) $(PL_CORECOMPRESSLIBS)


















LIB816  = /oracore/sun5/8.1.6.0.0/lib
CORE816 = $(LIB816)/$(LIBCORE_STATIC)
NLS816  = $(LIB816)/$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)


LIB817  = /oracore/sun5/8.1.7.0.0/lib
CORE817 = $(LIB817)/$(LIBCORE_STATIC)
NLS817  = $(LIB817)/$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)


S0MAIN   = $(LIBHOME)s0main.$(OBJ_EXT)
S1MAIN_C = $(COREHOME)src/corehl/lpm/sosd/main/s1main.c
SCOREPT  = $(LIBHOME)scorept.$(OBJ_EXT)
SSCOREED = $(LIBHOME)sscoreed.$(OBJ_EXT)

COREPUBLIC=$(COREHOME)include $(COREHOME)public/ $(XDKPUBLIC)

ORACOREPUBH=$(I_SYM)$(COREHOME)include $(I_SYM)$(COREHOME)public $(I_SYM)$(COREHOME)port/include $(XDKPUBH)


CORELIBD = $(LIBSNLSRTL) $(LIBNLSRTL) $(LIBCV6) $(LIBCORE) $(LIBSNLSRTL) \
           $(LIBNLSRTL) $(LIBCORE) $(LIBSNLSRTL) $(LIBNLSRTL)  $(LIBUNLSRTL) \
           $(LIBSNLSRTL) $(LIBNLSRTL)
CORELIBS = $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBCV6) $(LLIBCORE) $(LLIBSNLSRTL) \
           $(LLIBNLSRTL) $(LLIBCORE) $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBXML) \
           $(LLIBCORE) $(LLIBUNLSRTL) $(LLIBSNLSRTL) $(LLIBNLSRTL) $(LLIBCORE)\
	   $(LLIBNLSRTL)

CORENATLIB= $(ORACLE_HOME)/oracore/$(LIBDIR)/libcorejava.$(SO_EXT)

ONVM_LIB_NAME     = onvm
ONVM_LIB_VER      = $(LIBMAJORVSN)
ONVM_LIB          = $(ONVM_LIB_NAME)$(ONVM_LIB_VER)
LIBONVM           = $(LIBHOME)$(LIB_PREFIX)$(ONVM_LIB).$(LIB_EXT)
LLIBONVM          = $(LDLIBFLAG)$(ONVM_LIB)
LIBONVM_STATIC    = $(LIB_PREFIX)$(ONVM_LIB).$(LIB_EXT)

ONVMS_LIB_NAME    = onvms
ONVMS_LIB_VER     = $(LIBMAJORVSN)
ONVMS_LIB         = $(ONVMS_LIB_NAME)$(ONVMS_LIB_VER)
LIBONVMS          = $(LIBHOME)$(LIB_PREFIX)$(ONVMS_LIB).$(LIB_EXT)
LLIBONVMS         = $(LDLIBFLAG)$(ONVMS_LIB)
LIBONVMS_STATIC   = $(LIB_PREFIX)$(ONVMS_LIB).$(LIB_EXT)


# Entering SRCHOME/oracore/s_exports.mk
CORELIBS += $(SYSLIBS)


IPP_DIR=/usr/local/packages/ipp_remote/6.1.5.patched/

IPPCORE=ippcore
LIBIPPCORE=$(LIB_PREFIX)$(IPPCORE).$(LIB_EXT)
LLIBIPPCORE=$(LDLIBFLAG)$(IPPCORE)

IPPDCEMERGED=ippdcemerged
LIBIPPDCEMERGED=$(LIB_PREFIX)$(IPPDCEMERGED).$(LIB_EXT)
LLIBIPPDCEMERGED=$(LDLIBFLAG)$(IPPDCEMERGED)

IPPDCMERGED =ippdcmerged
LIBIPPDCMERGED=$(LIB_PREFIX)$(IPPDCMERGED).$(LIB_EXT)
LLIBIPPDCMERGED=$(LDLIBFLAG)$(IPPDCMERGED)


IPPSEMERGED=ippsemerged
LIBIPPSEMERGED=$(LIB_PREFIX)$(IPPSEMERGED).$(LIB_EXT)
LLIBIPPSEMERGED=$(LDLIBFLAG)$(IPPSEMERGED)

IPPSMERGED=ippsmerged
LIBIPPSMERGED=$(LIB_PREFIX)$(IPPSMERGED).$(LIB_EXT)
LLIBIPPSMERGED=$(LDLIBFLAG)$(IPPSMERGED)

IPPSAMPLEZLIB=ipp_z
LIBIPPSAMPLEZLIB=$(LIB_PREFIX)$(IPPSAMPLEZLIB).$(LIB_EXT)
LLIBIPPSAMPLEZLIB=$(LDLIBFLAG)$(IPPSAMPLEZLIB)

IPPSAMPLEBZ2 =ipp_bz2
LIBIPPSAMPLEBZ2=$(LIB_PREFIX)$(IPPSAMPLEBZ2).$(LIB_EXT)
LLIBIPPSAMPLEBZ2=$(LDLIBFLAG)$(IPPSAMPLEBZ2)

IPPCOMPLIBS  = $(LLIBIPPDCEMERGED) $(LLIBIPPSEMERGED) \
               $(LLIBIPPDCMERGED)  $(LLIBIPPSMERGED)
IPPCORELIBS  = $(LLIBIPPCORE)
IPPSAMPLELIBS= $(LLIBIPPSAMPLEZLIB) $(LLIBIPPSAMPLEBZ2)
IPPCOMPRESSLIBS = $(IPPSAMPLELIBS) $(IPPCOMPLIBS) $(IPPCORELIBS) 


ORABZ2LIB = orabz2

ORAZIPLIB = orazip
 
S_BUILD_LIBCOREJAVA=\
  $(SHLIB_LD) -Wl,--whole-archive $(COREJAVALIB) -Wl,--no-whole-archive \
  $(RTLIBS) -o $@

$(CORENATLIB) $(LIBHOME)libcorejava.$(SO_EXT) :
	$(S_BUILD_LIBCOREJAVA)

# Exiting SRCHOME/oracore/s_exports.mk
# Exiting SRCHOME/oracore/exports.mk
# Entering SRCHOME/nlsrtl/exports.mk

NLSRTLHOME= $(ORACLE_HOME)/nlsrtl/


ORA_NLS = $(ORACLE_HOME)/ocommon/nls/admin/data/
ORA_NLS33 = $(ORACLE_HOME)/ocommon/nls/admin/data/
ORA_NLS10 = $(ORACLE_HOME)/nls/data/

NLSRTL_VERSION=$(LIBMAJORVSN)
NLSRTL_DEBUG_LIBTAG = 

LIBNLSRTLNAME = nls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBNLSRTLNAME).$(LIB_EXT)
LLIBNLSRTL= $(LDLIBFLAG)$(LIBNLSRTLNAME)$(LIB_SUFFIX)

LIBUNLSRTLNAME = unls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBUNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBUNLSRTLNAME).$(LIB_EXT)
LLIBUNLSRTL= $(LDLIBFLAG)$(LIBUNLSRTLNAME)$(LIB_SUFFIX)

LIBSNLSRTLNAME = snls$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBSNLSRTL= $(LIBHOME)$(LIB_PREFIX)$(LIBSNLSRTLNAME).$(LIB_EXT)
LLIBSNLSRTL= $(LDLIBFLAG)$(LIBSNLSRTLNAME)$(LIB_SUFFIX)

NLSRTLPUBH = $(I_SYM)$(NLSRTLHOME)include

GSSHOME = $(ORACLE_HOME)/nlsrtl3/java
GSSCLASSES11 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCLASSES12 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCHARSET11 = $(ORACLE_HOME)/jlib/orai18n.jar
GSSCHARSET12 = $(ORACLE_HOME)/jlib/orai18n.jar

GDKHOME = $(ORACLE_HOME)/nlsrtl3/java
GDKCLASSES = $(ORACLE_HOME)/jlib/orai18n.jar$(PATHSEP)$(ORACLE_HOME)/jlib/orai18n-lcsd.jar
NLSRTL_JARS = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-translation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-net.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-servlet.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-tools.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-lcsd.jar

NLSRTL_JARS_FOR_GENERAL = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar

NLSRTL_JARS_FOR_DBJAVA_JAVAVM = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-utility.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-collation.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-net.jar

NLSRTL_JARS_FOR_DBJAVA_CLIENT = \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n.jar \
  $(ORACLE_HOME)/nlsrtl3/jlib/orai18n-mapping.jar

NLSRTL_SHIPHOME_JARS_FOR_DBJAVA_CLIENT = \
  $(ORACLE_HOME)/jlib/orai18n.jar \
  $(ORACLE_HOME)/jlib/orai18n-mapping.jar

# Entering SRCHOME/nlsrtl/s_exports.mk

LIBNLSRTLSHNAME = nlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBUNLSRTLSHNAME = unlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)
LIBSNLSRTLSHNAME = snlssh$(NLSRTL_VERSION)$(NLSRTL_DEBUG_LIBTAG)

LLIBNLSSH=-lnlssh$(NLSRTL_VERSION)
LLIBSNLSSH=-lsnlssh$(NLSRTL_VERSION)
LLIBUNLSSH=-lunlssh$(NLSRTL_VERSION)

# Exiting SRCHOME/nlsrtl/s_exports.mk
# Exiting SRCHOME/nlsrtl/exports.mk
# Entering SRCHOME/plsql/exports.mk

PLSQL_VERSION=12

WRAP=$(BINHOME)wrap

LIBPLSNAME=pls
LIBPLSN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBPLS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION)$(ILIB_SUFFIX) 
LIBPLSNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(SO_EXT)
ILIBPLSN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLSNAME).$(ILIB_EXT)
LIBPLPNAME=plp
LIBPLPN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBPLP=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION)$(ILIB_SUFFIX)
LIBPLPNSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(SO_EXT)
ILIBPLPN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLPNAME).$(ILIB_EXT)
LIBPLCNAME=plc
LIBPLCN=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBPLC=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION)$(ILIB_SUFFIX)
LIBPLCSHR=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(SO_EXT)
ILIBPLCN=$(LIBHOME)/$(LIB_PREFIX)$(LIBPLCNAME).$(ILIB_EXT)

LIBEXTP=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(DEPLIB_EXT)
LLIBEXTP=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION)

LIBPLSF=$(LIBHOME)$(LIB_PREFIX)$(LIBPLSNAME)$(PLSQL_VERSION).$(LIB_EXT) 
LLIBPLSF=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION) $(LDLIBFLAG)$(LIBPLPNAME)$(PLSQL_VERSION)

LIBPLSB=$(LIBHOME)$(LIBPLSNAME)$(PLSQL_VERSION)
LLIBPLSB=$(LDLIBFLAG)$(LIBPLSNAME)$(PLSQL_VERSION)

PLSQLLIBS=$(LIBPLSN) $(LIBPLPN)
LPLSQLLIBS=$(LLIBPLS)


LLIBPLSQL= $(LPLSQLLIBS) $(LLIBPLP)

LIBPSANAME=psa
LIBICD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLPNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBICD=$(LDLIBFLAG)$(LIBPLPNAME)$(PLSQL_VERSION)
LIBPSD=$(LIBHOME)$(LIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPSD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPLCNAME)$(PLSQL_VERSION)$(LIB_SUFFIX)
LIBPSA=$(LIBHOME)$(LIB_PREFIX)$(LIBPSANAME)$(PLSQL_VERSION).$(LIB_EXT)
LLIBPSA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBPSANAME)$(PLSQL_VERSION)$(LIB_SUFFIX)

PLSQLHOME=$(ORACLE_HOME)/plsql/

PLSSHNAME=plssh$(PLSQL_VERSION)
LLIBPLSSH=$(LDLIBFLAG)$(PLSSHNAME)$(LIB_SUFFIX)
PLPSHNAME=plpsh$(PLSQL_VERSION)
LLIBPLPSH=$(LDLIBFLAG)$(PLPSHNAME)$(LIB_SUFFIX)
# Entering SRCHOME/plsql/s_exports.mk


LLIBPLS+=-lrt

# Exiting SRCHOME/plsql/s_exports.mk
# Exiting SRCHOME/plsql/exports.mk
# Entering SRCHOME/precomp/exports.mk

TOP=$(ORACLE_HOME)/precomp

PRECOMP_VERSION=12
LIBSQLNAME=sql$(PRECOMP_VERSION)
LLIBSQL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSQLNAME)$(ILIB_SUFFIX)
LIBSQL=$(LIBHOME)$(LIB_PREFIX)$(LIBSQLNAME).$(DEPLIB_EXT)

PRECOMP_PRD=precomp
PRECOMPHOME=$(ORACLE_HOME)/precomp/
PRECOMPADMIN=$(PRECOMPHOME)admin/
PRECOMPLIB=$(PRECOMPHOME)$(LIBDIR)/

OTTCLASSESZIP=$(PRECOMPLIB)ottclasses.$(ZIP_EXT)

PRECOMPPUBH=$(I_SYM)$(PRECOMPHOME)public $(I_SYM)$(PRECOMPHOME)include

LIBSQLSHNAME=sqlsh$(PRECOMP_VERSION)
LLIBSQLSH=$(LDLIBFLAG)$(LIBSQLSHNAME)$(LIB_SUFFIX)

# Entering SRCHOME/precomp/s_exports.mk
 
# Exiting SRCHOME/precomp/s_exports.mk
# Exiting SRCHOME/precomp/exports.mk
# Entering SRCHOME/ldap/exports.mk

# Entering SRCHOME/ldap/iasr_exports.mk


# Exiting SRCHOME/ldap/iasr_exports.mk

LDAP_VERSION=$(LIBMAJORVSN)

LIBGSLSSFNAME= gslssf$(LDAP_VERSION)
LLIBGSLSSF= $(LDLIBFLAG)$(LIBGSLSSFNAME)$(LIB_SUFFIX)
LIBGSLSSF= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSSFNAME).$(LIB_EXT)

LIBGSLSSBNAME= gslssb$(LDAP_VERSION)
LLIBGSLSSB= $(LDLIBFLAG)$(LIBGSLSSBNAME)$(LIB_SUFFIX)
LIBGSLSSB= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSSBNAME).$(LIB_EXT)

LIBGSLBER_SNAME= gslber_s$(LDAP_VERSION)
LLIBGSLBER_S= $(LDLIBFLAG)$(LIBGSLBER_SNAME)$(LIB_SUFFIX)
LIBGSLBER_S= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLBER_SNAME).$(LIB_EXT)

LIBGSLAVLNAME= gslavl$(LDAP_VERSION)
LLIBGSLAVL= $(LDLIBFLAG)$(LIBGSLAVLNAME)$(LIB_SUFFIX)
LIBGSLAVL= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLAVLNAME).$(LIB_EXT)

LIBGSLRNAME= gslr$(LDAP_VERSION)
LLIBGSLR= $(LDLIBFLAG)$(LIBGSLRNAME)$(LIB_SUFFIX)
LIBGSLR= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRNAME).$(LIB_EXT)

LIBGSLRTANAME= gslrta$(LDAP_VERSION)
LLIBGSLRTA= $(LDLIBFLAG)$(LIBGSLRTANAME)$(LIB_SUFFIX)
LIBGSLRTA= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRTANAME).$(LIB_EXT)

LIBGSLRTDNAME= gslrtd$(LDAP_VERSION)
LLIBGSLRTD= $(LDLIBFLAG)$(LIBGSLRTDNAME)$(LIB_SUFFIX)
LIBGSLRTD= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRTDNAME).$(LIB_EXT)

LIBGSLRTMNAME= gslrtm$(LDAP_VERSION)
LLIBGSLRTM= $(LDLIBFLAG)$(LIBGSLRTMNAME)$(LIB_SUFFIX)
LIBGSLRTM= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRTMNAME).$(LIB_EXT)

LIBGSLRTPNAME= gslrtp$(LDAP_VERSION)
LLIBGSLRTP= $(LDLIBFLAG)$(LIBGSLRTPNAME)$(LIB_SUFFIX)
LIBGSLRTP= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRTPNAME).$(LIB_EXT)

LIBGSLRTRNAME= gslrtr$(LDAP_VERSION)
LLIBGSLRTR= $(LDLIBFLAG)$(LIBGSLRTRNAME)$(LIB_SUFFIX)
LIBGSLRTR= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRTRNAME).$(LIB_EXT)

LIBGSLRTUNAME= gslrtu$(LDAP_VERSION)
LLIBGSLRTU= $(LDLIBFLAG)$(LIBGSLRTUNAME)$(LIB_SUFFIX)
LIBGSLRTU= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLRTUNAME).$(LIB_EXT)

LIBGSLDBNAME= gsldb$(LDAP_VERSION)
LLIBGSLDB= $(LDLIBFLAG)$(LIBGSLDBNAME)$(LIB_SUFFIX)
LIBGSLDB= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLDBNAME).$(LIB_EXT)


LIBGSLUSNAME= gslus$(LDAP_VERSION)
LLIBGSLUS= $(LDLIBFLAG)$(LIBGSLUSNAME)$(LIB_SUFFIX)
LIBGSLUS= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLUSNAME).$(LIB_EXT)

LIBGSLTNAME= gslt$(LDAP_VERSION)
LLIBGSLT= $(LDLIBFLAG)$(LIBGSLTNAME)$(LIB_SUFFIX)
LIBGSLT= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLTNAME).$(LIB_EXT)

LIBGSLSGNAME= gslsg$(LDAP_VERSION)
LLIBGSLSG= $(LDLIBFLAG)$(LIBGSLSGNAME)$(LIB_SUFFIX)
LIBGSLSG= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSGNAME).$(LIB_EXT)

LIBGSLECNAME= gslec$(LDAP_VERSION)
LLIBGSLEC= $(LDLIBFLAG)$(LIBGSLECNAME)$(LIB_SUFFIX)
LIBGSLEC= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLECNAME).$(LIB_EXT)

LIBGSLSMNAME= gslsm$(LDAP_VERSION)
LLIBGSLSM= $(LDLIBFLAG)$(LIBGSLSMNAME)$(LIB_SUFFIX)
LIBGSLSM= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLSMNAME).$(LIB_EXT)

LIBGSLIRNAME= gslir$(LDAP_VERSION)
LLIBGSLIR= $(LDLIBFLAG)$(LIBGSLIRNAME)$(LIB_SUFFIX)
LIBGSLIR= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLIRNAME).$(LIB_EXT)

LIBGSLGRNAME= gslgr$(LDAP_VERSION)
LLIBGSLGR= $(LDLIBFLAG)$(LIBGSLGRNAME)$(LIB_SUFFIX)
LIBGSLGR= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLGRNAME).$(LIB_EXT)

LIBGSLAUDNAME= gslaud$(LDAP_VERSION)
LLIBGSLAUD= $(LDLIBFLAG)$(LIBGSLAUDNAME)$(LIB_SUFFIX)
LIBGSLAUD= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLAUDNAME).$(LIB_EXT)

LIBGSLPLNAME= gslpl$(LDAP_VERSION)
LLIBGSLPL= $(LDLIBFLAG)$(LIBGSLPLNAME)$(LIB_SUFFIX)
LIBGSLPL= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLPLNAME).$(LIB_EXT)

LIBGSLMNAME= gslm$(LDAP_VERSION)
LLIBGSLM= $(LDLIBFLAG)$(LIBGSLMNAME)$(LIB_SUFFIX)
LIBGSLM=$(LIBHOME)$(LIB_PREFIX)$(LIBGSLMNAME).$(LIB_EXT)

LIBSGSL_SNAME= sgsl_s$(LDAP_VERSION)
LLIBSGSL_S= $(LDLIBFLAG)$(LIBSGSL_SNAME)$(LIB_SUFFIX)
LIBSGSL_S= $(LIBHOME)$(LIB_PREFIX)$(LIBSGSL_SNAME).$(LIB_EXT)

LIBLDAPCLNTNAME= ldapclnt$(LDAP_VERSION)
LIBLDAPCLNT= $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTNAME).$(LIB_EXT)
LLIBLDAPCLNT= $(LDLIBFLAG)$(LIBLDAPCLNTNAME)

LIBLDAPCLNTSHNAME= ldapclntsh$(LDAP_VERSION)
LIBLDAPCLNTSH= $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTSHNAME).$(LIB_EXT)
LLIBLDAPCLNTSH= $(LDLIBFLAG)$(LIBLDAPCLNTSHNAME)
LIBLDAPCLNTSHLIBS= $(LIBLDAPCLNTSHNAME)LIBS

LIBLDAPJCLNTNAME= ldapjclnt$(LDAP_VERSION)
LIBLDAPJCLNT= $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPJCLNTNAME).$(LIB_EXT)
LIBLDAPJCLNTSH = $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPJCLNTNAME).$(SO_EXT)
LLIBLDAPJCLNT= $(LDLIBFLAG)$(LIBLDAPJCLNTNAME)
LIBLDAPJCLNTLIBS= $(LIBLDAPJCLNTNAME)LIBS

LIBGSLMTNAME= gslmt$(LDAP_VERSION)
LLIBGSLMT= $(LDLIBFLAG)$(LIBGSLMTNAME)$(LIB_SUFFIX)
LIBGSLMT= $(LIBHOME)$(LIB_PREFIX)$(LIBGSLMTNAME).$(LIB_EXT)

LIBZTKGNAME= ztkg$(LDAP_VERSION)
LIBZTKG= $(LIBHOME)$(LIB_PREFIX)$(LIBZTKGNAME).$(LIB_EXT)
LLIBZTKG= $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBZTKGNAME)$(ILIB_SUFFIX)

LDAPHOME=    $(ORACLE_HOME)/ldap/
LDAPBIN=     $(LDAPHOME)$(BINDIR)/
LDAPLIB=     $(LDAPHOME)$(LIBDIR)/
LDAPJLIB=    $(LDAPHOME)jlib/

LDAPPUBH=    $(I_SYM)$(LDAPHOME)public $(I_SYM)$(LDAPHOME)include

SSLPUBH = $(I_SYM)$(LDAPHOME)public/sslinc $(I_SYM)$(LDAPHOME)include/sslinc

CRYPTOPUBH = $(I_SYM)$(LDAPHOME)include/cryptoinc

ZTCE_DIR=$(IASRESTRICTEDSRC)ldap/security/zt/ztce/
ZTMISC_DIR=$(IASRESTRICTEDJSRC)/zt/oracle/security/misc

LIBNZFNAME= nnzf$(LDAP_VERSION)
LLIBNZF= $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBNZFNAME)$(ILIB_SUFFIX)
LIBNZF=$(LIBHOME)$(LIB_PREFIX)$(LIBNZFNAME).$(LIB_EXT)
 
NZNAME= nnz$(LDAP_VERSION)
NZSTNAME= nnzst$(LDAP_VERSION)
LLIBNZ= $(LDLIBFLAG)$(ILIB_PREFIX)$(NZNAME)$(ILIB_SUFFIX)
LIBNZ=$(LIBHOME)$(LIB_PREFIX)$(NZNAME).$(SO_EXT)
LLIBNZST= $(LDLIBFLAG)$(ILIB_PREFIX)$(NZSTNAME)$(ILIB_SUFFIX)
LIBNZST=$(LIBHOME)$(LIB_PREFIX)$(NZSTNAME).$(LIB_EXT)
LLIBNZ_SERVER=$(LLIBNZST)

OWMNAME = owm2
LIBOWM  = $(LDAPLIB)$(LIB_PREFIX)$(OWMNAME).$(SO_EXT)

NZJSNAME = nzjs${LDAP_VERSION}
LLIBNZJS = $(LDLIBFLAG)$(ILIB_PREFIX)$(NZJSNAME)$(ILIB_SUFFIX)
LIBNZJS  = $(LDAPLIB)$(LIB_PREFIX)$(NZJSNAME).$(LIB_EXT)

SSLBNAME = nsslb${LDAP_VERSION}
LIBSSLB  = $(LIBHOME)$(LIB_PREFIX)$(SSLBNAME).$(LIB_EXT)
LLIBSSLB = $(LDLIBFLAG)$(ILIB_PREFIX)$(SSLBNAME)$(ILIB_SUFFIX)
LIBSSLB  = $(LDAPLIB)$(LIB_PREFIX)$(SSLBNAME).$(LIB_EXT)

LIBZTNAME  = zt${LDAP_VERSION}
ZTRNAME = ztr${LDAP_VERSION}
NZTNAME = ${NZNAME}
NZTRNAME = ${NZNAME}
LIBZT   = $(LIBHOME)$(LIB_PREFIX)$(LIBZTNAME).$(LIB_EXT)
LLIBZT   = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBZTNAME)$(ILIB_SUFFIX)
LIBZTR  = $(LIBHOME)$(LIB_PREFIX)$(ZTRNAME).$(LIB_EXT)
LOC_LIBZTR   = $(LDAPLIB)$(LIB_PREFIX)$(ZTRNAME).$(LIB_EXT)
LOC_LIBNZTR   = $(LDAPLIB)$(LIB_PREFIX)$(NZTRNAME).$(LIB_EXT)
LOC_LIBNZ  = $(LDAPLIB)$(LIB_PREFIX)$(NZNAME).$(LIB_EXT)
LIBZTLWNAME  = ztlw${LDAP_VERSION}
LIBZTLW   = $(LIBHOME)$(LIB_PREFIX)$(LIBZTLWNAME).$(LIB_EXT)
LLIBZTLW   = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBZTLWNAME)$(ILIB_SUFFIX)

NZLIBS = $(LLIBNZ) $(LLIBZT) $(LLIBZTKG)
NZLIBSLW = $(LLIBNZ) $(LLIBZTLW)

NZLIBS_SERVER = $(LLIBNZ_SERVER) $(LLIBZT) $(LLIBZTKG)

SPFLAGS+= -DLDAP_CM

# Entering SRCHOME/ldap/s_exports.mk


# Exiting SRCHOME/ldap/s_exports.mk
# Exiting SRCHOME/ldap/exports.mk
# Entering SRCHOME/slax/exports.mk

TOP = $(ORACLE_HOME)/slax

SLAX_VERSION=$(LIBMAJORVSN)
LIBSLAXNAME=slax$(SLAX_VERSION)
LLIBSLAX=$(LDLIBFLAG)$(LIBSLAXNAME)$(LIB_SUFFIX)
LIBSLAX=$(LIBHOME)$(LIB_PREFIX)$(LIBSLAXNAME).$(LIB_EXT)

SLAX_PRD=slax
SLAXHOME=$(ORACLE_HOME)/slax/
SLAXADMIN=$(SLAXHOME)admin/
SLAXLIB=$(SLAXHOME)$(LIBDIR)/
 
SLAXPUBH=$(I_SYM)$(SLAXHOME)include

# Entering SRCHOME/slax/s_exports.mk

# Exiting SRCHOME/slax/s_exports.mk
# Exiting SRCHOME/slax/exports.mk
# Entering SRCHOME/encryption/exports.mk

ENCRYPTIONHOME  = $(ORACLE_HOME)/encryption/
ENCRYPTIONLIB   = $(ENCRYPTIONHOME)$(LIBDIR)/
ENCRYPTIONJLIB  = $(ENCRYPTIONHOME)jlib/
ENCRYPTIONPUBH  = $(I_SYM)$(ENCRYPTIONHOME)include

ENCRYPTION_VERSION=$(LIBMAJORVSN)
BASENAME        =n
CRYPTNAME       =${BASENAME}crypt$(ENCRYPTION_VERSION)
LIBSNS          =$(ENCRYPTIONLIB)$(LIB_PREFIX)$(CRYPTNAME).$(LIB_EXT)
LLIBNCRYPT      =$(LDLIBFLAG)$(ILIB_PREFIX)$(CRYPTNAME)$(ILIB_SUFFIX)

PHAOSJAR=$(ENCRYPTIONJLIB)ojpse.$(JAR_EXT)
PHAOSCMSJAR=$(ENCRYPTIONJLIB)ojpcms.$(JAR_EXT)
CRYPTSHNAME=$(BASENAME)cryptsh$(ENCRYPTION_VERSION)
LLIBNCRYPTSH=$(LDLIBFLAG)$(CRYPTSHNAME)$(ILIB_SUFFIX)
# Entering SRCHOME/encryption/s_exports.mk

# Exiting SRCHOME/encryption/s_exports.mk
# Exiting SRCHOME/encryption/exports.mk
# Entering SRCHOME/ldap/iasr_exports.mk


# Exiting SRCHOME/ldap/iasr_exports.mk
# Entering SRCHOME/xdk/exports.mk

XDKHOME    = $(ORACLE_HOME)/xdk/

XDK_LIB_VER    = $(LIBMAJORVSN)



XML_LIB_NAME     = xml
XML_LIB_VER      = $(XDK_LIB_VER)
XML_LIB          = $(XML_LIB_NAME)$(XML_LIB_VER)

LIBXML_STATIC    = $(LIB_PREFIX)$(XML_LIB).$(LIB_EXT)
LIBXML_SHARED    = $(LIB_PREFIX)$(XML_LIB).$(SO_EXT)
LIBXML_SLH       = $(LIB_PREFIX)$(XML_LIB).$(ILIB_EXT)

LIBXML           = $(LIBHOME)$(LIBXML_STATIC)
LLIBXML          = $(LDLIBFLAG)$(XML_LIB)

LIBXML_ARC_LIB   = $(LIBXML)
LIBXML_SHARE_LIB = $(LIBHOME)$(LIBXML_SHARED)

XDKPUBLIC=$(XDKHOME)include $(XDKHOME)public

XDKPUBH=$(I_SYM)$(XDKHOME)include $(I_SYM)$(XDKHOME)public



XMLORGJAR = $(XDKSRC)java/lib/xmlorg.jar
XMLORG1JAR = $(XDKSRC)java/lib/xmlorg1.jar
JAXP_SERVICESJAR = $(XDKSRC)java/lib/jaxp_services.jar

XMLORG2JAR = $(XDKSRC)java/lib/xmlorg2.jar

JAXB2JAR = $(XDKSRC)java/lib/jaxb-api.jar


XML = xml
XMLJAR = $(LIBHOME)$(XML).$(JAR_EXT)

XMLPARSERV2 = xmlparserv2
XMLPARSERV2A = xmlparserv2_sans_jaxp_services
XMLPARSERV2B = xmlparserv2_jaxp_services

XMLPARSERV2JAR = $(LIBHOME)$(XMLPARSERV2).$(JAR_EXT)
XMLPARSERV2AJAR = $(LIBHOME)$(XMLPARSERV2A).$(JAR_EXT)
XMLPARSERV2BJAR = $(LIBHOME)$(XMLPARSERV2B).$(JAR_EXT)

XMLMESG = xmlmesg
XMLMESGJAR = $(LIBHOME)$(XMLMESG).$(JAR_EXT)

XMLCOMP = xmlcomp
XMLCOMPJAR = $(LIBHOME)$(XMLCOMP).$(JAR_EXT)

XMLCOMP2 = xmlcomp2
XMLCOMP2JAR = $(LIBHOME)$(XMLCOMP2).$(JAR_EXT)

XMLDEMO = xmldemo

CLASSGEN = classgen
CLASSGENJAR = $(LIBHOME)$(CLASSGEN).$(JAR_EXT)

XSCHEMA = xschema
XSCHEMAJAR  = $(LIBHOME)$(XSCHEMA).$(JAR_EXT)

XSQL = oraclexsql
XSQLJAR = $(LIBHOME)$(XSQL).$(JAR_EXT)

XSQLSERIAL = xsqlserializers
XSQLSERIALJAR = $(LIBHOME)$(XSQLSERIAL).$(JAR_EXT)

XSU = xsu12
XSUJAR = $(LIBHOME)$(XSU).$(JAR_EXT)

TRANSX = transx
TRANSXJAR  = $(LIBHOME)$(TRANSX).$(ZIP_EXT)

JAXBJAR = $(XDKSRC)java/lib/jaxb-api.jar

XQUERY = xquery
XQUERYJAR  = $(LIBHOME)$(XQUERY).$(JAR_EXT)

OXQUERY = oxquery
OXQUERYJAR  = $(LIBHOME)$(OXQUERY).$(JAR_EXT)
OXQUERYEE = oxquery-ee
OXQUERYEEJAR  = $(LIBHOME)$(OXQUERYEE).$(JAR_EXT)
OXQUERYXBA = oxquery-xmlbeans-interop
OXQUERYXBAJAR = $(LIBHOME)$(OXQUERYXBA).$(JAR_EXT)
OXQUERYXBB = oxquery-beaxmlbeans-interop
OXQUERYXBBJAR = $(LIBHOME)$(OXQUERYXBB).$(JAR_EXT)
OXQUERYHE = oxh

XQJAPI = xqjapi
XQJAPIJAR  = $(LIBHOME)$(XQJAPI).$(JAR_EXT)

XQJORI = xqjori
XQJORIJAR  = $(LIBHOME)$(XQJORI).$(JAR_EXT)

OJCR = ojcr
OJCRJAR  = $(LIBHOME)$(OJCR).$(JAR_EXT)


# Entering SRCHOME/xdk/s_exports.mk
 
# Exiting SRCHOME/xdk/s_exports.mk
# Exiting SRCHOME/xdk/exports.mk
# Entering SRCHOME/has/exports.mk


HAS_VERSION = 12

HAS_SKGXNLIBS=$(LLIBSKGXN)

HAS_CORELIBS=$(LLIBCLNTSH) $(CORELIBS)
HAS_LLIBCORE=$(LLIBCORE)

HAS_NZLIBS=$(NZLIBS)
HAS_NZLIBS_SERVER=$(LLIBNZ_SERVER) $(LLIBZT)

HAS_XMLLIBS=$(LLIBXML)

HAS_GENERICLIBS=$(LLIBGENERIC)

CSSGCNAME=clssgc
CSSGC_OBJ=$(HASLIB)$(CSSGCNAME).$(OBJ_EXT)

SCLSINAME=sclsi
SCLSI_OBJ=$(HASLIB)$(SCLSINAME).$(OBJ_EXT)

HASGENNAME=hasgen
LIBHASGENNAME=$(HASGENNAME)$(HAS_VERSION)
LIBHASGEN=$(LIBHOME)$(LIB_PREFIX)$(LIBHASGENNAME).$(HASGEN_EXT)
LLIBHASGEN=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBHASGENNAME)$(ILIB_SUFFIX)
LIBHASGENST=$(LIBHOME)$(LIB_PREFIX)$(LIBHASGENNAME).$(LIB_EXT)

HASGENLIBS=$(LLIBHASGEN) $(OCRLIBS_DEFAULT) $(HAS_CORELIBS) $(HAS_SKGXNLIBS) \
	$(HAS_NZLIBS) $(HAS_XMLLIBS) $(LLIBCLNTSH) $(LLIBGENERIC)
HASGENLIBS_OCR=$(LLIBHASGEN) $(HAS_CORELIBS) \
	$(HAS_SKGXNLIBS) $(LLIBGENERIC)
HASGENLIBS_SERVER=$(LLIBHASGEN) $(HAS_SKGXNLIBS) $(HAS_NZLIBS_SERVER) \
  $(HAS_XMLLIBS) $(LLIBGENERIC)

CSSCLNTLIBS=$(HASGENLIBS)

CSSCLNTLIBS_SERVER=$(HASGENLIBS_SERVER) $(OCRLIBS_SERVER) \
	$(CSSCLNTLIBS_SERVER_XLIBS)

CSSCLNTLIBS_SERVER_XLIBS=
CSSCLNTLIBS_SERVER_STATICLIBS=$(CSSGC_OBJ)


LIBEVMNAME=oevm
LLIBEVM=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBEVMNAME)$(LIB_SUFFIX)

LLIBORAAGENT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBORAAGENTNAME)$(LIB_SUFFIX)

LIBORAAGENTNAME=oraagent
LIBORAROOTAGENTNAME=orarootagent
LIBORADAEMONAGENTNAME=oradaemonagent

LIBCLSRNAME=clsr$(HAS_VERSION)
LIBCLSR=$(HASLIB)$(LIB_PREFIX)$(LIBCLSRNAME).$(LIB_EXT)
LLIBCLSR=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSRNAME)$(LIB_SUFFIX)
CLSRLIBS=$(LLIBCLSR) $(LIBDBTOOLS) $(LLIBONS) \
	$(LLIBEVM) $(HASGENLIBS) \
	$(OCRLIBS_NONCACHING) $(HAS_CORELIBS) $(LLIBDBCFG) $(SUIDLINKLDLIBS) 

LIBCLSRANAME=clsra$(HAS_VERSION)
LIBCLSRA=$(HASLIB)$(LIB_PREFIX)$(LIBCLSRANAME).$(SO_EXT)
LLIBCLSRA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSRANAME)$(ILIB_SUFFIX)
CLSRLIBS_SERVER=$(LLIBCLSRA) $(LLIBDBCFG)

RDLIBS=$(HAS_CORELIBS) $(HAS_SKGXNLIBS) $(RDPROVIDERLIBS)

LIBRDJNINAME=rdjni$(HAS_VERSION)
LIBRDJNI=$(HASLIB)$(LIB_PREFIX)$(LIBRDJNINAME).$(SO_EXT)
LLIBRDJNI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDJNINAME)$(ILIB_SUFFIX)

RD_JARNAME=rd
RD_JAR=$(HASJLIB)$(RD_JARNAME).$(JAR_EXT)

RDTOOL_JARNAME=rdtool
RDTOOL_JAR=$(HASJLIB)$(RDTOOL_JARNAME).$(JAR_EXT)


LIBDNSSDNAME=dns_sd
LIBDNSSD=$(HASLIB)$(LIB_PREFIX)$(LIBDNSSDNAME).$(SO_EXT)
LLIBDNSSD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDNSSDNAME)$(ILIB_SUFFIX)

LIBMDNSNAME=omdns$(HAS_VERSION)
LIBMDNS=$(HASLIB)$(LIB_PREFIX)$(LIBMDNSNAME).$(SO_EXT)
LLIBMDNS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBMDNSNAME)$(ILIB_SUFFIX)

MDNSRESPONDERNAME=mdnsd
MDNSRESPONDER=$(HASBIN)$(MDNSRESPONDERNAME)$(EXE_SUFFIX)

MDNSNETMONITORNAME=oranetmonitor
MDNSNETMONITOR=$(HASBIN)$(MDNSNETMONITORNAME)$(EXE_SUFFIX)

DNS_SDNAME=oradnssd
DNS_SD=$(HASBIN)$(DNS_SDNAME)$(EXE_SUFFIX)


RDPROVIDERNAMEPREFIX=rdp

LIBRDPAPPLENAME=$(RDPROVIDERNAMEPREFIX)apple$(HAS_VERSION)
LIBRDPAPPLE=$(HASLIB)$(LIB_PREFIX)$(LIBRDPAPPLENAME).$(SO_EXT)
LLIBRDPAPPLE=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPAPPLENAME)$(ILIB_SUFFIX)

LIBRDPEAPPLENAME=$(RDPROVIDERNAMEPREFIX)eapple$(HAS_VERSION)
LIBRDPEAPPLE=$(HASLIB)$(LIB_PREFIX)$(LIBRDPEAPPLENAME).$(SO_EXT)
LLIBRDPEAPPLE=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPEAPPLENAME)$(ILIB_SUFFIX)

LIBRDPSLPNAME=$(RDPROVIDERNAMEPREFIX)slp$(HAS_VERSION)
LIBRDPSLP=$(HASLIB)$(LIB_PREFIX)$(LIBRDPSLPNAME).$(LIB_EXT)
LLIBRDPSLP=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPSLPNAME)$(ILIB_SUFFIX)

LIBRDPNULLNAME=$(RDPROVIDERNAMEPREFIX)null$(HAS_VERSION)
LIBRDPNULL=$(HASLIB)$(LIB_PREFIX)$(LIBRDPNULLNAME).$(SO_EXT)
LLIBRDPNULL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBRDPNULLNAME)$(ILIB_SUFFIX)

LIBGPNPTNAME=gpnpt$(HAS_VERSION)
LLIBGPNPT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGPNPTNAME)$(LIB_SUFFIX)

GPNPSETUP_JARNAME=gpnpsetup
GPNPSETUP_JAR=$(HASJLIB)$(GPNPSETUP_JARNAME).$(JAR_EXT)

LIBGNSNAME=gns$(HAS_VERSION)
LIBGNS=$(HASLIB)$(LIB_PREFIX)$(LIBGNSNAME).$(SO_EXT)
LLIBGNS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGNSNAME)$(ILIB_SUFFIX)

LIBGNSUTLNAME=gnsutl$(HAS_VERSION)
LIBGNSUTL=$(HASLIB)$(LIB_PREFIX)$(LIBGNSUTLNAME).$(SO_EXT)
LLIBGNSUTL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGNSUTLNAME)$(ILIB_SUFFIX)

GNSLIBS=$(HAS_CORELIBS)

LIBGNSJARNAME=gns
LIBGNSJAR=$(HASJLIB)$(LIBGNSJARNAME).$(JAR_EXT)

LIBGNSJNINAME=gnsjni$(HAS_VERSION)
LIBGNSJNI=$(HASLIB)$(LIB_PREFIX)$(LIBGNSJNINAME).$(SO_EXT)
LLIBGNSJNI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBGNSJNINAME)$(ILIB_SUFFIX)

LIBCLSNSJNINAME=clsnsjni$(HAS_VERSION)
LIBCLSNSJNI=$(HASLIB)$(LIB_PREFIX)$(LIBCLSNSJNINAME).$(SO_EXT)
LLIBCLSNSJNI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSNSJNINAME)$(ILIB_SUFFIX)

LIBCLSDNAME=clsd$(HAS_VERSION)
LIBCLSD=$(HASLIB)$(LIB_PREFIX)$(LIBCLSDNAME).$(LIB_EXT)
LLIBCLSD=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSDNAME)$(LIB_SUFFIX)
CLSDLIBS=$(LLIBCLSD) $(HAS_CORELIBS)

CONSOLEAPPS=consoleapps
CONSOLEAPPS_HOME=$(HASHOME)jsrc/$(CONSOLEAPPS)/
CONSOLEAPPS_JAR=$(HASJLIB)$(CONSOLEAPPS).$(JAR_EXT)
CONSOLEAPPS_TEST_JAR=$(HASJLIB)$(CONSOLEAPPS)-test.$(JAR_EXT)
CONSOLEAPPS_TEST_HOME=$(HASHOME)test/jsrc/$(CONSOLEAPPS)/
CONSOLEAPPS_ACTPOL=activatepolicy
CONSOLEAPPS_ACTPOL_JAR=$(HASHOME)utl/$(CONSOLEAPPS_ACTPOL).$(JAR_EXT)
CONSOLEAPPS_OTN_ZIP=$(HASHOME)/utl/otn-$(CONSOLEAPPS_ACTPOL).$(ZIP_EXT)
CONSOLEAPPS_VMCPU=vmcpu
CONSOLEAPPS_VMCPU_JAR=$(HASHOME)utl/$(CONSOLEAPPS_VMCPU).$(JAR_EXT)
CONSOLEAPPS_VMCPU_ZIP=$(HASHOME)/utl/otn-$(CONSOLEAPPS_VMCPU).$(ZIP_EXT)

WAR_EXT=war
JWC=jwc
JWC_HOME=$(HASHOME)jsrc/$(JWC)/
JWC_TEST_HOME=$(HASHOME)test/jsrc/$(JWC)/
JWC_SECURITY_JAR=$(HASJLIB)$(JWC)-security.$(JAR_EXT)
JWC_ADMIN_JAR=$(HASJLIB)$(JWC)-admin.$(JAR_EXT)
JWC_CLIENT_JAR=$(HASJLIB)$(JWC)-client.$(JAR_EXT)
JWC_LOGGING_JAR=$(HASJLIB)$(JWC)-logging.$(JAR_EXT)
JWC_TEST_JAR=$(HASJLIB)$(JWC)-test.$(JAR_EXT)
JWC_TEST_DBWLM_WAR=$(HASJLIB)jwc-dbwlm-test.$(WAR_EXT)

JWCCRED=$(JWC)cred
JWCCRED_HOME=$(HASHOME)jsrc/$(JWCCRED)/
JWCCRED_JAR=$(HASJLIB)$(JWC)-cred.$(JAR_EXT)
JWCCRED_TEST_HOME=$(HASHOME)test/jsrc/$(JWCCRED)/
JWCCRED_TEST_JAR=$(HASJLIB)$(JWC)-cred-test.$(JAR_EXT)
JWCCRED_TLS_REMOTE_CLIENT_JAR=$(HASJLIB)$(JWC)-cred-tls-remote-client.$(JAR_EXT)

LIBAGFWNAME=agfw$(HAS_VERSION)
LIBAGFW=$(HASLIB)$(LIB_PREFIX)$(LIBAGFWNAME).$(LIB_EXT)
LLIBAGFW=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBAGFWNAME)$(LIB_SUFFIX)
AGFWLIBS=$(LLIBAGFW) $(HAS_CORELIBS) $(HASLIBS) $(OCRLIBS_DEFAULT)

LIBCLSCENAME=clsce$(HAS_VERSION)
LIBCLSCE=$(HASLIB)$(LIB_PREFIX)$(LIBCLSCENAME).$(LIB_EXT)
LLIBCLSCE=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSCENAME)$(ILIB_SUFFIX)
CLSCELIBS=$(LLIBCLSCE) $(HAS_CORELIBS) $(HASLIBS) $(EVMLIBS_DEFAULT)

LIBCLSCREDNAME=clscred$(HAS_VERSION)
LIBCLSCRED=$(HASLIB)$(LIB_PREFIX)$(LIBCLSCREDNAME).$(LIB_EXT)
LLIBCLSCRED=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCLSCREDNAME)$(ILIB_SUFFIX)
CLSCREDLIBS=$(LLIBCLSCRED) $(HAS_CORELIBS) $(HASLIBS)

LIBCHANAME=cha$(HAS_VERSION)
LIBCHA=$(HASLIB)$(LIB_PREFIX)$(LIBCHANAME).$(LIB_EXT)
LLIBCHA=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCHANAME)$(ILIB_SUFFIX)
CHALIBS=$(LLIBCHA) $(HAS_CORELIBS) $(HASLIBS)
CHACONFIG=chaconfig
CHACONFIG_JAR=$(HASJLIB)$(CHACONFIG).$(JAR_EXT)
CHAJAR=cha
CHA_JAR=$(HASJLIB)$(CHAJAR).$(JAR_EXT)

LIBDBNAME=db
LIBDB46NAME=db-4.6

LIBCRFNAME=crf$(HAS_VERSION)
LIBCRFBDBNAME=crf_bdb$(HAS_VERSION)
LIBCRFMDBNAME=crf_mdb$(HAS_VERSION)
LIBCRF=$(HASLIB)$(LIB_PREFIX)$(LIBCRFNAME).$(LIB_EXT)
LLIBCRF=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBCRFNAME)$(ILIB_SUFFIX)
CRFLIBS=$(LLIBCRF) $(HAS_CORELIBS)
CRF_CLIENT_JAR=$(HASHOME)$(JLIBDIR)/crf-client.jar
CRF_JAR=$(HASHOME)$(JLIBDIR)/crf.jar
CRF_TEST_JAR=$(HASHOME)$(JLIBDIR)/crf-test.jar

OPMNLIB=$(ORACLE_HOME)/opmn/lib/

LIBONSNAME=ons
LIBONS=$(OPMNLIB)$(LIB_PREFIX)$(LIBONSNAME).$(LIB_EXT)
LLIBONS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBONSNAME)$(LIB_SUFFIX)

LIBSCCLNTNAME=scclnt$(HAS_VERSION)
LIBSCCLNT=$(HASLIB)$(LIB_PREFIX)$(LIBSCCLNTNAME).$(SO_EXT)
LLIBSCCLNT=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSCCLNTNAME)$(ILIB_SUFFIX)

HASHOME=$(ORACLE_HOME)/has/
HASLIB=$(HASHOME)$(LIBDIR)/
HASJLIB=$(HASHOME)$(JLIBDIR)/
HASADMIN=$(HASHOME)admin/
HASPUBH=$(I_SYM)$(HASHOME)include


HASLIBS=$(LLIBCSSCLNT) $(LLIBHASGEN) $(LLIBSCLS)
SCCLNTLIBS=$(LLIBSCCLNT) $(LLIBEONS)

# Entering SRCHOME/has/s_exports.mk


CSSCLNT_EXT=$(SO_EXT)

SCLS_EXT=$(SO_EXT)

HASGEN_EXT=$(SO_EXT)

LLIBEVM=$(LDLIBFLAG)c $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBEVMNAME)$(LIB_SUFFIX)

SSCLSINAME=ssclsi
SCLSI_OBJ=$(HASLIB)$(SCLSINAME).$(OBJ_EXT) $(HASLIB)$(SSCLSINAME).$(OBJ_EXT)

# Exiting SRCHOME/has/s_exports.mk
# Exiting SRCHOME/has/exports.mk
# Entering SRCHOME/opsm/exports.mk

OPSMHOME=$(ORACLE_HOME)/opsm/
OPSMJLIB   = $(OPSMHOME)/jlib
OPSMLIB =$(ORACLE_HOME)/opsm/lib/
OPSM_VERSION=$(HAS_VERSION)

SRVMNAME=srvm
LIBOPSMNAME=$(SRVMNAME)$(OPSM_VERSION)
LIBOPSM=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOPSMNAME).$(SO_EXT)
LIBOPSM_STATIC=$(LIB_PREFIX)$(LIBOPSMNAME).$(LIB_EXT)
LLIBOPSM=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOPSMNAME)$(ILIB_SUFFIX)

SRVMOCRNAME=srvmocr
LIBSRVMOCRNAME=$(SRVMOCRNAME)$(OPSM_VERSION)
LIBSRVMOCR=$(PRODSOHOME)$(LIB_PREFIX)$(LIBSRVMOCRNAME).$(SO_EXT)
LIBSRVMOCR_STATIC=$(LIB_PREFIX)$(LIBSRVMOCRNAME).$(LIB_EXT)
LLIBSRVMOCR=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSRVMOCRNAME)$(ILIB_SUFFIX)

SRVMCREDNAME=srvmcred
LIBSRVMCREDNAME=$(SRVMCREDNAME)$(OPSM_VERSION)
LIBSRVMCRED=$(PRODSOHOME)$(LIB_PREFIX)$(LIBSRVMCREDNAME).$(SO_EXT)
LIBSRVMCRED_STATIC=$(LIB_PREFIX)$(LIBSRVMCREDNAME).$(LIB_EXT)
LLIBSRVMCRED=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSRVMCREDNAME)$(ILIB_SUFFIX)

SRVMHASNAME=srvmhas
LIBSRVMHASNAME=$(SRVMHASNAME)$(OPSM_VERSION)
LIBSRVMHAS=$(PRODSOHOME)$(LIB_PREFIX)$(LIBSRVMHASNAME).$(SO_EXT)
LIBSRVMHAS_STATIC=$(LIB_PREFIX)$(LIBSRVMHASNAME).$(LIB_EXT)
LLIBSRVMHAS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBSRVMHASNAME)$(ILIB_SUFFIX)

OCRUTLNAME=ocrutl
LIBOCRUTLNAME=$(OCRUTLNAME)$(OPSM_VERSION)
LIBOCRUTL_STATIC=$(OPSMLIB)$(LIB_PREFIX)$(LIBOCRUTLNAME).$(LIB_EXT)
LOC_LIBOCRUTL=$(LIBOCRUTL_STATIC)
LIBOCRUTL=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOCRUTLNAME).$(SO_EXT)
LLIBOCRUTL=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCRUTLNAME)$(ILIB_SUFFIX)

OCRBACKENDNAME=ocrb
LIBOCRBACKENDNAME=$(OCRBACKENDNAME)$(OPSM_VERSION)
LIBOCRBACKEND_STATIC=$(OPSMLIB)$(LIB_PREFIX)$(LIBOCRBACKENDNAME).$(LIB_EXT)
LOC_LIBOCRBACKEND=$(LIBOCRBACKEND_STATIC)
LIBOCRBACKEND=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOCRBACKENDNAME).$(SO_EXT)
LLIBOCRBACKEND=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCRBACKENDNAME)$(ILIB_SUFFIX)

OCRNAME=ocr
LIBOCRNAME=$(OCRNAME)$(OPSM_VERSION)
LIBOCR_STATIC=$(OPSMLIB)$(LIB_PREFIX)$(LIBOCRNAME).$(LIB_EXT)
LOC_LIBOCR=$(LIBOCR_STATIC)
LIBOCR=$(PRODSOHOME)$(LIB_PREFIX)$(LIBOCRNAME).$(SO_EXT)
LLIBOCR=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBOCRNAME)$(ILIB_SUFFIX)

EMMASNAME=emmas
LIBEMMASNAME=$(EMMASNAME)$(OPSM_VERSION)
LIBEMMAS=$(PRODSOHOME)$(LIB_PREFIX)$(LIBEMMASNAME).$(SO_EXT)
LLIBEMMAS=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBEMMASNAME)$(ILIB_SUFFIX)

DBCFGNAME=dbcfg
LIBDBCFGNAME=$(DBCFGNAME)$(OPSM_VERSION)
LIBDBCFG=$(PRODSOHOME)$(LIB_PREFIX)$(LIBDBCFGNAME).$(SO_EXT)
LLIBDBCFG=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBDBCFGNAME)$(ILIB_SUFFIX)

UININAME=uini
LIBUININAME=$(UININAME)$(OPSM_VERSION)
LIBUINI=$(PRODSOHOME)$(LIB_PREFIX)$(LIBUININAME).$(SO_EXT)
LLIBUINI=$(LDLIBFLAG)$(ILIB_PREFIX)$(LIBUININAME)$(ILIB_SUFFIX)


OCRLIBS_CACHING =  $(LLIBOCR)  $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
		   $(HASGENLIBS_OCR) $(HAS_CORELIBS) $(SYSLIBS) \
		   $(LLIBTHREAD) $(ASMCLNTSH_LIBS)

OCRLIBS_DEFAULT =  $(LLIBOCR) $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
                   $(HASGENLIBS_OCR) $(HAS_CORELIBS) $(SYSLIBS) \
		   $(ASMCLNTSH_LIBS)

OCRLIBS_NONCACHING =  $(LLIBOCR) $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
                      $(HASGENLIBS_OCR) $(HAS_CORELIBS) $(SYSLIBS) \
                      $(ASMCLNTSH_LIBS)

OCRLIBS_SERVER =  $(LLIBOCR) $(LLIBOCRBACKEND) $(LLIBOCRUTL) \
                  $(HASGENLIBS_SERVER)

DBCFGLIBS = $(LLIBDBCFG) $(OCRLIBS_DEFAULT)

EMMASLIBS = $(LLIBEMMAS) $(OCRLIBS_DEFAULT)

UINILIBS = $(LLIBUINI) $(OCRLIBS_NONCACHING)

# Entering SRCHOME/opsm/s_exports.mk

# Exiting SRCHOME/opsm/s_exports.mk
# Exiting SRCHOME/opsm/exports.mk

# Entering SRCHOME/ipc/exports.mk


IPCHOME = $(ORACLE_HOME)/ipc/

CLEAN_IPC=clean_ipc

IPCPUBH = $(I_SYM)$(IPCHOME)include $(I_SYM)$(IPCHOME)public $(I_SYM)$(IPCHOME)src/ipcor

IPC_VERSION = 1

LIBIPCPRODNAME = ipc$(IPC_VERSION)
LIBIPC = $(LIBHOME)lib/$(LIB_PREFIX)$(LIBIPCPRODNAME).$(DEPLIB_EXT)
LLIBIPC = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBIPCPRODNAME)$(ILIB_SUFFIX)

LIBMQLPRODNAME = mql$(IPC_VERSION)
LIBMQL = $(LIBHOME)lib/$(LIB_PREFIX)$(LIBMQLPRODNAME).$(DEPLIB_EXT)
LLIBMQL = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBMQLPRODNAME)$(ILIB_SUFFIX)

LIBIPCGLPRODNAME = ipcgl$(IPC_VERSION)
LIBIPCGL = $(LIBHOME)lib/$(LIB_PREFIX)$(LIBIPCGLPRODNAME).$(DEPLIB_EXT)
LLIBIPCGL = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBIPCGLPRODNAME)$(ILIB_SUFFIX)

LIBIPCGLEXPRODNAME = ipcglex$(IPC_VERSION)
LIBIPCGLEX = $(LIBHOME)lib/$(LIB_PREFIX)$(LIBIPCGLEXPRODNAME).$(DEPLIB_EXT)
LLIBIPCGLEX = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBIPCGLEXPRODNAME)$(ILIB_SUFFIX)

LIBBCMPRODNAME = ipc$(IPC_VERSION)
LIBBCM = $(LIBHOME)lib/$(LIB_PREFIX)$(LIBBCMPRODNAME).$(DEPLIB_EXT)
LLIBBCM = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBBCMPRODNAME)$(ILIB_SUFFIX)
# Exiting SRCHOME/ipc/exports.mk

# Entering SRCHOME/network/exports.mk

NETWORKHOME=$(ORACLE_HOME)/network/
NETWORKADMIN=$(NETWORKHOME)admin/
NETWORKINSTALL=$(NETWORKHOME)install/
NETWORKDEMO=$(NETWORKHOME)demo/

# Entering SRCHOME/network/adapters.mk

# Entering SRCHOME/network/s_adapters.mk

# Exiting SRCHOME/network/s_adapters.mk

# Entering SRCHOME/network/libnames.mk

NETWORK_VERSION=$(LIBMAJORVSN)
BASENAME=n
NETWORKLIB=$(NETWORKHOME)$(LIBDIR)/
NETWORKJLIB=$(NETWORKHOME)$(JLIBDIR)/

COMMONNAME=${BASENAME}${NETWORK_VERSION}
NLNAME=${BASENAME}l${NETWORK_VERSION}
TCPNAME=${BASENAME}tcp${NETWORK_VERSION}
QUENAME=${BASENAME}que${NETWORK_VERSION}
DECNETNAME=${BASENAME}dec${NETWORK_VERSION}
LU62NAME=${BASENAME}lu62${NETWORK_VERSION}
MBNAME=${BASENAME}mb${NETWORK_VERSION}
DCENAME=${BASENAME}dce${NETWORK_VERSION}
BEQNAME=${BASENAME}beq${NETWORK_VERSION}
IPCNAME=${BASENAME}ipc${NETWORK_VERSION}
SPXNAME=${BASENAME}spx${NETWORK_VERSION}
TLINAME=${BASENAME}tli${NETWORK_VERSION}
TLITNAME=${BASENAME}tlit${NETWORK_VERSION}
TLISNAME=${BASENAME}tlis${NETWORK_VERSION}
TLIDNAME=${BASENAME}tlid${NETWORK_VERSION}
USNAME=${BASENAME}us${NETWORK_VERSION}
MQNAME=${BASENAME}tmq${NETWORK_VERSION}
SHMNAME=${BASENAME}shm${NETWORK_VERSION}
TCPSNAME=${BASENAME}tcps${NETWORK_VERSION}
CRYPTNAME=${BASENAME}crypt${NETWORK_VERSION}
TCPAIONAME=${BASENAME}tcpaio${NETWORK_VERSION}
NSGRNAME=${BASENAME}sgr${NETWORK_VERSION}
GSMNAME=${BASENAME}gsm${NETWORK_VERSION}
GSMSHDNAME=${BASENAME}gsmshd${NETWORK_VERSION}
LSNRNAME=${BASENAME}lsnr${NETWORK_VERSION}
LSNRCNAME=${BASENAME}lsnrc${NETWORK_VERSION}
RONAME=${BASENAME}ro${NETWORK_VERSION}
ROCNAME=${BASENAME}roc${NETWORK_VERSION}
ROXNAME=${BASENAME}rox${NETWORK_VERSION}
ROTNAME=${BASENAME}rot${NETWORK_VERSION}
CMNAME=${BASENAME}cm${NETWORK_VERSION}
NHOSTNAME=${BASENAME}host${NETWORK_VERSION}
TNSNAME=${BASENAME}tns${NETWORK_VERSION}
ORACLENAME=${BASENAME}oname${NETWORK_VERSION}
NISNAME=${BASENAME}nis${NETWORK_VERSION}
CDSNAME=${BASENAME}cds${NETWORK_VERSION}
NDSNAME=${BASENAME}nds${NETWORK_VERSION}
LDAPNAME=${BASENAME}ldap${NETWORK_VERSION}
LDAPJNAME=${BASENAME}ldapj${NETWORK_VERSION}
NUJNINAME=${BASENAME}jni${NETWORK_VERSION}
NZJSNAME=${BASENAME}zjs${NETWORK_VERSION}
JSSLNAME=${BASENAME}jssl${NETWORK_VERSION}
WSSNAME=${BASENAME}twss${NETWORK_VERSION}

NMPNAME=${BASENAME}nmp${NETWORK_VERSION}

TANAME=${BASENAME}ta${NETWORK_VERSION}
TALNAME=${BASENAME}tal${NETWORK_VERSION}


SNLPTDUM         =  $(NETWORKLIB)snlptdum.$(OBJ_EXT) 
OSNTABST         = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT            = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

LIBNETWORK	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBTHINNCR       =  $(NETWORKLIB)$(LIB_PREFIX)$(ROTNAME).$(LIB_EXT)

LOC_LIBNUJNI     =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(LIB_EXT)
LOC_LIBJSSL      =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(LIB_EXT)
LIBNUJNI         =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(SO_EXT)
LIBJSSL          =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(SO_EXT)
LIBLDAPJ         =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(SO_EXT)
LOC_LIBLDAPJ     =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(LIB_EXT)

LIBNCR           =  $(NETWORKLIB)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LIBNFP           =  $(NETWORKLIB)$(LIB_PREFIX)$(CMNAME).$(LIB_EXT)
LIBNI            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNSGR          =  $(NETWORKLIB)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LIBNSGL          =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRNAME).$(LIB_EXT)
LIBNSGLC         =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRCNAME).$(LIB_EXT)
LOC_LIBNGSM      =  $(NETWORKLIB)$(LIB_PREFIX)$(GSMNAME).$(LIB_EXT)
LIBNGSM          =  $(NETWORKLIB)$(LIB_PREFIX)$(GSMNAME).$(SO_EXT)
LOC_LIBNGSMSHD   =  $(NETWORKLIB)$(LIB_PREFIX)$(GSMSHDNAME).$(LIB_EXT)
LOC_LIBNWSS   =  $(NETWORKLIB)$(LIB_PREFIX)$(WSSNAME).$(LIB_EXT)

LLIBNCR           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)
LLIBNFP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CMNAME)$(ILIB_SUFFIX)
LLIBNI            =  $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)
LLIBNSGR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)
LLIBNSGL          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRNAME)$(ILIB_SUFFIX)
LLIBNSGLC         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRCNAME)$(ILIB_SUFFIX)
LLIBNGSM          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(GSMNAME)$(ILIB_SUFFIX)
LLIBNGSMSHD       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(GSMSHDNAME)$(ILIB_SUFFIX)
LLIBNWSS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(WSSNAME)$(ILIB_SUFFIX)



LIBNTT           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LIBNTTAIO        =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(SO_EXT)
LOC_LIBNTTAIO    =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(LIB_EXT)
LOC_LIBNTVI      =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(LIB_EXT)
LIBNTVI          =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(SO_EXT)
LOC_LIBNTEVQ     =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(LIB_EXT)
LIBNTEVQ         =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(SO_EXT)
LIBNTZ           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME).$(LIB_EXT)
LIBNTZSTUB       =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME)_std.$(LIB_EXT)
LIBNTS           =  $(NETWORKLIB)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LIBNTD           =  $(NETWORKLIB)$(LIB_PREFIX)$(DECNETNAME).$(LIB_EXT)
LIBNTOD          =  $(NETWORKLIB)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LIBCDS           =  $(NETWORKLIB)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LIBNTLU62        =  $(NETWORKLIB)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LIBNTTLI	 =  $(NETWORKLIB)$(LIB_PREFIX)$(TLINAME).$(LIB_EXT)
LIBNTUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(USNAME).$(LIB_EXT)
LIBNTSHM         =  $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME).$(LIB_EXT)
LIBNTP           =  $(NETWORKLIB)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNTNP          =  $(NETWORKLIB)$(LIB_PREFIX)$(NMPNAME).$(LIB_EXT)
LIBNTMQ          =  $(NETWORKLIB)$(LIB_PREFIX)$(MQNAME).$(LIB_EXT)
LIBNWSS          =  $(NETWORKLIB)$(LIB_PREFIX)$(WSSNAME).$(LIB_EXT)

LLIBNTT           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)
LLIBNTVI          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(VINAME)$(ILIB_SUFFIX)
LLIBNTEVQ         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(QUENAME).$(ILIB_SUFFIX)
LLIBNTZ           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPSNAME)$(ILIB_SUFFIX)
LLIBNTS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)
LLIBNTD           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DECNETNAME)$(ILIB_SUFFIX)
LLIBNTOD          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)
LLIBCDS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)
LLIBNTLU62        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)
LLIBNTTLI	 =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TLINAME)$(ILIB_SUFFIX)
LLIBNTUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(USNAME)$(ILIB_SUFFIX)
LLIBNTSHM        = $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME)$(ILIB_SUFFIX)
LLIBNTP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(BEQNAME)$(ILIB_SUFFIX)
LLIBNTNP          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NMPNAME)$(ILIB_SUFFIX)
LLIBNTMQ          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(MQNAME)$(ILIB_SUFFIX)
LLIBNWSS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(WSSNAME)$(ILIB_SUFFIX)

LIBNL1           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBNL2           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LIBNL            =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LLIBNL           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NLNAME)$(ILIB_SUFFIX)


LIBNUAPI         =  $(NETWORKLIB)$(LIB_PREFIX)$(TANAME).$(LIB_EXT)
LIBNULOCAL       =  $(NETWORKLIB)$(LIB_PREFIX)$(TALNAME).$(LIB_EXT)

LLIBNUAPI         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)


LLIBNUAPI	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)
LLIBSSL          = #$(LDLIBFLAG)$(ILIB_PREFIX)sslref-bsafe$(ILIB_SUFFIX)
LLIBNZJS 	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(NZJSNAME)$(ILIB_SUFFIX)

LIBNA            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAE           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAU           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMP           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCI          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNFG          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNG           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNPL           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNR            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNS            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNTR           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBSSLREF 	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBZT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)


LIBNZJS          =  $(NETWORKLIB)$(LIB_PREFIX)$(NZJSNAME).$(LIB_EXT)

LIBNLNV          =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LDAPSYSLIBD = $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTNAME).$(LIB_EXT)
LDAPSYSLIBS = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBLDAPCLNTNAME)$(ILIB_SUFFIX)

COMMONSHNAME=$(BASENAME)sh$(NETWORK_VERSION)
NLSHNAME=$(BASENAME)lsh$(NETWORK_VERSION)
LDAPSHNAME=$(BASENAME)ldapsh$(NETWORK_VERSION)
ROSHNAME=$(BASENAME)rosh$(NETWORK_VERSION)
LIBNETWORKSH=$(NETWORKLIB)$(LIB_PREFIX)$(COMMONSHNAME).$(SO_EXT)
LIBNLSH=$(NETWORKLIB)$(LIB_PREFIX)$(NLSHNAME).$(SO_EXT)
LIBLDAPSH=$(NETWORKLIB)$(LIB_PREFIX)$(LDAPSHNAME).$(SO_EXT)
LIBRPCSH=$(NETWORKLIB)$(LIB_PREFIX)$(ROSHNAME).$(SO_EXT)
LLIBNETWORKSH=$(LDLIBFLAG)$(COMMONSHNAME)$(ILIB_SUFFIX)
LLIBNLSH=$(LDLIBFLAG)$(NLSHNAME)$(ILIB_SUFFIX)
LLIBLDAPSH=$(LDLIBFLAG)$(LDAPSHNAME)$(ILIB_SUFFIX)
LLIBRPCSH=$(LDLIBFLAG)$(ROSHNAME)$(ILIB_SUFFIX)
# Exiting SRCHOME/network/libnames.mk

# Exiting SRCHOME/network/adapters.mk

LIBNTTCP     = $(LIBHOME)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LLIBNTTCP    = $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)

LIBNTOD      = $(LIBHOME)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LLIBNTOD     = $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)

LIBCDS       = $(LIBHOME)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LLIBCDS      = $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)

LIBNTLU62    = $(LIBHOME)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LLIBNTLU62   = $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)

LIBNTS       = $(LIBHOME)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LLIBNTS      = $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)

LIBNETWORK   = $(LIBHOME)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LLIBNETWORK  = $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)

LIBNSGR      = $(LIBHOME)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LLIBNSGR     = $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)

LIBNGSMSHD   = $(LIBHOME)$(LIB_PREFIX)$(GSMSHDNAME).$(LIB_EXT)
LLIBNGSMSHD  = $(LDLIBFLAG)$(ILIB_PREFIX)$(GSMSHDNAME)$(ILIB_SUFFIX)

LIBSQLNET  = $(LDFLAGSFILE) $(PROTOCOLLIBD) $(NATIVELIBD) $(NATIVESYSLIBD) $(LIBNSGR) $(LIBNZJS) $(LIBNETWORK) $(LIBNL) $(LLIBNGSMSHD)
LLIBSQLNET = $(LDFLAGSLIST) $(PROTOCOLLIBS) $(NATIVELIBS) $(NATIVESYSLIBS) $(LLIBNCRYPT) $(LLIBNSGR) $(LLIBNZJS) $(LLIBNETWORK) $(LLIBNL) $(LLIBNGSMSHD)

LIBRPC       = $(LIBHOME)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LLIBRPC      = $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)

TNSLSNR	     = $(BINHOME)tnslsnr$(EXE_SUFFIX)
LSNRCTL	     = $(BINHOME)lsnrctl$(EXE_SUFFIX)

NIGTAB       = $(LIBHOME)nigtab.$(OBJ_EXT)
NIGCON       = $(LIBHOME)nigcon.$(OBJ_EXT) 
NTCONTAB     = $(LIBHOME)ntcontab.$(OBJ_EXT)
MTS_NCR	     = $(LIBHOME)ncrstab.$(OBJ_EXT)

OSNTABST     = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT        = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

NAETAB       = $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS	     = $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB_OBJ   = nautab.$(OBJ_EXT)
NAUTAB	     = $(LIBHOME)$(NAUTAB_OBJ)

NETLIBS      = $(LLIBSQLNET) $(LLIBRPC) $(LLIBSQLNET)
NETLIBD      = $(LIBSQLNET) $(LIBRPC)

LDFLAGSFILE=$(LIBHOME)ldflags
LDFLAGSLIST=`$(CAT) $(LDFLAGSFILE)`

LIBNTP       = $(LIBHOME)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNL        = $(LIBHOME)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)


# Entering SRCHOME/network/s_exports.mk


NAETAB64	= $(LIBHOME)naeet.$(OBJ_EXT) $(LIBHOME)naect.$(OBJ_EXT)
NAEDHS64	= $(LIBHOME)naedhs.$(OBJ_EXT)
NAUTAB64	= $(LIBHOME)$(NAUTAB_OBJ)


# Exiting SRCHOME/network/s_exports.mk
# Exiting SRCHOME/network/exports.mk

LPFLAGS+=$(BANNERDEFINES)


# Entering SRCHOME/network/libnames.mk

NETWORK_VERSION=$(LIBMAJORVSN)
BASENAME=n
NETWORKLIB=$(NETWORKHOME)$(LIBDIR)/
NETWORKJLIB=$(NETWORKHOME)$(JLIBDIR)/

COMMONNAME=${BASENAME}${NETWORK_VERSION}
NLNAME=${BASENAME}l${NETWORK_VERSION}
TCPNAME=${BASENAME}tcp${NETWORK_VERSION}
QUENAME=${BASENAME}que${NETWORK_VERSION}
DECNETNAME=${BASENAME}dec${NETWORK_VERSION}
LU62NAME=${BASENAME}lu62${NETWORK_VERSION}
MBNAME=${BASENAME}mb${NETWORK_VERSION}
DCENAME=${BASENAME}dce${NETWORK_VERSION}
BEQNAME=${BASENAME}beq${NETWORK_VERSION}
IPCNAME=${BASENAME}ipc${NETWORK_VERSION}
SPXNAME=${BASENAME}spx${NETWORK_VERSION}
TLINAME=${BASENAME}tli${NETWORK_VERSION}
TLITNAME=${BASENAME}tlit${NETWORK_VERSION}
TLISNAME=${BASENAME}tlis${NETWORK_VERSION}
TLIDNAME=${BASENAME}tlid${NETWORK_VERSION}
USNAME=${BASENAME}us${NETWORK_VERSION}
MQNAME=${BASENAME}tmq${NETWORK_VERSION}
SHMNAME=${BASENAME}shm${NETWORK_VERSION}
TCPSNAME=${BASENAME}tcps${NETWORK_VERSION}
CRYPTNAME=${BASENAME}crypt${NETWORK_VERSION}
TCPAIONAME=${BASENAME}tcpaio${NETWORK_VERSION}
NSGRNAME=${BASENAME}sgr${NETWORK_VERSION}
GSMNAME=${BASENAME}gsm${NETWORK_VERSION}
GSMSHDNAME=${BASENAME}gsmshd${NETWORK_VERSION}
LSNRNAME=${BASENAME}lsnr${NETWORK_VERSION}
LSNRCNAME=${BASENAME}lsnrc${NETWORK_VERSION}
RONAME=${BASENAME}ro${NETWORK_VERSION}
ROCNAME=${BASENAME}roc${NETWORK_VERSION}
ROXNAME=${BASENAME}rox${NETWORK_VERSION}
ROTNAME=${BASENAME}rot${NETWORK_VERSION}
CMNAME=${BASENAME}cm${NETWORK_VERSION}
NHOSTNAME=${BASENAME}host${NETWORK_VERSION}
TNSNAME=${BASENAME}tns${NETWORK_VERSION}
ORACLENAME=${BASENAME}oname${NETWORK_VERSION}
NISNAME=${BASENAME}nis${NETWORK_VERSION}
CDSNAME=${BASENAME}cds${NETWORK_VERSION}
NDSNAME=${BASENAME}nds${NETWORK_VERSION}
LDAPNAME=${BASENAME}ldap${NETWORK_VERSION}
LDAPJNAME=${BASENAME}ldapj${NETWORK_VERSION}
NUJNINAME=${BASENAME}jni${NETWORK_VERSION}
NZJSNAME=${BASENAME}zjs${NETWORK_VERSION}
JSSLNAME=${BASENAME}jssl${NETWORK_VERSION}
WSSNAME=${BASENAME}twss${NETWORK_VERSION}

NMPNAME=${BASENAME}nmp${NETWORK_VERSION}

TANAME=${BASENAME}ta${NETWORK_VERSION}
TALNAME=${BASENAME}tal${NETWORK_VERSION}


SNLPTDUM         =  $(NETWORKLIB)snlptdum.$(OBJ_EXT) 
OSNTABST         = $(NETWORKLIB)osntabst.$(OBJ_EXT)
NNFGT            = $(NETWORKLIB)nnfgt.$(OBJ_EXT)

LIBNETWORK	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBTHINNCR       =  $(NETWORKLIB)$(LIB_PREFIX)$(ROTNAME).$(LIB_EXT)

LOC_LIBNUJNI     =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(LIB_EXT)
LOC_LIBJSSL      =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(LIB_EXT)
LIBNUJNI         =  $(NETWORKLIB)$(LIB_PREFIX)$(NUJNINAME).$(SO_EXT)
LIBJSSL          =  $(NETWORKLIB)$(LIB_PREFIX)$(JSSLNAME).$(SO_EXT)
LIBLDAPJ         =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(SO_EXT)
LOC_LIBLDAPJ     =  $(NETWORKLIB)$(LIB_PREFIX)$(LDAPJNAME).$(LIB_EXT)

LIBNCR           =  $(NETWORKLIB)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)
LIBNFP           =  $(NETWORKLIB)$(LIB_PREFIX)$(CMNAME).$(LIB_EXT)
LIBNI            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNSGR          =  $(NETWORKLIB)$(LIB_PREFIX)$(NSGRNAME).$(LIB_EXT)
LIBNSGL          =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRNAME).$(LIB_EXT)
LIBNSGLC         =  $(NETWORKLIB)$(LIB_PREFIX)$(LSNRCNAME).$(LIB_EXT)
LOC_LIBNGSM      =  $(NETWORKLIB)$(LIB_PREFIX)$(GSMNAME).$(LIB_EXT)
LIBNGSM          =  $(NETWORKLIB)$(LIB_PREFIX)$(GSMNAME).$(SO_EXT)
LOC_LIBNGSMSHD   =  $(NETWORKLIB)$(LIB_PREFIX)$(GSMSHDNAME).$(LIB_EXT)
LOC_LIBNWSS   =  $(NETWORKLIB)$(LIB_PREFIX)$(WSSNAME).$(LIB_EXT)

LLIBNCR           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(RONAME)$(ILIB_SUFFIX)
LLIBNFP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CMNAME)$(ILIB_SUFFIX)
LLIBNI            =  $(LDLIBFLAG)$(ILIB_PREFIX)$(COMMONNAME)$(ILIB_SUFFIX)
LLIBNSGR          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NSGRNAME)$(ILIB_SUFFIX)
LLIBNSGL          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRNAME)$(ILIB_SUFFIX)
LLIBNSGLC         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LSNRCNAME)$(ILIB_SUFFIX)
LLIBNGSM          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(GSMNAME)$(ILIB_SUFFIX)
LLIBNGSMSHD       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(GSMSHDNAME)$(ILIB_SUFFIX)
LLIBNWSS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(WSSNAME)$(ILIB_SUFFIX)



LIBNTT           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPNAME).$(LIB_EXT)
LIBNTTAIO        =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(SO_EXT)
LOC_LIBNTTAIO    =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPAIONAME).$(LIB_EXT)
LOC_LIBNTVI      =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(LIB_EXT)
LIBNTVI          =  $(NETWORKLIB)$(LIB_PREFIX)$(VINAME).$(SO_EXT)
LOC_LIBNTEVQ     =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(LIB_EXT)
LIBNTEVQ         =  $(NETWORKLIB)$(LIB_PREFIX)$(QUENAME).$(SO_EXT)
LIBNTZ           =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME).$(LIB_EXT)
LIBNTZSTUB       =  $(NETWORKLIB)$(LIB_PREFIX)$(TCPSNAME)_std.$(LIB_EXT)
LIBNTS           =  $(NETWORKLIB)$(LIB_PREFIX)$(SPXNAME).$(LIB_EXT)
LIBNTD           =  $(NETWORKLIB)$(LIB_PREFIX)$(DECNETNAME).$(LIB_EXT)
LIBNTOD          =  $(NETWORKLIB)$(LIB_PREFIX)$(DCENAME).$(LIB_EXT)
LIBCDS           =  $(NETWORKLIB)$(LIB_PREFIX)$(CDSNAME).$(LIB_EXT)
LIBNTLU62        =  $(NETWORKLIB)$(LIB_PREFIX)$(LU62NAME).$(LIB_EXT)
LIBNTTLI	 =  $(NETWORKLIB)$(LIB_PREFIX)$(TLINAME).$(LIB_EXT)
LIBNTUS          =  $(NETWORKLIB)$(LIB_PREFIX)$(USNAME).$(LIB_EXT)
LIBNTSHM         =  $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME).$(LIB_EXT)
LIBNTP           =  $(NETWORKLIB)$(LIB_PREFIX)$(BEQNAME).$(LIB_EXT)
LIBNTNP          =  $(NETWORKLIB)$(LIB_PREFIX)$(NMPNAME).$(LIB_EXT)
LIBNTMQ          =  $(NETWORKLIB)$(LIB_PREFIX)$(MQNAME).$(LIB_EXT)
LIBNWSS          =  $(NETWORKLIB)$(LIB_PREFIX)$(WSSNAME).$(LIB_EXT)

LLIBNTT           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPNAME)$(ILIB_SUFFIX)
LLIBNTVI          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(VINAME)$(ILIB_SUFFIX)
LLIBNTEVQ         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(QUENAME).$(ILIB_SUFFIX)
LLIBNTZ           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TCPSNAME)$(ILIB_SUFFIX)
LLIBNTS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(SPXNAME)$(ILIB_SUFFIX)
LLIBNTD           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DECNETNAME)$(ILIB_SUFFIX)
LLIBNTOD          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(DCENAME)$(ILIB_SUFFIX)
LLIBCDS           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(CDSNAME)$(ILIB_SUFFIX)
LLIBNTLU62        =  $(LDLIBFLAG)$(ILIB_PREFIX)$(LU62NAME)$(ILIB_SUFFIX)
LLIBNTTLI	 =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TLINAME)$(ILIB_SUFFIX)
LLIBNTUS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(USNAME)$(ILIB_SUFFIX)
LLIBNTSHM        = $(NETWORKLIB)$(LIB_PREFIX)$(SHMNAME)$(ILIB_SUFFIX)
LLIBNTP           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(BEQNAME)$(ILIB_SUFFIX)
LLIBNTNP          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NMPNAME)$(ILIB_SUFFIX)
LLIBNTMQ          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(MQNAME)$(ILIB_SUFFIX)
LLIBNWSS          =  $(LDLIBFLAG)$(ILIB_PREFIX)$(WSSNAME)$(ILIB_SUFFIX)

LIBNL1           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LIBNL2           =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LIBNL            =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
LLIBNL           =  $(LDLIBFLAG)$(ILIB_PREFIX)$(NLNAME)$(ILIB_SUFFIX)


LIBNUAPI         =  $(NETWORKLIB)$(LIB_PREFIX)$(TANAME).$(LIB_EXT)
LIBNULOCAL       =  $(NETWORKLIB)$(LIB_PREFIX)$(TALNAME).$(LIB_EXT)

LLIBNUAPI         =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL       =  $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)


LLIBNUAPI	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TANAME)$(ILIB_SUFFIX)
LLIBNULOCAL	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(TALNAME)$(ILIB_SUFFIX)
LLIBSSL          = #$(LDLIBFLAG)$(ILIB_PREFIX)sslref-bsafe$(ILIB_SUFFIX)
LLIBNZJS 	 = $(LDLIBFLAG)$(ILIB_PREFIX)$(NZJSNAME)$(ILIB_SUFFIX)

LIBNA            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAE           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNAU           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNMP           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNCI          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNFG          =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNNG           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNPL           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNR            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNS            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBNTR           =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBSSLREF 	 =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
LIBZT            =  $(NETWORKLIB)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)


LIBNZJS          =  $(NETWORKLIB)$(LIB_PREFIX)$(NZJSNAME).$(LIB_EXT)

LIBNLNV          =  $(NETWORKLIB)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)

LDAPSYSLIBD = $(LIBHOME)$(LIB_PREFIX)$(LIBLDAPCLNTNAME).$(LIB_EXT)
LDAPSYSLIBS = $(LDLIBFLAG)$(ILIB_PREFIX)$(LIBLDAPCLNTNAME)$(ILIB_SUFFIX)

COMMONSHNAME=$(BASENAME)sh$(NETWORK_VERSION)
NLSHNAME=$(BASENAME)lsh$(NETWORK_VERSION)
LDAPSHNAME=$(BASENAME)ldapsh$(NETWORK_VERSION)
ROSHNAME=$(BASENAME)rosh$(NETWORK_VERSION)
LIBNETWORKSH=$(NETWORKLIB)$(LIB_PREFIX)$(COMMONSHNAME).$(SO_EXT)
LIBNLSH=$(NETWORKLIB)$(LIB_PREFIX)$(NLSHNAME).$(SO_EXT)
LIBLDAPSH=$(NETWORKLIB)$(LIB_PREFIX)$(LDAPSHNAME).$(SO_EXT)
LIBRPCSH=$(NETWORKLIB)$(LIB_PREFIX)$(ROSHNAME).$(SO_EXT)
LLIBNETWORKSH=$(LDLIBFLAG)$(COMMONSHNAME)$(ILIB_SUFFIX)
LLIBNLSH=$(LDLIBFLAG)$(NLSHNAME)$(ILIB_SUFFIX)
LLIBLDAPSH=$(LDLIBFLAG)$(LDAPSHNAME)$(ILIB_SUFFIX)
LLIBRPCSH=$(LDLIBFLAG)$(ROSHNAME)$(ILIB_SUFFIX)
# Exiting SRCHOME/network/libnames.mk

PRODUCT=network

NETWORKSRC=$(NETWORKHOME)src/
NETWORKMESG=$(NETWORKHOME)mesg/

SNLPTDUM=$(NETWORKLIB)snlptdum.$(OBJ_EXT)
NAUDIR=$(NETWORKSRC)nau/

GSMMON    = $(NETWORKBIN)gsmmon$(EXE_SUFFIX)
GSMPING   = $(NETWORKBIN)gsmping$(EXE_SUFFIX)
GSMOCI    = $(NETWORKBIN)gsmoci$(EXE_SUFFIX)
GSMOPXY   = $(NETWORKBIN)gsmopxy$(EXE_SUFFIX)
GSMONSC   = $(NETWORKBIN)gsmonsc$(EXE_SUFFIX)
CMGW      = $(NETWORKBIN)cmgw$(EXE_SUFFIX)
CMADMIN   = $(NETWORKBIN)cmadmin$(EXE_SUFFIX)
CMCTL     = $(NETWORKBIN)cmctl$(EXE_SUFFIX)
CMMIGR    = $(NETWORKBIN)cmmigr$(EXE_SUFFIX)
LSNRCTL   = $(NETWORKBIN)lsnrctl$(EXE_SUFFIX)
TNSLSNR   = $(NETWORKBIN)tnslsnr$(EXE_SUFFIX)
NAMESCTL  = $(NETWORKBIN)namesctl$(EXE_SUFFIX)
NLUIDGEN  = $(NETWORKBIN)nluidgen$(EXE_SUFFIX)
SNTPTEST  = $(NETWORKBIN)sntptest$(EXE_SUFFIX)
TRCROUTE  = $(NETWORKBIN)trcroute$(EXE_SUFFIX)
TESTSTRIP = $(NETWORKBIN)teststrip$(EXE_SUFFIX)
TNGSMTL1  = $(NETWORKBIN)tngsmtl1$(EXE_SUFFIX)
TNGSMUIT  = $(NETWORKBIN)tngsmuit$(EXE_SUFFIX)
TNLAD     = $(NETWORKBIN)tnlad$(EXE_SUFFIX)
TNLDS     = $(NETWORKBIN)tnlds$(EXE_SUFFIX)
TNLER     = $(NETWORKBIN)tnler$(EXE_SUFFIX)
TNLFI     = $(NETWORKBIN)tnlfi$(EXE_SUFFIX)
TNLFN     = $(NETWORKBIN)tnlfn$(EXE_SUFFIX)
TNLGH     = $(NETWORKBIN)tnlgh$(EXE_SUFFIX)
TNLNV     = $(NETWORKBIN)tnlnv$(EXE_SUFFIX)
TNLPA     = $(NETWORKBIN)tnlpa$(EXE_SUFFIX)
TNLTS     = $(NETWORKBIN)tnlts$(EXE_SUFFIX)
TNLIN   = $(NETWORKBIN)tnlin$(EXE_SUFFIX)
TNLTRCHK  = $(NETWORKBIN)tnltrchk$(EXE_SUFFIX)
TNLSTDG   = $(NETWORKBIN)tnlstdg$(EXE_SUFFIX)
TSETPRM   = $(NETWORKBIN)tsetprm$(EXE_SUFFIX)
TNITS     = $(NETWORKBIN)tnits$(EXE_SUFFIX)
TNNTS     = $(NETWORKBIN)tnnts$(EXE_SUFFIX)
TNSLSNR_HASTST = $(NETWORKBIN)tnslsnr_hastst$(EXE_SUFFIX)

S0NGSMM      =$(NETWORKLIB)s0ngsmm.$(OBJ_EXT)
NGSMM        =$(NETWORKLIB)ngsmm.$(OBJ_EXT)
NGSMMI       =$(NETWORKLIB)ngsmmi.$(OBJ_EXT)
S0NGSMP      =$(NETWORKLIB)s0ngsmp.$(OBJ_EXT)
S0NGSMOC     =$(NETWORKLIB)s0ngsmoc.$(OBJ_EXT)
NGSMP        =$(NETWORKLIB)ngsmp.$(OBJ_EXT)
NGSMOC       =$(NETWORKLIB)ngsmoc.$(OBJ_EXT)
NGSMOCC       =$(NETWORKLIB)ngsmocc.$(OBJ_EXT)
NGSMOC1      =$(NETWORKLIB)ngsmoc1.$(OBJ_EXT)
S0NGSMO      =$(NETWORKLIB)s0ngsmo.$(OBJ_EXT)
NGSMO        =$(NETWORKLIB)ngsmo.$(OBJ_EXT)
S0NGSMON     =$(NETWORKLIB)s0ngsmon.$(OBJ_EXT)
NGSMON       =$(NETWORKLIB)ngsmon.$(OBJ_EXT)
S0NSPING     =$(NETWORKLIB)s0nsping.$(OBJ_EXT)
NSPING       =$(NETWORKLIB)nsping.$(OBJ_EXT)
S0NSGL       =$(NETWORKLIB)s0nsgl.$(OBJ_EXT)
S0NSGLC      =$(NETWORKLIB)s0nsglc.$(OBJ_EXT)
SNSGLP       =$(NETWORKLIB)snsglp.$(OBJ_EXT)
S0NFPGW      =$(NETWORKLIB)s0nfpg.$(OBJ_EXT)
S0NFPC       =$(NETWORKLIB)s0nfpc.$(OBJ_EXT)
S0NFPA       =$(NETWORKLIB)s0nfpa.$(OBJ_EXT)
S0NFPR       =$(NETWORKLIB)s0nfpr.$(OBJ_EXT)
S0NUE        =$(NETWORKLIB)s0nue.$(OBJ_EXT)
S0NUR        =$(NETWORKLIB)s0nur.$(OBJ_EXT)
NUR          =$(NETWORKLIB)nur.$(OBJ_EXT)
S0SNTPTEST   =$(NETWORKLIB)sntptest.$(OBJ_EXT)
NAEDHSD	     =$(NETWORKLIB)naedhsd.$(OBJ_EXT)
S0NTISMN     =$(NETWORKLIB)s0ntismn.$(OBJ_EXT)
S0NTSPXC     =$(NETWORKLIB)s0ntspxc.$(OBJ_EXT)
S0NTLOBT     =$(NETWORKLIB)ntlobt.$(OBJ_EXT)
S0NTTPB      =$(NETWORKLIB)s0nttpb.$(OBJ_EXT)

COMMONLIBD=$(LIBNI) $(LIBNFP) $(LIBNSGR) \
             $(LIBNSGL) $(LIBNSGI) \
             $(LIBNETV2) \
             $(PROTOCOLLIBD) $(LIBSSLREF) $(LIBNETWORK) \
             $(LIBRPC) $(LIBEPC) $(PROTOCOLLIBD) $(ANOLIBD) \
             $(NATIVELIBD) $(LIBSSLREF)

LOCALNETLIBS=$(LLIBNL)   \
             $(PROTOCOLLIBS) $(LLIBNETWORK) \
             $(LLIBNSGL) $(LLIBNSGLC) $(LLIBNSGR) \
             $(LLIBNFP) \
             $(LLIBRPC) $(LLIBNETWORK) $(PROTOCOLLIBS) \
             $(LLIBEPC) $(LLIBNL) \
             $(LLIBNSGL) $(LLIBNSGLC) \
             $(LLIBNFP) \
             $(LLIBNETWORK) $(ANOLIBS) $(NATIVELIBS) \
             $(LLIBSSL) 

LLIBONS=$(LDLIBFLAG)$(ILIB_PREFIX)ons$(ILIB_SUFFIX)

LOCALNETLIBD=$(COMMONLIBD)

STATICNETLIBD=$(COMMONLIBD)

GSMMON_LINKLINE=$(LINK) $(S0NGSMM) $(NGSMM) $(NGSMMI) $(LINKTTLIBS) $(LOCALNETLIBS) $(LLIBNGSM)
GSMPING_LINKLINE=$(LINK) $(S0NGSMP) $(NGSMP) $(LINKTTLIBS) $(LOCALNETLIBS) $(LLIBNGSM)
GSMOCI_LINKLINE=$(LINK) $(S0NGSMOC) $(NGSMOC) $(NGSMOCC) $(NGSMOC1) $(LINKTTLIBS) $(LOCALNETLIBS) $(LLIBNGSM)
GSMONSC_LINKLINE=$(LINK) $(S0NGSMON) $(NGSMON) $(LINKTTLIBS) $(LOCALNETLIBS) $(LLIBONS) $(LLIBNGSM)
GSMOPXY_LINKLINE=$(LINK) $(S0NGSMO) $(NGSMO) $(NGSMO1) $(LINKTTLIBS) $(LOCALNETLIBS) $(LLIBONS) $(LLIBNGSM)
CMGW_LINKLINE=$(LINK) $(S0NFPGW) $(LINKTTLIBS) $(LOCALNETLIBS)
CMADMIN_LINKLINE=$(LINK) $(S0NFPA) $(LOCALNETLIBS)\
                $(LOCALNETLIBS) $(LLIBONS) $(LINKTTLIBS) 
CMCTL_LINKLINE=$(LINK) $(S0NFPC) $(LINKTTLIBS) $(LOCALNETLIBS) $(LOCALNETLIBS)
CMMIGR_LINKLINE=$(LINK) $(S0NFPR) $(LINKTTLIBS) $(LOCALNETLIBS) $(LLIBCORE)
SNTPTEST_LINKLINE=$(LINK) $(S0SNTPTEST) $(LINKLDLIBS)
OKLIST_LINKLINE=$(LINK) $(NETWORKLIB)snauk5pt.$(OBJ_EXT) \
		$(NETWORKLIB)s0nauk5l.$(OBJ_EXT) \
		$(LINKTTLIBS) $(KERBEROS_LIB)
OKINIT_LINKLINE=$(LINK) $(NETWORKLIB)snauk5pt.$(OBJ_EXT) \
		$(NETWORKLIB)s0nauk5i.$(OBJ_EXT) \
		$(LINKTTLIBS) $(KERBEROS_LIB)
OKDSTRY_LINKLINE=$(LINK) $(NETWORKLIB)snauk5pt.$(OBJ_EXT) \
		$(NETWORKLIB)s0nauk5d.$(OBJ_EXT) \
		$(LINKTTLIBS) $(KERBEROS_LIB)
NPLITEST_LINKLINE=$(LDCCOM) $(NETWORKSRC)npl/s0tnpl.$(OBJ_EXT) \
	$(NETWORKSRC)npl/stnpl.$(OBJ_EXT) $(NETWORKSRC)npl/tnpl.$(OBJ_EXT) \
	$(TTLIBS)
NAEDAC_LINKLINE=$(LDCCOM) $(NETWORKSRC)nae/s0naedac.$(OBJ_EXT) \
	$(NETWORKSRC)nae/naedac.$(OBJ_EXT) $(LIBNAE) $(TTLIBS)
TNSLSNR_OFILES=$(S0NSGL) $(SNSGLP)
TNSLSNR_LINKLINE=$(LINK) $(TNSLSNR_OFILES) $(LINKTTLIBS) $(LLIBONS) \
                 $(LOCALNETLIBS) $(MATHLIB) $(TNSLSNR_THREADLIB) 
TNSLSNR_HASTST_LINKLINE=$(LINK) $(TNSLSNR_OFILES) $(LINKTTLIBS) $(LLIBONS) \
                 $(LOCALNETLIBS) $(MATHLIB) $(TNSLSNR_THREADLIB) $(LLIBHASGEN) \
	         $(LLIBOCR) $(LLIBOCRUTL) $(LLIBSKGXN) $(LLIBCLSRA) $(LLIBDBCFG)
LSNRCTL_OFILES=$(S0NSGLC)
LSNRCTL_LINKLINE=$(LINK) $(LSNRCTL_OFILES) $(LINKTTLIBS) $(LOCALNETLIBS) $(MATHLIB)
ORAPBIND_OFILES=$(S0NTTPB)
ORAPBIND_LINKLINE=$(LINK) $(ORAPBIND_OFILES) $(SYSLIBS)
TNSPING_LINKLINE=$(LINK) $(S0NSPING) $(NSPING) $(LINKTTLIBS)
TRCROUTE_LINKLINE=$(LINK) $(S0NUR) $(NUR) $(LINKTTLIBS)


LDRUNFLAG=-R

INSTALL_GSM_TARGS=ilibngsm igsmmon igsmping igsmoci igsmonsc igsmopxy
INSTALL_CMAN_TARGS=icmctl icmadmin icmgw icmmigr
INSTALL_NAU_TARGS=ioklist iokinit iokdstry ientrust
INSTALL_NET_CLIENT_TARGS=itrcroute itnsping
INSTALL_NET_SERVER_TARGS=itnslsnr ilsnrctl

INSTALL_LDSHLIB=$(LD) $(LDFLAGS) -h $@ -G
INSTALL_LDZFLAGSPRE=-z text -z allextract
INSTALL_LDZFLAGSPOST=-z defaultextract -z defs
INSTALL_LDRUNFLAG=-R

# Entering SRCHOME/network/s_network.mk


ASFLAGS_SHIP=$(ASFLAGS64) -o

LLAIO=-laio
LLIBTHREAD=-lthread

GENNT=assemble
DIRSEPARATOR = /

INSTALL_NAU_TARGS=ioklist iokinit iokdstry


INSTALL_CMAN_TARGS+= iorapbind


DEPDIRS=-L $(ORACLE_HOME)/rdbms/lib \
  -L $(ORACLE_HOME)/plsql/lib \
  -L $(ORACLE_HOME)/encryption/lib \
  -L $(ORACLE_HOME)/ldap/lib 

libnsh$(NETWORK_VERSION)LIBS=$(DEPDIRS) $(NAUTAB) $(NAETAB) $(LLIBGENERICSH) \
  $(LLIBCOMMONSH) \
  $(LLIBNCRYPTSH) $(LLIBLDAPSH) $(LLIBRPCSH) \
  $(LLIBNTP) $(LLIBNTT) $(LLIBNTZ) $(LLIBNTUS) \
  $(LLIBHOST) $(LLIBONAMES) $(LLIBNIS) $(LLIBTNS) \
  $(LLIBLDAPCLNTSH) $(LLIBNLSH) $(LLIBNMS) $(LLIBNMSP) $(LLIBPEER) \
  $(LLIBCORE_SH) $(LLIBNLSSH) -lnsl -lsocket -lm -lc
libnsh$(NETWORK_VERSION)EXTRALIBS=$(DEF_OPT) $(LLIBUNLSSH) $(LLIBSNLSSH) $(LIBXMLSH) \
  $(LLIBCLIENTSH) $(LLIBPLSSH) $(LLIBGENERICSH) $(LLIBCOMMONSH) \
  $(LLIBCLIENTSH) $(LLIBNNETSH) $(LLIBXMLSH) -lkstat -ldl

libnlsh$(NETWORK_VERSION)LIBS=$(DEPDIRS) $(LLIBNETWORKSH) $(LLIBLDAPSH) $(LLIBCORE_SH) \
  $(LLIBNLSSH) -lsocket -lnsl -ldl -lc
libnlsh$(NETWORK_VERSION)EXTRALIBS=$(NNZ_DEP)

libnldapsh$(NETWORK_VERSION)LIBS=$(DEPDIRS) $(LLIBLDAPCLNTSH) \
  $(LLIBNETWORKSH) $(LLIBNLSH) $(LLIBCORE_SH) -lc
libnldapsh$(NETWORK_VERSION)EXTRALIBS=$(NNZ_DEP)

libnrosh$(NETWORK_VERSION)LIBS=$(DEPDIRS) $(LLIBNLSH) $(LLIBNETWORKSH) $(LLIBCORE_SH) \
  -lnsl -lsocket -lc
libnrosh$(NETWORK_VERSION)EXTRALIBS=$(NNZ_DEP)

BSLIBNETWORKSH=$(BOOTSTRAPLIB)$(LIB_PREFIX)$(COMMONSHNAME).$(SO_EXT)
BSLIBNLSH=$(BOOTSTRAPLIB)$(LIB_PREFIX)$(NLSHNAME).$(SO_EXT)
BSLIBLDAPSH=$(BOOTSTRAPLIB)$(LIB_PREFIX)$(LDAPSHNAME).$(SO_EXT)
BSLIBRPCSH=$(BOOTSTRAPLIB)$(LIB_PREFIX)$(ROSHNAME).$(SO_EXT)

CUS_BOOTSTRAPLIBS=$(BSLIBNETWORKSH) $(BSLIBNLSH) $(BSLIBLDAPSH) \
$(BSLIBRPCSH)

OHLIBNETWORK=$(LIBHOME)$(LIB_PREFIX)$(COMMONNAME).$(LIB_EXT)
OHLIBNL=$(LIBHOME)$(LIB_PREFIX)$(NLNAME).$(LIB_EXT)
OHLIBLDAP=$(LIBHOME)$(LIB_PREFIX)$(LDAPNAME).$(LIB_EXT)
OHLIBRPC=$(LIBHOME)$(LIB_PREFIX)$(RONAME).$(LIB_EXT)

LOC_LIBNETWORKSH=$(NETWORKLIB)$(LIB_PREFIX)$(COMMONSHNAME).$(LIB_EXT)
LOC_LIBNLSH=$(NETWORKLIB)$(LIB_PREFIX)$(NLSHNAME).$(LIB_EXT)
LOC_LIBLDAPSH=$(NETWORKLIB)$(LIB_PREFIX)$(LDAPSHNAME).$(LIB_EXT)
LOC_LIBRPCSH=$(NETWORKLIB)$(LIB_PREFIX)$(ROSHNAME).$(LIB_EXT)

OHLIBNETWORKSH=$(LIBHOME)$(LIB_PREFIX)$(COMMONSHNAME).$(SO_EXT)
OHLIBNLSH=$(LIBHOME)$(LIB_PREFIX)$(NLSHNAME).$(SO_EXT)
OHLIBLDAPSH=$(LIBHOME)$(LIB_PREFIX)$(LDAPSHNAME).$(SO_EXT)
OHLIBRPCSH=$(LIBHOME)$(LIB_PREFIX)$(ROSHNAME).$(SO_EXT)

S_SHLIB_NGSMDEF=$(NM) -gp $(LOC_LIBNGSM) | $(GREP) T | $(GREP) ngsm \
        | $(AWK) '{ print "-u " $$3 }' > \
        $(LIBHOME)$(LIB_PREFIX)$(GSMNAME).$(DEF_EXT)

S_SHLIB_NGSMLINK=$(SHLIB_NGSMDEF); \
        $(INSTALL_LDSHLIB) \
        `$(CAT) $(LIBHOME)$(LIB_PREFIX)$(GSMNAME).$(DEF_EXT)` \
        $(INSTALL_LDZFLAGSPRE) $(INSTALL_LDZFLAGSPOST) $(LOC_LIBNGSM) \
        $(LDRUNFLAG) $(LDPATHFLAG)$(LIBHOME) \
        $(LOC_LIBNGSM) $(SUIDLINKTTLIBS); \
        $(RM) $(LIBHOME)$(LIB_PREFIX)$(GSMNAME).$(DEF_EXT)

CFLAGS_SHIP += $(LDOBJSZ) 

# Exiting SRCHOME/network/s_network.mk
# Exiting network.mk
# Entering s_cus_ntwk.mk



SNMPFLAG     =  -DORACLE_SNMP_PEER
SNMPSUFFIX   =  peer
LSNMPLIB     =  -lnmsp
SNMPLIB      =  $(LIBNMSP)
SNMPAGENTLIB =  $(LLIBPEER)

# Exiting s_cus_ntwk.mk
# Entering SRCHOME/buildtools/mkfile/libclntsh.mk
$(LIBCLNTSH_NPT) $(LIBCLNTSH): ${LIBHOME}libclient12.$(LIB_EXT) ${LIBHOME}libsql12.$(LIB_EXT) \
	${LIBHOME}libntcp12.$(LIB_EXT)	${LIBHOME}libn12.$(LIB_EXT) \
        ${LIBHOME}libnl12.$(LIB_EXT)	${LIBHOME}libnldap12.$(LIB_EXT) \
        ${LIBHOME}libnhost12.$(LIB_EXT)	${LIBHOME}libntns12.$(LIB_EXT) \
        ${LIBHOME}libnoname12.$(LIB_EXT) ${LIBHOME}libnus12.$(LIB_EXT) \
        ${LIBHOME}libntcps12.$(LIB_EXT)	${LIBHOME}libnro12.$(LIB_EXT) \
	${LIBHOME}libcommon12.$(LIB_EXT)\
	${LIBHOME}libgeneric12.$(LIB_EXT) ${LIBHOME}libmm.$(LIB_EXT)\
	${LIBHOME}libnls12.$(LIB_EXT)	${LIBHOME}libcore12.$(LIB_EXT)\
	${RDBMSLIB}xaondy.$(OBJ_EXT)
	$(SILENT)$(ECHO) "Building client shared library libclntsh.$(SO_EXT) ..."
	$(SILENT)$(ECHO) "Call script $$ORACLE_HOME/bin/genclntsh ..."
	$(GENCLNTSH) -all
	$(SILENT)$(ECHO) "Built $$ORACLE_HOME/${LIBDIR}/libclntsh.$(SO_EXT) ... DONE"

ALLSHLIBS=$(VARLIBS) $(LD_SHLIBS) $(DLOPENLIBS) $(NEW_LD_SHLIBS) $(NEW_DLOPENLIBS)
shlibs: $(ALLSHLIBS)
bootstraplibs: $(CUS_BOOTSTRAPLIBS)

$(LD_SHLIBS) ld_shlibs_target: $(ALWAYS)
	$(RMF) $@
	$(CUS_SHLIB_COMMAND)

$(DLOPENLIBS) dlopenlibs_target: $(ALWAYS)
	$(RMF) $@
	$(CUS_DLOPENLIB_COMMAND)

$(NEW_LD_SHLIBS) new_ld_shlibs_target: $(ALWAYS)
	$(RMF) $@
	$(CUS_NEW_SHLIB_COMMAND)

$(NEW_DLOPENLIBS) new_dlopenlibs_target: $(ALWAYS)
	$(RMF) $@
	$(CUS_NEW_DLOPENLIB_COMMAND)

$(VARLIBS) varlibs_target: $(ALWAYS)
	$(RMF) $@
	$(CUS_VARLIB_COMMAND)

$(CUS_BOOTSTRAPLIBS) bootstraplib_target: $(ALWAYS)
	$(RMF) $@
	$(CUS_BOOTSTRAPLIB_COMMAND)

ld_shlib:
	$(LD_SHLIB_COMMAND)

dlopenlib:
	$(DLOPENLIB_COMMAND)

new_ld_shlib:
	$(NEW_LD_SHLIB_COMMAND)

new_dlopenlib:
	$(NEW_DLOPENLIB_COMMAND)

bootstrap:
	$(BOOTSTRAPLIB_COMMAND)

always:

oh_link_shlibs: $(OHSO_TARGETS)
$(OHSO_TARGETS) oh_link_shlibs_target: always
	$(OH_LINK_SHLIB_COMMAND)

prod_link_shlibs: $(PRODSO_TARGETS)
$(PRODSO_TARGETS) pl_link_shlibs_target: always
	$(PROD_LINK_SHLIB_COMMAND)

echo_shlib_lists:
	$(SILENT)$(ECHO) VARLIBS: $(VARLIBS) $(SPACE2NEWLINE)
	$(SILENT)$(ECHO) LD_SHLIBS: $(LD_SHLIBS) $(SPACE2NEWLINE)
	$(SILENT)$(ECHO) DLOPENLIBS: $(DLOPENLIBS) $(SPACE2NEWLINE)
	$(SILENT)$(ECHO) NEW_LD_SHLIBS: $(NEW_LD_SHLIBS) $(SPACE2NEWLINE)
	$(SILENT)$(ECHO) NEW_DLOPENLIBS: $(NEW_DLOPENLIBS) $(SPACE2NEWLINE)
	$(SILENT)$(ECHO) OHSO_TARGETS: $(OHSO_TARGETS) $(SPACE2NEWLINE)
	$(SILENT)$(ECHO) PRODSO_TARGETS: $(PRODSO_TARGETS) $(SPACE2NEWLINE)
# Exiting SRCHOME/buildtools/mkfile/libclntsh.mk
