$ECHO "Performing root user operation."

$ECHO ""
$ECHO "The following environment variables are set as:"
$ECHO "    ORACLE_OWNER= $ORACLE_OWNER"
$ECHO "    ORACLE_HOME=  $ORACLE_HOME"

#
# Get name of local bin directory
#

saveLBIN=$LBIN
retry='r'
surewrite='y'

DBHOME=$ORACLE_HOME/bin/dbhome
ORAENV=$ORACLE_HOME/bin/oraenv
CORAENV=$ORACLE_HOME/bin/coraenv
FILES="$DBHOME $ORAENV $CORAENV"

if [ ! -w $LBIN ]
then
  surewrite='n'
fi

if [ `$UNAME` = "AIX" -a "$surewrite" = "y" ]
then
# check write-able by copying 1 file first
  $CP $DBHOME $LBIN > /dev/null 2>&1
  if [ $? -ne 0 ]
  then
    surewrite='n'
  fi
fi


while [ "$retry" = "r" ]
do
  if [ $SILENT -eq 0 ]
  then
    LBIN=$saveLBIN
    $ECHO ""
    $ECHO $N "Enter the full pathname of the local bin directory: $C"
    DEFLT=${LBIN}; . $ORACLE_HOME/install/utl/read.sh; LBIN=$RDVAR
  fi

  if [ ! -d $LBIN ];then
    $ECHO "Creating ${LBIN} directory..."
    $MKDIR -p ${LBIN} 2>&1
    $CHMOD 755 ${LBIN} 2>&1
  fi

  if [ -w $LBIN ]
  then
    surewrite='y'
  else
    surewrite='n'
  fi

  if [ `$UNAME` = "AIX" -a "$surewrite" = "y" ]
  then
  # check write-able by copying 1 file first
    $CP $DBHOME $LBIN > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
      surewrite='n'
    fi
  fi

  if [ "$surewrite" = "n" ]
  then
    if [ $SILENT -eq 0 ]
    then
      $ECHO ""
      $ECHO $N "$LBIN is read only.  Continue without copy (y/n) or retry (r)? $C"
      DEFLT='y' ; . $ORACLE_HOME/install/utl/read.sh ; retry=$RDVAR
    else
      retry='y'  # continue without copy
    fi
  else
    retry='y'
  fi
done
if [ "$retry" = "n" ] ; then
  $ECHO "Warning: Script terminated by user."
  exit 1
fi

#
# Move files to LBIN, and set permissions
#

if [ "$surewrite" = "y" ]
then
  for f in $FILES ; do
    if [ -f $f ] ; then
      $CHMOD 755 $f  2>&1 2>> $LOG
      short_f=`$ECHO $f | $SED 's;.*/;;'`
      lbin_f=$LBIN/$short_f
      if [ -f $lbin_f -a $SILENT -eq 0 ] ; then
        DIFF_STATUS=`$DIFF $f $lbin_f`
        if [ $? -ne 0 ] ; then
          # The contents of $lbin_f and $f are different (User updated $lbin_f)
          # Prompt user before overwriting $lbin_f.
          $ECHO $n "The file \"$short_f\" already exists in $LBIN.  Overwrite it? (y/n) $C"
          DEFLT='n'; . $ORACLE_HOME/install/utl/read.sh; OVERWRITE=$RDVAR
        else
          # The contents of $lbin_f and $f are identical. Don't overwrite.
          $ECHO "The contents of \"$short_f\" have not changed. No need to overwrite."
          OVERWRITE='n';        
        fi
      else
        OVERWRITE='y';
      fi
      if [ "$OVERWRITE" = "y" -o "$OVERWRITE" = "Y" ] ; then
        $CP $f $LBIN  2>&1 2>>  $LOG
        $CHMOD 755 $lbin_f  2>&1 2>> $LOG
        $ECHO "   Copying $short_f to $LBIN ..."
      fi
    fi
  done
else
  $ECHO ""
  $ECHO "Warning: $LBIN is read only. No files will be copied."
fi
$ECHO ""


#
# Make sure an oratab file exists on this system
#

# Variable to determine whether oratab is new or not; default is true
NEW="true"

if [ ! -s ${ORATAB} ];then
  $ECHO "" 
  $ECHO "Creating ${ORATAB} file..."
  if [ ! -d ${ORATABLOC} ];then
    $MKDIR -p ${ORATABLOC}
  fi

  $CAT <<!>> ${ORATAB}
#



# This file is used by ORACLE utilities.  It is created by root.sh
# and updated by either Database Configuration Assistant while creating
# a database or ASM Configuration Assistant while creating ASM instance.

# A colon, ':', is used as the field terminator.  A new line terminates
# the entry.  Lines beginning with a pound sign, '#', are comments.
#
# Entries are of the form:
#   \$ORACLE_SID:\$ORACLE_HOME:<N|Y>:
#
# The first and second fields are the system identifier and home
# directory of the database respectively.  The third field indicates
# to the dbstart utility that the database should , "Y", or should not,
# "N", be brought up at system boot time.
#
# Multiple entries with the same \$ORACLE_SID are not allowed.
#
#
!

else
# Oratab file exists; this is not a new installation on this system.
# We check if temporary install/oratab exists, and then check if the entry
# in temporary install/oratab has been added to the oratab file.
# In case of patchset this is usually the case, and we don't want to reappend
# the same entry to oratab again.
  if [ -f $ORACLE_HOME/install/oratab ]
  then
    TMP_ENTRY=`$GREP "${ORACLE_HOME}" $ORACLE_HOME/install/oratab`

    FOUND=`$GREP "${TMP_ENTRY}" ${ORATAB}`
    if [ -n "${FOUND}" ]
    then
      NEW="false"
    fi
  fi
fi

$CHOWN $ORACLE_OWNER:$OSDBA_GROUP ${ORATAB}
$CHMOD 664 ${ORATAB}

#
# If there is an old entry with no sid and same oracle home,
# that entry will be marked as a comment.
#

FOUND_OLD=`$GREP "^*:${ORACLE_HOME}:" ${ORATAB}`
if [ -n "${FOUND_OLD}" ];then
  $SED -e "s?^*:$ORACLE_HOME:?# *:$ORACLE_HOME:?" $ORATAB > $TMPORATB
  $CAT $TMPORATB > $ORATAB
  $RM -f $TMPORATB 2>/dev/null
fi


$ECHO "Entries will be added to the ${ORATAB} file as needed by"
$ECHO "Database Configuration Assistant when a database is created"

#
# Append the dbca temporary oratab entry to oratab
# In the case of ASM and RAC install, oratab is not yet created when root.sh
# is run, so we need to check for its existence before attempting to append it.
#
if [ -f $ORACLE_HOME/install/oratab -a $NEW = "true" ]
then
  $CAT $ORACLE_HOME/install/oratab >> $ORATAB
fi

$ECHO "Finished running generic part of root script."
$ECHO "Now product-specific root actions will be performed."
