# 
# $Header: install/utl/scripts/db/modmakedeps.pl.pp /main/2 2012/01/05 04:48:23 pvenkatr Exp $
#
# modmakedeps.pl
# 
# Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      modmakedeps.pl - change (disable or enable) optional components
#
#    DESCRIPTION
#      this perl script is invoked by ORACLE_HOME/bin/relink (shell script) 
#      it checks the state of the options in an ORACLE_HOME in order to
#      replace values in a makedeps.xml file, which is used for relinking
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    pvenkatr    11/15/11 - Bug 13326065
#    dschrein    04/20/10 - creation
#

use File::Compare;

my $ORACLE_HOME = shift;
my $infile = shift;
my $SO_EXT = 'so';
my $VERSION = '12';
my $AR_CMD = '/usr/ccs/bin/ar';

# initial hash populated with options from libknlopt
my %opts_hash = ( 'kcsm.o' => 'rac_off/rac_on',
                  'kzlilbac.o' => 'lbac_off/lbac_on',
                  'kzvidv.o' => 'dv_off/dv_on',
                  'kxmwsd.o' => 'sdo_off/sdo_on',
                  'xsyeolap.o' => 'olap_off/olap_on',
                  'kkpoban.o' => 'part_off/part_on',
                  'dmwdm.o' => 'dm_off/dm_on',
                  'kecwr.o' => 'rat_off/rat_on',
                  'ksnkcs.o' => 'rac_on/rac_off',
                  'kzlnlbac.o' => 'lbac_on/lbac_off',
                  'kzvndv.o' => 'dv_on/dv_off',
                  'kxmnsd.o' => 'sdo_on/sdo_off',
                  'xsnoolap.o' => 'olap_on/olap_off',
                  'ksnkkpo.o' => 'part_on/part_off',
                  'dmndm.o' => 'dm_on/dm_off',
                  'kecnr.o' => 'rat_on/rat_off',
                  'jox.o' => 'jox_on/jox_off' );

# add some additional entries to the has that are not defined
# in libknlopt

my $libskgxp = "$ORACLE_HOME/lib/libskgxp$VERSION.$SO_EXT";
my $libskgxpd = "$ORACLE_HOME/lib/libskgxpd.$SO_EXT";
my $libskgxpr = "$ORACLE_HOME/lib/libskgxpr.$SO_EXT";
my $libskgxpg = "$ORACLE_HOME/lib/libskgxpg.$SO_EXT";

if ( compare ( $libskgxp, $libskgxpg ) == 0 ) {
    $other_replace_strings{'ipc_[a-z]+'} = 'ipc_g';
}
elsif ( compare ( $libskgxp, $libskgxpr ) == 0 ) {
    $other_replace_strings{'ipc_[a-z]+'} = 'ipc_rds';
}
elsif ( compare ( $libskgxp, $libskgxpd ) == 0 ) {
    $other_replace_strings{'ipc_[a-z]+'} = 'ipc_none';
}

# query the home's libknlopt for current options
open KNLOPTS, "$AR_CMD t $ORACLE_HOME/rdbms/lib/libknlopt.a|" or die "couldn't open pipe: $!";
my @knlopts = <KNLOPTS>;
chomp @knlopts;
close KNLOPTS;

# loop through the input file, assumed to be makeorder.xml
open INFILE, "<$infile" or die "couldn't open $infile:$!";
while ( <INFILE> ) {
    my $opt;
    # modify all lines according to the options found in knlopt
    foreach $opt ( @knlopts ) {
        if ( exists $opts_hash{$opt} ) {
            my ( $old, $new ) = split /\//, $opts_hash{$opt};
            s/$old/$new/g;
        }
    }
    # modify all lines according to the other options 
    my ( $old, $new );
    while ( ( $old, $new ) = each %other_replace_strings ) {
        s/$old/$new/g;
    }

    # print original or modified line
    print;
}
close INFILE;
