#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/remove_cvuresource_baseline.sh /main/3 2015/10/28 14:47:43 spavan Exp $
#
# remove_cvuresource_baseline.sh
#
# Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      remove_cvuresource_baseline.sh - remove baseline xmls from cvu resource
#
#    DESCRIPTION
#      Every time CVU resource runs it generates a baseline xml. Ensure only 5 
#      latest of these files exist and the old ones gets deleted.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    spavan      10/13/15 - fix bug21870934 - change file removed
#    spavan      08/24/15 - fix bug21661076 - fix script
#    mpradeep    01/30/15 - new file for deleting cvures files
#    mpradeep    01/30/15 - Creation
#
#!/bin/ksh
xmlcount=0
for i  in `ls -lt $1/* | awk '{ print $9}'`
do
   xmlcount=`expr $xmlcount + 1 `;
   if [ $xmlcount -gt 5 ];
   then
      rm $i
   fi
done
