#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/ora_07445_errors_analyzer2.sh /main/2 2015/12/22 22:18:56 maboddu Exp $
#
# ora_07445_errors_analyzer2.sh
#
# Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      ora_07445_errors_analyzer2.sh - checks ORA-07445 errors in the alert log
#
#    DESCRIPTION
#      Analyzer script to check for ORA-07445 erorrs in the alert log
#      and this check applicable in pre 11.1 db.
#
#    NOTES
#     
#
#    MODIFIED   (MM/DD/YY)
#    maboddu     12/11/15 - Fix bug#22305002 - fix syntax error
#    nvira       04/21/15 - move the existing check to the new script to be
#                           used for pre 11.1 db
#    nvira       09/05/14 - bug fix 19471722, move the existing check to the
#                           new script to be used for pre 11.1 db
#    nvira       09/05/14 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin


SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

exitStatus=3
dbName=$1
nodeName=$2
instance_id=$3
alert_dest=$4
expectedCount=$5

instance_id=${dbName}"("${instance_id}")"

# Set default exit message to indicate failure.
 result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking for ORA-07445 errors in alert log</EXEC_ERROR><TRACE>Error while checking for ORA-07445 errors in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2924</ID><MSG_DATA><DATA>$dbName</DATA></MSG_DATA></NLS_MSG>"

ret=0
count=0

resultSet="<RESULTSET>"

exitStatus=0

for alert_name in `find "$alert_dest" -name 'alert_*.log' 2>/dev/null`
do
  command="grep -i 'ORA-07445' $alert_name|wc -l"
  tempCount=`/bin/sh -c "$command"`
  ret=$?
  count=`expr $count + $tempCount`
done

if [ $ret -eq 0 ]
then
  if [ $count -le $expectedCount ]
    then
      resultSet=${resultSet}"<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>ORA-07445_ERR_COUNT=$count</COLLECTED><EXPECTED>ORA-07445_ERR_COUNT=$expectedCount</EXPECTED><TRACE>No ORA-07445 errors found in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2922</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$count</DATA><DATA>$expectedCount</DATA><DATA>$alert_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  else
      resultSet=${resultSet}"<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>ORA-07445_ERR_COUNT=$count</COLLECTED><EXPECTED>ORA-07445_ERR_COUNT=$expectedCount</EXPECTED><TRACE>ORA-07445 errors found in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2923</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$count</DATA><DATA>$expectedCount</DATA><DATA>$alert_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  fi   
else
  resultSet=${resultSet}"<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking for ORA-07445 errors in alert log</EXEC_ERROR><TRACE>Error while checking for ORA-07445 errors in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2924</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
fi   

resultSet=${resultSet}"</RESULTSET>"

echo $resultSet
exit $exitStatus
