#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/ora_00600_errors_analyzer.sh /main/5 2015/12/22 22:18:55 maboddu Exp $
#
# ora_00600_errors_analyzer.sh
#
# Copyright (c) 2010, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      ora_00600_errors_analyzer.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      Analyzer script to check for ORA-00600 erorrs in the alert log
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    maboddu     12/11/15 - Fix bug#22305002 - fix syntax error
#    nvira       10/27/14 - Backport nvira_bug-19471722 from main
#    nvira       04/10/14 - Backport nvira_bug-17315187 from main
#    nvira       01/29/14 - bug fix 17315187, use Java to execute analyzer
#                           script on remote nodes
#    nvira       10/05/10 - script to analyze ora 00600 errors
#    nvira       10/05/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin


SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

exitStatus=3
dbName=$1
nodeName=$2
instance_name=$3
diagnostic_dest=$4
expectedCount=$5

alert_dest=${diagnostic_dest}"/diag/rdbms/"${dbName}"/"${instance_name}"/alert/"

instance_id=${dbName}"("${instance_name}")"


# Set default exit message to indicate failure.
 result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking for ORA-00600 errors in alert log</EXEC_ERROR><TRACE>Error while checking for ORA-00600 errors in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2884</ID><MSG_DATA><DATA>$dbName</DATA></MSG_DATA></NLS_MSG>"

ret=0
count=0

resultSet="<RESULTSET>"
exitStatus=0

for alert_name in `find "$alert_dest" -type f  2>/dev/null`
do
  command="grep -i 'ORA-00600' $alert_name|wc -l"
  tempCount=`/bin/sh -c "$command"`
  ret=$?
  count=`expr $count + $tempCount`
done

if [ $ret -eq 0 ]
then
  if [ $count -le $expectedCount ]
    then
      resultSet=${resultSet}"<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>ORA-00600_COUNT=$count</COLLECTED><EXPECTED>ORA-00600_COUNT=$expectedCount</EXPECTED><TRACE>No ORA-00600 errors found in alert log on node $nodeName</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2882</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$count</DATA><DATA>$expectedCount</DATA><DATA>$alert_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  else
      resultSet=${resultSet}"<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>ORA-00600_COUNT=$count</COLLECTED><EXPECTED>ORA-00600_COUNT=$expectedCount</EXPECTED><TRACE>ORA-00600 errors found in alert log on node $nodeName</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2883</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$count</DATA><DATA>$expectedCount</DATA><DATA>$alert_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  fi   
else
  resultSet=${resultSet}"<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking for ORA-00600 errors in alert log</EXEC_ERROR><TRACE>Error while checking for ORA-00600 errors in alert log on node $nodeName</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2884</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
fi   

resultSet=${resultSet}"</RESULTSET>"

echo $resultSet
exit $exitStatus
