#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/localenam_check.sh /main/2 2014/07/21 10:37:38 jgagarci Exp $
#
# localenam_check.sh
#
# Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      localenam_check.sh - checks for North America region (nam) installed on solaris
#
#    DESCRIPTION
#
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jgagarci    07/17/14 - fixbug 19232809 - remove invalid option
#    jgagarci    04/25/14 - fix bug 14607661 - check english locale is
#                           installed in the system
#    jgagarci    04/25/14 - Creation
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin
SECHO="echo"
SGREP="grep"
SAWK="awk"
SUNAME="uname"
SPKG="pkg"
SLOCALEADM="localeadm"
HOSTNAME="hostname"

host=`$HOSTNAME`

SOLARISVERSION=`$SUNAME -X | $SGREP Release | $SAWK '{print$3}' | $SAWK -F'.' '{print$2}'`

if [ $SOLARISVERSION -gt 10 ]
then
# Solaris 11 or higher use pkg instead of
# look for locale.en facets installed in the system
  loc_nam_msgid_ni="10171"
  loc_nam_msgid_ud="10172"
  loc_nam_status=`$SPKG facet -H *locale.en* > /dev/null`
else
# Solaris 10 or lower
# including a "no" print in order to provide an input for localeadm
# in case no configuration file has been created previously for the system.
  loc_nam_msgid_ni="10169"
  loc_nam_msgid_ud="10170"
  loc_nam_status=`echo "no" | $SLOCALEADM -q nam > /dev/null`
fi


# exit code 0, means is installed
# exit code 1, means is not installed
# exit code 2, means undetermined
loc_nam_excode=$?
loc_nam_status_msg="installed"
loc_nam_result=true  #assume English locale is installed on this system

if [ $loc_nam_excode -eq 1 ]
then
  loc_nam_msgid="$loc_nam_msgid_ni"
  loc_nam_status_msg="not installed"
fi

if [ $loc_nam_excode -eq 2 ]
then
  loc_nam_msgid="$loc_nam_msgid_ud"
  loc_nam_status_msg="undetermined"
fi

if [ $loc_nam_excode -ne 0 ]
then
  echo "<RESULT>VFAIL</RESULT><COLLECTED>$loc_nam_status_msg</COLLECTED><EXPECTED>installed</EXPECTED><TRACE>North America region (nam) or English locale is $loc_nam_status_msg on node $host</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>$loc_nam_msgid</ID><MSG_DATA><DATA>$host</DATA></MSG_DATA></NLS_MSG>"
  loc_nam_result=false
fi

if [ $loc_nam_result = true ]
then
  echo "<RESULT>SUCC</RESULT><COLLECTED>$loc_nam_status_msg</COLLECTED><EXPECTED>installed</EXPECTED><TRACE> North America region (nam) or English locale is installed on node $host </TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>10173</ID><MSG_DATA><DATA>$host</DATA></MSG_DATA></NLS_MSG>"
fi

exit 0
