#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/css_reboot_time.sh /main/5 2015/12/22 22:18:55 maboddu Exp $
#
# css_reboot_time.sh
#
# Copyright (c) 2010, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      css_reboot_time.sh - check css reboot time parameter
#
#    DESCRIPTION
#      Pluggable task to veriy the css reboot time parameter
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    maboddu     12/11/15 - Fix bug#22305002 - fix syntax error
#    nvira       09/09/15 - bug fix 21655060, update the incorrect trace
#                           statement
#    spavan      06/15/15 - fix bug20971032 - append crsctl output
#    nvira       08/11/10 - script to check css reboot time
#    nvira       08/11/10 - Creation
#

SCAT="/bin/cat"
SGREP="/bin/grep"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

expected=3
CRS_HOME=$1

# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXPECTED>$expected</EXPECTED><EXEC_ERROR>Error while CSS reboottime settings</EXEC_ERROR><TRACE>Unable to get the CSS reboottime settings on the sytem</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0264</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
existstatus=3


crsctl_command="$CRS_HOME/bin/crsctl get css reboottime"
css_reboot_time=`/bin/sh -c "$crsctl_command"`
ret=$?

if [ $ret -eq 0 ]
then
  command="echo "$css_reboot_time" | sed 's/CRS-4678:\([^0-9]*\)\([0-9]*\)\(.*\)/\2/'"
  css_reboot_time=`/bin/sh -c "$command"`
  if [ $css_reboot_time -eq $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$css_reboot_time</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS reboottime is set to recommended value of $expected on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0262</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=0
  else
    result="<RESULT>VFAIL</RESULT><COLLECTED>$css_reboot_time</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS reboottime is not set to recommended value of $expected on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0263</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=2
  fi   
else
  result="<RESULT>VFAIL</RESULT><COLLECTED>NOT SET</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>Error while getting CSS rebottime on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0264</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG><NLS_MSG><FACILITY>Prvg</FACILITY><ID>2034</ID><MSG_DATA><DATA>$crsctl_command</DATA><DATA>$_HOST</DATA><DATA>$ret</DATA><DATA>$css_reboot_time</DATA></MSG_DATA></NLS_MSG>"
  existstatus=$ret
fi   

echo $result
exit $existstatus
