#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/css_disk_timeout.sh /st_has_pt-cvuotn12201/1 2017/05/02 09:20:28 ptare Exp $
#
# css_disk_timeout.sh
#
# Copyright (c) 2010, 2017, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      css_disk_timeout.sh - check css disk timeout parameter
#
#    DESCRIPTION
#      pluggable task to collect and check CSS disk timeout parameter 
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    ptare       10/18/16 - Backport ptare_bug-24345186 from main
#    ptare       09/22/16 - Fix Bug#24345186 correct the NLS message tags
#    maboddu     12/11/15 - Fix bug#22305002 - fix syntax error
#    spavan      06/15/15 - fix bug20971032 - append crsctl output
#    mpradeep    06/11/15 - 20930314 - Add a check to determine a vendor
#                           cluster
#    dsaggi      10/24/13 - XbranchMerge agorla_bug-13002015 from st_has_11.2.0
#    nvira       08/11/10 - script to check css disk timeout
#    nvira       08/11/10 - Creation
#

SCAT="/bin/cat"
SGREP="/bin/grep"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

existstatus=3
expected=200
CRS_HOME=$1

#determine presence of vendor clusterware on SunOS or HP-UX and set the
#reference value accordingly
vcluster=1 #holds zero if vendor cluster is present

comm=$CRS_HOME/bin/lsnodes
check_vcluster=`/bin/sh -c "$comm"`
ret=$?

if [ $ret -eq 0 ]
 then
   vcluster=0
fi

if [ $vcluster -eq 0 ]
then
  expected=597
fi

# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXPECTED>$expected</EXPECTED><EXEC_ERROR>Error while CSS disktimeout settings</EXEC_ERROR><TRACE>Unable to get the CSS disktimeout settings on the sytem</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0354</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"

crsctl_command="$CRS_HOME/bin/crsctl get css disktimeout"
css_disktimeout=`/bin/sh -c "$crsctl_command"`
ret=$?

if [ $ret -eq 0 ]
then
  command="echo "$css_disktimeout" | sed 's/CRS-4678:\([^0-9]*\)\([0-9]*\)\(.*\)/\2/'"
  css_disktimeout=`/bin/sh -c "$command"`

  if [ $css_disktimeout -eq $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$css_disktimeout</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS disktimeout is set to recommended value of $expected on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0352</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=0
  else
    result="<RESULT>VFAIL</RESULT><COLLECTED>$css_disktimeout</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS disktimeout is not set to recommended value of $expected on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0353</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=2
  fi   
else
  result="<RESULT>VFAIL</RESULT><COLLECTED>NOT SET</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>Error while getting CSS disktimeout settings on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0354</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG><NLS_MSG><FACILITY>Prvg</FACILITY><ID>2034</ID><MSG_DATA><DATA>$crsctl_command</DATA><DATA>$_HOST</DATA><DATA>$ret</DATA><DATA>$css_disktimeout</DATA></MSG_DATA></NLS_MSG>"
  existstatus=$ret
fi   

echo $result
exit $existstatus
