#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/css_diagwait.sh /st_has_pt-cvuotn12201/1 2017/05/02 09:20:28 ptare Exp $
#
# css_diagwait.sh
#
# Copyright (c) 2010, 2017, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      css_diagwait.sh - check value of css diagwait parameter
#
#    DESCRIPTION
#      Pluggable task to collect and check css diagwait parameter value.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    ptare       10/18/16 - Backport ptare_bug-24345186 from main
#    ptare       09/22/16 - Fix Bug#24345186 correct the NLS message tags
#    maboddu     12/11/15 - Fix bug#22305002 - fix syntax error
#    spavan      06/15/15 - fix bug20971032 - append crsctl output
#    nvira       08/09/10 - pluggable script for css diagwait check
#    nvira       08/09/10 - Creation
#

SCAT="/bin/cat"
SGREP="/bin/grep"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

existstatus=3
CRS_HOME=$1
expected=13


# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXPECTED>$expected</EXPECTED><EXEC_ERROR>Error while CSS Diagwait settings</EXEC_ERROR><TRACE>Unable to get the CSS Diagwait settings on the sytem</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0244</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"

crsctl_command="$CRS_HOME/bin/crsctl get css diagwait"
css_diagwait=`/bin/sh -c "$crsctl_command"`
ret=$?

if [ $ret -eq 0 ]
then
  command="echo $css_diagwait | sed 's/CRS-4678:\([^0-9]*\)\([0-9]*\)\(.*\)/\2/'"
  css_diagwait=`/bin/sh -c "$command"`

  if [ $css_diagwait -eq $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$css_diagwait</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS Diagwait is set to recommended value of $expected on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0242</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=0
  else
    result="<RESULT>VFAIL</RESULT><COLLECTED>$css_diagwait</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>CSS Diagwait is not set to recommended value of $expected on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0243</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=2
  fi   
else
  result="<RESULT>VFAIL</RESULT><COLLECTED>NOT SET</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>Error while getting CSS Diagwait settings on $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0244</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG><NLS_MSG><FACILITY>Prvg</FACILITY><ID>2034</ID><MSG_DATA><DATA>$crsctl_command</DATA><DATA>$_HOST</DATA><DATA>$ret</DATA><DATA>$css_diagwait</DATA></MSG_DATA></NLS_MSG>"
  existstatus=$ret
fi   

echo $result
exit $existstatus
