#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/core_dump_dest_analyzer2.sh /main/2 2015/12/22 22:18:55 maboddu Exp $
#
# core_dump_dest_analyzer2.sh
#
# Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      core_dump_dest_analyzer2.sh - checks core_dump_dest has too many 
#                                    old core dump files
#
#    DESCRIPTION
#      Check whether core_dump_dest has too many old core dump files
#      and this check is applicable in pre 11.1 db
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    maboddu     12/11/15 - Fix bug#22305002 - fix syntax error
#    nvira       04/21/15 - move the existing check to the new script to be
#                           used for pre 11.1 db
#    nvira       09/05/14 - bug fix 19471722, move the existing check to the
#                           new script to be used for pre 11.1 db
#    nvira       09/05/14 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin


SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

exitStatus=3
dbName=$1
nodeName=$2
instance_id=$3
cdump_dest=$4
ageInDays=$5
expectedCount=$6

instance_id=${dbName}"("${instance_id}")"

resultSet="<RESULTSET>"
exitStatus=0

tempCount=0
count=0

command="find $cdump_dest -name '*.trc' -mtime +$ageInDays 2>/dev/null |wc -l"
count=`/bin/sh -c "$command"`
ret=$?

if [ $ret -eq 0 ]
then
  if [ $count -le $expectedCount ]
    then
      resultSet=${resultSet}"<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>core_dump_dest not have too many old core dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2872</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$ageInDays</DATA><DATA>$count</DATA><DATA>$expected</DATA><DATA>$cdump_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  else
      resultSet=${resultSet}"<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>core_dump_dest has too many old core dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2873</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$ageInDays</DATA><DATA>$count</DATA><DATA>$expected</DATA><DATA>$cdump_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  fi   
else
  resultSet=${resultSet}"<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking core dump destination</EXEC_ERROR><TRACE>Error while checking background dump destination</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2874</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
fi   

resultSet=${resultSet}"</RESULTSET>"

echo $resultSet
exit $exitStatus

