#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/core_dump_dest_analyzer.sh /main/5 2015/12/22 22:18:55 maboddu Exp $
#
# core_dump_dest_analyzer.sh
#
# Copyright (c) 2010, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      core_dump_dest_analyzer.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      Analyzer to script to check whether core_dump_dest has too many old core dump files
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    maboddu     12/11/15 - Fix bug#22305002 - fix syntax error
#    nvira       10/27/14 - Backport nvira_bug-19471722 from main
#    nvira       04/10/14 - Backport nvira_bug-17315187 from main
#    nvira       01/29/14 - bug fix 17315187, use Java to execute analyzer
#                           script on remote nodes
#    nvira       10/04/10 - shell script to analyze results of core dump dest
#                           sql query
#    nvira       10/04/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin


SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

exitStatus=3
dbName=$1
nodeName=$2
instance_name=$3
diagnostic_dest=$4
ageInDays=$5
expectedCount=$6

cdump_dest=${diagnostic_dest}"/diag/rdbms/"${dbName}"/"${instance_name}"/cdump/"

instance_id=${dbName}"("${instance_name}")"

resultSet="<RESULTSET>"
exitStatus=0

tempCount=0
count=0

command="find $cdump_dest -type f -mtime +$ageInDays 2>/dev/null |wc -l"
count=`/bin/sh -c "$command"`
ret=$?

if [ $ret -eq 0 ]
then
  if [ $count -le $expectedCount ]
    then
      resultSet=${resultSet}"<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>core_dump_dest not have too many old core dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2872</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$ageInDays</DATA><DATA>$count</DATA><DATA>$expected</DATA><DATA>$cdump_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  else
      resultSet=${resultSet}"<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>core_dump_dest has too many old core dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2873</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$ageInDays</DATA><DATA>$count</DATA><DATA>$expected</DATA><DATA>$cdump_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  fi   
else
  resultSet=${resultSet}"<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking core dump destination</EXEC_ERROR><TRACE>Error while checking background dump destination</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2874</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
fi   

resultSet=${resultSet}"</RESULTSET>"

echo $resultSet
exit $exitStatus

