#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/check_tcp_packet_retransmit.sh /main/4 2016/06/19 23:20:45 nvira Exp $
#
# check_tcp_packet_retransmit.sh
#
# Copyright (c) 2010, 2016, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      check_tcp_packet_retransmit.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       06/09/16 - handle tcp out overflow
#    nvira       09/02/10 - script to check tcp packet retransmissions
#    nvira       09/02/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin


SAWK="awk"
SCAT="cat"
SCUT="cut"
SGREP="grep"
SNETSTAT="netstat"
waitSeconds=300
tracelog=""

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
esac


# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking TCP retransmissions</EXEC_ERROR><TRACE>Error while checking TCP retransmissions</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0334</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
existstatus=3
expected=$1

case $PLATFORM in
  SunOS)
    tcpOutDataBytes=`$SNETSTAT -sP tcp|$SGREP tcpOutDataBytes| $SCUT -d= -f3`
    tcpRetransBytes=`$SNETSTAT -sP tcp|$SGREP tcpRetransBytes| $SCUT -d= -f3`
    retrans_rate=`echo "scale =10;$tcpRetransBytes / $tcpOutDataBytes*100"|bc|$SAWK '{print int($1+0.5)}'`
    ret=$?
    if [ $retrans_rate -ge $expected ]
    then
	  # if retransmission rate is greater than the expected, try to get a more accurate picture by collecting the values after 5 min and comparing the delta
      sleep $waitSeconds
      tracelog="Retransmission rate found greater than $expected. Recalculating retransmission rate using the delta after waiting for $waitSeconds seconds. "
      tcpOutDataBytes2=`$SNETSTAT -sP tcp|$SGREP tcpOutDataBytes| $SCUT -d= -f3`
      tcpRetransBytes2=`$SNETSTAT -sP tcp|$SGREP tcpRetransBytes| $SCUT -d= -f3`
      retrans_rate=`echo "scale =10;($tcpRetransBytes2 - $tcpRetransBytes) / ($tcpOutDataBytes2 - $tcpOutDataBytes) * 100"|bc|$SAWK '{print int($1+0.5)}'`
      ret=$?
    fi
  ;;
esac


if [ $ret -eq 0 ]
then
  if [ $retrans_rate -le $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$retrans_rate</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>$tracelog TCP retransmissions rate [$retrans_rate] is not too high on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0332</ID><MSG_DATA><DATA>$retrans_rate</DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=0
  else
    result="<RESULT>WARN</RESULT><COLLECTED>$retrans_rate</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>$tracelog TCP retransmissions rate [$retrans_rate] is too high on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0333</ID><MSG_DATA><DATA>$retrans_rate</DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=2
  fi   
else
  result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking TCP retransmissions</EXEC_ERROR><TRACE>Error while checking TCP retransmissions</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0334</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
  existstatus=3
fi   



echo $result
exit $existstatus
