#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/check_os_sru_version.sh /st_has_pt-cvuotn12201/1 2017/11/21 09:38:34 ptare Exp $
#
# check_os_sru_version.sh
#
# Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      check_os_sru_version.sh - Check that the version of SRU is greater
#      than or equal to the minimum expected version.
#
#    DESCRIPTION
#      Retrieves the current version of OS and compares the version for 
#      the expected SRU number,
#      The Solaris version format is explained below.
#      Header      Value     Comments
#      ------      ------  ------------------------------------------------
#      release     5.11    Release version, for example, Oracle Solaris 11
#      update      1       Update version, for example, Oracle Solaris 11.1
#      sru         20      SRU version
#      reserved    0       Reserved (not currently used)
#      buildid     5       Build number of SRU
#      nightly_id  0       Nightly build number
#     So the version 11.1.20.5.0 implicates 
#     <release>.<update>.<sru>.<buildid>.<nightly_id>
#
#    NOTES
#      Applicable to Solaris Sparc and X64 platforms version 11 and further 
#
#    MODIFIED   (MM/DD/YY)
#    ptare       05/05/17 - Bug#24459291 Introduce a check for minimum SRU
#                           version on Solaris
#    ptare       05/05/17 - Creation
PKG="/bin/pkg"
GREP="/bin/grep"
ECHO="/bin/echo"
HOST=`/bin/hostname`
UNAME="/usr/bin/uname"
CUT="/bin/cut"
EXPECTED_VERSION=$1
EXPECTED_RELEASE=`$ECHO $EXPECTED_VERSION | $CUT -d "." -f1`
EXPECTED_UPDATE=`$ECHO $EXPECTED_VERSION | $CUT -d "." -f2`
EXPECTED_SRU=`$ECHO $EXPECTED_VERSION | $CUT -d "." -f3`
EXPECTED_BLDID=`$ECHO $EXPECTED_VERSION | $CUT -d "." -f4`
EXPECTED_NGHTLY_ID=`$ECHO $EXPECTED_VERSION | $CUT -d "." -f5`
COMMAND=
OUTPUT=

#Assume result to be failure to begin with the comparison.
RESULT=1
CURR_OS_VER=`$UNAME -v`
if [ $? -eq 0 ]
then
  CURR_RELEASE_BRANCH=`$PKG info entire | $GREP "Branch:"`
  if [ $? -eq 0 ]
  then
    CURR_RELEASE=`$ECHO $CURR_OS_VER  | $CUT -d '.' -f1`
    CURR_UPDATE=`$ECHO $CURR_OS_VER | $CUT -d '.' -f2`
    CURR_SRU=`$ECHO $CURR_RELEASE_BRANCH | $CUT -d "." -f4`
    CURR_BLDID=`$ECHO $CURR_RELEASE_BRANCH | $CUT -d "." -f6`
    CURR_NGHTLY_ID=`$ECHO $CURR_RELEASE_BRANCH | $CUT -d "." -f7`
    CURRENT_VERSION="$CURR_RELEASE.$CURR_UPDATE.$CURR_SRU.$CURR_BLDID.$CURR_NGHTLY_ID"
    if [ $CURR_RELEASE -gt $EXPECTED_RELEASE ]
    then
      RESULT=0
    elif [ $CURR_RELEASE -eq $EXPECTED_RELEASE ]
    then
      if [ $CURR_UPDATE -gt $EXPECTED_UPDATE ]
      then
        RESULT=0
      elif  [ $CURR_UPDATE -eq $EXPECTED_UPDATE ]
      then
        if [ $CURR_SRU -gt $EXPECTED_SRU ]
        then
          RESULT=0
        elif [ $CURR_SRU -eq $EXPECTED_SRU ]
        then
          if [ $CURR_BLDID -ge $EXPECTED_BLDID ]
          then
            RESULT=0
          else
            RESULT=1
          fi
        else
          RESULT=1
        fi
      else
        RESULT=1
      fi
    else
      RESULT=1
    fi
  else
    RESULT=2
    COMMAND="$PKG info entire | $GREP \"Branch:\""
    OUTPUT=$CURR_RELEASE_BRANCH
  fi
else
  RESULT=2
  COMMAND="uname -v"
  OUTPUT=$CURR_OS_VER
fi

#Display the results and exit.
if [ $RESULT -eq 0 ]
then
  $ECHO "<RESULT>SUCC</RESULT><EXPECTED>$EXPECTED_VERSION</EXPECTED><COLLECTED>$CURRENT_VERSION</COLLECTED><TRACE>Check for minimum SRU version passed on node $HOST, SRU version was found up to date.</TRACE>"
elif [ $RESULT -eq 1 ]
then
  $ECHO "<RESULT>VFAIL</RESULT><EXPECTED>$EXPECTED_VERSION</EXPECTED><COLLECTED>$CURRENT_VERSION</COLLECTED><TRACE>The verification check for minimum SRU version failed. The existing SRU version $CURRENT_VERSION is not up to date on node $HOST.</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0438</ID><MSG_DATA><DATA>$CURRENT_VERSION</DATA><DATA>$EXPECTED_VERSION</DATA><DATA>$HOST</DATA></MSG_DATA></NLS_MSG>"
else
  $ECHO "<RESULT>EFAIL</RESULT><EXPECTED></EXPECTED><COLLECTED></COLLECTED><TRACE>The verification check minimum SRU version failed with an error while retrieval of current OS version on node $HOST.</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0439</ID><MSG_DATA><DATA>$COMMAND</DATA><DATA>$HOST</DATA><DATA>$OUTPUT</DATA></MSG_DATA></NLS_MSG>"
fi

exit $RESULT

