#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/check_network_packet_reassembly.sh /main/4 2016/06/19 23:20:45 nvira Exp $
#
# check_network_packet_reassembly.sh
#
# Copyright (c) 2010, 2016, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      check_network_packet_reassembly.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       06/09/16 - handle tcp out overflow
#    nvira       09/02/10 - script to check network packet reassembly
#    nvira       09/02/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin

SAWK="awk"
SCAT="cat"
SCUT="cut"
SGREP="grep"
SNETSTAT="netstat"
waitSeconds=300
tracelog=""

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
esac


# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking TCP retransmissions</EXEC_ERROR><TRACE>Error while checking TCP retransmissions</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0344</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
existstatus=3
expected=$1

case $PLATFORM in
  SunOS)
    ipReasmOKs=`$SNETSTAT -sP ip | $SGREP ipReasmOKs| $SCUT -d= -f2| $SAWK '{print $1}'`;
    ipReasmReqds=`$SNETSTAT -sP ip| $SGREP ipReasmReqds| $SCUT -d= -f3`;
    ipReasm=`echo "scale =10;$ipReasmOKs - $ipReasmReqds"|bc`;
    ret=$?
    if [ $ipReasm -gt $expected ]
    then
      #if reassembly rate is greater than the expected, try to get a more accurate picture by collecting the values after 5 min and comparing the delta
      sleep $waitSeconds
      tracelog="Packet reassembly rate found greater than $expected. Recalculating packet reassembly rate using the delta after waiting for $waitSeconds seconds. "
      ipReasmOKs2=`$SNETSTAT -sP ip | $SGREP ipReasmOKs| $SCUT -d= -f2| $SAWK '{print $1}'`;
      ipReasmReqds2=`$SNETSTAT -sP ip| $SGREP ipReasmReqds| $SCUT -d= -f3`;
      ipReasm=`echo "scale =10;($ipReasmOKs2 - $ipReasmOKs) - ($ipReasmReqds2 - $ipReasmReqds)"|bc`;
      ret=$?
    fi
  ;;
esac


if [ $ret -eq 0 ]
then
  if [ $ipReasm -eq $expected ]
  then
    result="<RESULT>SUCC</RESULT><COLLECTED>$ipReasm</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>$tracelog Network packet reassembly not occuring on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0342</ID><MSG_DATA><DATA>$ipReasm</DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=0
  else
    result="<RESULT>WARN</RESULT><COLLECTED>$ipReasm</COLLECTED><EXPECTED>$expected</EXPECTED><TRACE>$tracelog Network packet reassembly occuring on node $_HOST</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0343</ID><MSG_DATA><DATA>$ipReasm</DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
    existstatus=2
  fi   
else
  result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking TCP retransmissions</EXEC_ERROR><TRACE>Error while checking TCP retransmissions</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>0344</ID><MSG_DATA><DATA>$_HOST</DATA></MSG_DATA></NLS_MSG>"
  existstatus=3
fi   


echo $result
exit $existstatus
