#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/check_dax_access.sh /main/1 2015/06/04 14:20:30 spavan Exp $
#
# check_dax_access.sh
#
# Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      check_dax_access.sh - check dax_access privilege on dax enabled hardware
#
#    DESCRIPTION
#      This check is specific to Solaris sparc. There are two modes that this
#      shell script can be executed in:
#      2. -checkPriv - verify user has dax access
#      3. -getfixupdata - get fixup data command
#     
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    spavan      04/07/15 - fix ER20474814 - check dax access
#    spavan      04/07/15 - Creation
#

LSPRIV="/usr/bin/ppriv"
access_privilege="dax_access"
CUT="cut"

#get oracle user
if [ "X$2" = "X" ]; then
   ORACLE_HOME_USER=$USER
else
   ORACLE_HOME_USER=$2
fi

# Get the host name 
HOST=`/usr/bin/hostname`

if [ "X$1" = "X-getfixupdata" ]; then
   echo "$ORACLE_HOME_USER"
else
    $LSPRIV -l ${access_privilege} >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
      echo "<RESULT>SUCC</RESULT><EXPECTED>true</EXPECTED><TRACE>oracle user '${ORACLE_HOME_USER}' has privilege '${access_privilage}'</TRACE>"  
    else
      echo "<RESULT>VFAIL</RESULT><COLLECTED>false</COLLECTE><EXPECTED>true</EXPECTED><TRACE>oracle user '${ORACLE_HOME_USER}' does not have privilege '${access_privilage}'</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>3202</ID><MSG_DATA><DATA>$ORACLE_HOME_USER</DATA><DATA>$access_privilege</DATA><DATA>$HOST</DATA></MSG_DATA></NLS_MSG>"
    fi
fi
