#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/checkIOCPDeviceStatus.sh /main/4 2015/04/22 08:47:14 shshrini Exp $
#
# checkIOCPDeviceStatus.sh
#
# Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      checkIOCPDeviceStatus.sh - check the status of IOCP device
#
#    DESCRIPTION
#      In AIX, the IOCP need to be available on the host for I/O operations.
#      Report error if IOCP status is not Available
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    shshrini    04/10/15 - Fix bug 20803442 - Use cut command directly instead
#                           of using absolute path /usr/bin/cut
#    fjlee       01/23/15 - bug 20225311 - Change /etc/lsdev to /usr/sbin/lsdev
#    maboddu     07/23/14 - Fix bug#19273577 - Use the hostname command to get
#                           the host name
#    maboddu     02/20/14 - Fix bug#18029051 - Check the status of iocp device
#    maboddu     02/20/14 - Creation
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin:/etc

LSDEV="/usr/sbin/lsdev"
SAWK="/bin/awk"
CUT="cut"
HOSTNAME="/usr/bin/hostname"

# Get the host name without domain
HOST=`$HOSTNAME | $CUT -d'.' -f1`

#Check the status of IOCP device
status=`$LSDEV -Cc iocp | $SAWK '{print $2}'`

ret=$?
if [ $ret -eq 0 ]
then
   if [ "$status" = "Available" ] 
   then
      RESULT="<RESULT>SUCC</RESULT><TRACE>IOCP device status is $status</TRACE>"
   else
      RESULT="<RESULT>VFAIL</RESULT><EXPECTED>Available</EXPECTED><TRACE>IOCP device status is $status on node $HOST.</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>10167</ID><MSG_DATA><DATA>$HOST</DATA><DATA>$status</DATA></MSG_DATA></NLS_MSG>"
   fi;
else
   RESULT="<RESULT>WARN</RESULT><EXEC_ERROR>Error while getting the status of IOCP device</EXEC_ERROR><TRACE>Failed to get the IOCP device status</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>10168</ID><MSG_DATA><DATA>$LSDEV</DATA><DATA>$HOST</DATA></MSG_DATA></NLS_MSG>"
fi;


echo $RESULT


