#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/unix/alert_log_file_size_analyzer2.sh /main/1 2015/06/30 14:45:48 nvira Exp $
#
# alert_log_file_size_analyzer2.sh
#
# Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      alert_log_file_size_analyzer2.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       04/21/15 - move the existing check to the new script to be
#                           used for pre 11.1 db
#    nvira       09/05/14 - bug fix 19471722, move the existing check to the
#                           new script to be used for pre 11.1 db
#    nvira       09/05/14 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin

SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

dbName=$1
nodeName=$2
instance_id=$3
alert_dest=$4
expectedSize=$5
expectedCount=0

instance_id=${dbName}"("${instance_id}")"

# Set default exit message to indicate failure.
 result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking the size of alert log file</EXEC_ERROR><TRACE>Error while checking the size of alert log file</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2894</ID><MSG_DATA><DATA>$dbName</DATA></MSG_DATA></NLS_MSG>"
exitStatus=0

resultSet="<RESULTSET>"
exitStatus=0

count=`find $alert_dest -name 'alert*.log' -size +$expectedSize 2>/dev/null|wc -l`
ret=$?

if [ $ret -eq 0 ]
then
  if [ $count -le $expectedCount ]
    then
      resultSet=${resultSet}"<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>Alert log is not too big</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2892</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$expectedSize</DATA><DATA>$count</DATA><DATA>$expectedCount</DATA><DATA>$alert_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  else
      resultSet=${resultSet}"<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>Alert log file is too big and should be rolled over periodically</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2893</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA><DATA>$expectedSize</DATA><DATA>$count</DATA><DATA>$expectedCount</DATA><DATA>$alert_dest</DATA></MSG_DATA></NLS_MSG></RESULT>"
  fi   
else
  resultSet=${resultSet}"<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking for ORA-00600 errors in alert log</EXEC_ERROR><TRACE>Error while checking the size of alert log file</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2894</ID><MSG_DATA><DATA>$nodeName</DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
fi   

resultSet=${resultSet}"</RESULTSET>"

echo $resultSet
exit $exitStatus
