#!/bin/sh
#
# Copyright (c) 2004, 2016, Oracle and/or its affiliates. All rights reserved.

# Build: 110804

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin
export PATH

PLATFORM=`/bin/uname`
case $PLATFORM in
  AIX)
       #Starting release 5.3 AIX does not use LIBPATH but uses LD_LIBRARY_PATH instead.
       #Hence unset LIBPATH variable incase of oslevel >= 5.3 to avoid loading issues. 
       unset LIBPATH 
     ;;
  SunOS)
       #make sure to set the LD_LIBRARY_PATH only to point to ORACLE libraries
       #to avoid loading issues.
       #Append the ORACLE_HOME/lib path in case of rungencmd only.
       if [ "$1" = "-rungencmd" ]
       then
         if [ -n "$ORACLE_HOME" ]
         then
           if [ -n "$LD_LIBRARY_PATH" ]
           then
             LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib/
           else
             LD_LIBRARY_PATH=$ORACLE_HOME/lib/
           fi
         fi
       else
         LD_LIBRARY_PATH=
       fi
       unset LD_LIBRARY_PATH_64
     ;;
esac

DIRNAME=`dirname $0`

# checks if ORA_CRS_HOME has not been set
if [ -n "$ORA_CRS_HOME" ]
then 
   ORA_CRS_HOME=
   export ORA_CRS_HOME
fi

if [ "-getver" = "$1" ]
 then
  EXECTASK_OUT_FILE="$DIRNAME/exectask.$$.out"
  $DIRNAME/exectask "$@" > $EXECTASK_OUT_FILE 2>&1
  EXIT_STATUS=$?
  out=`cat $EXECTASK_OUT_FILE`
  if [ "$EXIT_STATUS" = "0" ]
   then
    echo $out
   else
    echo "<CV_CMD>$0 $@</CV_CMD><CV_VAL>$out</CV_VAL><CV_ERES>$EXIT_STATUS</CV_ERES><CV_ERR></CV_ERR>"
  fi
  rm -rf $EXECTASK_OUT_FILE
else
  exec $DIRNAME/exectask "$@" 
fi
