# 
# $Header: has/install/crsconfig/s_oraolr.pm /unix/2 2015/04/16 02:48:30 xyuan Exp $
#
# s_oraolr.pm
# 
# Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      s_oraolr.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xyuan       04/13/15 - Address noncompliance with the base class
#    sbezawad    12/23/14 - Bug 20019354: Migrate OCR and OLR to new framework
#    sbezawad    12/23/14 - Creation
#

package oraClusterwareComp::oraolr;

use parent 'oraClusterwareComp';

use strict;
use English;
use Carp;
use File::Copy;
use File::Path;
use File::Find;
use File::Basename;
use File::Spec::Functions;

use crsutils;
use s_crsutils;

my $dev_null          = "/dev/null";

#
# Private methods
#

sub s_validate_olrconfig
#------------------------------------------------------------------------------
# Function: Creates local olr config file if it does not exists.
#           It also validates/sets up OLR config if does not exist
# Args    : [0] Complete path of OLR location
#           [1] CRS Home
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $olrlocation = shift;
  my $crshome     = shift;
  my $OLRCONFIG   = $CFG->params('OLRCONFIG');

  trace ("Validating " . $CFG->params('OLRCONFIG') .
         " file for OLR location " . $olrlocation);

  ## @todo Check existing olr.loc file. If it exists, then check value of
  #  olrconfig_loc property. If it's same as the one passed on the call
  #  then go ahead. Else, throw an error msg and quit the installation.
  if (-f $OLRCONFIG)
  {
    trace ("$OLRCONFIG already exists. Backing up " . $OLRCONFIG .
           " to " . $OLRCONFIG . ".orig");
    # Need to remove this once the @todo is implemented.
    copy ($OLRCONFIG, $OLRCONFIG . ".orig") || return FAILED;
  }

  open (OLRCFGFILE, ">$OLRCONFIG") || return FAILED;
  print OLRCFGFILE "olrconfig_loc=$olrlocation\n";
  print OLRCFGFILE "crs_home=$crshome\n";
  close (OLRCFGFILE) || return FAILED;

  #FIXME: This should be moved to add_olr_ocr_vdisks_locs
  if (is_dev_env())
  {
    s_set_ownergroup($CFG->params('ORACLE_OWNER'),
                     $CFG->params('ORA_DBA_GROUP'),
                     $CFG->params('OLRCONFIG'));
  }
  else
  {
    s_set_ownergroup($CFG->SUPERUSER,
                     $CFG->params('ORA_DBA_GROUP'),
                     $CFG->params('OLRCONFIG'));
  }

  s_set_perms ("0644", $CFG->params('OLRCONFIG'));
  trace("Done setting permissions on file " . $CFG->params('OLRCONFIG'));
  return TRUE;
}

sub s_ResetOLR
#------------------------------------------------------------------------------
# Function: Reset OLR
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $bin_dd    = "/bin/dd";
  my $olr_file  = s_get_olr_file("olrconfig_loc");

  trace ("Reset OLR");

  if (-f $olr_file)
  {
    trace("Removing OLR file: $olr_file");
    s_remove_file ("$olr_file");
  }
  else
  {
    trace ("Removing contents from OLR file: $olr_file");
    system ("$bin_dd if=/dev/zero skip=25 bs=4k count=2560 of=$olr_file > $dev_null");
  }
  s_remove_file ($CFG->params('OLRCONFIG'));
  return TRUE;
}

sub s_checkolrbackup
#------------------------------------------------------------------------------
# Function: Check if an OLR backup exists
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $oldolr     = $CFG->params('OLRCONFIG');
  my $oldolrbkp  = $oldolr . ".bkp";

  if (! (-e $oldolrbkp))
  {
    trace("Could not find OLR backup");
    return FALSE;
  }
  return TRUE;
}

sub s_createOldOLR
#------------------------------------------------------------------------------
# Function: Create the olr.loc file pointing to the old home during downgrade
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $crshome = $CFG->oldcrshome;
  my $host = tolower_host();
  $host = $host . ".olr";
  my $olrLoc = catfile($crshome, "cdata", $host);
  my $olrLocFile = $CFG->params('OLRCONFIG');

  if (-e $olrLocFile)
  {
    trace("Removing existing $olrLocFile file");
    s_remove_file($olrLocFile); 
  }
  trace("create olr.loc file pointing to the old home");
  open(my $fh, '>', $olrLocFile) || die(dieformat(207, $olrLocFile, $!));
  print $fh "olrconfig_loc=$olrLoc\n";
  print $fh "crs_home=$crshome";
  close $fh;

  if (is_dev_env())
  {
    s_set_ownergroup($CFG->params('ORACLE_OWNER'),
                     $CFG->params('ORA_DBA_GROUP'),
                     $olrLocFile);
  }
  else
  {
    s_set_ownergroup($CFG->SUPERUSER,
                     $CFG->params('ORA_DBA_GROUP'),
                     $olrLocFile);
  }

  s_set_perms ("0644", $olrLocFile);
  trace("Done setting permissions '0644' on file " . $olrLocFile);

  return TRUE;
}

1;
