# 
# $Header: has/install/crsconfig/s_orachm.pm /unix/2 2015/08/20 14:21:42 agutman Exp $
#
# s_orachm.pm
# 
# Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      s_orachm.pm - port specific subroutines of CHM
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    agutman     08/19/15 - Enabling zLinux
#    shullur     06/12/15 - For migrating CHM subroutines
#    shullur     06/12/15 - Creation
# 

package oraClusterwareComp::orachm;

use parent 'oraClusterwareComp';

use strict;
use English;
use Carp;
use File::Copy;
use File::Path;
use File::Find;
use File::Basename;
use File::Spec::Functions;

use crsutils;
use s_crsutils;


sub s_isCHMSupported
#-----------------------------------------------------------------------------
# Function: Check if CHM is supported on this platform
# Returns : TRUE if supported else FALSE
#-----------------------------------------------------------------------------
{
  my $osysmond     = catfile ($CFG->ORA_CRS_HOME, "bin", "osysmond");
  if ($^O =~ /linux|solaris|aix/i) {
    my $mach =`uname -m`;
    chomp($mach);

    if (! (-e $osysmond)) {
      trace ("Cluster Health Monitor osysmond not found");
      return FALSE;
    }
    else
    {
      return TRUE;
    }
  }
  trace ("Cluster Health Monitor not supported on this platform");
  return FALSE;
}

sub s_chm_check_bdbloc
{
  my $bdbloc = $_[0];

  trace("CHM/OS repository location checks: $bdbloc");

  # check for existence first
  if (! -d $bdbloc)
  {
    trace("INFO: CHM/OS repository path $bdbloc does not exist. Creating...\n");
    mkpath($bdbloc);
  }

  if (! -w $bdbloc)
  {
    trace("INFO: CHM/OS repository path $bdbloc is not writable, changing ");
    trace("permissions on it...\n");
    s_set_perms ("0755", $bdbloc);
  }

  # check for space now. df -k reports 1K blocks on linux/solaris.
  # Check for 2GB per node.
  my $rqrd;
  my $nodelist = $_[1];
  my $df;

  # For storing the df -k/bdf index as it is same on Linux, Solaris,
  # HPUX but different on AIX. In AIX it is 3rd column for available
  # space where as in others it is 4
  my $avail_index;

  if ($^O =~ /aix/i)
  {
    $avail_index = 2;
  }
  else
  {
    $avail_index = 3;
  }

  # Linux and Solaris has df command but HPUX doesn't have it.
  # For fixing Bug 11675864. HPUX uses bdf comand.

  if ($^O =~ /hpux/i)
  {
    $df =  "/usr/bin/bdf";
  }
  else
  {
    $df = "/bin/df -k";
  }

  chomp($nodelist);
  my @hosts = split(/[,]+/, $nodelist);
  my $tlang = $ENV{LANG};
  $ENV{LANG} = "";

  $rqrd = 1024*1024;

  if (open(DFH, "$df $bdbloc 2>/dev/null |"))
  {
    $ENV{LANG} = $tlang;
    my $fulline="";
    while (<DFH>)
    {
      chomp();
      if (!($_ =~ m/Filesystem.*/i))
      {
        $fulline .= $_;
      }
    }
    close DFH;
    my @parts = split(/[ \n]+/, $fulline);
    my $avl = $parts[$avail_index];
    if ($avl < $rqrd)
    {
      print_error(216, $bdbloc);
      trace ("Insufficient free space available in CHM/OS repository $bdbloc;" .
            "required space is $rqrd KB and available space is $avl KB;" .
            " run 'oclumon manage -repos reploc <new_path>' command to change" .
            " CHM/OS");
      return 12; #correct error code for out of space.
    }
    $rqrd += $rqrd/3;
    if ($avl < $rqrd)
    {
      trace("WARNING: File system hosting the CHM/OS repository $bdbloc is");
      trace(" running low on disk space. Available disk space=$avl KB. ");
    }
  }
  $ENV{LANG} = $tlang;
}

sub s_chm_remove_itab
{
  trace("Removing /etc/init.d/init.crfd");
  unlink("/etc/init.d/init.crfd");

  # cleanup from the auto startup configuration
  s_remove_itab ("crfd");

  if ((! s_is_Linux_Upstart()) && (! s_is_Linux_Systemd()))
  {
     system ($CFG->params('INIT') . " q");
  }
}


1;
