/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import oracle.i18n.lcsd.CmgIState;
import oracle.i18n.lcsd.MGroupEval;
import oracle.i18n.lcsd.MgeUAElem;
import oracle.i18n.lcsd.ProfileData;
import oracle.i18n.text.OraBoot;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.LocaleMapper;

class Profile
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static final transient HashMap profileCache = new HashMap();
    private static final String DATAPATH = GDKOracleMetaData.getDataPath();
    private static final transient int UCHR_MAX = 256;
    private static final transient float EPSILON_LPROB = 30.0f;
    private static final transient long MIN_SAMPLING_LEN = 3L;
    private static final String LXLED_PROFILE = "lx70001";
    private ProfileData profileData;
    private transient byte prev_byte;
    private transient int curr_state;
    private transient MGroupEval mg_eval;
    private transient byte fst1;
    private transient byte fst2;
    private transient int nb_fsts;
    private transient int langid;
    private transient int charsetid;
    private transient int bestIndex;
    private transient float bestRatio;
    private transient long byteCounter = 0L;
    private static final String EMPTY_LANG_CS = "_";
    private static final int CS_AL16UTF16 = 2000;
    private static final int CS_AL16UTF16LE = 2002;

    private Profile() {
    }

    public static synchronized Profile getInstance() throws FileNotFoundException, IOException {
        return Profile.getInstance(LXLED_PROFILE);
    }

    public static synchronized Profile getInstance(String string) throws FileNotFoundException, IOException {
        ProfileData profileData = (ProfileData)profileCache.get(string);
        if (profileData == null) {
            profileData = (ProfileData)Profile.readObj(DATAPATH + string + ".glb");
            if (profileData == null) {
                throw new FileNotFoundException(string + " not found");
            }
            profileCache.put(string, profileData);
        }
        Profile profile = new Profile();
        profile.profileData = profileData;
        profile.mg_eval = new MGroupEval(profile.profileData);
        return profile;
    }

    public void reset() {
        this.mg_eval = new MGroupEval(this.profileData);
        this.prev_byte = 0;
        this.curr_state = 0;
        this.fst1 = 0;
        this.fst2 = 0;
        this.nb_fsts = 0;
        this.langid = 0;
        this.charsetid = 0;
        this.bestIndex = 0;
        this.bestRatio = 0.0f;
        this.byteCounter = 0L;
    }

    private String getOracleLanguage(String string) {
        Locale locale;
        String string2;
        if (string.equalsIgnoreCase("zt")) {
            string = "zh_TW";
        }
        if ((string2 = (locale = LocaleMapper.getLocaleFromString((String)string)).getLanguage()).equals("en")) {
            return "ENGLISH";
        }
        return string2.equals("") ? "" : LocaleMapper.getOraLanguage((Locale)locale);
    }

    public void prt_allmodels() {
        for (int i = 0; i < this.profileData.nb_models; ++i) {
            String string = String.valueOf(this.profileData.models[i].name);
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3);
            System.out.printf("%2d:%s  %s\n", i, this.getOracleLanguage(string2), string3);
        }
        System.out.printf("\n==> Profile=%s, models=%d, facts=%d\n", LXLED_PROFILE, this.profileData.nb_models, this.profileData.nb_facts);
    }

    private void addByte(byte by, int[] nArray) {
        int n;
        this.curr_state = this.getNextState(by, this.curr_state);
        int n2 = this.profileData.nb_istates;
        if (this.curr_state < n2) {
            if (this.curr_state == 0) {
                this.curr_state = this.getNextState(this.prev_byte, 0);
                this.curr_state = this.getNextState(by, this.curr_state);
                if (this.curr_state == 0) {
                    this.curr_state = this.getNextState(by, 0);
                }
            }
            this.prev_byte = by;
            nArray[0] = -1;
            nArray[1] = 0;
            return;
        }
        this.prev_byte = by;
        int n3 = this.curr_state - n2;
        this.curr_state = this.profileData.def_so[n3] & 0xFFFF;
        int n4 = this.profileData.lstates_nb_vals[n3] & 0xFF;
        nArray[0] = n = this.profileData.lstates_vals_offs[n3];
        nArray[1] = n4;
    }

    private int getNextState(byte by, int n) {
        CmgIState[] cmgIStateArray = this.profileData.istates;
        byte[] byArray = this.profileData.istates_chrs;
        if (cmgIStateArray[n].so_offset != 0) {
            int n2;
            int n3 = cmgIStateArray[n].chrs;
            int n4 = cmgIStateArray[n].nb_chrs;
            if (n4 > 4) {
                int n5 = 0;
                int n6 = n4 - 1;
                while (n5 <= n6) {
                    int n7 = n5 + n6 + 1 >>> 1;
                    if (byArray[n3 + n7] == by) {
                        return cmgIStateArray[n].so_offset + n7;
                    }
                    if ((byArray[n3 + n7] & 0xFF) < (by & 0xFF)) {
                        n5 = n7 + 1;
                        continue;
                    }
                    n6 = n7 - 1;
                }
                return 0;
            }
            for (n2 = 0; n2 < n4 && (byArray[n3 + n2] & 0xFF) < (by & 0xFF); ++n2) {
            }
            return n2 < n4 && byArray[n3 + n2] == by ? cmgIStateArray[n].so_offset + n2 : 0;
        }
        return this.profileData.istates_dnxts[cmgIStateArray[n].dnxts + (by & 0xFF)];
    }

    private void evaluateBytes(byte[] byArray, int n, int n2) {
        if (this.byteCounter < 3L) {
            this.byteCounter += (long)n2;
        }
        this.mg_eval.tot_nb_lprobs += n2;
        int[] nArray = new int[2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n2 != 0) {
            byte by = byArray[n];
            this.addByte(by, nArray);
            n3 = 0;
            n5 = 0;
            n6 = 0;
            n6 = nArray[0];
            n5 = nArray[1];
            int n7 = by & 0xFF;
            this.mg_eval.uni_counts[n7] = this.mg_eval.uni_counts[n7] + 1;
            this.mg_eval.verifyutf8(by);
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = this.profileData.lstates_model_no[n6 + n4] & 0xFF;
                int[] nArray2 = this.mg_eval.models_chrs_counts[n3];
                int n8 = by & 0xFF;
                nArray2[n8] = nArray2[n8] + 1;
                int n9 = n3;
                this.mg_eval.ilprobs[n9] = this.mg_eval.ilprobs[n9] + (this.profileData.lstates_lprob[n6 + n4] & 0xFF);
                int n10 = n3;
                this.mg_eval.ilp_counts[n10] = this.mg_eval.ilp_counts[n10] + 1;
            }
            ++n;
            --n2;
        }
        this.int2float();
    }

    private float int2float_lp(int n, float f, float f2, int n2) {
        return (float)n * f2 + (float)n2 * f;
    }

    private void int2float() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.mg_eval.nb_models; ++n2) {
            n = this.profileData.models[n2].fact_id;
            if (n == -1) continue;
            int n3 = n2;
            this.mg_eval.ilp_counts[n3] = this.mg_eval.ilp_counts[n3] + this.mg_eval.ilp_counts[n];
            int n4 = n2;
            this.mg_eval.ilprobs[n4] = this.mg_eval.ilprobs[n4] + this.mg_eval.ilprobs[n];
        }
        for (n = this.mg_eval.nb_models; n < this.mg_eval.nb_mods_facts; ++n) {
            this.mg_eval.ilp_counts[n] = 0;
            this.mg_eval.ilprobs[n] = 0;
        }
        for (n2 = 0; n2 < this.mg_eval.nb_models; ++n2) {
            if (this.mg_eval.ilp_counts[n2] == 0) continue;
            int n5 = n2;
            this.mg_eval.lprobs[n5] = this.mg_eval.lprobs[n5] + this.int2float_lp(this.mg_eval.ilprobs[n2], this.profileData.models[n2].lpmin, this.profileData.models[n2].grad, this.mg_eval.ilp_counts[n2]);
            int n6 = n2;
            this.mg_eval.lp_counts[n6] = this.mg_eval.lp_counts[n6] + this.mg_eval.ilp_counts[n2];
            this.mg_eval.ilp_counts[n2] = 0;
            this.mg_eval.ilprobs[n2] = 0;
        }
    }

    public void add(byte[] byArray) {
        this.add(byArray, byArray.length);
    }

    public void add(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        if (n3 <= 0) {
            return;
        }
        int[] nArray = new int[2];
        while (n3 > 0) {
            int n4 = n3 > 1024 ? 1024 : n3;
            byte[] byArray2 = new byte[n4];
            int n5 = 0;
            n3 -= n4;
            System.arraycopy(byArray, n2, byArray2, 0, n4);
            n2 += n4;
            this.mg_eval.chk_ucs2(byArray2, n4);
            n4 = this.preprocessFacs(byArray2, n4);
            if (this.nb_fsts < 2) {
                if (n4 != 0 && this.nb_fsts == 0) {
                    int n6 = byArray2[n5] & 0xFF;
                    this.mg_eval.uni_counts[n6] = this.mg_eval.uni_counts[n6] + 1;
                    this.mg_eval.verifyutf8(byArray2[n5]);
                    this.fst1 = byArray2[n5++];
                    --n4;
                    ++this.nb_fsts;
                }
                if (n4 != 0 && this.nb_fsts == 1) {
                    int n7 = byArray2[n5] & 0xFF;
                    this.mg_eval.uni_counts[n7] = this.mg_eval.uni_counts[n7] + 1;
                    this.mg_eval.verifyutf8(byArray2[n5]);
                    this.fst2 = byArray2[n5++];
                    --n4;
                    ++this.nb_fsts;
                    this.curr_state = 0;
                    this.prev_byte = 0;
                    this.addByte(this.fst1, nArray);
                    this.addByte(this.fst2, nArray);
                }
            }
            if (n4 == 0) {
                if (this.langid == 0 || this.charsetid != 0) {
                    // empty if block
                }
                return;
            }
            this.nb_fsts = 3;
            this.evaluateBytes(byArray2, n5, n4);
            if (this.langid == 0 || this.charsetid == 0) continue;
        }
    }

    public MGroupEval getMGroupEval() {
        return null;
    }

    private int rmTricarDups(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        int n3 = -1;
        int n4 = 0;
        while (n2 != n) {
            if (by == byArray[n2]) {
                if (++n3 == 3) {
                    while (by == byArray[++n2]) {
                    }
                    n3 = 0;
                }
            } else {
                n3 = 0;
            }
            by = byArray[n2];
            byArray[n4++] = byArray[n2++];
        }
        return n4;
    }

    private int rmCaps(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) < 65 || (byArray[i] & 0xFF) > 90) continue;
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] + 32);
        }
        return n;
    }

    private int rmDigits(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) >= 48 && (byArray[i] & 0xFF) <= 57) continue;
            byArray[n2++] = byArray[i];
        }
        return n2;
    }

    private int rmDigitsCaps(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) >= 65 && (byArray[i] & 0xFF) <= 90) {
                byArray[n2++] = (byte)(byArray[i] + 32);
                continue;
            }
            if ((byArray[i] & 0xFF) >= 48 && (byArray[i] & 0xFF) <= 57) continue;
            byArray[n2++] = byArray[i];
        }
        return n2;
    }

    private int rmDigitsCapsTriDup(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        int n3 = -1;
        int n4 = 0;
        while (n2 < n) {
            if (by == byArray[n2]) {
                if (++n3 == 3) {
                    while (++n2 < n && by == byArray[n2]) {
                    }
                    n3 = 0;
                }
            } else {
                n3 = 0;
            }
            if (n2 >= n) break;
            by = byArray[n2];
            if ((byArray[n2] & 0xFF) >= 65 && (byArray[n2] & 0xFF) <= 90) {
                byArray[n4++] = (byte)(byArray[n2++] + 32);
                continue;
            }
            if ((byArray[n2] & 0xFF) < 48 || (byArray[n2] & 0xFF) > 57) {
                byArray[n4++] = byArray[n2++];
                continue;
            }
            ++n2;
        }
        return n4;
    }

    private int rmDigitsCapsTriDupBlks(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        int n3 = -1;
        int n4 = 0;
        while (n2 < n) {
            if (by == byArray[n2]) {
                if (++n3 == 3) {
                    while (++n2 < n && by == byArray[n2]) {
                    }
                    n3 = 0;
                }
            } else {
                n3 = 0;
            }
            if (n2 >= n) break;
            by = byArray[n2];
            if ((byArray[n2] & 0xFF) >= 65 && (byArray[n2] & 0xFF) <= 90) {
                byArray[n4++] = (byte)(byArray[n2++] + 32);
                continue;
            }
            if ((byArray[n2] & 0xFF) == 9 || (byArray[n2] & 0xFF) == 10 || (byArray[n2] & 0xFF) == 13) {
                byArray[n4++] = 32;
                ++n2;
                continue;
            }
            if ((byArray[n2] & 0xFF) < 48 || (byArray[n2] & 0xFF) > 57) {
                byArray[n4++] = byArray[n2++];
                continue;
            }
            ++n2;
        }
        return n4;
    }

    private int rmBlks(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byArray[n2++] = (byArray[i] & 0xFF) != 9 && (byArray[i] & 0xFF) != 10 && (byArray[i] & 0xFF) != 13 ? byArray[i] : 32;
        }
        return n2;
    }

    private int preprocessFacs(byte[] byArray, int n) {
        switch (this.profileData.preprocessbitmap) {
            case 15: {
                n = this.rmDigitsCapsTriDupBlks(byArray, n);
                break;
            }
            case 7: {
                n = this.rmDigitsCapsTriDup(byArray, n);
                break;
            }
            case 6: {
                n = this.rmDigitsCaps(byArray, n);
                break;
            }
            case 8: {
                n = this.rmBlks(byArray, n);
                break;
            }
            case 4: {
                n = this.rmDigits(byArray, n);
                break;
            }
            case 2: {
                n = this.rmCaps(byArray, n);
                break;
            }
            case 1: {
                n = this.rmTricarDups(byArray, n);
                break;
            }
            default: {
                if ((this.profileData.preprocessbitmap & 8) != 0) {
                    n = this.rmTricarDups(byArray, n);
                }
                if ((this.profileData.preprocessbitmap & 4) != 0) {
                    n = this.rmCaps(byArray, n);
                }
                if ((this.profileData.preprocessbitmap & 2) != 0) {
                    n = this.rmDigits(byArray, n);
                }
                if ((this.profileData.preprocessbitmap & 1) == 0) break;
                n = this.rmBlks(byArray, n);
            }
        }
        return n;
    }

    float[] get_lprobs_mgroupeval() {
        int n;
        int n2;
        this.int2float();
        for (n2 = 0; n2 < this.mg_eval.nb_mods_facts; ++n2) {
            this.mg_eval.uilprobs[n2] = 0;
            this.mg_eval.uilp_counts[n2] = 0;
        }
        for (int i = 0; i < 256; ++i) {
            int n3 = this.mg_eval.ulp_acs.tlens[i];
            MgeUAElem[] mgeUAElemArray = this.mg_eval.ulp_acs.tables[i];
            for (n2 = 0; n2 < n3; ++n2) {
                n = mgeUAElemArray[n2].model & 0xFFFF;
                int n4 = mgeUAElemArray[n2].fact & 0xFFFF;
                int n5 = this.mg_eval.uni_counts[i] - (n == n4 ? this.mg_eval.models_chrs_counts[n][i] : this.mg_eval.models_chrs_counts[n][i] + this.mg_eval.models_chrs_counts[n4][i]);
                int n6 = n;
                this.mg_eval.uilprobs[n6] = this.mg_eval.uilprobs[n6] + n5 * (mgeUAElemArray[n2].uilp & 0xFF);
                int n7 = n;
                this.mg_eval.uilp_counts[n7] = this.mg_eval.uilp_counts[n7] + n5;
            }
        }
        for (n = 0; n < this.mg_eval.nb_models; ++n) {
            float f = this.mg_eval.lprobs[n];
            if (this.mg_eval.uilp_counts[n] != 0) {
                f += this.int2float_lp(this.mg_eval.uilprobs[n], this.profileData.umg.models_lpmin[n], this.profileData.umg.models_grad[n], this.mg_eval.uilp_counts[n]);
            }
            this.mg_eval.out_lprobs[n] = (f += 30.0f * (float)(this.mg_eval.tot_nb_lprobs - this.mg_eval.lp_counts[n] - this.mg_eval.uilp_counts[n])) / (float)this.mg_eval.tot_nb_lprobs;
        }
        this.mg_eval.filter_utf8(this.profileData);
        return this.mg_eval.out_lprobs;
    }

    float calcul_ratio(float[] fArray) {
        int n = this.profileData.nb_models;
        float f = 1.0E7f;
        int n2 = -1;
        if (fArray == null) {
            return -1.0f;
        }
        for (int i = 0; i < n; ++i) {
            if (!(fArray[i] < f)) continue;
            n2 = i;
            f = fArray[i];
        }
        this.bestIndex = n2;
        this.bestRatio = n2 < 0 || n2 >= n ? -1.0f : this.calcul_ratio_mdl(fArray, n2);
        return this.bestRatio;
    }

    float calcul_ratio_mdl(float[] fArray, int n) {
        float f = 0.0f;
        for (int i = 0; i < this.mg_eval.nb_models; ++i) {
            f += (float)Math.exp(fArray[n] - fArray[i]);
        }
        return 1.0f / f;
    }

    Object[][] getResult(String string, String string2) {
        Object object;
        int n;
        float[] fArray = this.get_lprobs_mgroupeval();
        int n2 = this.profileData.nb_models;
        int[] nArray = new int[n2];
        nArray[0] = 0;
        if (string != null) {
            for (n = 0; n < n2; ++n) {
                object = new String(this.profileData.models[n].name);
                if (string.equalsIgnoreCase(((String)object).substring(0, ((String)object).indexOf(95)))) continue;
                fArray[n] = 1.0E7f;
            }
        } else if (string2 != null) {
            for (n = 0; n < n2; ++n) {
                object = new String(this.profileData.models[n].name);
                if (string2.equalsIgnoreCase(((String)object).substring(((String)object).indexOf(95) + 1))) continue;
                fArray[n] = 1.0E7f;
            }
        }
        object = new Object[n2][2];
        for (int i = 0; i < n2; ++i) {
            object[i][0] = new String(this.profileData.models[i].name);
            object[i][1] = new Float(this.calcul_ratio_mdl(fArray, i));
        }
        this.optModels((Object[][])object);
        return object;
    }

    boolean isAL16UTF16LE() {
        return this.mg_eval.isAL16UTF16LE();
    }

    boolean isBOMAL16UTF16() {
        return this.mg_eval.isBOMAL16UTF16();
    }

    int promote_demote(int n) {
        return this.mg_eval.promote_demote(n);
    }

    boolean isCharsetSupported(String string) {
        return this.profileData.supportedCharset.contains(string.toUpperCase(Locale.US));
    }

    boolean isCharsetInProfile(String string) {
        for (int i = 0; i < this.profileData.nb_models; ++i) {
            String string2 = String.valueOf(this.profileData.models[i].name);
            String string3 = string2.substring(3);
            if (!string.equals(string3)) continue;
            return true;
        }
        return false;
    }

    boolean isLangInProfile(String string) {
        for (int i = 0; i < this.profileData.nb_models; ++i) {
            String string2 = String.valueOf(this.profileData.models[i].name);
            String string3 = string2.substring(0, 2);
            if (!string.equals(string3)) continue;
            return true;
        }
        return false;
    }

    boolean isSampledEnough() {
        return this.byteCounter >= 3L;
    }

    private static Object readObj(String string) {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            uRL = classLoader.getResource(string);
        } else {
            uRL = ClassLoader.getSystemResource(string);
        }
        if (uRL == null) {
            return null;
        }
        try {
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            inputStream.close();
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException: " + iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("ClassNotFound: " + classNotFoundException.getMessage());
        }
    }

    private void swap(Object[][] objectArray, int n, int n2) {
        String string = objectArray[n][0].toString();
        Float f = (Float)objectArray[n][1];
        objectArray[n][0] = objectArray[n2][0].toString();
        objectArray[n][1] = (Float)objectArray[n2][1];
        objectArray[n2][0] = string;
        objectArray[n2][1] = f;
    }

    private void quickSortRatio(Object[][] objectArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Float f = (Float)objectArray[(n + n2) / 2][1];
        while (true) {
            if (((Float)objectArray[n3][1]).compareTo(f) > 0) {
                ++n3;
                continue;
            }
            while (((Float)objectArray[n4][1]).compareTo(f) < 0) {
                --n4;
            }
            if (n3 >= n4) break;
            this.swap(objectArray, n3, n4);
            ++n3;
            --n4;
        }
        if (n < n3 - 1) {
            this.quickSortRatio(objectArray, n, n3 - 1);
        }
        if (n4 + 1 < n2) {
            this.quickSortRatio(objectArray, n4 + 1, n2);
        }
    }

    private void optModels(Object[][] objectArray) {
        if (objectArray.length > 1) {
            int n;
            int n2;
            OraBoot oraBoot = OraBoot.getInstance();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                int n3;
                String string = (String)objectArray[n2][0];
                int n4 = string.indexOf(95);
                String string2 = string.substring(0, n4);
                String string3 = string.substring(n4 + 1);
                int n5 = n3 = string3.equals("") ? -1 : this.promote_demote(Integer.parseInt(oraBoot.getCharSetId(string3)));
                if (!(n3 != 2000 || !this.isAL16UTF16LE() || this.isBOMAL16UTF16() || string2.equals("ja") || string2.equals("ko") || string2.equals("zh") || string2.equals("zt"))) {
                    n3 = 2002;
                }
                String string4 = string2 + EMPTY_LANG_CS + oraBoot.getCharSetName(Integer.toString(n3));
                objectArray[n2][0] = string4 == null ? "" : string4;
            }
            n2 = 0;
            for (n = 1; n < objectArray.length; ++n) {
                if (objectArray[n - 1][0].equals(objectArray[n][0])) {
                    objectArray[n][1] = Float.valueOf(((Float)objectArray[n][1]).floatValue() + ((Float)objectArray[n - 1][1]).floatValue());
                    if (n != objectArray.length - 1) continue;
                    objectArray[n2][0] = objectArray[n][0];
                    objectArray[n2][1] = objectArray[n][1];
                    ++n2;
                    continue;
                }
                objectArray[n2][0] = objectArray[n - 1][0];
                objectArray[n2][1] = objectArray[n - 1][1];
                ++n2;
                if (n != objectArray.length - 1) continue;
                objectArray[n2][0] = objectArray[n][0];
                objectArray[n2][1] = objectArray[n][1];
                ++n2;
            }
            for (n = n2; n < objectArray.length; ++n) {
                objectArray[n][0] = EMPTY_LANG_CS;
                objectArray[n][1] = new Float(0.0f);
            }
            this.quickSortRatio(objectArray, 0, objectArray.length - 1);
        }
    }
}

