/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.i18n.lcsd.LCSDResultSet;
import oracle.i18n.lcsd.LCSDetectionHTMLReader;
import oracle.i18n.lcsd.LCSDetectionReader;

public class LCSScan {
    static final String banner = "Language and Character Set File Scanner (Java version)" + System.getProperty("line.separator") + "(c) Copyright 2003, 2013 Oracle Corporation. All rights reserved. ";
    static final String results_pattern = "RESULTS=";
    static final String size_pattern = "SIZE=";
    static final String format_pattern = "FORMAT=";
    static final String file_pattern = "FILE=";
    static final String ratio_pattern = "RATIO=";
    static final String help_pattern = "HELP";
    static final int results_pattern_len = "RESULTS=".length();
    static final int size_pattern_len = "SIZE=".length();
    static final int format_pattern_len = "FORMAT=".length();
    static final int file_pattern_len = "FILE=".length();
    static final int ratio_pattern_len = "RATIO=".length();
    static final int help_pattern_len = "HELP".length();
    int results_ = 1;
    int size_ = 8192;
    String format_ = "TEXT";
    boolean valid_format_ = true;
    String ratio_ = "NO";
    boolean valid_ratio_ = true;
    String file_ = null;
    boolean help_ = false;

    private LCSScan() {
    }

    public void prt_banner() {
        System.out.printf("%s\n\n", banner);
    }

    public void prt_usage() {
        System.out.printf("Usage: java LCSScan <options>\n", new Object[0]);
        System.out.printf("Example: Java LCSScan FILE=test.txt RESULTS=3 SIZE=1000\n", new Object[0]);
        System.out.printf("Keyword   Description (Default)\n", new Object[0]);
        System.out.printf("-------------------------------------------------------------------------------\n", new Object[0]);
        System.out.printf("RESULTS   number of language and character set pairs to return 1..3 (1)\n", new Object[0]);
        System.out.printf("SIZE      sampling size of the file in bytes (8192)\n", new Object[0]);
        System.out.printf("FORMAT    file format TEXT or HTML (TEXT)\n", new Object[0]);
        System.out.printf("RATIO     show result ratio YES or NO (NO)\n", new Object[0]);
        System.out.printf("FILE      name of input file\n", new Object[0]);
        System.out.printf("HELP      show help screen (this screen)\n\n", new Object[0]);
    }

    private void parse_args(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > results_pattern_len && stringArray[i].substring(0, results_pattern_len).equalsIgnoreCase(results_pattern)) {
                this.results_ = Integer.parseInt(stringArray[i].substring(results_pattern_len));
                continue;
            }
            if (stringArray[i].length() > size_pattern_len && stringArray[i].substring(0, size_pattern_len).equalsIgnoreCase(size_pattern)) {
                this.size_ = Integer.parseInt(stringArray[i].substring(size_pattern_len));
                continue;
            }
            if (stringArray[i].length() > format_pattern_len && stringArray[i].substring(0, format_pattern_len).equalsIgnoreCase(format_pattern)) {
                this.format_ = stringArray[i].substring(format_pattern_len);
                if (this.format_.equalsIgnoreCase("TEXT") || this.format_.equalsIgnoreCase("HTML")) continue;
                this.valid_format_ = false;
                continue;
            }
            if (stringArray[i].length() > ratio_pattern_len && stringArray[i].substring(0, ratio_pattern_len).equalsIgnoreCase(ratio_pattern)) {
                this.ratio_ = stringArray[i].substring(ratio_pattern_len);
                if (this.ratio_.equalsIgnoreCase("YES") || this.ratio_.equalsIgnoreCase("NO")) continue;
                this.valid_ratio_ = false;
                continue;
            }
            if (stringArray[i].length() > file_pattern_len && stringArray[i].substring(0, file_pattern_len).equalsIgnoreCase(file_pattern)) {
                this.file_ = stringArray[i].substring(file_pattern_len);
                continue;
            }
            if (stringArray[i].length() < help_pattern_len || !stringArray[i].substring(0, help_pattern_len).equalsIgnoreCase(help_pattern)) continue;
            this.help_ = true;
        }
        if (this.help_) {
            this.prt_usage();
            System.exit(0);
        }
        if (this.results_ < 1 || this.results_ > 3 || this.size_ <= 0 || !this.valid_format_ || !this.valid_ratio_ || this.file_ == null) {
            this.prt_usage();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_scan(String[] stringArray) {
        FileInputStream fileInputStream = null;
        LCSDetectionReader lCSDetectionReader = null;
        try {
            fileInputStream = new FileInputStream(this.file_);
            lCSDetectionReader = this.format_.equalsIgnoreCase("TEXT") ? new LCSDetectionReader(fileInputStream, this.size_) : new LCSDetectionHTMLReader(fileInputStream, this.size_);
            LCSDResultSet lCSDResultSet = lCSDetectionReader.getResult();
            System.out.printf("File: %s \n", this.file_);
            for (int i = 1; i <= this.results_; ++i) {
                if (this.ratio_.equalsIgnoreCase("YES")) {
                    System.out.printf("   Rank=%d, Language=%s, CharacterSet=%s, Ratio=%.4f\n", i, lCSDResultSet.getORALanguage(i), lCSDResultSet.getORACharacterSet(i), Float.valueOf(lCSDResultSet.getRatio(i)));
                    continue;
                }
                System.out.printf("   Rank=%d, Language=%s, CharacterSet=%s\n", i, lCSDResultSet.getORALanguage(i), lCSDResultSet.getORACharacterSet(i));
            }
            System.out.printf("\n", new Object[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.printf("LCSScan: FileNotFoundException - the input file %s not found.\n", this.file_);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static final void main(String[] stringArray) {
        LCSScan lCSScan = new LCSScan();
        lCSScan.prt_banner();
        lCSScan.parse_args(stringArray);
        lCSScan.do_scan(stringArray);
    }
}

