/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.IOException;
import java.io.InputStream;
import oracle.i18n.lcsd.GDKMessage;
import oracle.i18n.lcsd.LCSDResultSet;
import oracle.i18n.lcsd.Profile;
import oracle.i18n.util.LocaleMapper;

public class LCSDetector {
    private static final int PROCESS_BYTE = 1;
    private static final int PROCESS_STRING = 2;
    private static final int PROCESS_FILESTREAM = 3;
    private static final int FLAG_RESET = 0;
    private Profile profile = null;
    private String OraCharSetName = null;
    private String ISOLangName = null;
    private int process_flag = 0;

    public LCSDetector() {
        this(null);
    }

    public LCSDetector(String string) {
        try {
            Profile profile = this.profile = string != null ? Profile.getInstance(string) : Profile.getInstance();
            if (this.profile == null) {
                throw new IllegalArgumentException(GDKMessage.getMessage(6001));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6001));
        }
    }

    public void setCharacterSetFilter(String string) {
        this.OraCharSetName = LocaleMapper.getOraCharacterSet((int)3, (String)string);
        if (this.OraCharSetName == null) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6002));
        }
        if (this.OraCharSetName.equals("AL32UTF8")) {
            this.OraCharSetName = "UTF8";
        }
        if (this.OraCharSetName.equals("IW8MSWIN1255")) {
            this.OraCharSetName = "IW8ISO8859P8";
        }
        if (this.OraCharSetName.equals("KO16MSWIN949")) {
            this.OraCharSetName = "KO16KSC5601";
        }
        if (this.OraCharSetName.equals("TR8MSWIN1254")) {
            this.OraCharSetName = "WE8ISO8859P9";
        }
        if (this.OraCharSetName.equals("US7ASCII") || this.OraCharSetName.equals("WE8ISO8859P1") || this.OraCharSetName.equals("WE8ISO8859P15")) {
            this.OraCharSetName = "WE8MSWIN1252";
        }
        if (this.OraCharSetName.equals("ZHS16GBK")) {
            this.OraCharSetName = "ZHS16CGB231280";
        }
        if (this.profile.isCharsetInProfile(this.OraCharSetName)) {
            if (this.ISOLangName == null) {
                return;
            }
            this.ISOLangName = null;
            this.OraCharSetName = null;
            throw new IllegalArgumentException(GDKMessage.getMessage(6004));
        }
        throw new IllegalArgumentException(GDKMessage.getMessage(6002));
    }

    public void setLanguageFilter(String string) {
        this.ISOLangName = string;
        if (this.ISOLangName != null && this.profile.isLangInProfile(this.ISOLangName.toLowerCase())) {
            if (this.OraCharSetName == null) {
                return;
            }
            this.ISOLangName = null;
            this.OraCharSetName = null;
            throw new IllegalArgumentException(GDKMessage.getMessage(6004));
        }
        throw new IllegalArgumentException(GDKMessage.getMessage(6003));
    }

    public void detect(byte[] byArray) {
        this.detect(byArray, 0, byArray.length);
    }

    public int detect(byte[] byArray, int n, int n2) {
        if (this.process_flag == 0) {
            this.process_flag = 1;
        } else if (this.process_flag != 1) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6005));
        }
        if (n < 0 || n2 <= 0) {
            return 0;
        }
        int n3 = byArray.length;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.profile.add(byArray2);
        if (n + n2 == n3) {
            return -1;
        }
        return n2;
    }

    public void detect(InputStream inputStream) throws IOException {
        if (this.process_flag == 0) {
            this.process_flag = 3;
        } else if (this.process_flag != 3) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6005));
        }
        byte[] byArray = new byte[2048];
        int n = inputStream.read(byArray);
        while (n != -1) {
            this.profile.add(byArray, n);
            n = inputStream.read(byArray);
        }
    }

    public int detect(InputStream inputStream, int n) throws IOException {
        if (this.process_flag == 0) {
            this.process_flag = 3;
        } else if (this.process_flag != 3) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6005));
        }
        int n2 = 0;
        if (n < 2048) {
            byte[] byArray = new byte[n];
            n2 = inputStream.read(byArray);
            if (n2 > 0) {
                this.profile.add(byArray, n2);
            }
        } else {
            byte[] byArray = new byte[2048];
            int n3 = -1;
            while ((n3 = inputStream.read(byArray)) != -1) {
                if (n2 + n3 >= n) {
                    this.profile.add(byArray, n - n2);
                    break;
                }
                this.profile.add(byArray, n3);
                n2 += n3;
            }
        }
        return n2;
    }

    public void detect(String string) {
        this.detect(string, string.length());
    }

    public int detect(String string, int n) {
        if (this.process_flag == 0) {
            this.process_flag = 2;
        } else if (this.process_flag != 2) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6005));
        }
        if (n < string.length()) {
            byte[] byArray = this.convertToByteArray(string.substring(0, n - 1).toCharArray());
            this.profile.add(byArray);
            return n;
        }
        byte[] byArray = this.convertToByteArray(string.toCharArray());
        this.profile.add(byArray);
        return -1;
    }

    public void detect(char[] cArray) {
        this.detect(cArray, 0, cArray.length);
    }

    public int detect(char[] cArray, int n, int n2) {
        if (this.process_flag == 0) {
            this.process_flag = 2;
        } else if (this.process_flag != 2) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6005));
        }
        byte[] byArray = this.convertToByteArray(cArray, n, n2);
        this.profile.add(byArray);
        if (n + n2 >= cArray.length) {
            return -1;
        }
        return n2;
    }

    public LCSDResultSet getResult() {
        return new LCSDResultSet(this.profile.isSampledEnough() ? this.profile : null, this.ISOLangName, this.OraCharSetName, this.process_flag);
    }

    public static boolean isCharsetSupported(int n, String string) {
        Profile profile;
        try {
            profile = Profile.getInstance();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(GDKMessage.getMessage(6001));
        }
        String string2 = n == 2 ? LocaleMapper.getOraCharacterSet((int)2, (String)string) : (n == 3 ? LocaleMapper.getOraCharacterSet((int)3, (String)string) : string);
        if (string2 == null) {
            return false;
        }
        return profile.isCharsetSupported(string2);
    }

    public void reset() {
        this.ISOLangName = null;
        this.OraCharSetName = null;
        this.process_flag = 0;
        this.profile.reset();
    }

    private byte[] convertToByteArray(char[] cArray) {
        return this.convertToByteArray(cArray, 0, cArray.length);
    }

    private byte[] convertToByteArray(char[] cArray, int n, int n2) {
        int n3 = cArray.length;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        byte[] byArray = new byte[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i + n];
            byArray[2 * i] = (byte)(c >>> 8);
            byArray[2 * i + 1] = (byte)c;
        }
        return byArray;
    }
}

