/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import oracle.i18n.lcsd.GDKMessage;
import oracle.i18n.lcsd.LCSDResultSet;
import oracle.i18n.lcsd.LCSDetectionFilter;
import oracle.i18n.lcsd.LCSDetectionInputStream;
import oracle.i18n.lcsd.LCSDetector;
import oracle.i18n.util.DualReaderBuilder;
import oracle.i18n.util.LocaleMapper;

public class LCSDetectionReader
extends Reader {
    protected static final int DEFAULT_SAMPLING_SIZE = 8192;
    private static final String ORACHARSET_PREFIX = "X-ORACLE-";
    private final Reader m_reader;
    private final LCSDetectionInputStream m_lcsdis;
    private final LCSDetector m_lcsd;

    public LCSDetectionReader(InputStream inputStream) throws IOException, UTFDataFormatException {
        this(null, inputStream, 8192, null);
    }

    public LCSDetectionReader(InputStream inputStream, int n) throws IOException, UTFDataFormatException {
        this(null, inputStream, n, null);
    }

    public LCSDetectionReader(String string, InputStream inputStream) throws IOException, UTFDataFormatException {
        this(string, inputStream, 8192, null);
    }

    public LCSDetectionReader(String string, InputStream inputStream, int n) throws IOException, UTFDataFormatException {
        this(string, inputStream, n, null);
    }

    public LCSDetectionReader(String string, InputStream inputStream, int n, LCSDetectionFilter lCSDetectionFilter) throws IOException, EOFException, UTFDataFormatException {
        this.m_lcsdis = new LCSDetectionInputStream(string, inputStream, n, lCSDetectionFilter);
        InputStreamReader inputStreamReader = null;
        LCSDResultSet lCSDResultSet = this.m_lcsdis.getResult();
        String string2 = lCSDResultSet.getJavaCharacterSet();
        if ("".equals(string2)) {
            throw new EOFException(GDKMessage.getMessage(6006));
        }
        inputStreamReader = string2 != null ? new InputStreamReader((InputStream)this.m_lcsdis, string2) : this.createInputStreamReader(lCSDResultSet.getORACharacterSet());
        this.m_reader = inputStreamReader;
        this.m_lcsd = null;
    }

    public LCSDetectionReader(String string, InputStream inputStream, int n, LCSDetectionFilter lCSDetectionFilter, int n2) throws IOException, EOFException, UTFDataFormatException {
        this.m_lcsdis = new LCSDetectionInputStream(string, inputStream, n, lCSDetectionFilter);
        InputStreamReader inputStreamReader = null;
        String string2 = new String();
        if (n2 == 1) {
            string2 = LocaleMapper.getJavaCharacterSet((int)2, (String)lCSDetectionFilter.getCharset());
        }
        LCSDResultSet lCSDResultSet = this.m_lcsdis.getResult();
        if (string2 == null || "".equals(string2)) {
            string2 = lCSDResultSet.getJavaCharacterSet();
        }
        if ("".equals(string2)) {
            throw new EOFException(GDKMessage.getMessage(6006));
        }
        inputStreamReader = string2 != null ? new InputStreamReader((InputStream)this.m_lcsdis, string2) : this.createInputStreamReader(lCSDResultSet.getORACharacterSet());
        this.m_reader = inputStreamReader;
        this.m_lcsd = null;
    }

    public LCSDetectionReader(Reader reader) throws IOException {
        this(null, reader);
    }

    public LCSDetectionReader(String string, Reader reader) throws IOException {
        DualReaderBuilder dualReaderBuilder = new DualReaderBuilder(reader, 8192);
        this.m_reader = dualReaderBuilder.getFirstReader();
        this.m_lcsdis = null;
        this.m_lcsd = string != null ? new LCSDetector(string) : new LCSDetector();
        Reader reader2 = dualReaderBuilder.getSecondReader();
        char[] cArray = new char[8192];
        int n = reader2.read(cArray);
        this.m_lcsd.detect(cArray);
        reader2.close();
    }

    public synchronized LCSDResultSet getResult() throws IOException, UTFDataFormatException {
        return this.m_lcsdis != null ? this.m_lcsdis.getResult() : this.m_lcsd.getResult();
    }

    @Override
    public int read() throws IOException, UTFDataFormatException {
        return this.m_reader.read();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException, UTFDataFormatException {
        return this.m_reader.read(cArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        this.m_reader.close();
    }

    @Override
    public boolean ready() throws IOException {
        return this.m_reader.ready();
    }

    @Override
    public boolean markSupported() {
        return this.m_reader.markSupported();
    }

    @Override
    public void mark(int n) throws IOException {
        this.m_reader.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this.m_reader.reset();
    }

    @Override
    public int read(char[] cArray) throws IOException, UTFDataFormatException {
        return this.m_reader.read(cArray);
    }

    private InputStreamReader createInputStreamReader(String string) throws UnsupportedEncodingException {
        InputStreamReader inputStreamReader;
        String string2 = string.toUpperCase(Locale.US).startsWith(ORACHARSET_PREFIX) ? string : ORACHARSET_PREFIX + string;
        try {
            inputStreamReader = new InputStreamReader((InputStream)this.m_lcsdis, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(6007));
        }
        return inputStreamReader;
    }
}

