/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import oracle.i18n.lcsd.GDKMessage;
import oracle.i18n.lcsd.LCSDResultSet;
import oracle.i18n.lcsd.LCSDetectionFilter;
import oracle.i18n.lcsd.LCSDetector;
import oracle.i18n.text.UTF8ValidationFilter;
import oracle.i18n.util.DualInputStreamBuilder;

public class LCSDetectionInputStream
extends FilterInputStream {
    protected static final int DEFAULT_SAMPLING_SIZE = 8192;
    private final LCSDetector m_lcsd;
    private final DualInputStreamBuilder m_disb;

    public LCSDetectionInputStream(InputStream inputStream) throws IOException, UTFDataFormatException {
        this(null, inputStream, 8192, null);
    }

    public LCSDetectionInputStream(InputStream inputStream, int n) throws IOException, UTFDataFormatException {
        this(null, inputStream, n, null);
    }

    public LCSDetectionInputStream(String string, InputStream inputStream) throws IOException, UTFDataFormatException {
        this(string, inputStream, 8192, null);
    }

    public LCSDetectionInputStream(String string, InputStream inputStream, int n) throws IOException, UTFDataFormatException {
        this(string, inputStream, n, null);
    }

    public LCSDetectionInputStream(String string, InputStream inputStream, int n, LCSDetectionFilter lCSDetectionFilter) throws IOException, UTFDataFormatException {
        super(inputStream);
        this.m_disb = new DualInputStreamBuilder(inputStream, 8192);
        this.in = this.m_disb.getFirstInputStream();
        this.m_lcsd = string == null ? new LCSDetector() : new LCSDetector(string);
        InputStream inputStream2 = this.m_disb.getSecondInputStream();
        inputStream2 = lCSDetectionFilter != null ? lCSDetectionFilter.doFilter(inputStream2) : inputStream2;
        this.m_lcsd.detect(inputStream2, n);
        if ("UTF-8".equals(this.m_lcsd.getResult().getIANACharacterSet())) {
            this.in = new UTF8ValidationFilter(this.in, 1024, UTF8ValidationFilter.ValidationBehavior.REPLACE);
        }
    }

    public LCSDResultSet getResult() throws IOException, EOFException, UTFDataFormatException {
        LCSDResultSet lCSDResultSet = this.m_lcsd.getResult();
        if ("".equals(lCSDResultSet.getORALanguage())) {
            throw new EOFException(GDKMessage.getMessage(6006));
        }
        return lCSDResultSet;
    }

    @Override
    public int read() throws IOException, UTFDataFormatException {
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException, UTFDataFormatException {
        return super.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException, UTFDataFormatException {
        return super.read(byArray, n, n2);
    }
}

