/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.util.Locale;
import oracle.i18n.lcsd.Profile;
import oracle.i18n.text.OraBoot;
import oracle.i18n.util.LocaleMapper;

public class LCSDResultSet {
    private static final String EMPTY_LANG_CS = "_";
    private static int PROCESS_STRING = 2;
    private static String ORA_UTF16 = "AL16UTF16";
    Object[][] resultArray = null;
    OraBoot ob = null;
    Profile profile = null;
    int process_flag = 0;

    LCSDResultSet(Profile profile, String string, String string2, int n) {
        this.profile = profile;
        if (profile != null) {
            this.resultArray = this.profile.getResult(string, string2);
        } else {
            this.resultArray = new Object[1][2];
            this.resultArray[0][0] = EMPTY_LANG_CS;
            this.resultArray[0][1] = new Float(0.0f);
        }
        this.ob = OraBoot.getInstance();
        this.process_flag = n;
    }

    public String getISOLanguage() {
        return this.getISOLanguage(1);
    }

    public String getISOLanguage(int n) {
        String string = (String)this.resultArray[n - 1][0];
        String string2 = string.substring(0, string.indexOf(95));
        if (string2.equalsIgnoreCase("zt")) {
            return "zh_TW";
        }
        return string2;
    }

    public String getORALanguage() {
        return this.getORALanguage(1);
    }

    public String getORALanguage(int n) {
        Locale locale = LocaleMapper.getLocaleFromString((String)this.getISOLanguage(n));
        String string = locale.getLanguage();
        if ("en".equals(string)) {
            return "ENGLISH";
        }
        return "".equals(string) ? "" : LocaleMapper.getOraLanguage((Locale)locale);
    }

    public String getIANACharacterSet() {
        return this.getIANACharacterSet(1);
    }

    public String getIANACharacterSet(int n) {
        String string = this.getORACharacterSet(n);
        return "".equals(string) ? "" : LocaleMapper.getIANACharacterSet((int)1, (String)string);
    }

    public String getORACharacterSet() {
        return this.getORACharacterSet(1);
    }

    public String getORACharacterSet(int n) {
        if (this.process_flag == PROCESS_STRING && n == 1) {
            return ORA_UTF16;
        }
        String string = (String)this.resultArray[n - 1][0];
        String string2 = string.substring(string.indexOf(95) + 1);
        return string2;
    }

    public String getJavaCharacterSet() {
        return this.getJavaCharacterSet(1);
    }

    public String getJavaCharacterSet(int n) {
        return LocaleMapper.getJavaCharacterSet((int)1, (String)this.getORACharacterSet(n));
    }

    public int getHiHitPairs() {
        float f;
        if (EMPTY_LANG_CS.equals(this.resultArray[0][0])) {
            return 0;
        }
        float f2 = ((Float)this.resultArray[0][1]).floatValue();
        if ((double)((f2 - (f = ((Float)this.resultArray[1][1]).floatValue())) / f2) < 0.05) {
            float f3 = ((Float)this.resultArray[2][1]).floatValue();
            if ((double)((f2 - f3) / f2) < 0.05) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public int getSize() {
        int n = 0;
        int n2 = this.resultArray.length;
        for (n = 0; n < n2 && ((Float)this.resultArray[n][1]).floatValue() != 0.0f; ++n) {
        }
        return n;
    }

    public float getRatio() {
        return ((Float)this.resultArray[0][1]).floatValue();
    }

    public float getRatio(int n) {
        return ((Float)this.resultArray[n - 1][1]).floatValue();
    }
}

