/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class HTMLFilterStream
extends FilterInputStream {
    private static final int BUFSIZE = 2048;
    private int[] attributevalue = new int[2048];
    private int currpos = 0;
    private int attrvaluelen = 0;
    private boolean endoftag = false;
    private String charset = new String();

    public HTMLFilterStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n5 = n + n2;
        for (n4 = n; n4 < n5 && (n3 = this.read()) != -1; ++n4) {
            byArray[n4] = (byte)n3;
        }
        if (n4 - n == 0) {
            return -1;
        }
        return n4 - n;
    }

    @Override
    public int read() throws IOException {
        if (this.currpos < this.attrvaluelen) {
            return this.attributevalue[this.currpos++];
        }
        int n = this.in.read();
        while (n == 60) {
            String string = this.getTag();
            if (string.equalsIgnoreCase("APPLET") || string.equalsIgnoreCase("AREA") || string.equalsIgnoreCase("IMG") || string.equalsIgnoreCase("INPUT")) {
                if (this.getAttribute("ALT")) {
                    this.setAttributeValue();
                    this.skipToTagEnd();
                    return this.attributevalue[this.currpos++];
                }
                this.skipToTagEnd();
            } else if (string.equalsIgnoreCase("OPTION") || string.equalsIgnoreCase("PARAM")) {
                if (this.getAttribute("VALUE")) {
                    this.setAttributeValue();
                    this.skipToTagEnd();
                    return this.attributevalue[this.currpos++];
                }
                this.skipToTagEnd();
            } else if (string.equalsIgnoreCase("OBJECT")) {
                if (this.getAttribute("STANDBY")) {
                    this.setAttributeValue();
                    this.skipToTagEnd();
                    return this.attributevalue[this.currpos++];
                }
                this.skipToTagEnd();
            } else if (string.equalsIgnoreCase("TABLE")) {
                if (this.getAttribute("SUMMARY")) {
                    this.setAttributeValue();
                    this.skipToTagEnd();
                    return this.attributevalue[this.currpos++];
                }
                this.skipToTagEnd();
            } else if (string.equalsIgnoreCase("META")) {
                if (this.getAttribute("CONTENT")) {
                    this.charset = this.setCharset(this.getContent());
                }
                this.skipToTagEnd();
            } else if (string.equalsIgnoreCase("script")) {
                this.skipToCloseTag("/script");
            } else if (string.equalsIgnoreCase("style")) {
                this.skipToCloseTag("/style");
            } else {
                this.skipToTagEnd();
            }
            n = this.in.read();
        }
        return n;
    }

    private void skipToTagEnd() throws IOException {
        int n;
        if (this.endoftag) {
            return;
        }
        while ((byte)(n = this.in.read()) != 62 && n != -1) {
        }
        this.endoftag = true;
    }

    private void skipToCloseTag(String string) throws IOException {
        int n;
        this.skipToTagEnd();
        do {
            if ((n = this.in.read()) != 60) continue;
            String string2 = this.getTag();
            this.skipToTagEnd();
            if (string2.equalsIgnoreCase(string)) break;
        } while (n != -1);
    }

    private void setAttributeValue() throws IOException {
        this.attrvaluelen = 0;
        this.currpos = 0;
        int n = this.in.read();
        while (n != 34 && n != -1 && n != 62) {
            n = this.in.read();
        }
        if (n != 34) {
            this.endoftag = true;
            return;
        }
        n = this.in.read();
        do {
            this.attributevalue[this.attrvaluelen++] = n;
        } while ((n = this.in.read()) != 34 && n != -1 && n != 62);
        this.endoftag = n != 34;
    }

    private String getTag() throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = this.in.read();
        while (n2 != 62 && n2 != 32 && n2 != -1) {
            byArray[n++] = (byte)n2;
            n2 = this.in.read();
        }
        this.endoftag = n2 == 62;
        return new String(byArray, 0, n, "ASCII");
    }

    private boolean getAttribute(String string) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = this.in.read();
        while (n2 != 62 && n2 != -1) {
            while (n2 == 32) {
                n2 = this.in.read();
            }
            while (97 <= n2 && n2 >= 122 || 65 <= n2 && n2 >= 90 || n2 == 45) {
                byArray[n++] = (byte)n2;
                n2 = this.in.read();
            }
            if (n > 0) {
                String string2 = new String(byArray, 0, n, "ASCII");
                if (string2.equalsIgnoreCase(string)) {
                    this.endoftag = false;
                    return true;
                }
                this.skipAttrValue();
                n = 0;
            }
            n2 = this.in.read();
        }
        this.endoftag = true;
        return false;
    }

    private void skipAttrValue() throws IOException {
        int n = this.in.read();
        while (n != 34 && n != 62 && n != -1) {
            n = this.in.read();
        }
        if (n == 34) {
            n = this.in.read();
        } else {
            this.endoftag = true;
            return;
        }
        while (n != 34 && n != 62 && n != -1) {
            n = this.in.read();
        }
        this.endoftag = n != 34;
    }

    private String getContent() throws IOException {
        byte[] byArray = new byte[2048];
        int n = 0;
        int n2 = this.in.read();
        while (n2 != 34 && n2 != 62 && n2 != -1) {
            n2 = this.in.read();
        }
        if (n2 != 34) {
            this.endoftag = true;
            return new String(byArray, 0, n, "ASCII");
        }
        n2 = this.in.read();
        byArray[n++] = (byte)n2;
        while (n2 != 34 && n2 != 62 && n2 != -1) {
            n2 = this.in.read();
            if (n >= 2048) continue;
            byArray[n++] = (byte)n2;
        }
        this.endoftag = n2 != 34;
        return new String(byArray, 0, n - 1, "ASCII");
    }

    private String setCharset(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 7 || !string2.trim().substring(0, 7).equalsIgnoreCase("charset")) continue;
            return string2.substring(string2.indexOf(61) + 1).trim();
        }
        return null;
    }

    public String getCharset() {
        return this.charset;
    }
}

