/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.builder.NLTParser;
import oracle.i18n.util.builder.NLTParserException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinguisticParser
extends NLTParser {
    public LinguisticParser(String string) throws NLTParserException {
        super(string);
        this.topNode = LinguisticParser.findNode(this.topNode, "LINGUISTIC_DEFINITION");
        if (this.topNode == null) {
            throw new NLTParserException("Pattern LINGUISTIC_DEFINITION not found!");
        }
    }

    public Vector getMajorSort() throws NLTParserException {
        return this.getPBlockVector("major_sort");
    }

    public HashMap getMinorSort() throws NLTParserException {
        return this.getPHashMap("minor_sort");
    }

    public Vector getBaseLetter() throws NLTParserException {
        Vector vector = this.getPBlockVector("base_letter");
        NodeList nodeList = LinguisticParser.findNodes(this.topNode, "special_base_letter");
        if (nodeList == null) {
            return vector;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            int n2 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                String string = node.getNodeName();
                if (string.equals("char")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char>");
                    continue;
                }
                if (string.equals("base1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <major1>");
                    continue;
                }
                if (!string.equals("base2")) continue;
                nArrayArray[1][1] = this.getValueOfHex(node, "Element <major2>");
            }
            vector.addElement(nArrayArray);
        }
        return vector;
    }

    public Vector getSpecialLetter() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = LinguisticParser.findNodes(this.topNode, "special_letter");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            int n2 = nodeList2.getLength();
            int[][] nArrayArray = new int[3][];
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                String string = node.getNodeName();
                if (string.equals("char")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char>");
                    continue;
                }
                if (string.equals("major1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <major1>");
                    continue;
                }
                if (string.equals("major2")) {
                    nArrayArray[1][1] = this.getValueOfHex(node, "Element <major2>");
                    continue;
                }
                if (string.equals("minor1")) {
                    nArrayArray[2] = new int[2];
                    nArrayArray[2][0] = this.getValueOfHex(node, "Element <minor1>");
                    continue;
                }
                if (!string.equals("minor2")) continue;
                nArrayArray[2][1] = this.getValueOfHex(node, "Element <minor2>");
            }
            vector.addElement(nArrayArray);
        }
        return vector;
    }

    public Vector getCombinationLetter() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = LinguisticParser.findNodes(this.topNode, "combination_letter");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            int n2 = nodeList2.getLength();
            int[][] nArrayArray = new int[3][];
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                String string = node.getNodeName();
                if (string.equals("char1")) {
                    nArrayArray[0] = new int[2];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char1>");
                    continue;
                }
                if (string.equals("char2")) {
                    nArrayArray[0][1] = this.getValueOfHex(node, "Element <char2>");
                    continue;
                }
                if (string.equals("major")) {
                    nArrayArray[1] = new int[1];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <major>");
                    continue;
                }
                if (!string.equals("minor")) continue;
                nArrayArray[2] = new int[1];
                nArrayArray[2][0] = this.getValueOfHex(node, "Element <minor>");
            }
            vector.addElement(nArrayArray);
        }
        return vector;
    }

    public Vector getSpecialUppercase() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = LinguisticParser.findNodes(this.topNode, "special_uppercase");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            int n2 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                String string = node.getNodeName();
                if (string.equals("lower")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <lower>");
                    continue;
                }
                if (string.equals("lower1")) {
                    nArrayArray[0] = new int[2];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <lower1>");
                    continue;
                }
                if (string.equals("lower2")) {
                    nArrayArray[0][1] = this.getValueOfHex(node, "Element <lower2>");
                    continue;
                }
                if (string.equals("upper")) {
                    nArrayArray[1] = new int[1];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <upper>");
                    continue;
                }
                if (string.equals("upper1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <upper1>");
                    continue;
                }
                if (string.equals("upper2")) {
                    nArrayArray[1][1] = this.getValueOfHex(node, "Element <upper2>");
                    continue;
                }
                if (!string.equals("upper3")) continue;
                int[] nArray = new int[]{nArrayArray[1][0], nArrayArray[1][1], this.getValueOfHex(node, "Element <upper3>")};
                nArrayArray[1] = nArray;
            }
            vector.addElement(nArrayArray);
        }
        return vector;
    }

    public Vector getSpecialLowercase() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = LinguisticParser.findNodes(this.topNode, "special_lowercase");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            int n2 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                String string = node.getNodeName();
                if (string.equals("upper")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <upper>");
                    continue;
                }
                if (string.equals("upper1")) {
                    nArrayArray[0] = new int[2];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <upper1>");
                    continue;
                }
                if (string.equals("upper2")) {
                    nArrayArray[0][1] = this.getValueOfHex(node, "Element <upper2>");
                    continue;
                }
                if (string.equals("lower")) {
                    nArrayArray[1] = new int[1];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <lower>");
                    continue;
                }
                if (string.equals("lower1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <lower1>");
                    continue;
                }
                if (!string.equals("lower2")) continue;
                nArrayArray[1][1] = this.getValueOfHex(node, "Element <lower2>");
            }
            vector.addElement(nArrayArray);
        }
        return vector;
    }

    public Vector getSpecialBaseLetter() throws NLTParserException {
        Vector<int[][]> vector = new Vector<int[][]>();
        NodeList nodeList = LinguisticParser.findNodes(this.topNode, "special_base_letter");
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            int n2 = nodeList2.getLength();
            int[][] nArrayArray = new int[2][];
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                String string = node.getNodeName();
                if (string.equals("char")) {
                    nArrayArray[0] = new int[1];
                    nArrayArray[0][0] = this.getValueOfHex(node, "Element <char>");
                    continue;
                }
                if (string.equals("base1")) {
                    nArrayArray[1] = new int[2];
                    nArrayArray[1][0] = this.getValueOfHex(node, "Element <base1>");
                    continue;
                }
                if (!string.equals("base2")) continue;
                nArrayArray[1][1] = this.getValueOfHex(node, "Element <base2>");
            }
            vector.addElement(nArrayArray);
        }
        return vector;
    }

    public String getVersion() {
        return this.getStringValue("VERSION");
    }

    public String getName() {
        return this.getStringValue("Name");
    }

    public String getId() {
        return this.getStringValue("Id");
    }

    public String getSortName() {
        return this.getStringValue("SORT_NAME");
    }

    public String getSortId() {
        return this.getStringValue("SORT_ID");
    }

    public String getBaseSortId() {
        return this.getStringValue("BASE_SORT_ID");
    }

    public String getBaseSortName() {
        return this.getStringValue("BASE_SORT_NAME");
    }

    public String getCollationFunctionID() {
        return this.getStringValue("collation_function_id");
    }

    public String getComparisonFunctionID() {
        return this.getStringValue("comparison_function_id");
    }

    public String getCanonicalEquivalence() {
        return this.getStringValue("Canonical_equivalence");
    }

    public String getReverseSecondary() {
        return this.getStringValue("Reverse_secondary");
    }

    public String getSwapWithNext() {
        return this.getStringValue("Swap_with_next");
    }

    public String LinInternalFlag() {
        return this.getStringValue("Lin_internal_flag");
    }

    public String getHangulJamoComp() {
        return this.getStringValue("Hangul_Jamo_Composition");
    }

    public Vector getCollationRules(byte by) throws NLTParserException {
        Node node = LinguisticParser.findNode(this.topNode, "COLLATION_RULES");
        if (node == null) {
            return null;
        }
        Vector vector = new Vector();
        int[] nArray = new int[]{0};
        switch (by) {
            case 1: {
                node = LinguisticParser.findNode(node, "Ign_Sec");
                break;
            }
            case 2: {
                node = LinguisticParser.findNode(node, "Ign_Ter");
                break;
            }
            case 3: {
                node = LinguisticParser.findNode(node, "Non_Ign");
                break;
            }
            default: {
                return null;
            }
        }
        this.getColRulesNonRecur(node, vector);
        return vector;
    }

    public void getColRulesNonRecur(Node node, Vector vector) throws NLTParserException {
        if (node == null) {
            return;
        }
        Node node2 = node.getFirstChild();
        int[] nArray = new int[]{0};
        while (node2 != null) {
            int[] nArray2;
            String string = node2.getNodeName();
            if (string.equals("Prim")) {
                nArray[0] = nArray[0] | 1;
            } else if (string.equals("Sec")) {
                nArray[0] = nArray[0] | 2;
            } else if (string.equals("Ter")) {
                nArray[0] = nArray[0] | 4;
            } else if (string.equals("CP")) {
                if (nArray[0] != 0) {
                    nArray2 = new int[]{nArray[0], this.getValueOfHex(node2, "ELEMENT CP")};
                    vector.addElement(nArray2);
                    nArray[0] = 0;
                } else {
                    nArray2 = (int[])vector.lastElement();
                    int[] nArray3 = new int[nArray2.length + 1];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray3[i] = nArray2[i];
                    }
                    nArray3[nArray2.length] = this.getValueOfHex(node2, "ELEMENT CP");
                    vector.setElementAt(nArray3, vector.size() - 1);
                }
            } else if (string.equals("EQ")) {
                nArray[0] = nArray[0] | 0x10;
            } else if (string.equals("Gap")) {
                nArray[0] = nArray[0] | 8;
                nArray2 = new int[]{nArray[0], this.getValueOfHex(node2, "ELEMENT Gap")};
                vector.addElement(nArray2);
                nArray[0] = 0;
            }
            node2 = this.getNextNode(node2, node);
        }
    }

    private Node getNextNode(Node node, Node node2) {
        if (node.hasChildNodes()) {
            node = node.getFirstChild();
        } else {
            Node node3 = null;
            while ((node3 = node.getNextSibling()) == null) {
                if ((node = node.getParentNode()) != node2 && node != null) continue;
                return null;
            }
            node = node3;
        }
        return node;
    }

    public Vector getExpandingRules() throws NLTParserException {
        return this.getPBlockVector("EXPANDING_RULES");
    }

    public Vector getContextSensitiveRules() throws NLTParserException {
        Node node = LinguisticParser.findNode(this.topNode, "CONTEXT_SENSITIVE_RULES");
        if (node == null) {
            return null;
        }
        Vector vector = new Vector();
        int[] nArray = new int[]{0};
        this.getColRulesNonRecur(node, vector);
        return vector;
    }

    public static void printColVector(Vector vector) {
        if (vector == null) {
            System.out.println("Null Vector!");
            return;
        }
        vector.trimToSize();
        int n = vector.size();
        if (n == 0) {
            System.out.println("Empty Vector!");
            return;
        }
        for (int i = 0; i < n; ++i) {
            int[] nArray = (int[])vector.elementAt(i);
            if ((nArray[0] & 1) != 0) {
                System.out.print("PrimStart ");
            }
            if ((nArray[0] & 2) != 0) {
                System.out.print("SecStart  ");
            }
            if ((nArray[0] & 4) != 0) {
                System.out.print("TerStart  ");
            }
            if ((nArray[0] & 0x10) != 0) {
                System.out.print("Equal     ");
            }
            if ((nArray[0] & 8) != 0) {
                System.out.print("Gap       ");
            }
            for (int j = 1; j < nArray.length; ++j) {
                System.out.print(nArray[j] + "  ");
            }
            System.out.println();
        }
    }
}

