/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.builder.BootBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.LinguisticParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.OraLinguisticSetter;
import oracle.i18n.util.builder.UnicodeMapChar;

public class LinguisticBuilder {
    private static final String LINGPREFIX = "lx3";
    private static final int SECONDARYDIFFERENCEONLY = -256;
    static final short PRIMARY_BEGIN = 1;
    static final short SECONDARY_BEGIN = 2;
    static final short TERTIARY_BEGIN = 4;
    static final short GAP = 8;
    static final short EQUAL = 16;
    static final short GREATER = 32;
    static final byte SECONDARY_ONLY = 1;
    static final byte TERTIARY_ONLY = 2;
    static final byte OTHERS = 3;
    static final short CS_TERTIARY_DIFF = 25;
    static final short BASE_PRIMARY_PART = 31;
    static final short BASE_SECONDARY_PART = 1;
    static final short BASE_TERTIARY_PART = 1;
    static final short BASE_TERTIARY_VAL = 31;
    static final int FIRST_LEVEL_LENGTH = 256;
    static final int SECOND_LEVEL_LENGTH = 65536;
    static final int TWOBYTESHIFT = 16;
    static final int ONEBYTESHIFT = 8;
    static final int LOWBYTEMASK = 255;
    static final int HIGHBYTEMASK = 65280;
    static final int LOWTWOBYTEMASK = 65535;
    static final int HIGHTWOBYTEMASK = -65536;

    public static void buildGLB(String string, String string2, String string3, boolean bl) throws IOException, NLTParserException {
        LinguisticParser linguisticParser = null;
        linguisticParser = new LinguisticParser(string3);
        OraLinguisticSetter oraLinguisticSetter = new OraLinguisticSetter();
        oraLinguisticSetter.setVersion(linguisticParser.getVersion());
        oraLinguisticSetter.setSortName(linguisticParser.getName());
        oraLinguisticSetter.setSortId(linguisticParser.getId());
        oraLinguisticSetter.setBaseSortId(linguisticParser.getBaseSortId());
        oraLinguisticSetter.setBaseSortName(linguisticParser.getBaseSortName());
        Vector vector = linguisticParser.getMajorSort();
        if (vector == null) {
            oraLinguisticSetter.setMonolingual(false);
            oraLinguisticSetter.setReverseSec(linguisticParser.getReverseSecondary());
            oraLinguisticSetter.setSwapWithNext(linguisticParser.getSwapWithNext());
            oraLinguisticSetter.setCanonicalEq(linguisticParser.getCanonicalEquivalence());
            oraLinguisticSetter.setHangulJamo(linguisticParser.getHangulJamoComp());
            int[][] nArrayArray = new int[1024][];
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            int[] nArray = new int[65536];
            LinguisticBuilder.processCollationRules(linguisticParser, oraLinguisticSetter, nArray, nArrayArray, vector3);
            LinguisticBuilder.processExpandingRules(linguisticParser, oraLinguisticSetter, nArray, vector2);
            LinguisticBuilder.processContextSensitiveRules(linguisticParser, oraLinguisticSetter, nArray);
            if (oraLinguisticSetter.isCanonicalEq()) {
                LinguisticBuilder.processDecomposition(nArray, nArrayArray, vector2, vector3, oraLinguisticSetter, string3);
            }
            oraLinguisticSetter.setExpandingTable(vector2);
            oraLinguisticSetter.setContractTable(vector3);
            Vector[] vectorArray = new Vector[16];
            OraLinguisticSetter.compressSurrogateTables((int[][])nArrayArray, (int[])nArray, (Vector[])vectorArray);
            oraLinguisticSetter.setSurrogateTable(vectorArray);
            int[] nArray2 = new int[256];
            int n = OraLinguisticSetter.compressIntArray((int[])nArray, (int[])nArray2);
            oraLinguisticSetter.setCollationLevel1(nArray2);
            oraLinguisticSetter.setCollationLevel2(n, nArray);
            oraLinguisticSetter.setLatinOneTable();
        } else {
            int n;
            oraLinguisticSetter.setMonolingual(true);
            HashMap hashMap = linguisticParser.getMinorSort();
            int[] nArray = new int[65536];
            if (vector != null) {
                int n2 = 0;
                n = vector.size();
                for (n2 = 0; n2 < n; ++n2) {
                    int n3;
                    Object[] objectArray = (Object[])vector.elementAt(n2);
                    int[] nArray3 = (int[])objectArray[0];
                    int[] nArray4 = (int[])objectArray[1];
                    char c = (char)(nArray3[0] & 0xFFFF);
                    int n4 = nArray4[0];
                    objectArray = (Object[])hashMap.get(new Integer(nArray3[0]));
                    int n5 = objectArray == null ? 0 : ((int[])objectArray[0])[0];
                    nArray[c] = n3 = LinguisticBuilder.combineKey(n4, 1, n5);
                }
            }
            LinguisticBuilder.processSpeicalLetters(linguisticParser, oraLinguisticSetter, nArray);
            LinguisticBuilder.processCombinationLetters(linguisticParser, oraLinguisticSetter, nArray);
            int[] nArray5 = new int[256];
            n = OraLinguisticSetter.compressIntArray((int[])nArray, (int[])nArray5);
            oraLinguisticSetter.setCollationLevel1(nArray5);
            oraLinguisticSetter.setCollationLevel2(n, nArray);
            LinguisticBuilder.processBaseLetters(linguisticParser, oraLinguisticSetter);
        }
        BootBuilder.writeGLBFile(string, string2, BootBuilder.formatFileName(LINGPREFIX, Integer.toString(oraLinguisticSetter.getId())), bl, oraLinguisticSetter);
    }

    private static int combineKey(int n, int n2, int n3) {
        if (((long)n & 0xFFFFFFFFL) >= 0xFFF00000L) {
            return n;
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    private static void processCollationRules(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray, int[][] nArray2, Vector vector) throws NLTParserException {
        int n;
        int n2;
        int[] nArray3;
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        Vector vector2 = linguisticParser.getCollationRules((byte)1);
        int n5 = 0;
        int n6 = 0;
        if (vector2 != null) {
            n5 = vector2.size();
            n4 = 0;
            l = 0;
            n3 = 1;
            for (n6 = 0; n6 < n5; ++n6) {
                nArray3 = (int[])vector2.elementAt(n6);
                if (nArray3.length != 2) {
                    System.out.println("bug!!!");
                }
                if (((n2 = nArray3[0]) & 2) == 0) {
                    System.out.println("bug!!!");
                }
                if ((n2 & 8) != 0) {
                    n3 += nArray3[1];
                    continue;
                }
                if ((n2 & 0x10) == 0) {
                    ++n3;
                }
                nArray[nArray3[1] & 0xFFFF] = n = LinguisticBuilder.combineKey((int)l, n3, n4);
            }
        }
        if ((vector2 = linguisticParser.getCollationRules((byte)2)) != null) {
            n5 = vector2.size();
            n3 = 0;
            l = 0;
            n4 = 31;
            n2 = 0;
            for (n6 = 0; n6 < n5; ++n6) {
                nArray3 = (int[])vector2.elementAt(n6);
                n2 = nArray3[0];
                if (nArray3.length != 2 || (n2 & 4) == 0) {
                    System.out.println("bug!!!!");
                }
                if ((n2 & 8) != 0) {
                    n4 += nArray3[1];
                    continue;
                }
                if ((n2 & 0x10) == 0) {
                    ++n4;
                }
                nArray[nArray3[1] & 0xFFFF] = n = LinguisticBuilder.combineKey((int)l, n3, n4);
            }
        }
        if ((vector2 = linguisticParser.getCollationRules((byte)3)) != null) {
            n5 = vector2.size();
            l = 31L;
            n3 = 1;
            n4 = 1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (n6 = 0; n6 < n5; ++n6) {
                int n7;
                int n8;
                nArray3 = (int[])vector2.elementAt(n6);
                bl = false;
                bl2 = false;
                bl3 = false;
                int n9 = nArray3.length;
                if (n9 < 2) {
                    System.out.println("BUG!!!");
                }
                if (((n2 = nArray3[0]) & 0x10) == 0) {
                    if ((n2 & 1) != 0) {
                        n3 = 1;
                        n4 = 1;
                        bl = true;
                        l = l < 65471L || l >= 0xFFF00000L ? ++l : 0xFFF00001L;
                    }
                    if ((n2 & 2) != 0) {
                        bl2 = true;
                        n4 = 1;
                        ++n3;
                    }
                    if ((n2 & 4) != 0) {
                        bl3 = true;
                        ++n4;
                    }
                    if ((n2 & 8) != 0) {
                        if (bl3) {
                            n4 += nArray3[1] - 1;
                        } else if (bl2) {
                            n3 += nArray3[1] - 1;
                        } else if (bl) {
                            l += (long)(nArray3[1] - 1);
                        }
                        if (l < 65472L || l >= 0xFFF00000L) continue;
                        l = 0xFFF00000L + (long)nArray3[1];
                        continue;
                    }
                }
                n = LinguisticBuilder.combineKey((int)l, n3, n4);
                if (n9 == 2) {
                    nArray[nArray3[1] & 0xFFFF] = n;
                    continue;
                }
                if (n9 == 3 && nArray3[1] >= 55296 && nArray3[1] <= 56319 && nArray3[2] >= 56320 && nArray3[2] <= 57343) {
                    OraLinguisticSetter.processSurrogate((int[][])nArray2, (int)nArray3[1], (int)nArray3[2], (int)n);
                    continue;
                }
                int[] nArray4 = new int[--n9 + 3];
                nArray4[0] = n9;
                nArray4[1] = n;
                nArray4[2] = 0;
                for (n8 = 3; n8 < n9 + 3; ++n8) {
                    nArray4[n8] = nArray3[n8 - 2];
                }
                if (nArray[nArray3[1]] != 0) {
                    if (oraLinguisticSetter.isContracting(nArray[nArray3[1]])) {
                        int[] nArray5;
                        n7 = oraLinguisticSetter.getIndex(nArray[nArray3[1]]);
                        int[] nArray6 = (int[])vector.elementAt(n7);
                        for (n8 = 0; n8 < nArray6[2] + 1; ++n8) {
                            nArray5 = (int[])vector.elementAt(n7 + n8);
                            if (n9 < nArray5[0]) continue;
                            nArray4[2] = nArray5[2] + 1;
                            break;
                        }
                        vector.insertElementAt(nArray4, n7 + n8);
                        for (int i = 0; i < n8; ++i) {
                            nArray5 = (int[])vector.elementAt(n7 + i);
                            nArray5[2] = nArray5[2] + 1;
                        }
                        continue;
                    }
                    nArray4[2] = 1;
                    int[] nArray7 = new int[]{1, nArray[nArray3[1]], 0, nArray3[1]};
                    int n10 = vector.size();
                    vector.addElement(nArray4);
                    vector.addElement(nArray7);
                    nArray[nArray3[1]] = n = -4128768 + (n10 & 0xFFFF);
                    continue;
                }
                n7 = vector.size();
                vector.addElement(nArray4);
                nArray[nArray3[1]] = n = -4128768 + (n7 & 0xFFFF);
            }
        }
    }

    private static void processExpandingRules(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray, Vector vector) throws NLTParserException {
        Vector vector2 = linguisticParser.getExpandingRules();
        if (vector2 == null) {
            return;
        }
        int n = vector2.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            Object[] objectArray = (Object[])vector2.elementAt(i);
            int[] nArray2 = (int[])objectArray[0];
            int[] nArray3 = (int[])objectArray[1];
            String string = (String)objectArray[2];
            int n4 = 0;
            if (string != null) {
                if (string.equalsIgnoreCase("G")) {
                    n4 = 1;
                } else if (string.equalsIgnoreCase("L")) {
                    n4 = -1;
                }
            }
            int n5 = 0;
            if (objectArray[3] != null) {
                n5 = (Integer)objectArray[3];
            }
            int n6 = 0;
            int n7 = 0;
            if (n5 == 2) {
                n6 = 1;
            } else if (n5 == 3) {
                n7 = 1;
            }
            char c = (char)nArray2[0];
            Vector<Integer> vector3 = new Vector<Integer>();
            for (int j = 0; j < nArray3.length; ++j) {
                n3 = nArray[nArray3[j]];
                if (n3 == 0) {
                    n3 = -65536;
                    vector3.addElement(new Integer(n3 += n4 * n6 << 8 + n4 * n7));
                    continue;
                }
                if (!oraLinguisticSetter.isExpanding(n3)) {
                    vector3.addElement(new Integer(n3 += n4 * n6 << 8 + n4 * n7));
                    continue;
                }
                n2 = oraLinguisticSetter.getIndex(n3);
                int[] nArray4 = (int[])vector.elementAt(n2);
                for (int k = 0; k < nArray4.length; ++k) {
                    vector3.addElement(new Integer(nArray4[k] + n4 * n6 << 8 + n4 * n7));
                }
            }
            n3 = vector.size();
            nArray[nArray2[0]] = n2 = -4063232 + (n3 & 0xFFFF);
            vector.addElement(vector3);
        }
    }

    private static void processContextSensitiveRules(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray) throws NLTParserException {
        Vector vector = linguisticParser.getContextSensitiveRules();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector<int[]> vector2 = new Vector<int[]>();
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = (int[])vector.elementAt(i);
            int n6 = nArray2[0];
            int[] nArray3 = new int[5];
            if (nArray2.length != 3 && nArray2.length != 4) {
                return;
            }
            if ((n6 & 1) != 0) {
                bl = true;
                n3 = nArray2[1];
                if (nArray2.length == 3) {
                    n4 = 0;
                    n5 = nArray2[2];
                    continue;
                }
                n4 = nArray2[2];
                n5 = nArray2[3];
                continue;
            }
            if (!bl) {
                // empty if block
            }
            bl = false;
            n2 = (n6 & 0x10) != 0 ? 0 : 25;
            int n7 = nArray2[nArray2.length - 1];
            int n8 = nArray[n5] + n2;
            nArray3[0] = n7;
            nArray3[1] = 0;
            nArray3[2] = n8;
            nArray3[3] = n3;
            nArray3[4] = n4;
            if (!oraLinguisticSetter.isContextSensitive(nArray[n7])) {
                if (nArray[n7] == 0) {
                    nArray[n7] = -3997696 + vector2.size();
                    vector2.addElement(nArray3);
                    continue;
                }
                if (nArray3[3] != 0) continue;
                nArray3[4] = 0;
                nArray3[3] = 0;
                if (n7 != n5) {
                    // empty if block
                }
                nArray3[2] = nArray[n7];
                nArray[n7] = -3997696 + vector2.size();
                vector2.addElement(nArray3);
                continue;
            }
            int n9 = oraLinguisticSetter.getIndex(nArray[n7]);
            int n10 = 0;
            int[] nArray4 = null;
            for (n10 = 0; n10 < ((int[])vector2.elementAt(n9))[1] + 1; ++n10) {
                nArray4 = (int[])vector2.elementAt(n9 + n10);
                if (((long)nArray3[3] << 16) + (long)nArray3[4] >= ((long)nArray4[3] << 16) + (long)nArray4[4]) continue;
                nArray3[1] = nArray4[1] + 1;
                break;
            }
            vector2.insertElementAt(nArray3, n9 + n10);
            for (int j = n9; j < n9 + n10; ++j) {
                nArray4 = (int[])vector2.elementAt(j);
                nArray4[1] = nArray4[1] + 1;
            }
        }
        oraLinguisticSetter.setContextSensitiveTable(vector2);
    }

    private static void processSpeicalLetters(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray) throws NLTParserException {
        Vector vector = linguisticParser.getSpecialLetter();
        Vector vector2 = null;
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            vector2 = new Vector();
            Object[] objectArray = null;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                objectArray = (Object[])vector.elementAt(i);
                Vector<Integer> vector3 = new Vector<Integer>();
                int[] nArray2 = (int[])objectArray[0];
                int[] nArray3 = (int[])objectArray[1];
                int[] nArray4 = (int[])objectArray[2];
                for (int j = 0; j < nArray3.length; ++j) {
                    vector3.addElement(new Integer(LinguisticBuilder.combineKey(nArray3[j], 1, nArray4[j])));
                }
                vector2.addElement(vector3);
                nArray[nArray2[0]] = n2 = -4063232 + (i & 0xFF);
            }
            oraLinguisticSetter.setExpandingTable(vector2);
        }
    }

    private static void processCombinationLetters(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray) throws NLTParserException {
        Vector vector = linguisticParser.getCombinationLetter();
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            Vector<int[]> vector2 = new Vector<int[]>();
            Object[] objectArray = null;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                objectArray = (Object[])vector.elementAt(i);
                int[] nArray2 = (int[])objectArray[0];
                int[] nArray3 = (int[])objectArray[1];
                int[] nArray4 = (int[])objectArray[2];
                int n4 = LinguisticBuilder.combineKey(nArray3[0], 1, nArray4[0]);
                int n5 = nArray[nArray2[0]];
                int[] nArray5 = new int[nArray2.length + 3];
                int n6 = nArray5[0] = nArray2.length;
                nArray5[1] = n4;
                nArray5[2] = 0;
                for (n3 = 0; n3 < nArray2.length; ++n3) {
                    nArray5[n3 + 3] = nArray2[n3];
                }
                if (nArray[nArray2[0]] != 0) {
                    int[] nArray6;
                    if (oraLinguisticSetter.isContracting(nArray[nArray2[0]])) {
                        int[] nArray7;
                        n2 = oraLinguisticSetter.getIndex(nArray[nArray2[0]]);
                        nArray6 = (int[])vector2.elementAt(n2);
                        for (n3 = 0; n3 < nArray6[2] + 1; ++n3) {
                            nArray7 = (int[])vector2.elementAt(n2 + n3);
                            if (n6 < nArray7[0]) continue;
                            nArray5[2] = nArray7[2] + 1;
                            break;
                        }
                        vector2.insertElementAt(nArray5, n2 + n3);
                        for (int j = 0; j < n3; ++j) {
                            nArray7 = (int[])vector2.elementAt(n2 + j);
                            nArray7[2] = nArray7[2] + 1;
                        }
                        continue;
                    }
                    nArray5[2] = 1;
                    nArray6 = new int[]{1, nArray[nArray2[0]], 0, nArray2[0]};
                    n2 = vector2.size();
                    vector2.addElement(nArray5);
                    vector2.addElement(nArray6);
                    nArray[nArray2[0]] = -4128768 + (n2 & 0xFF);
                    continue;
                }
                n2 = vector2.size();
                vector2.addElement(nArray5);
                nArray[nArray2[0]] = -4128768 + (n2 & 0xFF);
            }
            oraLinguisticSetter.setContractTable(vector2);
        }
    }

    private static void processBaseLetters(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter) throws NLTParserException {
        Vector vector = linguisticParser.getBaseLetter();
        Object var4_3 = null;
        if (vector != null) {
            UnicodeMapChar unicodeMapChar = new UnicodeMapChar(vector);
            oraLinguisticSetter.setBaseLetterTable(unicodeMapChar);
        }
    }

    private static int getSurrogate(int[][] nArray, int n, int n2) {
        int n3 = n - 55296;
        int n4 = n2 - 56320;
        return nArray[n3][n4];
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processDecomposition(int[] nArray, int[][] nArray2, Vector vector, Vector vector2, OraLinguisticSetter oraLinguisticSetter, String string) throws NLTParserException {
        String string2 = string.substring(0, string.length() - 11);
        CharSetParser charSetParser = CharSetParser.getInstance(string2 + "lx207d0.nlt");
        Vector vector3 = charSetParser.getDecomposition();
        if (vector3 == null) {
            return;
        }
        Object[] objectArray = null;
        int n = vector3.size();
        int n2 = 0;
        while (true) {
            block20: {
                Vector vector4;
                int n3;
                int n4;
                int[] nArray3;
                block22: {
                    block19: {
                        int n5;
                        Object object;
                        int n6;
                        block24: {
                            block25: {
                                block26: {
                                    int n7;
                                    block23: {
                                        block21: {
                                            int n8;
                                            int n9;
                                            if (n2 >= n) {
                                                return;
                                            }
                                            objectArray = (Object[])vector3.elementAt(n2);
                                            int[] nArray4 = (int[])objectArray[0];
                                            nArray3 = (int[])objectArray[1];
                                            String string3 = (String)objectArray[2];
                                            if (string3 != null) break block20;
                                            if ((nArray4[0] & 0xFFFF0000) != 0) {
                                                n9 = (nArray4[0] & 0xFFFF0000) >>> 16;
                                                n8 = nArray4[0] & 0xFFFF;
                                            } else {
                                                n9 = 0;
                                                n8 = nArray4[0];
                                            }
                                            n4 = 1;
                                            if ((nArray[n8] & 0xFFFF0000) != 0) break block20;
                                            int n10 = vector.size();
                                            n7 = -4063232 + n10;
                                            n3 = nArray3.length;
                                            if (n9 == 0) {
                                                nArray[n8] = n7;
                                            } else {
                                                OraLinguisticSetter.processSurrogate((int[][])nArray2, (int)n9, (int)n8, (int)n7);
                                                if (nArray[n9] == 0) {
                                                    nArray[n9] = -3866624;
                                                }
                                            }
                                            vector4 = new Vector();
                                            n7 = nArray[nArray3[0] & 0xFFFF];
                                            n4 = 1;
                                            if (oraLinguisticSetter.isSurrogate(n7)) {
                                                n7 = LinguisticBuilder.getSurrogate(nArray2, nArray3[0], nArray3[1]);
                                                n4 = 2;
                                            }
                                            if (!oraLinguisticSetter.isExpanding(n7)) break block21;
                                            n6 = oraLinguisticSetter.getIndex(n7);
                                            object = (Vector)vector.elementAt(n6);
                                            for (int i = 0; i < ((Vector)object).size(); ++i) {
                                                vector4.addElement(((Vector)object).elementAt(i));
                                            }
                                            break block22;
                                        }
                                        if (!oraLinguisticSetter.isContracting(n7)) break block23;
                                        object = (int[])vector2.elementAt(n6);
                                        n5 = n6 + object[2] + 1;
                                        break block24;
                                    }
                                    if ((n7 & 0xFF00) != 0 || (n7 & 0xFF) != 0) break block25;
                                    if (n3 < 2) break block26;
                                    if (oraLinguisticSetter.isSurrogate(nArray3[0]) && n3 > 1) {
                                        vector4.addElement(new Integer(-65536));
                                        vector4.addElement(new Integer(nArray3[0] << 16));
                                        vector4.addElement(new Integer(-65536));
                                        vector4.addElement(new Integer(nArray3[1] << 16));
                                        n4 = 2;
                                        break block19;
                                    } else {
                                        vector4.addElement(new Integer(-65536));
                                        vector4.addElement(new Integer(nArray3[0] << 16));
                                    }
                                    break block19;
                                }
                                vector4.addElement(new Integer(-65536));
                                vector4.addElement(new Integer(nArray3[0] << 16));
                                break block22;
                            }
                            vector4.addElement(new Integer(nArray[nArray3[0]]));
                            n4 = 1;
                            break block22;
                        }
                        for (n6 = oraLinguisticSetter.getIndex(n7); n6 < n5; ++n6) {
                            object = (int[])vector2.elementAt(n6);
                            if (object[0] > n3) continue;
                            int n11 = 0;
                            for (n11 = 0; n11 < object[0] && object[3 + n11] == nArray3[n11]; ++n11) {
                            }
                            if (n11 != object[0]) continue;
                            n4 = n11;
                            vector4.addElement(new Integer((int)object[1]));
                            break;
                        }
                        if (n6 != n5) {
                            // empty if block
                        }
                        break block22;
                    }
                    while (n4 < n3) {
                        if ((nArray[nArray3[n4] & 0xFFFF] & 0xFFFFFF00) != 0) {
                            vector4.addElement(new Integer(nArray[nArray3[n4++] & 0xFFFF] & 0xFFFFFF00));
                            continue;
                        }
                        vector4.addElement(new Integer(-65536));
                        vector4.addElement(new Integer(nArray3[n4++] << 16));
                    }
                }
                while (n4 < n3) {
                    if ((nArray[nArray3[n4] & 0xFFFF] & 0xFFFFFF00) != 0) {
                        vector4.addElement(new Integer(nArray[nArray3[n4++] & 0xFFFF] & 0xFFFFFF00));
                        continue;
                    }
                    vector4.addElement(new Integer(nArray3[n4++] << 16));
                }
                vector.addElement(vector4);
            }
            ++n2;
        }
    }

    private static int compressCharArray(char[] cArray, int[] nArray) {
        nArray[0] = 0;
        int n = 256;
        for (int i = 1; i < 256; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                int n4;
                char c;
                char c2;
                for (n2 = 0; n2 < (256 < n - n3 ? 256 : n - n3) && (c2 = cArray[n3 + n2]) == (c = cArray[(n4 = i << 8) | n2]); ++n2) {
                }
                if (n2 == (256 < n - n3 ? 256 : n - n3)) break;
            }
            nArray[i] = (short)n3;
            for (n2 = (i << 8) + (n - n3); n2 < i + 1 << 8; ++n2) {
                cArray[n++] = cArray[n2];
            }
        }
        return n;
    }

    private static int getCodePoint(int n) {
        if ((n & 0xFFFF0000) != 0) {
            int n2 = (n & 0xFFFF0000) >>> 16;
            int n3 = n & 0xFFFF;
            int n4 = Character.toCodePoint((char)n2, (char)n3);
            return n4;
        }
        return n;
    }
}

